/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.tm.formplugin.lifecycle;

import java.math.BigDecimal;
import java.util.EventObject;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.ListSelectedRow;
import kd.bos.form.IFormView;
import kd.bos.form.control.events.BeforeItemClickEvent;
import kd.bos.form.control.events.ItemClickEvent;
import kd.bos.list.BillList;
import kd.bos.list.plugin.AbstractListPlugin;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.mservice.form.FormServiceImpl;
import kd.bos.mvc.SessionManager;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.tmc.fbp.common.util.EmptyUtil;

public class LifeCycleApplySapList
extends AbstractListPlugin {
    private static final Log logger = LogFactory.getLog(LifeCycleApplySapList.class);

    public void registerListener(EventObject e) {
        this.addItemClickListeners(new String[]{"push", "dealsapdata"});
    }

    public void beforeItemClick(BeforeItemClickEvent evt) {
        String itemKey;
        super.itemClick((ItemClickEvent)evt);
        switch (itemKey = evt.getItemKey()) {
            case "dealsapdata": {
                ListSelectedRow selectedRow = this.getBilllistap().getSelectedRows().get(0);
                DynamicObject originalRow = BusinessDataServiceHelper.loadSingle((Object)selectedRow.getPrimaryKeyValue(), (String)"tm_lifecycle_apply");
                this.dealSapData(originalRow);
                break;
            }
            case "push": {
                ListSelectedRow selectedRow = this.getBilllistap().getSelectedRows().get(0);
                DynamicObject originalRow = BusinessDataServiceHelper.loadSingle((Object)selectedRow.getPrimaryKeyValue(), (String)"tm_lifecycle_apply");
                if (!this.isFromSap(originalRow)) break;
                try {
                    this.dealSapData(originalRow);
                    break;
                }
                catch (Exception e) {
                    logger.error((Throwable)e);
                }
            }
        }
    }

    private BillList getBilllistap() {
        return (BillList)this.getControl("billlistap");
    }

    private void dealSapData(DynamicObject originalRow) {
        FormServiceImpl formService = new FormServiceImpl();
        String response = formService.batchInvokeAction(this.getView().getPageId(), "[{\"key\":\"toolbarap\",\"methodName\":\"itemClick\",\"args\":[\"tblnew\",\"new\"],\"postData\":[{},[]]}]");
        String formPageId = response.split("\"pageId\":")[2].split("\",\"")[0];
        formPageId = formPageId.substring(1);
        formService.batchInvokeAction(formPageId, "[{\"key\":\"\",\"methodName\":\"loadData\",\"args\":[],\"postData\":[]}]");
        IFormView view = SessionManager.getCurrent().getView(formPageId);
        this.setValue(view, originalRow);
        DynamicObject dataEntity = view.getModel().getDataEntity();
        SaveServiceHelper.update((DynamicObject[])new DynamicObject[]{dataEntity});
        view.close();
    }

    private boolean isFromSap(DynamicObject originalRow) {
        BigDecimal buyAmountMax = originalRow.getBigDecimal("buyamountmax");
        BigDecimal sellAmountMax = originalRow.getBigDecimal("sellamountmax");
        return buyAmountMax.compareTo(BigDecimal.ZERO) == 0 && sellAmountMax.compareTo(BigDecimal.ZERO) == 0;
    }

    private void setValue(IFormView view, DynamicObject originalRow) {
        view.getModel().setValue("id", originalRow.getPkValue());
        view.getModel().setValue("billstatus", originalRow.get("billstatus"));
        if (EmptyUtil.isEmpty((Object)originalRow.get("tradetype")) || EmptyUtil.isEmpty((Object)originalRow.get("tradeno")) || EmptyUtil.isEmpty((Object)originalRow.get("lifecycleoperation"))) {
            return;
        }
        view.getModel().setValue("tradetype", originalRow.get("tradetype"));
        view.getModel().setValue("tradeno", originalRow.get("tradeno"));
        Object selectedCardId = originalRow.get("currentselectedcardid");
        if (EmptyUtil.isNoEmpty((Object)selectedCardId)) {
            for (int i = 1; i < view.getModel().getEntryRowCount("entryentity"); ++i) {
                if (!selectedCardId.equals(view.getModel().getValue("lifecyclecardid", i))) continue;
                view.getModel().setValue("currentselectedcardid", view.getModel().getValue("lifecyclecardid", i));
                break;
            }
        }
        this.setValue(view.getModel(), originalRow, "swaptype");
        this.setValue(view.getModel(), originalRow, "farornear");
        this.setValue(view.getModel(), originalRow, "applydate");
        view.getModel().setValue("lifecycleoperation", originalRow.get("lifecycleoperation"));
        this.setValue(view.getModel(), originalRow, "opdate");
        this.setValue(view.getModel(), originalRow, "ischoosedate");
        this.setValue(view.getModel(), originalRow, "applydeliverydate");
        this.setValue(view.getModel(), originalRow, "expiredatestart");
        this.setValue(view.getModel(), originalRow, "expiredateend");
        view.getModel().setValue("buyamount", originalRow.get("buyamount"));
        view.getModel().setValue("sellamount", originalRow.get("sellamount"));
    }

    private void setValue(IDataModel model, DynamicObject originalRow, String key) {
        if (originalRow.get(key) != null) {
            model.setValue(key, originalRow.get(key));
        }
    }
}

