/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.tm.formplugin.optioncom;

import java.math.BigDecimal;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.entity.datamodel.events.ChangeData;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.tmc.fbp.common.constant.Constants;
import kd.tmc.fbp.common.enums.OptionsTradeTypeEnum;
import kd.tmc.fbp.common.enums.TradeDirectionEnum;
import kd.tmc.fbp.common.util.EmptyUtil;
import kd.tmc.tm.common.enums.OptionComTradeDirect;
import kd.tmc.tm.common.enums.OptionComTypeEnum;
import kd.tmc.tm.common.resource.TeBizResource;

public class OptionComCalDynPlugin
extends AbstractFormPlugin {
    public void propertyChanged(PropertyChangedArgs args) {
        super.propertyChanged(args);
        String propName = args.getProperty().getName();
        ChangeData[] changeData = args.getChangeSet();
        int index = changeData[0].getRowIndex();
        switch (propName) {
            case "combotype": {
                this.getModel().setValue("comtradedirect", (Object)OptionComTradeDirect.BULLS.getValue());
                this.createEntryList();
                this.initData();
                break;
            }
            case "nameamt": {
                this.nameAmtChangeEnv(index);
                break;
            }
            case "optiontype": {
                this.optionTypeChangeEnv(index);
                break;
            }
            case "strikeprice": {
                this.strikePriceChangeEnv(index);
            }
        }
    }

    private void initData() {
        String combotype = (String)this.getModel().getValue("combotype");
        if (OptionComTypeEnum.BullSpread.getValue().equals(combotype) || OptionComTypeEnum.BearSpread.getValue().equals(combotype) || OptionComTypeEnum.RiskReversal.getValue().equals(combotype)) {
            this.initPropName("tradedirect", TradeDirectionEnum.buy.getValue(), TradeDirectionEnum.sell.getValue());
        } else if (OptionComTypeEnum.Butterfly.getValue().equals(combotype)) {
            this.initPropName("tradedirect", TradeDirectionEnum.buy.getValue(), TradeDirectionEnum.sell.getValue(), TradeDirectionEnum.buy.getValue());
        } else if (OptionComTypeEnum.Straddles.getValue().equals(combotype) || OptionComTypeEnum.Strangles.getValue().equals(combotype)) {
            this.initPropName("tradedirect", TradeDirectionEnum.buy.getValue(), TradeDirectionEnum.buy.getValue());
        }
        if (OptionComTypeEnum.Straddles.getValue().equals(combotype) || OptionComTypeEnum.Strangles.getValue().equals(combotype) || OptionComTypeEnum.RiskReversal.getValue().equals(combotype)) {
            this.initPropName("optiontype", OptionsTradeTypeEnum.call.getValue(), OptionsTradeTypeEnum.put.getValue());
        }
        if (OptionComTypeEnum.BullSpread.getValue().equals(combotype) || OptionComTypeEnum.BearSpread.getValue().equals(combotype)) {
            this.getView().setEnable(Boolean.valueOf(false), 1, new String[]{"optiontype"});
        } else if (OptionComTypeEnum.Butterfly.getValue().equals(combotype)) {
            this.getView().setEnable(Boolean.valueOf(false), 1, new String[]{"optiontype"});
            this.getView().setEnable(Boolean.valueOf(false), 2, new String[]{"optiontype"});
        }
        if (OptionComTypeEnum.BullSpread.getValue().equals(combotype) || OptionComTypeEnum.BearSpread.getValue().equals(combotype) || OptionComTypeEnum.RiskReversal.getValue().equals(combotype) || OptionComTypeEnum.Straddles.getValue().equals(combotype) || OptionComTypeEnum.Strangles.getValue().equals(combotype)) {
            this.getView().setEnable(Boolean.valueOf(false), 1, new String[]{"nameamt"});
        } else if (OptionComTypeEnum.Butterfly.getValue().equals(combotype)) {
            this.getView().setEnable(Boolean.valueOf(false), 1, new String[]{"nameamt"});
            this.getView().setEnable(Boolean.valueOf(false), 2, new String[]{"nameamt"});
        }
        if (OptionComTypeEnum.Butterfly.getValue().equals(combotype)) {
            this.getView().setEnable(Boolean.valueOf(false), 2, new String[]{"strikeprice"});
        } else if (OptionComTypeEnum.Straddles.getValue().equals(combotype)) {
            this.getView().setEnable(Boolean.valueOf(false), 1, new String[]{"strikeprice"});
        }
    }

    private void initPropName(String propName, Object ... param) {
        for (int i = 0; i < param.length; ++i) {
            this.getModel().setValue(propName, param[i], i);
        }
    }

    private void createEntryList() {
        String combotype = (String)this.getModel().getValue("combotype");
        int size = 2;
        if (OptionComTypeEnum.Butterfly.getValue().equals(combotype)) {
            size = 3;
        } else if (OptionComTypeEnum.Custom.getValue().equals(combotype)) {
            size = 1;
        }
        DynamicObjectCollection entrys = this.getModel().getEntryEntity("entrys");
        if (EmptyUtil.isNoEmpty((DynamicObjectCollection)entrys)) {
            this.getModel().deleteEntryData("entrys");
        }
        this.getModel().batchCreateNewEntryRow("entrys", size);
    }

    private void optionTypeChangeEnv(int index) {
        String combotype = (String)this.getModel().getValue("combotype");
        DynamicObjectCollection entrys = this.getModel().getEntryEntity("entrys");
        Object optionType = this.getModel().getValue("optiontype", index);
        if (OptionComTypeEnum.BullSpread.getValue().equals(combotype) || OptionComTypeEnum.BearSpread.getValue().equals(combotype) || OptionComTypeEnum.Butterfly.getValue().equals(combotype)) {
            for (int i = 0; i < entrys.size(); ++i) {
                this.getModel().setValue("optiontype", optionType, i);
            }
        }
    }

    private void strikePriceChangeEnv(int index) {
        String combotype = (String)this.getModel().getValue("combotype");
        if (OptionComTypeEnum.Custom.getValue().equals(combotype)) {
            return;
        }
        DynamicObjectCollection entrys = this.getModel().getEntryEntity("entrys");
        BigDecimal strikePrice0 = (BigDecimal)this.getModel().getValue("strikeprice", 0);
        BigDecimal strikePrice1 = (BigDecimal)this.getModel().getValue("strikeprice", 1);
        if (OptionComTypeEnum.BullSpread.getValue().equals(combotype) && EmptyUtil.isNoEmpty((BigDecimal)strikePrice1)) {
            this.setStrikePrice(strikePrice0, strikePrice1, -1, index);
        }
        if ((OptionComTypeEnum.BearSpread.getValue().equals(combotype) || OptionComTypeEnum.Strangles.getValue().equals(combotype) || OptionComTypeEnum.RiskReversal.getValue().equals(combotype)) && EmptyUtil.isNoEmpty((BigDecimal)strikePrice1)) {
            this.setStrikePrice(strikePrice0, strikePrice1, 1, index);
        }
        if (OptionComTypeEnum.Straddles.getValue().equals(combotype)) {
            Object strikePrice = this.getModel().getValue("strikeprice", index);
            for (int i = 0; i < entrys.size(); ++i) {
                this.getModel().setValue("strikeprice", strikePrice, i);
            }
        }
        if (EmptyUtil.isNoEmpty((BigDecimal)strikePrice1) && EmptyUtil.isNoEmpty((BigDecimal)strikePrice0) && OptionComTypeEnum.Butterfly.getValue().equals(combotype)) {
            this.setStrikePrice(strikePrice0, strikePrice1, -1, index);
            BigDecimal strikePrice2 = strikePrice1.multiply(BigDecimal.valueOf(2L)).subtract(strikePrice0);
            if (strikePrice2.compareTo(Constants.ZERO) > 0) {
                this.getModel().setValue("strikeprice", (Object)strikePrice2, 2);
            }
        }
    }

    private void setStrikePrice(BigDecimal price1, BigDecimal price2, int exp, int index) {
        if (price1.compareTo(price2) != exp) {
            this.getModel().setValue("strikeprice", (Object)0, index);
            String combotype = (String)this.getModel().getValue("combotype");
            if (OptionComTypeEnum.BullSpread.getValue().equals(combotype) || OptionComTypeEnum.Butterfly.getValue().equals(combotype)) {
                this.getView().showErrorNotification(TeBizResource.twoMoreOne());
            } else if (OptionComTypeEnum.RiskReversal.getValue().equals(combotype) || OptionComTypeEnum.BearSpread.getValue().equals(combotype) || OptionComTypeEnum.Strangles.getValue().equals(combotype)) {
                this.getView().showErrorNotification(TeBizResource.twoLessOne());
            }
        }
    }

    private void nameAmtChangeEnv(int index) {
        String combotype = (String)this.getModel().getValue("combotype");
        DynamicObjectCollection entrys = this.getModel().getEntryEntity("entrys");
        if (OptionComTypeEnum.Custom.getValue().equals(combotype)) {
            return;
        }
        if (OptionComTypeEnum.Butterfly.getValue().equals(combotype)) {
            BigDecimal indexNameAmt = (BigDecimal)this.getModel().getValue("nameamt", 0);
            this.getModel().setValue("nameamt", (Object)indexNameAmt, 0);
            this.getModel().setValue("nameamt", (Object)indexNameAmt.multiply(BigDecimal.valueOf(2L)), 1);
            this.getModel().setValue("nameamt", (Object)indexNameAmt, 2);
        } else {
            BigDecimal indexNameAmt = (BigDecimal)this.getModel().getValue("nameamt", index);
            for (int i = 0; i < entrys.size(); ++i) {
                this.getModel().setValue("nameamt", (Object)indexNameAmt, i);
            }
        }
    }
}

