/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.tm.formplugin.rate;

import java.util.Date;
import java.util.EventObject;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import kd.bos.bill.OperationStatus;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.form.IFormView;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.list.ListShowParameter;
import kd.bos.orm.query.QFilter;
import kd.tmc.fbp.common.enums.AdjustMethodEnum;
import kd.tmc.fbp.common.helper.TmcViewInputHelper;
import kd.tmc.fbp.common.helper.business.TradeBusinessHelper;
import kd.tmc.fbp.common.util.EmptyUtil;
import kd.tmc.fbp.common.util.TcDateUtils;
import kd.tmc.fbp.common.util.TermUtils;
import kd.tmc.tm.formplugin.trade.AbstractTradeBillEdit;

public class ForwRateAgreeEdit
extends AbstractTradeBillEdit
implements BeforeF7SelectListener {
    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
    }

    public void propertyChanged(PropertyChangedArgs e) {
        String key;
        super.propertyChanged(e);
        switch (key = e.getProperty().getName()) {
            case "bizdate": 
            case "settledelay": {
                this.setStartDate();
                break;
            }
            case "startdate": {
                if (this.isDate1AfterOrEqualDate2("startdate", "bizdate")) {
                    this.setSettleDelay();
                    this.FRAchange();
                    break;
                }
                this.getModel().setValue("startdate", null);
                this.getView().showErrorNotification(ResManager.loadKDString((String)"\u8fdc\u671f\u5408\u7ea6\u5f00\u59cb\u65e5\u5fc5\u987b\u5927\u4e8e\u7b49\u4e8e\u4ea4\u6613\u65e5\u671f\u3002", (String)"ForwRateAgreeEdit_0", (String)"tmc-tm-formplugin", (Object[])new Object[0]));
                break;
            }
            case "settledate": {
                if (this.isDate1AfterDate2("settledate", "startdate")) {
                    if (this.isDate1AfterDate2("enddate", "settledate")) {
                        this.setLoanPeriod(key);
                        this.setAdjustDate("settledate", "adjustsettledate");
                        this.setFRA();
                        break;
                    }
                    this.getModel().setValue("settledate", null);
                    this.getView().showErrorNotification(ResManager.loadKDString((String)"\u5408\u7ea6\u8d37\u6b3e\u5230\u671f\u65e5\u5fc5\u987b\u5927\u4e8e\u5408\u7ea6\u7ed3\u7b97\u65e5\u671f\u3002", (String)"ForwRateAgreeEdit_1", (String)"tmc-tm-formplugin", (Object[])new Object[0]));
                    break;
                }
                this.getModel().setValue("settledate", null);
                this.getView().showErrorNotification(ResManager.loadKDString((String)"\u5408\u7ea6\u7ed3\u7b97\u65e5\u671f\u5fc5\u987b\u5927\u4e8e\u8fdc\u671f\u5408\u7ea6\u5f00\u59cb\u65e5\u3002", (String)"ForwRateAgreeEdit_2", (String)"tmc-tm-formplugin", (Object[])new Object[0]));
                break;
            }
            case "enddate": {
                if (this.isDate1AfterDate2("enddate", "settledate")) {
                    this.setLoanPeriod(key);
                    this.setAdjustDate("enddate", "adjustenddate");
                    this.setFRA();
                    break;
                }
                this.getModel().setValue("enddate", null);
                this.getView().showErrorNotification(ResManager.loadKDString((String)"\u5408\u7ea6\u8d37\u6b3e\u5230\u671f\u65e5\u5fc5\u987b\u5927\u4e8e\u5408\u7ea6\u7ed3\u7b97\u65e5\u671f\u3002", (String)"ForwRateAgreeEdit_1", (String)"tmc-tm-formplugin", (Object[])new Object[0]));
                break;
            }
            case "loanperiod": {
                this.loanPeriod_ChangeEvent();
                this.setFRA();
                break;
            }
            case "dateadjustmethod": 
            case "workcalendar": {
                this.setAdjustDate("settledate", "adjustsettledate");
                this.setAdjustDate("enddate", "adjustenddate");
                break;
            }
            case "fra": {
                this.FRAchange();
                break;
            }
            case "currency": {
                TmcViewInputHelper.setValWithoutPropChgEvt((IFormView)this.getView(), (IDataModel)this.getModel(), (String)"market", null);
                TradeBusinessHelper.initMarketValue((IDataModel)this.getModel(), (IFormView)this.getView(), (String)"market", (String)"currency");
                TradeBusinessHelper.initWorkCalendar((IDataModel)this.getModel(), (IFormView)this.getView(), (String)"currency", (String)"workcalendar");
                break;
            }
            case "amount": {
                this.getModel().setValue("bizrestamt", this.getModel().getValue("amount"));
            }
        }
    }

    protected void loanPeriod_ChangeEvent() {
        String loadPeriod = (String)this.getModel().getValue("loanperiod");
        if (EmptyUtil.isEmpty((String)loadPeriod)) {
            return;
        }
        if (TermUtils.isRightFormat((IDataModel)this.getModel(), (IFormView)this.getView(), (String)loadPeriod)) {
            Date settledate = (Date)this.getModel().getValue("settledate");
            if (EmptyUtil.isNoEmpty((Object)settledate)) {
                TmcViewInputHelper.setValWithoutPropChgEvt((IFormView)this.getView(), (IDataModel)this.getModel(), (String)"enddate", (Object)TermUtils.getDateByBaseDate4ymd((String)loadPeriod, (Date)settledate));
                this.setAdjustDate("enddate", "adjustenddate");
            }
        } else {
            TmcViewInputHelper.setValWithoutPropChgEvt((IFormView)this.getView(), (IDataModel)this.getModel(), (String)"loanperiod", null);
        }
    }

    private boolean isDate1AfterDate2(String dateProp1, String dateProp2) {
        Date date1 = (Date)this.getModel().getValue(dateProp1);
        Date date2 = (Date)this.getModel().getValue(dateProp2);
        if (EmptyUtil.isAnyoneEmpty((Object[])new Object[]{date1, date2})) {
            return true;
        }
        return date1.after(date2);
    }

    private boolean isDate1AfterOrEqualDate2(String dateProp1, String dateProp2) {
        Date date2;
        Date date1 = (Date)this.getModel().getValue(dateProp1);
        if (EmptyUtil.isAnyoneEmpty((Object[])new Object[]{date1, date2 = (Date)this.getModel().getValue(dateProp2)})) {
            return true;
        }
        return !date1.before(date2);
    }

    protected void setLoanPeriod(String changeDateProp) {
        Date settleDate = (Date)this.getModel().getValue("settledate");
        Date endDate = (Date)this.getModel().getValue("enddate");
        if (!EmptyUtil.isAnyoneEmpty((Object[])new Object[]{settleDate, endDate})) {
            TmcViewInputHelper.setValWithoutPropChgEvt((IFormView)this.getView(), (IDataModel)this.getModel(), (String)"loanperiod", (Object)TcDateUtils.getDiffYMD((Date)settleDate, (Date)endDate));
        }
    }

    public void setFRA() {
        if (EmptyUtil.isAnyoneEmpty((Object[])new Object[]{this.getModel().getValue("startdate"), this.getModel().getValue("settledate"), this.getModel().getValue("enddate")})) {
            return;
        }
        int N = this.getDiffMonth("startdate", "settledate");
        int M = this.getDiffMonth("startdate", "enddate");
        if (N == -1 || M == -1) {
            this.getView().setEnable(Boolean.valueOf(false), new String[]{"fra"});
            TmcViewInputHelper.setValWithoutPropChgEvt((IFormView)this.getView(), (IDataModel)this.getModel(), (String)"fra", null);
        } else {
            this.getView().setEnable(Boolean.valueOf(true), new String[]{"fra"});
            TmcViewInputHelper.setValWithoutPropChgEvt((IFormView)this.getView(), (IDataModel)this.getModel(), (String)"fra", (Object)String.format("%d-%d", N, M));
        }
    }

    public int getDiffMonth(String start, String end) {
        int diffMonth;
        Date startdate;
        Date diffDate;
        Date enddate = (Date)this.getModel().getValue(end);
        if (TcDateUtils.isSameDay((Date)enddate, (Date)(diffDate = TcDateUtils.getNextMonth((Date)(startdate = (Date)this.getModel().getValue(start)), (int)(diffMonth = TcDateUtils.getDiffMonth((Date)startdate, (Date)enddate)))))) {
            return diffMonth;
        }
        return -1;
    }

    public void setSettleDelay() {
        Date bizdate = (Date)this.getModel().getValue("bizdate");
        Date startdate = (Date)this.getModel().getValue("startdate");
        if (EmptyUtil.isNoEmpty((Object)bizdate) && EmptyUtil.isNoEmpty((Object)startdate)) {
            TmcViewInputHelper.setValWithoutPropChgEvt((IFormView)this.getView(), (IDataModel)this.getModel(), (String)"settledelay", (Object)TcDateUtils.getDiffDays((Date)bizdate, (Date)startdate));
        }
    }

    public void setStartDate() {
        Date bizdate = (Date)this.getModel().getValue("bizdate");
        if (EmptyUtil.isNoEmpty((Object)bizdate)) {
            int settledelay = 0;
            if (this.getModel().getValue("settledelay") != null) {
                settledelay = (Integer)this.getModel().getValue("settledelay");
            }
            this.getModel().setValue("startdate", (Object)TcDateUtils.getNextDay((Date)bizdate, (int)settledelay));
        }
    }

    public void FRAchange() {
        String FRA = (String)this.getModel().getValue("fra");
        if (!EmptyUtil.isEmpty((String)FRA)) {
            String pattern = "^(\\d+)-(\\d+)$";
            Pattern r = Pattern.compile(pattern);
            Matcher matcher = r.matcher(FRA);
            if (matcher.find()) {
                int M;
                int N = Integer.parseInt(matcher.group(1));
                if (N >= (M = Integer.parseInt(matcher.group(2)))) {
                    this.getModel().setValue("fra", null);
                    this.getView().showErrorNotification(ResManager.loadKDString((String)"FRA\u540e\u9762\u7684\u6570\u503c\u9700\u8981\u5927\u4e8e\u524d\u9762\u7684\u6570\u503c\u3002", (String)"ForwRateAgreeEdit_3", (String)"tmc-tm-formplugin", (Object[])new Object[0]));
                    return;
                }
                int loanPeriod = M - N;
                this.setSettleDate(N);
                this.setAdjustDate("settledate", "adjustsettledate");
                TmcViewInputHelper.setValWithoutPropChgEvt((IFormView)this.getView(), (IDataModel)this.getModel(), (String)"loanperiod", (Object)(loanPeriod + "m"));
                this.setEndDate(loanPeriod);
                this.setAdjustDate("enddate", "adjustenddate");
            } else {
                this.getModel().setValue("fra", null);
                this.getView().showErrorNotification(ResManager.loadKDString((String)"FRA\u7684\u6570\u636e\u9700\u6ee1\u8db3i-j\u7684\u683c\u5f0f\u3002", (String)"ForwRateAgreeEdit_4", (String)"tmc-tm-formplugin", (Object[])new Object[0]));
            }
        }
    }

    public void setSettleDate(int period) {
        Date startdate = (Date)this.getModel().getValue("startdate");
        if (!EmptyUtil.isEmpty((Object)startdate)) {
            TmcViewInputHelper.setValWithoutPropChgEvt((IFormView)this.getView(), (IDataModel)this.getModel(), (String)"settledate", (Object)TcDateUtils.getNextMonth((Date)startdate, (int)period));
        }
    }

    public void setAdjustDate(String dateProp, String adjDateProp) {
        String dateAdjMethod = (String)this.getModel().getValue("dateadjustmethod");
        Date date = (Date)this.getModel().getValue(dateProp);
        if (EmptyUtil.isAnyoneEmpty((Object[])new Object[]{date, dateAdjMethod})) {
            return;
        }
        AdjustMethodEnum adjustmethod = AdjustMethodEnum.valueOf((String)dateAdjMethod);
        if (!adjustmethod.equals((Object)AdjustMethodEnum.no_adjust)) {
            DynamicObjectCollection workCalendars = (DynamicObjectCollection)this.getModel().getValue("workcalendar");
            Date adjDate = TradeBusinessHelper.callAdjustSettleDate((DynamicObjectCollection)workCalendars, (Date)TcDateUtils.truncateDate((Date)date), (AdjustMethodEnum)adjustmethod);
            TmcViewInputHelper.setValWithoutDataChanged((IDataModel)this.getModel(), (String)adjDateProp, (Object)adjDate);
        } else {
            TmcViewInputHelper.setValWithoutDataChanged((IDataModel)this.getModel(), (String)adjDateProp, (Object)date);
        }
    }

    public void setEndDate(int loanPeriod) {
        Date settledate = (Date)this.getModel().getValue("settledate");
        if (!EmptyUtil.isEmpty((Object)settledate)) {
            TmcViewInputHelper.setValWithoutPropChgEvt((IFormView)this.getView(), (IDataModel)this.getModel(), (String)"enddate", (Object)TcDateUtils.getNextMonth((Date)settledate, (int)loanPeriod));
        }
    }

    public void beforeF7Select(BeforeF7SelectEvent arg) {
        DynamicObject currency;
        String fieldKey = arg.getProperty().getName();
        if (StringUtils.equals((CharSequence)fieldKey, (CharSequence)"market") && EmptyUtil.isNoEmpty((DynamicObject)(currency = (DynamicObject)this.getModel().getValue("currency")))) {
            QFilter qFilter = new QFilter("currency.id", "=", currency.getPkValue());
            ListShowParameter showParameter = (ListShowParameter)arg.getFormShowParameter();
            showParameter.getListFilterParameter().setFilter(qFilter);
        }
    }

    public void beforeBindData(EventObject e) {
        super.beforeBindData(e);
        if (this.getView().getFormShowParameter().getStatus().equals((Object)OperationStatus.ADDNEW)) {
            this.getModel().setValue("bizrestamt", this.getModel().getValue("amount"));
        }
    }

    public void registerListener(EventObject e) {
        super.registerListener(e);
        BasedataEdit market = (BasedataEdit)this.getView().getControl("market");
        market.addBeforeF7SelectListener((BeforeF7SelectListener)this);
    }
}

