/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.tm.formplugin.rate;

import java.math.BigDecimal;
import java.util.Collections;
import java.util.Date;
import java.util.EventObject;
import java.util.Map;
import kd.bos.bill.OperationStatus;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.form.FieldTip;
import kd.bos.form.IFormView;
import kd.bos.form.container.Tab;
import kd.bos.form.control.Control;
import kd.bos.form.control.events.TabSelectEvent;
import kd.bos.form.control.events.TabSelectListener;
import kd.bos.form.events.BeforeFieldPostBackEvent;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.DateEdit;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.form.fieldtip.DeleteRule;
import kd.bos.list.ListShowParameter;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.basedata.BaseDataServiceHelper;
import kd.tmc.fbp.common.enums.AdjustMethodEnum;
import kd.tmc.fbp.common.enums.TcBillStatusEnum;
import kd.tmc.fbp.common.helper.TmcDataServiceHelper;
import kd.tmc.fbp.common.helper.TmcViewInputHelper;
import kd.tmc.fbp.common.helper.business.TradeBusinessHelper;
import kd.tmc.fbp.common.helper.service.MarketDataServiceHelper;
import kd.tmc.fbp.common.model.ForexQuoteInfo;
import kd.tmc.fbp.common.util.EmptyUtil;
import kd.tmc.fbp.common.util.TcDateUtils;
import kd.tmc.fbp.common.util.TermUtils;
import kd.tmc.tm.common.enums.ConfigPayTypeEnum;
import kd.tmc.tm.common.enums.QuotaFrequency;
import kd.tmc.tm.common.enums.RateSwapsPayTypeEnum;
import kd.tmc.tm.common.enums.RateTypeEnum;
import kd.tmc.tm.common.enums.SwapTypeEnum;
import kd.tmc.tm.common.helper.RateSwapHelper;
import kd.tmc.tm.formplugin.trade.AbstractTradeBillEdit;

public class RateSwapsEdit
extends AbstractTradeBillEdit
implements BeforeF7SelectListener,
TabSelectListener {
    public void registerListener(EventObject e) {
        super.registerListener(e);
        BasedataEdit sellMarket = (BasedataEdit)this.getView().getControl("market");
        BasedataEdit buyMarket = (BasedataEdit)this.getView().getControl("recmarket");
        sellMarket.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        buyMarket.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        Tab tabap = (Tab)this.getView().getControl("tabap");
        if (tabap != null) {
            tabap.addTabSelectListener((TabSelectListener)this);
        }
    }

    public void beforeF7Select(BeforeF7SelectEvent arg) {
        DynamicObject currency;
        String fieldKey = arg.getProperty().getName();
        if ((StringUtils.equals((CharSequence)fieldKey, (CharSequence)"market") || StringUtils.equals((CharSequence)fieldKey, (CharSequence)"recmarket")) && EmptyUtil.isNoEmpty((DynamicObject)(currency = (DynamicObject)(StringUtils.equals((CharSequence)fieldKey, (CharSequence)"market") ? this.getModel().getValue("currency") : this.getModel().getValue("reccurrency"))))) {
            QFilter qFilter = new QFilter("currency.id", "=", currency.getPkValue());
            ListShowParameter showParameter = (ListShowParameter)arg.getFormShowParameter();
            showParameter.getListFilterParameter().setFilter(qFilter);
        }
    }

    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
        this.setStartDate();
        this.getModel().setValue("valuedate", this.getModel().getValue("startdate"));
        this.getModel().setValue("recvaluedate", this.getModel().getValue("startdate"));
    }

    public void beforeBindData(EventObject e) {
        super.beforeBindData(e);
        if (this.getView().getFormShowParameter().getStatus().equals((Object)OperationStatus.ADDNEW)) {
            this.setStartDate();
            this.getModel().setValue("bizrestamt", this.getModel().getValue("amount"));
        }
        this.setControl_endDate();
    }

    private void setControl_endDate() {
        if (EmptyUtil.isNoEmpty((Object)this.getModel().getValue("startdate"))) {
            DateEdit endDateEdit = (DateEdit)this.getView().getControl("enddate");
            endDateEdit.setMinDate((Date)this.getModel().getValue("startdate"));
        }
    }

    @Override
    public void afterBindData(EventObject e) {
        super.afterBindData(e);
        this.getView().setEnable(Boolean.valueOf(false), new String[]{"adjustedenddate", "firstfixeddate", "recfirstfixeddate"});
        this.setControlByStub();
        this.setControlByRecStub();
        this.setControlStubDate(true);
        this.setControlStubDate(false);
        this.setControlBeforeInitDate(true);
        this.setControlBeforeInitDate(false);
        this.setControlBaseCurrencyRate();
        this.payTypeChangeEvt("paytype");
        this.payTypeChangeEvt("recpaytype");
    }

    private boolean setControlBaseCurrencyRate() {
        boolean isShow = !this.isBaseCurrency();
        String[] mustInput = new String[]{"currentrate2", "currentrate3"};
        TmcViewInputHelper.registerVisibleStatus((IFormView)this.getView(), (String[])mustInput, (boolean)isShow);
        TmcViewInputHelper.registerMustInput((IFormView)this.getView(), (boolean)isShow, (String[])mustInput);
        return isShow;
    }

    public void beforeFieldPostBack(BeforeFieldPostBackEvent e) {
        String key;
        Control source = (Control)e.getSource();
        switch (key = source.getKey()) {
            case "fixedrate": 
            case "recfixedrate": {
                BigDecimal v = EmptyUtil.isEmpty((Object)e.getValue()) ? BigDecimal.ZERO : new BigDecimal((String)e.getValue());
                FieldTip tip = new FieldTip();
                tip.setFieldKey(key);
                if (v.compareTo(BigDecimal.ZERO) <= 0) {
                    tip.setLevel(FieldTip.FieldTipsLevel.Error);
                    tip.setTip(ResManager.loadKDString((String)"\u8f93\u5165\u6570\u503c\u8981\u5927\u4e8e0\u3002", (String)"RateSwapsEdit_2", (String)"tmc-tm-formplugin", (Object[])new Object[0]));
                    this.getView().showFieldTip(tip);
                    e.setCancel(true);
                    this.getView().updateView(key);
                    break;
                }
                DeleteRule deleteRule = new DeleteRule();
                deleteRule.setFields(Collections.singletonList(key));
                tip.setDeleteRule(deleteRule);
                tip.setSuccess(true);
                this.getView().showFieldTip(tip);
                break;
            }
            case "rateresetfreq": 
            case "recrateresetfreq": {
                BigDecimal value = EmptyUtil.isEmpty((Object)e.getValue()) ? BigDecimal.ZERO : new BigDecimal((String)e.getValue());
                FieldTip tips = new FieldTip();
                tips.setFieldKey(key);
                if (value.compareTo(BigDecimal.ZERO) <= 0 || value.compareTo(BigDecimal.valueOf(12L)) > 0) {
                    tips.setLevel(FieldTip.FieldTipsLevel.Error);
                    tips.setTip(ResManager.loadKDString((String)"\u8bf7\u8f93\u51651-12\u7684\u6574\u6570\u3002", (String)"RateSwapsEdit_3", (String)"tmc-tm-formplugin", (Object[])new Object[0]));
                    this.getView().showFieldTip(tips);
                    e.setCancel(true);
                    this.getView().updateView(key);
                    break;
                }
                if (new BigDecimal(value.intValue()).compareTo(value) != 0) {
                    tips.setLevel(FieldTip.FieldTipsLevel.Error);
                    tips.setTip(ResManager.loadKDString((String)"\u8bf7\u8f93\u51651-12\u7684\u6574\u6570\u3002", (String)"RateSwapsEdit_3", (String)"tmc-tm-formplugin", (Object[])new Object[0]));
                    this.getView().showFieldTip(tips);
                    e.setCancel(true);
                    this.getView().updateView(key);
                    break;
                }
                DeleteRule deleteRule = new DeleteRule();
                deleteRule.setFields(Collections.singletonList(key));
                tips.setDeleteRule(deleteRule);
                tips.setSuccess(true);
                this.getView().showFieldTip(tips);
            }
        }
    }

    public void propertyChanged(PropertyChangedArgs e) {
        super.propertyChanged(e);
        String key = e.getProperty().getName();
        Object newValue = e.getChangeSet()[0].getNewValue();
        switch (key) {
            case "rateswaptype": {
                this.swapTypeChangeEvt();
                break;
            }
            case "bizdate": 
            case "settledelay": {
                this.setStartDate();
                break;
            }
            case "startdate": {
                this.setSettleDelay();
                this.setControl_endDate();
                this.setEndDateWithoutPropChg();
                Date startDate = (Date)this.getModel().getValue("startdate");
                if (EmptyUtil.isEmpty((Object)startDate)) break;
                this.getModel().setValue("valuedate", (Object)startDate);
                this.getModel().setValue("recvaluedate", (Object)startDate);
                break;
            }
            case "term": {
                this.termChangeEvt();
                break;
            }
            case "enddate": {
                this.setTermWithoutPropChg();
                this.setAdjustedEndDate();
                this.setControlStubDate(true);
                this.setControlStubDate(false);
                break;
            }
            case "workcalendar": {
                this.setSettleDelay();
                this.setAdjustedEndDate();
                break;
            }
            case "endadjmethod": {
                this.setAdjustedEndDate();
                break;
            }
            case "currency": 
            case "reccurrency": {
                this.currencyChangeEvt(key.equals("currency"), newValue);
                break;
            }
            case "pricerule": {
                this.priceRuleChangeEvt();
                break;
            }
            case "amount": {
                this.amountChangeEvt();
                break;
            }
            case "recamount": {
                this.recAmountChangeEvt();
                break;
            }
            case "valuedate": 
            case "recvaluedate": {
                RateSwapHelper.calFirstComfirmDate((IDataModel)this.getModel(), (IFormView)this.getView(), (boolean)key.equals("valuedate"), (boolean)true, (boolean)true);
                this.setControlBeforeInitDate(key.equals("valuedate"));
                this.setControlStubDate(true);
                this.setControlStubDate(false);
                break;
            }
            case "ratetype": {
                this.setControlByStub();
                this.rateTypeChangeEvt(key, true);
                break;
            }
            case "recratetype": {
                this.setControlByRecStub();
                this.rateTypeChangeEvt(key, false);
                break;
            }
            case "paytype": 
            case "recpaytype": {
                this.payTypeChangeEvt(key);
                break;
            }
            case "paydatetype": 
            case "recpaydatetype": {
                this.payDateTypeChangeEvt(key);
                break;
            }
            case "ratequotafreq": 
            case "recratequotafreq": {
                this.quotaFreqChangeEvt(key);
                break;
            }
            case "rateresettype": {
                RateSwapHelper.calFirstComfirmDate((IDataModel)this.getModel(), (IFormView)this.getView(), (boolean)true, (boolean)true, (boolean)true);
                String rateresettype = (String)this.getModel().getValue("rateresettype");
                if (!"delay".equals(rateresettype)) break;
                TmcViewInputHelper.setValWithoutDataChanged((IDataModel)this.getModel(), (String)"firstfixeddate", null);
                TmcViewInputHelper.setValWithoutDataChanged((IDataModel)this.getModel(), (String)"firstfixedrate", null);
                break;
            }
            case "recrateresettype": {
                RateSwapHelper.calFirstComfirmDate((IDataModel)this.getModel(), (IFormView)this.getView(), (boolean)false, (boolean)true, (boolean)true);
                String recrateresettype = (String)this.getModel().getValue("recrateresettype");
                if (!"delay".equals(recrateresettype)) break;
                TmcViewInputHelper.setValWithoutDataChanged((IDataModel)this.getModel(), (String)"recfirstfixeddate", null);
                TmcViewInputHelper.setValWithoutDataChanged((IDataModel)this.getModel(), (String)"recfirstfixedrate", null);
                break;
            }
            case "rateresetoffset": 
            case "recrateresetoffset": {
                RateSwapHelper.calFirstComfirmDate((IDataModel)this.getModel(), (IFormView)this.getView(), (boolean)key.equals("rateresetoffset"), (boolean)true, (boolean)true);
                break;
            }
            case "payfrequency": 
            case "recpayfrequency": {
                this.freqChangeEvt(key);
                break;
            }
            case "firstpaycopdate": 
            case "recfirstpaycopdate": {
                RateSwapHelper.calFirstComfirmDate((IDataModel)this.getModel(), (IFormView)this.getView(), (boolean)key.equals("firstpaycopdate"), (boolean)true, (boolean)true);
                break;
            }
            case "stub": 
            case "stubtype": {
                this.setControlByStub();
                break;
            }
            case "recstub": 
            case "recstubtype": {
                this.setControlByRecStub();
                break;
            }
            case "refindex": {
                this.getModel().setValue("firstreferrate", this.getModel().getValue("refindex"));
                this.getModel().setValue("penureferrate", this.getModel().getValue("refindex"));
                break;
            }
            case "recrefindex": {
                this.getModel().setValue("recfirstreferrate", this.getModel().getValue("recrefindex"));
                this.getModel().setValue("recpenureferrate", this.getModel().getValue("recrefindex"));
                break;
            }
            case "initexamount": {
                TmcViewInputHelper.setValWithoutPropChgEvt((IFormView)this.getView(), (IDataModel)this.getModel(), (String)"initexamount", (Object)((BigDecimal)newValue).abs());
                break;
            }
            case "recinitexamount": {
                TmcViewInputHelper.setValWithoutPropChgEvt((IFormView)this.getView(), (IDataModel)this.getModel(), (String)"recinitexamount", (Object)((BigDecimal)newValue).abs().negate());
            }
        }
    }

    private void setControlByStub() {
        boolean isStub = (Boolean)this.getModel().getValue("stub");
        String stubType = (String)this.getModel().getValue("stubtype");
        String rateType = (String)this.getModel().getValue("ratetype");
        if (isStub) {
            this.getView().setVisible(Boolean.valueOf(true), new String[]{"stubtype"});
            this.getView().setVisible(Boolean.valueOf(false), new String[]{"firstpaycopdate", "penupaycopdate", "firstreferrate", "penureferrate"});
            if ("front".equals(stubType)) {
                this.getView().setVisible(Boolean.valueOf(true), new String[]{"firstpaycopdate", "firstreferrate"});
                this.getView().setVisible(Boolean.valueOf("float".equals(rateType)), new String[]{"firstreferrate"});
                TmcViewInputHelper.registerMustInput((IFormView)this.getView(), (boolean)true, (String[])new String[]{"firstpaycopdate", "firstreferrate"});
                TmcViewInputHelper.registerMustInput((IFormView)this.getView(), (boolean)false, (String[])new String[]{"penupaycopdate", "penureferrate"});
            }
            if ("end".equals(stubType)) {
                this.getView().setVisible(Boolean.valueOf(true), new String[]{"penupaycopdate", "penureferrate"});
                this.getView().setVisible(Boolean.valueOf("float".equals(rateType)), new String[]{"penureferrate"});
                TmcViewInputHelper.registerMustInput((IFormView)this.getView(), (boolean)false, (String[])new String[]{"firstpaycopdate", "firstreferrate"});
                TmcViewInputHelper.registerMustInput((IFormView)this.getView(), (boolean)true, (String[])new String[]{"penupaycopdate", "penureferrate"});
            }
        } else {
            this.getView().setVisible(Boolean.valueOf(false), new String[]{"stubtype", "firstpaycopdate", "firstreferrate", "penupaycopdate", "penureferrate"});
            TmcViewInputHelper.registerMustInput((IFormView)this.getView(), (boolean)false, (String[])new String[]{"stubtype", "firstpaycopdate", "firstreferrate", "penupaycopdate", "penureferrate"});
        }
    }

    private void setControlByRecStub() {
        boolean isStub = (Boolean)this.getModel().getValue("recstub");
        String stubType = (String)this.getModel().getValue("recstubtype");
        String rateType = (String)this.getModel().getValue("recratetype");
        if (isStub) {
            this.getView().setVisible(Boolean.valueOf(true), new String[]{"recstubtype"});
            this.getView().setVisible(Boolean.valueOf(false), new String[]{"recfirstpaycopdate", "recpenupaycopdate", "recfirstreferrate", "recpenureferrate"});
            if ("front".equals(stubType)) {
                this.getView().setVisible(Boolean.valueOf(true), new String[]{"recfirstpaycopdate", "recfirstreferrate"});
                this.getView().setVisible(Boolean.valueOf("float".equals(rateType)), new String[]{"recfirstreferrate"});
                TmcViewInputHelper.registerMustInput((IFormView)this.getView(), (boolean)true, (String[])new String[]{"recfirstpaycopdate", "recfirstreferrate"});
                TmcViewInputHelper.registerMustInput((IFormView)this.getView(), (boolean)false, (String[])new String[]{"recpenupaycopdate", "recpenureferrate"});
            }
            if ("end".equals(stubType)) {
                this.getView().setVisible(Boolean.valueOf(true), new String[]{"recpenupaycopdate", "recpenureferrate"});
                this.getView().setVisible(Boolean.valueOf("float".equals(rateType)), new String[]{"recpenureferrate"});
                TmcViewInputHelper.registerMustInput((IFormView)this.getView(), (boolean)false, (String[])new String[]{"recfirstpaycopdate", "recfirstreferrate"});
                TmcViewInputHelper.registerMustInput((IFormView)this.getView(), (boolean)true, (String[])new String[]{"recpenupaycopdate", "recpenureferrate"});
            }
        } else {
            this.getView().setVisible(Boolean.valueOf(false), new String[]{"recstubtype", "recfirstpaycopdate", "recfirstreferrate", "recpenupaycopdate", "recpenureferrate"});
            TmcViewInputHelper.registerMustInput((IFormView)this.getView(), (boolean)false, (String[])new String[]{"recstubtype", "recfirstpaycopdate", "recfirstreferrate", "recpenupaycopdate", "recpenureferrate"});
        }
    }

    protected boolean isRate() {
        return this.getModel().getValue("rateswaptype").equals(SwapTypeEnum.rate.getValue());
    }

    protected boolean isBaseCurrency() {
        boolean isBaseCurrency = false;
        Long orgId = (Long)((DynamicObject)this.getModel().getValue("org")).getPkValue();
        Map result = BaseDataServiceHelper.getBaseAccountingInfo((Long)orgId);
        DynamicObject payCurrency = (DynamicObject)this.getModel().getValue("currency");
        DynamicObject recCurrency = (DynamicObject)this.getModel().getValue("reccurrency");
        if (EmptyUtil.isNoEmpty((Object)result)) {
            Long baseCurrencyID = (Long)result.get("baseCurrencyID");
            isBaseCurrency = !EmptyUtil.isAnyoneEmpty((Object[])new Object[]{baseCurrencyID, payCurrency}) && baseCurrencyID.equals(payCurrency.getPkValue()) || !EmptyUtil.isAnyoneEmpty((Object[])new Object[]{baseCurrencyID, recCurrency}) && baseCurrencyID.equals(recCurrency.getPkValue());
        }
        return isBaseCurrency;
    }

    private void calExchangeRate() {
        BigDecimal amount = (BigDecimal)this.getModel().getValue("amount");
        BigDecimal recAmount = (BigDecimal)this.getModel().getValue("recamount");
        if (!this.isRate() && recAmount.compareTo(BigDecimal.ZERO) != 0) {
            this.getModel().setValue("nominalrate", (Object)amount.divide(recAmount, 10, 4).abs());
        }
    }

    protected boolean isRecresidual(String frequencyField) {
        String frequency;
        String term = (String)this.getModel().getValue("term");
        if (!EmptyUtil.isAnyoneEmpty((Object[])new Object[]{term, frequency = (String)this.getModel().getValue(frequencyField)})) {
            boolean isRecresidual = EmptyUtil.isNoEmpty((String)frequency) && RateSwapHelper.isIntMultiple((String)term, (String)frequency);
            return !isRecresidual;
        }
        return false;
    }

    protected void setEndDateWithoutPropChg() {
        Date startDate = (Date)this.getModel().getValue("startdate");
        String term = (String)this.getModel().getValue("term");
        if (!EmptyUtil.isAnyoneEmpty((Object[])new Object[]{startDate, term})) {
            TmcViewInputHelper.setValWithoutPropChgEvt((IFormView)this.getView(), (IDataModel)this.getModel(), (String)"enddate", (Object)TermUtils.getDateByBaseDate4ymd((String)term, (Date)startDate));
            this.setAdjustedEndDate();
            this.setControlStubDate(true);
            this.setControlStubDate(false);
        }
    }

    protected void setTermWithoutPropChg() {
        Date endDate = (Date)this.getModel().getValue("enddate");
        Date startDate = (Date)this.getModel().getValue("startdate");
        if (!EmptyUtil.isAnyoneEmpty((Object[])new Object[]{startDate, endDate})) {
            TmcViewInputHelper.setValWithoutPropChgEvt((IFormView)this.getView(), (IDataModel)this.getModel(), (String)"term", (Object)TcDateUtils.getDiffYMD((Date)startDate, (Date)endDate));
            this.checkNeedStub();
        }
    }

    protected void setAdjustedEndDate() {
        DynamicObjectCollection calendars = (DynamicObjectCollection)this.getModel().getValue("workcalendar");
        Date endDate = (Date)this.getModel().getValue("enddate");
        AdjustMethodEnum adjustMethod = AdjustMethodEnum.getEnumByValue((String)((String)this.getModel().getValue("endadjmethod")));
        if (EmptyUtil.isNoEmpty((Object)endDate)) {
            this.getModel().setValue("adjustedenddate", (Object)TradeBusinessHelper.callAdjustSettleDate((DynamicObjectCollection)calendars, (Date)endDate, (AdjustMethodEnum)adjustMethod));
        }
    }

    public void tabSelected(TabSelectEvent e) {
        String tabKey = e.getTabKey();
        if (tabKey.equals("tabpageap") && this.getModel().getDataChanged() && TcBillStatusEnum.SAVE.getValue().equals(this.getModel().getValue("billstatus"))) {
            RateSwapHelper.calFirstComfirmDate((IDataModel)this.getModel(), (IFormView)this.getView(), (boolean)true, (boolean)false, (boolean)true);
            RateSwapHelper.calFirstComfirmDate((IDataModel)this.getModel(), (IFormView)this.getView(), (boolean)false, (boolean)false, (boolean)true);
        }
    }

    protected void calFirstFixedRate(boolean isPay) {
        String rateQuoteFreq = "ratequotafreq";
        String fixedDate = "firstfixeddate";
        String referRate = "refindex";
        String rateMargin = "ratemargin";
        String workCalendars = "payworkcalendar";
        String beforeInitDate = "beforeinitdate";
        String rateAdjustMethod = "rateadjustmethod";
        String FirstFixedrate = "firstfixedrate";
        if (!isPay) {
            rateQuoteFreq = "recratequotafreq";
            fixedDate = "recfirstfixeddate";
            referRate = "recrefindex";
            rateMargin = "recratemargin";
            workCalendars = "recworkcalendar";
            beforeInitDate = "recbeforeinitdate";
            rateAdjustMethod = "recrateadjustmethod";
            FirstFixedrate = "recfirstfixedrate";
        }
        boolean isDay = this.getModel().getValue(rateQuoteFreq).equals(QuotaFrequency.Day.getValue());
        Date firstComfirmDate = (Date)this.getModel().getValue(fixedDate);
        if (EmptyUtil.isNoEmpty((Object)firstComfirmDate) && !firstComfirmDate.after(TcDateUtils.getCurrentDate())) {
            BigDecimal referRatePrice;
            DynamicObject referrate = (DynamicObject)this.getModel().getValue(referRate);
            BigDecimal margin = (BigDecimal)this.getModel().getValue(rateMargin);
            Date date = null;
            if (isDay) {
                date = firstComfirmDate;
            } else {
                AdjustMethodEnum adjustMethod;
                Date initDate;
                DynamicObjectCollection calendars = (DynamicObjectCollection)this.getModel().getValue(workCalendars);
                if (!EmptyUtil.isAnyoneEmpty((Object[])new Object[]{calendars, initDate = (Date)this.getModel().getValue(beforeInitDate), adjustMethod = AdjustMethodEnum.getEnumByValue((String)((String)this.getModel().getValue(rateAdjustMethod)))})) {
                    date = TradeBusinessHelper.callAdjustSettleDate((DynamicObjectCollection)calendars, (Date)initDate, (AdjustMethodEnum)adjustMethod);
                }
            }
            if (!EmptyUtil.isAnyoneEmpty((Object[])new Object[]{referrate, date}) && EmptyUtil.isNoEmpty((BigDecimal)(referRatePrice = MarketDataServiceHelper.referRate((String)referrate.getString("number"), (Date)date)))) {
                this.getModel().setValue(FirstFixedrate, (Object)referRatePrice.add(margin));
            }
        } else {
            this.getModel().setValue(FirstFixedrate, null);
        }
    }

    protected void swapTypeChangeEvt() {
        TmcViewInputHelper.setValWithoutPropChgEvt((IFormView)this.getView(), (IDataModel)this.getModel(), (String)"currency", null);
        TmcViewInputHelper.setValWithoutPropChgEvt((IFormView)this.getView(), (IDataModel)this.getModel(), (String)"market", null);
        TmcViewInputHelper.setValWithoutPropChgEvt((IFormView)this.getView(), (IDataModel)this.getModel(), (String)"reccurrency", null);
        TmcViewInputHelper.setValWithoutPropChgEvt((IFormView)this.getView(), (IDataModel)this.getModel(), (String)"recmarket", null);
        TmcViewInputHelper.setValWithoutPropChgEvt((IFormView)this.getView(), (IDataModel)this.getModel(), (String)"amount", null);
        TmcViewInputHelper.setValWithoutPropChgEvt((IFormView)this.getView(), (IDataModel)this.getModel(), (String)"recamount", null);
    }

    protected void setStartDate() {
        Date bizDate = (Date)this.getModel().getValue("bizdate");
        DateEdit dateEdit = (DateEdit)this.getView().getControl("startdate");
        dateEdit.setMinDate(bizDate);
        int settledelay = (Integer)this.getModel().getValue("settledelay");
        if (EmptyUtil.isNoEmpty((Object)bizDate)) {
            DynamicObjectCollection wc = (DynamicObjectCollection)this.getModel().getValue("workcalendar");
            this.getModel().setValue("startdate", (Object)TradeBusinessHelper.callSettleDelayDate((DynamicObjectCollection)wc, (Date)bizDate, (int)settledelay));
        }
    }

    protected void setSettleDelay() {
        Date bizDate = (Date)this.getModel().getValue("bizdate");
        Date startDate = (Date)this.getModel().getValue("startdate");
        if (!EmptyUtil.isAnyoneEmpty((Object[])new Object[]{bizDate, startDate})) {
            DynamicObjectCollection wc = (DynamicObjectCollection)this.getModel().getValue("workcalendar");
            this.getModel().setValue("settledelay", (Object)TradeBusinessHelper.callSettleDelayDay((DynamicObjectCollection)wc, (Date)bizDate, (Date)startDate));
        }
    }

    protected void termChangeEvt() {
        String term = (String)this.getModel().getValue("term");
        if (EmptyUtil.isNoEmpty((String)term)) {
            if (!TermUtils.isRightFormat((IDataModel)this.getModel(), (IFormView)this.getView(), (String)term)) {
                TmcViewInputHelper.setValWithoutPropChgEvt((IFormView)this.getView(), (IDataModel)this.getModel(), (String)"term", null);
                return;
            }
            Date startDate = (Date)this.getModel().getValue("startdate");
            if (EmptyUtil.isNoEmpty((Object)startDate)) {
                TmcViewInputHelper.setValWithoutPropChgEvt((IFormView)this.getView(), (IDataModel)this.getModel(), (String)"enddate", (Object)TermUtils.getDateByBaseDate4ymd((String)term, (Date)startDate));
                this.setAdjustedEndDate();
                this.setControlStubDate(true);
                this.setControlStubDate(false);
            }
        }
    }

    private void checkNeedStub() {
        boolean isPayRsd = this.isRecresidual("payfrequency");
        boolean isRecRsd = this.isRecresidual("recpayfrequency");
        if (isPayRsd || isRecRsd) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8be5\u4e92\u6362\u4ea4\u6613\u5b58\u5728\u524d\u7aef\u4ed8\u606f\u6b8b\u6bb5\u3002", (String)"RateSwapsEdit_0", (String)"tmc-tm-formplugin", (Object[])new Object[0]));
        }
    }

    protected void rateTypeChangeEvt(String key, boolean isPay) {
        if (this.getModel().getValue(key).equals(RateTypeEnum.rate_float.getValue())) {
            this.calFirstFixedRate(isPay);
        }
        RateSwapHelper.calFirstComfirmDate((IDataModel)this.getModel(), (IFormView)this.getView(), (boolean)isPay, (boolean)true, (boolean)true);
    }

    protected void payTypeChangeEvt(String key) {
        boolean isPayStages;
        String stub = "stub";
        String freq = "payfrequency";
        if (key.equals("recpaytype")) {
            stub = "recstub";
            freq = "recpayfrequency";
        }
        if (isPayStages = this.getModel().getValue(key).equals(RateSwapsPayTypeEnum.pay_stages.getValue())) {
            this.isRecresidual(freq);
            this.getView().setEnable(Boolean.valueOf(true), new String[]{stub});
            this.getView().setVisible(Boolean.valueOf(true), new String[]{freq});
        } else {
            this.getModel().setValue(stub, (Object)false);
            this.getView().setEnable(Boolean.valueOf(false), new String[]{stub});
            this.getView().setVisible(Boolean.valueOf(false), new String[]{freq});
        }
    }

    protected void payDateTypeChangeEvt(String key) {
        boolean isForward;
        String resetType = "rateresettype";
        if (key.equals("recpaydatetype")) {
            resetType = "recrateresettype";
        }
        if (isForward = this.getModel().getValue(key).equals(ConfigPayTypeEnum.forward.getValue())) {
            this.getModel().setValue(resetType, (Object)ConfigPayTypeEnum.forward);
        }
    }

    protected void quotaFreqChangeEvt(String key) {
        boolean isPay = key.equals("ratequotafreq");
        RateSwapHelper.calFirstComfirmDate((IDataModel)this.getModel(), (IFormView)this.getView(), (boolean)isPay, (boolean)true, (boolean)true);
        this.calFirstFixedRate(isPay);
    }

    protected void freqChangeEvt(String frequencyField) {
        if (this.isRecresidual(frequencyField)) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8be5\u4e92\u6362\u4ea4\u6613\u5b58\u5728\u524d\u7aef\u4ed8\u606f\u6b8b\u6bb5\u3002", (String)"RateSwapsEdit_0", (String)"tmc-tm-formplugin", (Object[])new Object[0]));
        }
    }

    protected void currencyChangeEvt(boolean isPay, Object changedCurrency) {
        String swapType = (String)this.getModel().getValue("rateswaptype");
        if (SwapTypeEnum.rate.getValue().equals(swapType)) {
            if (isPay) {
                this.getModel().setValue("reccurrency", changedCurrency);
                this.getModel().setValue("recmarket", null);
            } else {
                this.getModel().setValue("currency", changedCurrency);
                this.getModel().setValue("market", null);
            }
        }
        if (SwapTypeEnum.currency.getValue().equals(swapType)) {
            DynamicObject recCurrency;
            DynamicObject currency = (DynamicObject)this.getModel().getValue("currency");
            if (!EmptyUtil.isAnyoneEmpty((Object[])new Object[]{currency, recCurrency = (DynamicObject)this.getModel().getValue("reccurrency")}) && currency.getLong("id") == recCurrency.getLong("id")) {
                if (isPay) {
                    this.getModel().setValue("currency", null);
                } else {
                    this.getModel().setValue("reccurrency", null);
                }
            }
            boolean isShow = this.setControlBaseCurrencyRate();
            if (this.getModel().getValue("pricerule") == null) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u5b9a\u4ef7\u89c4\u5219\uff0c\u5426\u5219\u65e0\u6cd5\u8ba1\u7b97\u5f53\u524d\u6c47\u7387\u3002", (String)"RateSwapsEdit_1", (String)"tmc-tm-formplugin", (Object[])new Object[0]));
            } else {
                this.calCurrentRate1();
                if (isShow) {
                    this.calCurrentRate2();
                    this.calCurrentRate3();
                }
            }
        }
        if (isPay) {
            this.getModel().setValue("market", null);
        } else {
            this.getModel().setValue("recmarket", null);
        }
    }

    private void priceRuleChangeEvt() {
        String swapType = (String)this.getModel().getValue("rateswaptype");
        this.setMarketOnPriceRuleChanged();
        if (SwapTypeEnum.currency.getValue().equals(swapType)) {
            boolean isShow = this.setControlBaseCurrencyRate();
            if (this.getModel().getValue("pricerule") == null) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u5b9a\u4ef7\u89c4\u5219\uff0c\u5426\u5219\u65e0\u6cd5\u8ba1\u7b97\u5f53\u524d\u6c47\u7387\u3002", (String)"RateSwapsEdit_1", (String)"tmc-tm-formplugin", (Object[])new Object[0]));
            } else {
                this.calCurrentRate1();
                if (isShow) {
                    this.calCurrentRate2();
                    this.calCurrentRate3();
                }
            }
        }
    }

    private void setMarketOnPriceRuleChanged() {
        DynamicObject priceRule = (DynamicObject)this.getModel().getValue("pricerule");
        DynamicObject currency = (DynamicObject)this.getModel().getValue("currency");
        DynamicObject payMarket = (DynamicObject)this.getModel().getValue("market");
        DynamicObject recMarket = (DynamicObject)this.getModel().getValue("recmarket");
        DynamicObject recCurrency = (DynamicObject)this.getModel().getValue("reccurrency");
        DynamicObject priceRuleDb = TmcDataServiceHelper.loadSingle((Object)priceRule.get("id"), (String)"md_pricerule", (String)"id,markets");
        if (priceRuleDb != null) {
            DynamicObjectCollection markets = priceRuleDb.getDynamicObjectCollection("markets");
            boolean isSamePayMarket = false;
            boolean isSameRecMarket = false;
            Long newPayMarket = null;
            Long newRecMarket = null;
            for (DynamicObject market : markets) {
                long marketId = market.getDynamicObject("fbasedataid").getLong("id");
                Long marketCurrency = market.getDynamicObject("fbasedataid").getDynamicObject("currency").getLong("id");
                if (currency != null && marketCurrency.longValue() == currency.getLong("id") && payMarket != null && !isSamePayMarket) {
                    if (marketId != payMarket.getLong("id")) {
                        if (newPayMarket == null) {
                            newPayMarket = marketId;
                        }
                    } else {
                        isSamePayMarket = true;
                    }
                }
                if (recCurrency == null || marketCurrency.longValue() != recCurrency.getLong("id") || recMarket == null || isSameRecMarket) continue;
                if (marketId != recMarket.getLong("id")) {
                    if (newRecMarket != null) continue;
                    newRecMarket = marketId;
                    continue;
                }
                isSameRecMarket = true;
            }
            if (!isSamePayMarket) {
                this.getModel().setValue("market", newPayMarket);
                this.getView().updateView("market");
            }
            if (!isSameRecMarket) {
                this.getModel().setValue("recmarket", newRecMarket);
                this.getView().updateView("recmarket");
            }
        }
    }

    private void calCurrentRate1() {
        DynamicObject currency = (DynamicObject)this.getModel().getValue("currency");
        DynamicObject recCurrency = (DynamicObject)this.getModel().getValue("reccurrency");
        DynamicObject priceRule = (DynamicObject)this.getModel().getValue("pricerule");
        if (!EmptyUtil.isAnyoneEmpty((Object[])new Object[]{currency, recCurrency, priceRule})) {
            String pair = recCurrency.getString("number") + "/" + currency.getString("number");
            DynamicObject fqInfo = priceRule.getDynamicObject("forexquote");
            ForexQuoteInfo forexQuoteInfo = MarketDataServiceHelper.getForexQuoteInfo((Long)fqInfo.getLong("id"), (String)pair, null, null);
            if (EmptyUtil.isNoEmpty((Object)forexQuoteInfo)) {
                String burrencyNumber = forexQuoteInfo.getFxquote().split("/")[0];
                if (recCurrency.getString("number").equals(burrencyNumber)) {
                    this.getModel().setValue("currentrate1", (Object)forexQuoteInfo.getSellPrice());
                } else {
                    this.getModel().setValue("currentrate1", (Object)BigDecimal.ONE.divide(forexQuoteInfo.getBuyPrice(), 10, 4));
                }
            }
        }
    }

    private void calCurrentRate2() {
        DynamicObject recCurrency = (DynamicObject)this.getModel().getValue("reccurrency");
        Long orgId = (Long)((DynamicObject)this.getModel().getValue("org")).getPkValue();
        Map result = BaseDataServiceHelper.getBaseAccountingInfo((Long)orgId);
        DynamicObject baseCurrency = BusinessDataServiceHelper.loadSingleFromCache(result.get("baseCurrencyID"), (String)"bd_currency", (String)"number");
        DynamicObject priceRule = (DynamicObject)this.getModel().getValue("pricerule");
        if (!EmptyUtil.isAnyoneEmpty((Object[])new Object[]{baseCurrency, recCurrency, priceRule})) {
            String pair = recCurrency.getString("number") + "/" + baseCurrency.getString("number");
            DynamicObject fqInfo = priceRule.getDynamicObject("forexquote");
            ForexQuoteInfo forexQuoteInfo = MarketDataServiceHelper.getForexQuoteInfo((Long)fqInfo.getLong("id"), (String)pair, null, null);
            if (EmptyUtil.isNoEmpty((Object)forexQuoteInfo)) {
                String burrencyNumber = forexQuoteInfo.getFxquote().split("/")[0];
                if (recCurrency.getString("number").equals(burrencyNumber)) {
                    this.getModel().setValue("currentrate2", (Object)forexQuoteInfo.getSellPrice());
                } else {
                    this.getModel().setValue("currentrate2", (Object)BigDecimal.ONE.divide(forexQuoteInfo.getBuyPrice(), 10, 4));
                }
            }
        }
    }

    private void calCurrentRate3() {
        DynamicObject currency = (DynamicObject)this.getModel().getValue("currency");
        Long orgId = (Long)((DynamicObject)this.getModel().getValue("org")).getPkValue();
        Map result = BaseDataServiceHelper.getBaseAccountingInfo((Long)orgId);
        DynamicObject baseCurrency = BusinessDataServiceHelper.loadSingleFromCache(result.get("baseCurrencyID"), (String)"bd_currency", (String)"number");
        DynamicObject priceRule = (DynamicObject)this.getModel().getValue("pricerule");
        if (!EmptyUtil.isAnyoneEmpty((Object[])new Object[]{baseCurrency, currency, priceRule})) {
            String pair = currency.getString("number") + "/" + baseCurrency.getString("number");
            DynamicObject fqInfo = priceRule.getDynamicObject("forexquote");
            ForexQuoteInfo forexQuoteInfo = MarketDataServiceHelper.getForexQuoteInfo((Long)fqInfo.getLong("id"), (String)pair, null, null);
            if (EmptyUtil.isNoEmpty((Object)forexQuoteInfo)) {
                String burrencyNumber = forexQuoteInfo.getFxquote().split("/")[0];
                if (baseCurrency.getString("number").equals(burrencyNumber)) {
                    this.getModel().setValue("currentrate3", (Object)forexQuoteInfo.getSellPrice());
                } else {
                    this.getModel().setValue("currentrate3", (Object)BigDecimal.ONE.divide(forexQuoteInfo.getBuyPrice(), 10, 4));
                }
            }
        }
    }

    protected void workCalendarChangeEvt(Object oldVale) {
        this.setAdjustedEndDate();
    }

    protected void amountChangeEvt() {
        BigDecimal amt = (BigDecimal)this.getModel().getValue("amount");
        if (this.isRate()) {
            TmcViewInputHelper.setValWithoutPropChgEvt((IFormView)this.getView(), (IDataModel)this.getModel(), (String)"recamount", (Object)amt);
        } else {
            this.getModel().setValue("initexamount", (Object)amt);
            TmcViewInputHelper.setValWithoutPropChgEvt((IFormView)this.getView(), (IDataModel)this.getModel(), (String)"endexamount", (Object)amt.negate());
        }
        this.getModel().setValue("bizrestamt", (Object)amt);
        this.calExchangeRate();
    }

    protected void recAmountChangeEvt() {
        BigDecimal amt = (BigDecimal)this.getModel().getValue("recamount");
        if (this.isRate()) {
            TmcViewInputHelper.setValWithoutPropChgEvt((IFormView)this.getView(), (IDataModel)this.getModel(), (String)"amount", (Object)amt);
        } else {
            this.getModel().setValue("recinitexamount", (Object)amt.negate());
            TmcViewInputHelper.setValWithoutPropChgEvt((IFormView)this.getView(), (IDataModel)this.getModel(), (String)"recendexamount", (Object)amt);
        }
        this.calExchangeRate();
    }

    protected void setControlStubDate(boolean isPay) {
        DateEdit firstDate = isPay ? (DateEdit)this.getView().getControl("firstpaycopdate") : (DateEdit)this.getView().getControl("recfirstpaycopdate");
        DateEdit penuDate = isPay ? (DateEdit)this.getView().getControl("penupaycopdate") : (DateEdit)this.getView().getControl("recpenupaycopdate");
        Date valueDate = (Date)(isPay ? this.getModel().getValue("valuedate") : this.getModel().getValue("recvaluedate"));
        Date endDate = (Date)this.getModel().getValue("enddate");
        if (EmptyUtil.isNoEmpty((Object)valueDate)) {
            firstDate.setMinDate(TcDateUtils.getNextDay((Date)valueDate, (int)1));
            penuDate.setMinDate(TcDateUtils.getNextDay((Date)valueDate, (int)1));
        }
        if (EmptyUtil.isNoEmpty((Object)endDate)) {
            firstDate.setMaxDate(TcDateUtils.getLastDay((Date)endDate, (int)1));
            penuDate.setMaxDate(TcDateUtils.getLastDay((Date)endDate, (int)1));
        }
    }

    protected void setControlBeforeInitDate(boolean isPay) {
        DateEdit edit = isPay ? (DateEdit)this.getView().getControl("beforeinitdate") : (DateEdit)this.getView().getControl("recbeforeinitdate");
        Date valueDate = (Date)(isPay ? this.getModel().getValue("valuedate") : this.getModel().getValue("recvaluedate"));
        edit.setMaxDate(valueDate);
    }
}

