/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.tm.formplugin.reqlimit;

import java.util.Date;
import java.util.EventObject;
import java.util.List;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.ShowType;
import kd.bos.form.control.Control;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeFieldPostBackEvent;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.DateEdit;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.list.ListShowParameter;
import kd.bos.orm.query.QFilter;
import kd.tmc.fbp.common.helper.TmcViewInputHelper;
import kd.tmc.fbp.common.util.EmptyUtil;
import kd.tmc.fbp.common.util.TcDateUtils;
import kd.tmc.fbp.common.util.TermUtils;
import kd.tmc.tm.common.enums.DateTermEnum;

public class ReqLimitEdit
extends AbstractFormPlugin
implements BeforeF7SelectListener {
    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addItemClickListeners(new String[]{"tbmain"});
        BasedataEdit productType = (BasedataEdit)this.getView().getControl("producttype");
        productType.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        BasedataEdit currency = (BasedataEdit)this.getView().getControl("currency");
        currency.addBeforeF7SelectListener((BeforeF7SelectListener)this);
    }

    public void afterBindData(EventObject e) {
        this.initDateRange();
    }

    public void beforeFieldPostBack(BeforeFieldPostBackEvent e) {
        Control source = (Control)e.getSource();
        String key = source.getKey();
        Object value = e.getValue();
        switch (key) {
            case "valiterm": 
            case "setterm": {
                Date date;
                if (EmptyUtil.isEmpty((Object)value)) break;
                if (!TermUtils.isRightFormat((IDataModel)this.getModel(), (IFormView)this.getView(), (String)((String)value))) {
                    e.setCancel(true);
                    this.getView().updateView(key);
                    break;
                }
                DateTermEnum dateTermEnum = DateTermEnum.getByTerm((String)key);
                if (dateTermEnum == null || !EmptyUtil.isEmpty((Object)(date = (Date)this.getModel().getValue(dateTermEnum.getStart())))) break;
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u5148\u586b\u5199%s\u3002", (String)"ReqNoteLimitEdit_0", (String)"tmc-tm-formplugin", (Object[])new Object[]{dateTermEnum.getStartName()}));
                e.setCancel(true);
                this.getView().updateView(key);
                break;
            }
            case "valienddate": 
            case "setenddate": {
                DateTermEnum dateTermEnum = DateTermEnum.getByEndDate((String)key);
                Date date = (Date)this.getModel().getValue(dateTermEnum.getStart());
                if (!EmptyUtil.isEmpty((Object)date)) break;
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u5148\u586b\u5199%s\u3002", (String)"ReqNoteLimitEdit_0", (String)"tmc-tm-formplugin", (Object[])new Object[]{dateTermEnum.getStartName()}));
                e.setCancel(true);
                this.getView().updateView(key);
            }
        }
    }

    public void propertyChanged(PropertyChangedArgs e) {
        String key;
        switch (key = e.getProperty().getName()) {
            case "applydate": {
                TmcViewInputHelper.clearValWithoutPropChgEvt((IFormView)this.getView(), (IDataModel)this.getModel(), (String[])new String[]{"valistdate", "valienddate", "valiterm", "setstdate", "setenddate", "setterm"});
                Date appdate = (Date)this.getModel().getValue("applydate");
                this.setDateMinValue(appdate, "valistdate", "setstdate");
                break;
            }
            case "valistdate": {
                Date valistdate = (Date)this.getModel().getValue("valistdate");
                this.setDateMinValue(valistdate, "valienddate");
                this.changeDateOrTerm(DateTermEnum.TM_REQLIMIT_LIMITDATE, key);
                break;
            }
            case "valienddate": 
            case "valiterm": {
                this.changeDateOrTerm(DateTermEnum.TM_REQLIMIT_LIMITDATE, key);
                break;
            }
            case "setstdate": {
                Date setstdate = (Date)this.getModel().getValue("setstdate");
                this.setDateMinValue(setstdate, "setenddate");
                this.changeDateOrTerm(DateTermEnum.TM_REQLIMIT_TRADEDATE, key);
                break;
            }
            case "setenddate": 
            case "setterm": {
                this.changeDateOrTerm(DateTermEnum.TM_REQLIMIT_TRADEDATE, key);
            }
        }
    }

    private void initDateRange() {
        Date appdate = (Date)this.getModel().getValue("applydate");
        this.setDateMinValue(appdate, "valistdate", "setstdate");
        Date valistdate = (Date)this.getModel().getValue("valistdate");
        this.setDateMinValue(valistdate, "valienddate");
        Date setstdate = (Date)this.getModel().getValue("setstdate");
        this.setDateMinValue(setstdate, "setenddate");
    }

    private void setDateMinValue(Date date, String ... fields) {
        if (EmptyUtil.isNoEmpty((Object)date)) {
            for (String field : fields) {
                DateEdit dateEdit = (DateEdit)this.getView().getControl(field);
                dateEdit.setMinDate(date);
            }
        }
    }

    private void changeDateOrTerm(DateTermEnum dateTermEnum, String field) {
        String termField = dateTermEnum.getTerm();
        String startField = dateTermEnum.getStart();
        String endField = dateTermEnum.getEnd();
        String term = (String)this.getModel().getValue(termField);
        Date startDate = (Date)this.getModel().getValue(startField);
        Date endDate = (Date)this.getModel().getValue(endField);
        if (EmptyUtil.isEmpty((Object)startDate)) {
            if (!StringUtils.equals((CharSequence)field, (CharSequence)startField)) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u5148\u586b\u5199%s\u3002", (String)"ReqNoteLimitEdit_0", (String)"tmc-tm-formplugin", (Object[])new Object[]{dateTermEnum.getStartName()}));
                return;
            }
            TmcViewInputHelper.clearValWithoutPropChgEvt((IFormView)this.getView(), (IDataModel)this.getModel(), (String[])new String[]{termField, endField});
            return;
        }
        if (StringUtils.equals((CharSequence)field, (CharSequence)startField)) {
            if (EmptyUtil.isNotEmpty((CharSequence)term)) {
                TmcViewInputHelper.setValWithoutPropChgEvt((IFormView)this.getView(), (IDataModel)this.getModel(), (String)endField, (Object)TermUtils.getDateByBaseDate4ymd((String)term, (Date)startDate));
            } else {
                TmcViewInputHelper.setValWithoutPropChgEvt((IFormView)this.getView(), (IDataModel)this.getModel(), (String)endField, null);
            }
        }
        if (StringUtils.equals((CharSequence)field, (CharSequence)termField) && EmptyUtil.isNotEmpty((CharSequence)term)) {
            TmcViewInputHelper.setValWithoutPropChgEvt((IFormView)this.getView(), (IDataModel)this.getModel(), (String)endField, (Object)TermUtils.getDateByBaseDate4ymd((String)term, (Date)startDate));
        }
        if (StringUtils.equals((CharSequence)field, (CharSequence)endField) && !EmptyUtil.isEmpty((Object)endDate)) {
            TmcViewInputHelper.setValWithoutPropChgEvt((IFormView)this.getView(), (IDataModel)this.getModel(), (String)termField, (Object)TcDateUtils.getDiffYMD((Date)startDate, (Date)endDate));
        }
    }

    public void beforeF7Select(BeforeF7SelectEvent evt) {
        String fieldKey = evt.getProperty().getName();
        if (StringUtils.equals((CharSequence)fieldKey, (CharSequence)"producttype")) {
            ListShowParameter showParameter = (ListShowParameter)evt.getFormShowParameter();
            showParameter.getTreeFilterParameter().getQFilters().add(new QFilter("longnumber", "like", (Object)"TRADE.01FOREX%"));
        }
        if (StringUtils.equals((CharSequence)fieldKey, (CharSequence)"currency")) {
            int index = evt.getRow();
            ListShowParameter showParameter = (ListShowParameter)evt.getFormShowParameter();
            DynamicObjectCollection entryentity = this.getModel().getEntryEntity("entryentity");
            DynamicObject curr = (DynamicObject)this.getModel().getValue("currency", index);
            List ids = entryentity.stream().filter(e -> e.getDynamicObject("currency") != null).map(e -> e.getDynamicObject("currency").getLong("id")).collect(Collectors.toList());
            if (curr != null) {
                ids.remove(curr.getLong("id"));
            }
            if (!ids.isEmpty()) {
                showParameter.getListFilterParameter().getQFilters().add(new QFilter("id", "not in", ids));
            }
        }
    }

    public void afterDoOperation(AfterDoOperationEventArgs afterDoOperationEventArgs) {
        super.afterDoOperation(afterDoOperationEventArgs);
        String operateKey = afterDoOperationEventArgs.getOperateKey();
        if ("lookupuse".equals(operateKey)) {
            ListShowParameter showParameter = new ListShowParameter();
            showParameter.setFormId("bos_list");
            showParameter.setBillFormId("tm_reqlimit_use");
            showParameter.getOpenStyle().setShowType(ShowType.MainNewTabPage);
            showParameter.setCustomParam("limitbillId", this.getModel().getValue("id"));
            this.getView().showForm((FormShowParameter)showParameter);
        }
    }
}

