/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.tm.formplugin.requestnote;

import java.util.EventObject;
import kd.bos.entity.datamodel.events.ChangeData;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.tmc.tm.common.enums.ForexBizTypeEnum;
import kd.tmc.tm.formplugin.requestnote.RequestNoteEdit;

public class ReqNoteForwardEdit
extends RequestNoteEdit
implements BeforeF7SelectListener {
    public void registerListener(EventObject e) {
        super.registerListener(e);
        BasedataEdit currency = (BasedataEdit)this.getView().getControl("currencytypein");
        currency.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        BasedataEdit currout = (BasedataEdit)this.getView().getControl("currencytypeout");
        currout.addBeforeF7SelectListener((BeforeF7SelectListener)this);
    }

    public void propertyChanged(PropertyChangedArgs e) {
        String name = e.getProperty().getName();
        ChangeData changeData = e.getChangeSet()[0];
        int focusRow = changeData.getRowIndex();
        switch (name) {
            case "businesstype": {
                this.setDeftCurrency("forwardinfo", changeData);
                break;
            }
            case "currencytypein": {
                this.doAfterCurrChange(focusRow, "amountin", "currencytypein", "currencytypeout", "exchangequotation");
                break;
            }
            case "currencytypeout": {
                this.doAfterCurrChange(focusRow, "amountout", "currencytypein", "currencytypeout", "exchangequotation");
                break;
            }
            case "amountin": {
                this.clearAmount(focusRow, "amountin", "amountout");
                break;
            }
            case "amountout": {
                this.clearAmount(focusRow, "amountout", "amountin");
                break;
            }
            case "exchangequotation": {
                this.setRateEnable(focusRow, "exchangequotation", "expectratebottom", "expectratetop");
                this.getModel().setValue("expectratebottom", null, focusRow);
                this.getModel().setValue("expectratetop", null, focusRow);
                break;
            }
            case "fobizdate": {
                this.getModel().setValue("deliverydate", null, focusRow);
                this.getModel().setValue("deliverystartdate", null, focusRow);
                this.getModel().setValue("deliveryenddate", null, focusRow);
                break;
            }
            case "deliverydate": {
                this.checkDelDate(focusRow, "fobizdate", "deliverydate");
                break;
            }
            case "deliverystartdate": 
            case "deliveryenddate": {
                this.checkDelDate(focusRow, "fobizdate", "deliverystartdate");
                this.checkDelDate(focusRow, "fobizdate", "deliveryenddate");
                break;
            }
            case "expectratetop": {
                this.checkRate(focusRow, "expectratebottom", "expectratetop", "expectratetop");
                break;
            }
            case "expectratebottom": {
                this.checkRate(focusRow, "expectratebottom", "expectratetop", "expectratebottom");
                break;
            }
            case "isoptionaltraction": {
                boolean op = (Boolean)this.getModel().getValue("isoptionaltraction", focusRow);
                if (op) {
                    this.getModel().setValue("deliverydate", null, focusRow);
                    break;
                }
                this.getModel().setValue("deliverystartdate", null, focusRow);
                this.getModel().setValue("deliveryenddate", null, focusRow);
                break;
            }
        }
    }

    public void beforeF7Select(BeforeF7SelectEvent evt) {
        String key = ((BasedataEdit)evt.getSource()).getKey();
        if ("currencytypein".equals(key) || "currencytypeout".equals(key)) {
            String busType = (String)this.getModel().getValue("businesstype");
            if (ForexBizTypeEnum.sell.getValue().equals(busType) && "currencytypein".equals(key) || ForexBizTypeEnum.buy.getValue().equals(busType) && "currencytypeout".equals(key)) {
                this.getCurrType(evt, "in");
            } else {
                this.getCurrType(evt, "not in");
            }
        }
    }
}

