/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.tm.formplugin.requestnote;

import java.util.Date;
import java.util.EventObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.events.AfterAddRowEventArgs;
import kd.bos.entity.datamodel.events.ChangeData;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.entity.property.EntryProp;
import kd.bos.form.control.Control;
import kd.bos.form.events.BeforeFieldPostBackEvent;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.tmc.fbp.common.helper.WorkCalendarHelper;
import kd.tmc.fbp.common.util.EmptyUtil;
import kd.tmc.fbp.common.util.TcDateUtils;
import kd.tmc.tm.common.enums.ForexBizTypeEnum;
import kd.tmc.tm.formplugin.requestnote.RequestNoteEdit;
import org.apache.commons.lang3.StringUtils;

public class ReqNoteSpotEdit
extends RequestNoteEdit
implements BeforeF7SelectListener {
    public void registerListener(EventObject e) {
        super.registerListener(e);
        BasedataEdit spcurrin = (BasedataEdit)this.getView().getControl("spotcurrencytypein");
        spcurrin.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        BasedataEdit spcurrout = (BasedataEdit)this.getView().getControl("spotcurrencytypeout");
        spcurrout.addBeforeF7SelectListener((BeforeF7SelectListener)this);
    }

    @Override
    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
        DynamicObjectCollection spotInfos = this.getModel().getEntryEntity("spotinfo");
        for (int i = 0; i < spotInfos.size(); ++i) {
            this.setApplyDeliveryDate(i);
        }
    }

    public void afterAddRow(AfterAddRowEventArgs e) {
        super.afterAddRow(e);
        EntryProp entryProp = e.getEntryProp();
        String name = entryProp.getName();
        if (StringUtils.equals((CharSequence)name, (CharSequence)"spotinfo")) {
            int insertRow = e.getRowDataEntities()[0].getRowIndex();
            this.setApplyDeliveryDate(insertRow);
        }
    }

    public void propertyChanged(PropertyChangedArgs e) {
        String name = e.getProperty().getName();
        ChangeData changeData = e.getChangeSet()[0];
        int focusRow = changeData.getRowIndex();
        switch (name) {
            case "spotbusinesstype": {
                this.setDeftCurrency("spotinfo", changeData);
                break;
            }
            case "spotcurrencytypein": {
                this.doAfterCurrChange(focusRow, "spotamountin", "spotcurrencytypein", "spotcurrencytypeout", "spotexchangequotation");
                break;
            }
            case "spotcurrencytypeout": {
                this.doAfterCurrChange(focusRow, "spotamountout", "spotcurrencytypein", "spotcurrencytypeout", "spotexchangequotation");
                break;
            }
            case "spotamountin": {
                this.clearAmount(focusRow, "spotamountin", "spotamountout");
                break;
            }
            case "spotamountout": {
                this.clearAmount(focusRow, "spotamountout", "spotamountin");
                break;
            }
            case "spotexchangequotation": {
                this.setRateEnable(focusRow, "spotexchangequotation", "spotexpectratebottom", "spotexpectratetop");
                this.getModel().setValue("spotexpectratebottom", null, focusRow);
                this.getModel().setValue("spotexpectratetop", null, focusRow);
                break;
            }
            case "spbizdate": {
                this.setApplyDeliveryDate(focusRow);
                break;
            }
            case "spotapplydeliverydate": {
                this.checkDelDate(focusRow, "spbizdate", "spotapplydeliverydate");
                break;
            }
            case "spotexpectratetop": {
                this.checkRate(focusRow, "spotexpectratebottom", "spotexpectratetop", "spotexpectratetop");
                break;
            }
            case "spotexpectratebottom": {
                this.checkRate(focusRow, "spotexpectratebottom", "spotexpectratetop", "spotexpectratebottom");
                break;
            }
        }
    }

    private void setApplyDeliveryDate(int focusRow) {
        Date bizDate = (Date)this.getModel().getValue("spbizdate", focusRow);
        if (EmptyUtil.isNoEmpty((Object)bizDate)) {
            this.getModel().setValue("spotapplydeliverydate", (Object)WorkCalendarHelper.getNextWorkDate(null, (Date)bizDate, (int)2), focusRow);
        }
    }

    public void beforeF7Select(BeforeF7SelectEvent evt) {
        String key = ((BasedataEdit)evt.getSource()).getKey();
        if ("spotcurrencytypein".equals(key) || "spotcurrencytypeout".equals(key)) {
            String busType = (String)this.getModel().getValue("spotbusinesstype");
            if (ForexBizTypeEnum.sell.getValue().equals(busType) && "spotcurrencytypein".equals(key) || ForexBizTypeEnum.buy.getValue().equals(busType) && "spotcurrencytypeout".equals(key)) {
                this.getCurrType(evt, "in");
            } else {
                this.getCurrType(evt, "not in");
            }
        }
    }

    public void beforeFieldPostBack(BeforeFieldPostBackEvent e) {
        Control source = (Control)e.getSource();
        String key = source.getKey();
        Object v = e.getValue();
        switch (key) {
            case "spotapplydeliverydate": {
                if (EmptyUtil.isEmpty((Object)this.getModel().getValue("spbizdate"))) {
                    e.setCancel(true);
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u8f93\u5165\u4ea4\u6613\u65e5\u3002", (String)"ReqNoteSpotEdit_1", (String)"tmc-tm-formplugin", (Object[])new Object[0]));
                    this.getView().updateView("spotapplydeliverydate", e.getRowIndex());
                    break;
                }
                if (!EmptyUtil.isNoEmpty((Object)v) || !TcDateUtils.stringToDate((String)((String)v), (String)"yyyy-MM-dd").before((Date)this.getModel().getValue("spbizdate"))) break;
                e.setCancel(true);
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u4ea4\u5272\u65e5\u4e0d\u80fd\u5c0f\u4e8e\u4ea4\u6613\u65e5\u3002", (String)"ReqNoteSpotEdit_2", (String)"tmc-tm-formplugin", (Object[])new Object[0]));
                this.getView().updateView("spotapplydeliverydate", e.getRowIndex());
            }
        }
    }
}

