/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.tm.formplugin.requestnote;

import java.math.BigDecimal;
import java.util.Date;
import java.util.EventObject;
import java.util.HashSet;
import java.util.Objects;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.events.ChangeData;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.form.IFormView;
import kd.bos.form.control.AbstractGrid;
import kd.bos.form.control.events.ItemClickEvent;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.list.ListShowParameter;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.tmc.fbp.common.helper.TmcViewInputHelper;
import kd.tmc.fbp.common.helper.service.MarketDataServiceHelper;
import kd.tmc.fbp.common.model.ForexQuoteInfo;
import kd.tmc.fbp.common.util.EmptyUtil;
import kd.tmc.tm.common.enums.ForexBizTypeEnum;

public class ReqNoteSwapsEdit
extends AbstractFormPlugin
implements BeforeF7SelectListener {
    public void registerListener(EventObject e) {
        BasedataEdit currin = (BasedataEdit)this.getView().getControl("currout");
        BasedataEdit currout = (BasedataEdit)this.getView().getControl("currin");
        currin.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        currout.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        this.addItemClickListeners(new String[]{"swrow"});
    }

    public void propertyChanged(PropertyChangedArgs e) {
        String name = e.getProperty().getName();
        ChangeData changeData = e.getChangeSet()[0];
        int focusRow = changeData.getRowIndex();
        String entryName = changeData.getDataEntity().getDataEntityType().getExtendName();
        String end = (String)this.getModel().getValue("end", focusRow);
        switch (name) {
            case "currin": {
                if (!"nearend".equalsIgnoreCase(end)) {
                    return;
                }
                DynamicObject currin = (DynamicObject)this.getModel().getValue("currin", focusRow);
                this.getModel().setValue("currout", (Object)currin, focusRow + 1);
                this.priceRuleNotify();
                this.updateSwapsExQuote(focusRow);
                break;
            }
            case "currout": {
                if (!"nearend".equalsIgnoreCase(end)) {
                    return;
                }
                DynamicObject currout = (DynamicObject)this.getModel().getValue("currout", focusRow);
                this.getModel().setValue("currin", (Object)currout, focusRow + 1);
                this.priceRuleNotify();
                this.updateSwapsExQuote(focusRow);
                break;
            }
            case "amtin": {
                if (!"nearend".equalsIgnoreCase(end)) {
                    return;
                }
                BigDecimal amtin = (BigDecimal)this.getModel().getValue("amtin", focusRow);
                this.clearAmount("amtin", "amtout", focusRow);
                this.getModel().setValue("amtout", (Object)amtin, focusRow + 1);
                break;
            }
            case "amtout": {
                if (!"nearend".equalsIgnoreCase(end)) {
                    return;
                }
                BigDecimal amtout = (BigDecimal)this.getModel().getValue("amtout", focusRow);
                this.clearAmount("amtout", "amtin", focusRow);
                this.getModel().setValue("amtin", (Object)amtout, focusRow + 1);
                break;
            }
            case "swbizdate": {
                if (!"nearend".equalsIgnoreCase(end)) {
                    return;
                }
                Date applydate = (Date)this.getModel().getValue("swbizdate", focusRow);
                this.getModel().setValue("swbizdate", (Object)applydate, focusRow + 1);
                this.getModel().setValue("swsettledate", null, focusRow);
                this.getModel().setValue("swsettledate", null, focusRow + 1);
                break;
            }
            case "bustype": {
                if (!"nearend".equalsIgnoreCase(end)) {
                    return;
                }
                this.setSwapsBustype(focusRow);
                this.setSwapsDeftCurrency(focusRow, entryName);
                break;
            }
            case "swcounterparty": {
                if (!"nearend".equalsIgnoreCase(end)) {
                    return;
                }
                DynamicObject counpty = (DynamicObject)this.getModel().getValue("swcounterparty", focusRow);
                this.getModel().setValue("swcounterparty", (Object)counpty, focusRow + 1);
                break;
            }
            case "swsettledate": {
                this.checkDelDate(focusRow, "swbizdate", "swsettledate");
                break;
            }
            case "exratetop": {
                this.checkRate(focusRow, "exratebottom", "exratetop", "exratetop");
                break;
            }
            case "exratebottom": {
                this.checkRate(focusRow, "exratebottom", "exratetop", "exratebottom");
                break;
            }
            case "quote": {
                if (!"nearend".equalsIgnoreCase(end)) {
                    return;
                }
                String quote = (String)this.getModel().getValue("quote", focusRow);
                this.getModel().setValue("quote", (Object)quote, focusRow + 1);
                this.getModel().setValue("exratebottom", null, focusRow);
                this.getModel().setValue("exratetop", null, focusRow);
                this.getModel().setValue("exratebottom", null, focusRow + 1);
                this.getModel().setValue("exratetop", null, focusRow + 1);
                break;
            }
        }
    }

    private void clearAmount(String changeColumn, String clearColumn, int focusRow) {
        BigDecimal amount = (BigDecimal)this.getModel().getValue(changeColumn, focusRow);
        if (EmptyUtil.isNoEmpty((BigDecimal)amount) && amount.compareTo(BigDecimal.ZERO) > 0) {
            this.getModel().setValue(clearColumn, null, focusRow);
        }
    }

    private void priceRuleNotify() {
        if (EmptyUtil.isEmpty((Object)this.getModel().getValue("pricerule"))) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u586b\u5199\u5b9a\u4ef7\u89c4\u5219\u83b7\u53d6\u8d27\u5e01\u5bf9\u7684\u5916\u6c47\u62a5\u4ef7\u65b9\u5f0f\u3002", (String)"ReqNoteSwapsEdit_1", (String)"tmc-tm-formplugin", (Object[])new Object[0]));
        }
    }

    private void checkRate(int focusRow, String botName, String topName, String focusCol) {
        BigDecimal ratebottom = (BigDecimal)this.getModel().getValue(botName, focusRow);
        BigDecimal ratetop = (BigDecimal)this.getModel().getValue(topName, focusRow);
        if (EmptyUtil.isEmpty((BigDecimal)ratebottom) || EmptyUtil.isEmpty((BigDecimal)ratetop)) {
            return;
        }
        if (ratetop.compareTo(ratebottom) < 0) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u4e0b\u9650\u5fc5\u987b\u5c0f\u4e8e\u4e0a\u9650\u3002", (String)"ReqNoteSwapsEdit_2", (String)"tmc-tm-formplugin", (Object[])new Object[0]));
            this.getModel().setValue(focusCol, null, focusRow);
        }
    }

    private void checkDelDate(int focusRow, String foBizdate, String foDeliverydate) {
        Date fobizdate = (Date)this.getModel().getValue(foBizdate, focusRow);
        Date fodeldate = (Date)this.getModel().getValue(foDeliverydate, focusRow);
        if (EmptyUtil.isEmpty((Object)fobizdate) || EmptyUtil.isEmpty((Object)fodeldate)) {
            return;
        }
        if (fobizdate.after(fodeldate)) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u4ea4\u5272\u65e5\u4e0d\u5f97\u65e9\u4e8e\u4ea4\u6613\u65e5\u3002", (String)"ReqNoteSwapsEdit_5", (String)"tmc-tm-formplugin", (Object[])new Object[0]));
            this.getModel().setValue(foDeliverydate, null, focusRow);
            return;
        }
        String end = (String)this.getModel().getValue("end", focusRow);
        if ("nearend".equalsIgnoreCase(end)) {
            TmcViewInputHelper.setValWithoutPropChgEvt((IFormView)this.getView(), (IDataModel)this.getModel(), (String)"swsettledate", null, (int)(focusRow + 1));
        }
    }

    private void setSwapsDeftCurrency(int focusRow, String entryName) {
        String swbustype;
        DynamicObject org = this.getOrg(focusRow, entryName);
        if (EmptyUtil.isEmpty((DynamicObject)org)) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u586b\u5199\u4ea4\u6613\u4e3b\u4f53\u3002", (String)"ReqNoteSwapsEdit_6", (String)"tmc-tm-formplugin", (Object[])new Object[0]));
            return;
        }
        QFilter filter = new QFilter("org", "=", (Object)org.getLong("id"));
        DynamicObject currencytbd = BusinessDataServiceHelper.loadSingle((String)"tbd_excurrency", (String)"excurrency,org,defcurrency", (QFilter[])filter.toArray());
        Long defcurrency = null;
        if (!Objects.isNull(currencytbd)) {
            DynamicObject obj = (DynamicObject)currencytbd.get("defcurrency");
            defcurrency = obj.getLong("id");
        }
        if ((swbustype = (String)this.getModel().getValue("bustype", focusRow)) != null) {
            switch (swbustype) {
                case "buy": {
                    this.getModel().setValue("currin", null, focusRow);
                    this.getModel().setValue("currout", (Object)defcurrency, focusRow);
                    break;
                }
                case "sell": {
                    this.getModel().setValue("currin", (Object)defcurrency, focusRow);
                    this.getModel().setValue("currout", null, focusRow);
                    break;
                }
                case "diff": {
                    this.getModel().setValue("currin", null, focusRow);
                    this.getModel().setValue("currout", null, focusRow);
                }
            }
        }
    }

    private void updateSwapsExQuote(int focusRow) {
        DynamicObject pricerule = (DynamicObject)this.getModel().getValue("pricerule");
        DynamicObject currtypein = (DynamicObject)this.getModel().getValue("currin", focusRow);
        DynamicObject currtypeout = (DynamicObject)this.getModel().getValue("currout", focusRow);
        this.setExQuote(pricerule, focusRow, currtypein, currtypeout, "quote");
    }

    private void setSwapsBustype(int focusRow) {
        String end = (String)this.getModel().getValue("end", focusRow);
        if ("nearend".equals(end)) {
            String bustype = (String)this.getModel().getValue("bustype", focusRow);
            if ("buy".equals(bustype)) {
                this.getModel().setValue("bustype", (Object)"sell", focusRow + 1);
            } else if ("sell".equals(bustype)) {
                this.getModel().setValue("bustype", (Object)"buy", focusRow + 1);
            } else if ("diff".equals(bustype)) {
                this.getModel().setValue("bustype", (Object)"diff", focusRow + 1);
            }
        }
    }

    private void setExQuote(DynamicObject pricerule, int focusRow, DynamicObject currtypein, DynamicObject currtypeout, String quote) {
        if (EmptyUtil.isNoEmpty((DynamicObject)pricerule) && EmptyUtil.isNoEmpty((DynamicObject)currtypein) && EmptyUtil.isNoEmpty((DynamicObject)currtypeout)) {
            String currOutno;
            String currInno = (String)currtypein.get("number");
            if (StringUtils.equals((CharSequence)currInno, (CharSequence)(currOutno = (String)currtypeout.get("number")))) {
                this.getModel().setValue(quote, null, focusRow);
                return;
            }
            String currenpair = currInno + "/" + currOutno;
            long id = pricerule.getLong("forexquote.id");
            ForexQuoteInfo quoteinfo = null;
            try {
                quoteinfo = MarketDataServiceHelper.getForexQuoteInfo((Long)id, (String)currenpair, null, (Date)new Date());
            }
            catch (Exception e) {
                this.getView().showTipNotification(e.getMessage());
                this.getModel().setValue(quote, null, focusRow);
                return;
            }
            this.getModel().setValue(quote, (Object)quoteinfo.getFxquote(), focusRow);
            this.getModel().setValue(quote, (Object)quoteinfo.getFxquote(), focusRow + 1);
        }
    }

    private void getCurrType(BeforeF7SelectEvent evt, String qcp) {
        IDataEntityProperty property = evt.getProperty();
        DynamicObject org = this.getOrg(evt.getRow(), property.getParent().getExtendName());
        if (EmptyUtil.isEmpty((DynamicObject)org)) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u586b\u5199\u4ea4\u6613\u4e3b\u4f53\u3002", (String)"ReqNoteSwapsEdit_6", (String)"tmc-tm-formplugin", (Object[])new Object[0]));
            return;
        }
        QFilter filter = new QFilter("org", "=", (Object)org.getLong("id"));
        HashSet<Long> idSet = new HashSet<Long>();
        DynamicObject currencytbd = BusinessDataServiceHelper.loadSingle((String)"tbd_excurrency", (String)"excurrency,org,defcurrency", (QFilter[])filter.toArray());
        if (Objects.isNull(currencytbd)) {
            return;
        }
        DynamicObjectCollection rows = (DynamicObjectCollection)currencytbd.get("excurrency");
        for (DynamicObject row : rows) {
            DynamicObject basedataObj = row.getDynamicObject("fbasedataid");
            Long basedataid = (Long)basedataObj.getPkValue();
            idSet.add(basedataid);
        }
        QFilter currfilter = new QFilter("id", qcp, idSet);
        ListShowParameter showParameter = (ListShowParameter)evt.getFormShowParameter();
        showParameter.getListFilterParameter().setFilter(currfilter);
    }

    public void beforeF7Select(BeforeF7SelectEvent evt) {
        String key = ((BasedataEdit)evt.getSource()).getKey();
        if ("currin".equals(key) || "currout".equals(key)) {
            String busType = (String)this.getModel().getValue("bustype");
            if (ForexBizTypeEnum.sell.getValue().equals(busType) && "currin".equals(key) || ForexBizTypeEnum.buy.getValue().equals(busType) && "currout".equals(key)) {
                this.getCurrType(evt, "in");
            } else {
                this.getCurrType(evt, "not in");
            }
        }
    }

    public void itemClick(ItemClickEvent evt) {
        if ("addswrow".equalsIgnoreCase(evt.getItemKey())) {
            this.getModel().batchCreateNewEntryRow("swapsinfo", 2);
            DynamicObjectCollection entryEntity = this.getModel().getEntryEntity("swapsinfo");
            int size = EmptyUtil.isNoEmpty((DynamicObjectCollection)entryEntity) ? entryEntity.size() : 0;
            this.getModel().setValue("end", (Object)"nearend", size - 2);
            this.getModel().setValue("end", (Object)"farend", size - 1);
        }
        if ("delswrow".equalsIgnoreCase(evt.getItemKey())) {
            AbstractGrid grid = (AbstractGrid)this.getView().getControl("swapsinfo");
            int focusRow = grid.getEntryState().getFocusRow();
            int[] rows = grid.getEntryState().getSelectedRows();
            if (rows.length > 1) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u53ea\u80fd\u9009\u62e9\u4e00\u884c\u3002", (String)"ReqNoteSwapsEdit_3", (String)"tmc-tm-formplugin", (Object[])new Object[0]));
                return;
            }
            String end = (String)this.getModel().getValue("end", focusRow);
            if ("farend".equals(end)) {
                this.getModel().deleteEntryRows("swapsinfo", new int[]{focusRow, focusRow - 1});
                this.getView().updateView("swapsinfo");
            } else {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u5fc5\u987b\u9009\u62e9\u8fdc\u7aef\u3002", (String)"ReqNoteSwapsEdit_4", (String)"tmc-tm-formplugin", (Object[])new Object[0]));
            }
        }
    }

    protected DynamicObject getOrg(int rowIndex, String entryName) {
        return (DynamicObject)this.getModel().getValue("org");
    }
}

