/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.tm.formplugin.structdeposit;

import com.alibaba.fastjson.JSON;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Date;
import java.util.EventObject;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.form.IFormView;
import kd.bos.form.chart.Axis;
import kd.bos.form.chart.Chart;
import kd.bos.form.chart.LineSeries;
import kd.bos.form.chart.Series;
import kd.bos.form.control.events.TabSelectEvent;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.field.ComboItem;
import kd.bos.form.field.DateEdit;
import kd.bos.form.field.DateTimeEdit;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.tmc.fbp.common.constant.Constants;
import kd.tmc.fbp.common.enums.TcBillStatusEnum;
import kd.tmc.fbp.common.helper.TmcViewInputHelper;
import kd.tmc.fbp.common.model.ModelAgent;
import kd.tmc.fbp.common.util.EmptyUtil;
import kd.tmc.fbp.common.util.TcDateUtils;
import kd.tmc.fbp.formplugin.chart.AbstractTabLineChartEdit;
import kd.tmc.tm.common.enums.DisplayFormEnum;
import kd.tmc.tm.common.enums.HookTypeEnum;
import kd.tmc.tm.common.enums.ObsFrequeEnum;
import kd.tmc.tm.common.helper.StructDepositHelper;

public class StructDepositChatEdit
extends AbstractTabLineChartEdit {
    private static final Log logger = LogFactory.getLog(StructDepositChatEdit.class);
    private static final String[] props = new String[]{"hooktype", "hookmark", "markprice", "intdate", "settledate", "displayform"};

    public void propertyChanged(PropertyChangedArgs args) {
        String propName;
        super.propertyChanged(args);
        switch (propName = args.getProperty().getName()) {
            case "displayform": 
            case "redeemdate": {
                this.drawChart();
                break;
            }
            case "redeemdate2": {
                String date = (String)args.getChangeSet()[0].getNewValue();
                if (EmptyUtil.isNoEmpty((String)date)) {
                    Date redeemDate = TcDateUtils.stringToDate((String)date, (String)"yyyy-MM-dd");
                    TmcViewInputHelper.setValWithoutPropChgEvt((IFormView)this.getView(), (IDataModel)this.getModel(), (String)"redeemdate", (Object)redeemDate);
                }
                this.drawChart();
                break;
            }
            case "obsfreq": 
            case "firstobsdate": 
            case "lastobsdate": {
                this.initRedeemDate();
                this.setObsDateLimit();
            }
        }
    }

    protected void drawChart() {
        if (this.verifyInput()) {
            super.drawChart();
        } else {
            this.clearData();
        }
    }

    public void afterBindData(EventObject e) {
        super.afterBindData(e);
        boolean isDataChange = this.getModel().getDataChanged();
        StructDepositHelper.initRedeemDateBox((IDataModel)this.getModel(), (IFormView)this.getView());
        this.initRedeemDateView();
        Date redeemDate = (Date)this.getModel().getValue("redeemdate");
        if (EmptyUtil.isEmpty((Object)redeemDate)) {
            this.initRedeemDate();
        } else {
            String date = TcDateUtils.formatString((Date)redeemDate, (String)"yyyy-MM-dd");
            TmcViewInputHelper.setValWithoutPropChgEvt((IFormView)this.getView(), (IDataModel)this.getModel(), (String)"redeemdate2", (Object)date);
        }
        this.getModel().setDataChanged(isDataChange);
    }

    public void tabSelected(TabSelectEvent e) {
        if (e.getTabKey().equals("tabchart")) {
            this.getPageCache().put("tab", e.getTabKey());
            DynamicObject priceRule = (DynamicObject)this.getModel().getValue("pricerule");
            if (EmptyUtil.isEmpty((DynamicObject)priceRule)) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u8bbe\u7f6e\u5b9a\u4ef7\u89c4\u5219\u3002", (String)"StructDepositChatEdit_0", (String)"tmc-tm-formplugin", (Object[])new Object[0]));
                return;
            }
        }
        super.tabSelected(e);
    }

    protected boolean verifyInput() {
        if (!this.getPageCache().getAll().containsKey("tab") || !this.getPageCache().get("tab").equals("tabchart")) {
            return false;
        }
        HashSet<String> propSet = new HashSet<String>(16);
        StringBuilder sb = new StringBuilder();
        Collections.addAll(propSet, props);
        String redeemType = (String)this.getModel().getValue("redeemtype");
        String displayForm = (String)this.getModel().getValue("displayform");
        String obsFreq = (String)this.getModel().getValue("obsfreq");
        if (DisplayFormEnum.intest.getValue().equals(displayForm) && "auto_redeem".equals(redeemType) && !ObsFrequeEnum.day.getValue().equals(obsFreq)) {
            propSet.add("redeemdate");
        }
        for (String string : propSet) {
            if (!EmptyUtil.isEmpty((Object)this.getModel().getValue(string))) continue;
            LocaleString field = this.getModel().getProperty(string).getDisplayName();
            sb.append(field).append(ResManager.loadKDString((String)"\u4e0d\u80fd\u4e3a\u7a7a\uff1b", (String)"StructDepositChatEdit_1", (String)"tmc-tm-formplugin", (Object[])new Object[0]));
        }
        DynamicObjectCollection zones = this.getModel().getEntryEntity("zone");
        for (DynamicObject zone : zones) {
            if (!EmptyUtil.isEmpty((DynamicObject)zone.getDynamicObject("bwsymbol"))) continue;
            LocaleString field = this.getModel().getProperty("bwsymbol").getDisplayName();
            sb.append(field).append(ResManager.loadKDString((String)"\u4e0d\u80fd\u4e3a\u7a7a\uff1b", (String)"StructDepositChatEdit_1", (String)"tmc-tm-formplugin", (Object[])new Object[0]));
        }
        String string = sb.toString();
        if (EmptyUtil.isNoEmpty((String)string)) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"%s \u4e0d\u80fd\u8fdb\u884c\u635f\u76ca\u5206\u6790\u3002", (String)"StructDepositChatEdit_2", (String)"tmc-tm-formplugin", (Object[])new Object[]{string}), Integer.valueOf(1500));
            return false;
        }
        return true;
    }

    protected Number[] getXValueRange() {
        Number[] x = new BigDecimal[]{Constants.ZERO, Constants.ZERO};
        String structType = (String)this.getModel().getValue("structtype");
        if ("break".equals(structType)) {
            BigDecimal begin = null;
            BigDecimal end = null;
            List priceZone = StructDepositHelper.transBreakMarkPriceZone((ModelAgent)new ModelAgent((Object)this.getModel()));
            for (Map zone : priceZone) {
                BigDecimal px = (BigDecimal)zone.get("x");
                BigDecimal py = (BigDecimal)zone.get("y");
                if (EmptyUtil.isNoEmpty((BigDecimal)px) && (EmptyUtil.isEmpty(begin) || px.compareTo(begin) < 0)) {
                    begin = px;
                }
                if (!EmptyUtil.isNoEmpty((BigDecimal)py) || !EmptyUtil.isEmpty((BigDecimal)end) && py.compareTo(end) <= 0) continue;
                end = py;
            }
            if (EmptyUtil.isNoEmpty(begin) && EmptyUtil.isNoEmpty(end)) {
                BigDecimal length = end.subtract(begin);
                end = Constants.ZERO.compareTo(length) == 0 ? end.multiply(new BigDecimal(2)) : end.add(length);
            }
            x = new BigDecimal[]{Constants.ZERO, end};
        } else if ("total".equals(structType)) {
            int D = StructDepositHelper.getD((ModelAgent)new ModelAgent((Object)this.getModel()));
            x[0] = Constants.ZERO;
            x[1] = new BigDecimal(D);
        }
        return x;
    }

    protected Number[] getYValueRange() {
        Number[] y = new BigDecimal[]{Constants.ZERO, Constants.ZERO};
        String structType = (String)this.getModel().getValue("structtype");
        DynamicObjectCollection zones = this.getModel().getEntryEntity("zone");
        if ("break".equals(structType)) {
            for (DynamicObject zone : zones) {
                BigDecimal max = zone.getBigDecimal("rate");
                if (y[1].compareTo(max) >= 0) continue;
                y[1] = max;
            }
            String displayForm = (String)this.getModel().getValue("displayform");
            if (DisplayFormEnum.intest.getValue().equals(displayForm) && EmptyUtil.isNoEmpty((BigDecimal)y[1])) {
                BigDecimal D = StructDepositHelper.getBreakPeriodDays((ModelAgent)new ModelAgent((Object)this.getModel()));
                y[1] = StructDepositHelper.callPredictIntest((ModelAgent)new ModelAgent((Object)this.getModel()), (BigDecimal)y[1], (BigDecimal)D);
            }
        } else if ("total".equals(structType)) {
            BigDecimal end;
            BigDecimal begin = ((DynamicObject)zones.get(0)).getBigDecimal("rate");
            y[1] = begin.compareTo(end = ((DynamicObject)zones.get(1)).getBigDecimal("rate")) >= 0 ? begin : end;
            Date intDate = (Date)this.getModel().getValue("intdate");
            Date settleDate = (Date)this.getModel().getValue("settledate");
            int D = TcDateUtils.getDiffDays((Date)intDate, (Date)settleDate);
            String displayForm = (String)this.getModel().getValue("displayform");
            if (DisplayFormEnum.intest.getValue().equals(displayForm) && EmptyUtil.isNoEmpty((BigDecimal)y[1])) {
                y[1] = StructDepositHelper.callPredictIntest((ModelAgent)new ModelAgent((Object)this.getModel()), (BigDecimal)y[1], (BigDecimal)new BigDecimal(D));
            }
        }
        y[1] = y[1].add(Constants.ONE).setScale(0, 4);
        return y;
    }

    protected List<Object> getSeriesValue() {
        ArrayList<Object> list = new ArrayList<Object>();
        String structType = (String)this.getModel().getValue("structtype");
        String priceMethod = (String)this.getModel().getValue("pricemethod");
        DynamicObjectCollection zones = this.getModel().getEntryEntity("zone");
        if ("break".equals(structType)) {
            List<Map<String, Object>> priceZone = StructDepositHelper.transBreakMarkPriceZone((ModelAgent)new ModelAgent((Object)this.getModel()));
            priceZone = this.reduceBeginPoint(priceZone);
            for (Map<String, Object> zone : priceZone) {
                BigDecimal x = (BigDecimal)zone.get("x");
                BigDecimal y = (BigDecimal)zone.get("y");
                if ((priceZone.size() == 2 || zone.equals(priceZone.get(priceZone.size() - 1))) && Constants.ZERO.compareTo(y) == 0) {
                    y = x.multiply(new BigDecimal(2));
                }
                BigDecimal rate = (BigDecimal)zone.get("rate");
                rate = StructDepositHelper.callBreakPredictIntest((ModelAgent)new ModelAgent((Object)this.getModel()), (BigDecimal)rate);
                list.add(Arrays.asList({x, rate}, {y, rate}));
            }
        } else if ("total".equals(structType)) {
            BigDecimal beginRate = Constants.ZERO;
            BigDecimal endRate = Constants.ZERO;
            for (DynamicObject zone : zones) {
                BigDecimal rate = zone.getBigDecimal("rate");
                BigDecimal x = zone.getBigDecimal("pricex");
                BigDecimal y = zone.getBigDecimal("pricey");
                if ("precent".equals(priceMethod)) {
                    x = x.divide(Constants.ONE_HUNDRED, 6, 4);
                    y = y.divide(Constants.ONE_HUNDRED, 6, 4);
                }
                if (EmptyUtil.isEmpty((BigDecimal)x)) {
                    beginRate = rate;
                    continue;
                }
                if (!EmptyUtil.isNoEmpty((BigDecimal)x) || !EmptyUtil.isNoEmpty((BigDecimal)y)) continue;
                endRate = rate;
            }
            BigDecimal days = new BigDecimal(StructDepositHelper.getPeriodDays((ModelAgent)new ModelAgent((Object)this.getModel())));
            String displayForm = (String)this.getModel().getValue("displayform");
            if (DisplayFormEnum.intest.getValue().equals(displayForm) && EmptyUtil.isNoEmpty((BigDecimal)beginRate)) {
                beginRate = StructDepositHelper.callPredictIntest((ModelAgent)new ModelAgent((Object)this.getModel()), (BigDecimal)beginRate, (BigDecimal)days);
            }
            if (DisplayFormEnum.intest.getValue().equals(displayForm) && EmptyUtil.isNoEmpty((BigDecimal)endRate)) {
                endRate = StructDepositHelper.callPredictIntest((ModelAgent)new ModelAgent((Object)this.getModel()), (BigDecimal)endRate, (BigDecimal)days);
            }
            int D = StructDepositHelper.getD((ModelAgent)new ModelAgent((Object)this.getModel()));
            list.add(Arrays.asList({Constants.ZERO, beginRate}, {new BigDecimal(D), endRate}));
            list.add(null);
            list.add(null);
        }
        logger.info(JSON.toJSONString(list));
        return list;
    }

    protected List<Object> getPointValue() {
        ArrayList<Object> list = new ArrayList<Object>();
        String structType = (String)this.getModel().getValue("structtype");
        String billStatus = this.getModel().getDataEntity().getString("billstatus");
        if (EmptyUtil.isNoEmpty((String)billStatus) && TcBillStatusEnum.SAVE.getValue().equals(billStatus)) {
            if ("break".equals(structType)) {
                BigDecimal[] result = StructDepositHelper.callBreakPredictResult((ModelAgent)new ModelAgent((Object)this.getModel()), (boolean)true);
                this.getModel().setValue("predictmark", (Object)result[0]);
                this.getModel().setValue("predictrate", (Object)result[1]);
            } else if ("total".equals(structType)) {
                this.getModel().setValue("predictmark", (Object)Constants.ZERO);
                BigDecimal rate = StructDepositHelper.callTotalPredictResult((ModelAgent)new ModelAgent((Object)this.getModel()));
                this.getModel().setValue("predictrate", (Object)rate);
            }
        }
        list.add(Arrays.asList((BigDecimal)this.getModel().getValue("predictmark"), (BigDecimal)this.getModel().getValue("predictrate")));
        logger.info(JSON.toJSONString(list));
        return list;
    }

    protected List<Map<String, Object>> reduceBeginPoint(List<Map<String, Object>> priceZone) {
        Map<String, Object> price;
        int index;
        BigDecimal begin = null;
        BigDecimal end = null;
        for (index = 0; index < priceZone.size(); ++index) {
            price = priceZone.get(index);
            BigDecimal x = (BigDecimal)price.get("x");
            BigDecimal y = (BigDecimal)price.get("y");
            if (EmptyUtil.isNoEmpty((BigDecimal)x) && (EmptyUtil.isEmpty(begin) || x.compareTo(begin) < 0)) {
                begin = x;
            }
            if (!EmptyUtil.isNoEmpty((BigDecimal)y) || !EmptyUtil.isEmpty(end) && y.compareTo(end) <= 0) continue;
            end = y;
        }
        for (index = 0; index < priceZone.size(); ++index) {
            price = priceZone.get(index);
            DynamicObject bwSymbol = (DynamicObject)price.get("symbol");
            String beginSymbol = bwSymbol.getString("begin");
            String endSymbol = bwSymbol.getString("end");
            BigDecimal x = (BigDecimal)price.get("x");
            BigDecimal y = (BigDecimal)price.get("y");
            if (y != null && y.compareTo(Constants.ZERO) == 0 && x != null && x.compareTo(Constants.ZERO) == 0 && EmptyUtil.isNoEmpty((BigDecimal)end) && EmptyUtil.isNoEmpty((BigDecimal)begin)) {
                y = begin.compareTo(end) == 0 ? x.add(begin) : x.add(end.subtract(begin));
                price.put("y", y);
            }
            if ("not_equal".equals(beginSymbol) && x != null) {
                price.put("x", x.add(Constants._OOO1));
            }
            if (!"not_equal".equals(endSymbol) || index == priceZone.size() - 1 || y == null) continue;
            price.put("y", y.subtract(Constants._OOO1));
        }
        return priceZone;
    }

    protected BigDecimal callMarketRate(BigDecimal price) {
        BigDecimal initprice;
        String priceMethod;
        if (EmptyUtil.isEmpty((BigDecimal)price)) {
            price = Constants.ZERO;
        }
        if ("precent".equals(priceMethod = (String)this.getModel().getValue("pricemethod")) && EmptyUtil.isNoEmpty((BigDecimal)(initprice = (BigDecimal)this.getModel().getValue("initialprice")))) {
            price = price.multiply(initprice).divide(Constants.ONE_HUNDRED, 6, 4);
        }
        return price;
    }

    protected void initXStyle(Axis axis) {
        super.initXStyle(axis);
        String structType = (String)this.getModel().getValue("structtype");
        if ("total".equals(structType) && EmptyUtil.isNoEmpty((Object)axis.getInterval())) {
            axis.setInterval((Number)new BigDecimal(axis.getInterval().toString()).setScale(0, 4));
        }
    }

    protected void initSeriesStyle(int index, Chart chart, LineSeries series, String color) {
        super.initSeriesStyle(index, chart, (Series)series, color);
        series.setSmooth(true);
        series.setPropValue("symbolSize", (Object)1);
    }

    protected String getChartTabName() {
        return "tabchart";
    }

    protected String getXTitleName() {
        String structType = (String)this.getModel().getValue("structtype");
        if ("break".equals(structType)) {
            String hookType = (String)this.getModel().getValue("hooktype");
            if (HookTypeEnum.referrate.getValue().equals(hookType)) {
                return ResManager.loadKDString((String)"\u6807\u7684\u4ef7\u683c(%)", (String)"StructDepositChatEdit_3", (String)"tmc-tm-formplugin", (Object[])new Object[0]);
            }
            return ResManager.loadKDString((String)"\u6807\u7684\u4ef7\u683c", (String)"StructDepositChatEdit_4", (String)"tmc-tm-formplugin", (Object[])new Object[0]);
        }
        return ResManager.loadKDString((String)"\u76ee\u6807\u533a\u95f4\u5185\u5929\u6570", (String)"StructDepositChatEdit_5", (String)"tmc-tm-formplugin", (Object[])new Object[0]);
    }

    protected String getYTitleName() {
        String displayForm = (String)this.getModel().getValue("displayform");
        if (DisplayFormEnum.intest.getValue().equals(displayForm)) {
            return ResManager.loadKDString((String)"%s\uff08\u5143\uff09", (String)"StructDepositChatEdit_6", (String)"tmc-tm-formplugin", (Object[])new Object[]{DisplayFormEnum.valueOf((String)displayForm).getName()});
        }
        return DisplayFormEnum.valueOf((String)displayForm).getName() + "\uff08%\uff09";
    }

    protected String getChartCtlName() {
        return "chartap";
    }

    protected boolean isDreawPoint() {
        return true;
    }

    protected void initRedeemDate() {
        String obsFreq = (String)this.getModel().getValue("obsfreq");
        if (!ObsFrequeEnum.day.getValue().equals(obsFreq) && !ObsFrequeEnum.continuous.getValue().equals(obsFreq)) {
            List items = StructDepositHelper.initRedeemDateBox((IDataModel)this.getModel(), (IFormView)this.getView());
            if (items.size() > 0) {
                this.getModel().setValue("redeemdate2", (Object)((ComboItem)items.get(0)).getValue());
                String selDate = ((ComboItem)items.get(0)).getValue();
                Date date = TcDateUtils.stringToDate((String)selDate, (String)"yyyy-MM-dd");
                TmcViewInputHelper.setValWithoutPropChgEvt((IFormView)this.getView(), (IDataModel)this.getModel(), (String)"redeemdate", (Object)date);
            }
        } else {
            Date lastObsDate = (Date)this.getModel().getValue("lastobsdate");
            TmcViewInputHelper.setValWithoutPropChgEvt((IFormView)this.getView(), (IDataModel)this.getModel(), (String)"redeemdate", (Object)lastObsDate);
        }
        this.initRedeemDateView();
    }

    protected void initRedeemDateView() {
        String obsFreq = (String)this.getModel().getValue("obsfreq");
        if (ObsFrequeEnum.day.getValue().equals(obsFreq) || ObsFrequeEnum.continuous.getValue().equals(obsFreq)) {
            this.getView().setVisible(Boolean.valueOf(false), new String[]{"redeemdate2"});
            this.getView().setVisible(Boolean.valueOf(true), new String[]{"redeemdate"});
            Date firstDate = (Date)this.getModel().getValue("firstobsdate");
            Date lastObsDate = (Date)this.getModel().getValue("lastobsdate");
            DateTimeEdit redeemDate = (DateTimeEdit)this.getView().getControl("redeemdate");
            if (EmptyUtil.isNoEmpty((Object)firstDate)) {
                redeemDate.setMinDate(firstDate);
            }
            if (EmptyUtil.isNoEmpty((Object)lastObsDate)) {
                redeemDate.setMaxDate(lastObsDate);
            }
        } else {
            this.getView().setVisible(Boolean.valueOf(true), new String[]{"redeemdate2"});
            this.getView().setVisible(Boolean.valueOf(false), new String[]{"redeemdate"});
        }
    }

    public void setObsDateLimit() {
        DateEdit obsDateControl = (DateEdit)this.getControl("obsdate");
        Date firstDate = (Date)this.getModel().getValue("firstobsdate");
        Date lastObsDate = (Date)this.getModel().getValue("lastobsdate");
        obsDateControl.setMinDate(firstDate);
        obsDateControl.setMaxDate(lastObsDate);
    }

    public void afterDoOperation(AfterDoOperationEventArgs e) {
        super.afterDoOperation(e);
        if ("refresh".equals(e.getOperateKey())) {
            this.drawChart();
        }
    }
}

