/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.tm.formplugin.structdeposit;

import java.util.Date;
import java.util.EventObject;
import kd.bos.bill.OperationStatus;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.form.IFormView;
import kd.bos.form.events.BeforeFieldPostBackEvent;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.DateEdit;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.list.ListShowParameter;
import kd.bos.orm.query.QFilter;
import kd.tmc.fbp.common.enums.AdjustMethodEnum;
import kd.tmc.fbp.common.helper.TmcViewInputHelper;
import kd.tmc.fbp.common.helper.business.TradeBusinessHelper;
import kd.tmc.fbp.common.util.EmptyUtil;
import kd.tmc.fbp.common.util.TcDateUtils;
import kd.tmc.fbp.common.util.TermUtils;
import kd.tmc.tm.common.helper.StructDepositHelper;
import kd.tmc.tm.formplugin.trade.AbstractTradeBillEdit;

public class StructDepositEdit
extends AbstractTradeBillEdit
implements BeforeF7SelectListener {
    public void registerListener(EventObject e) {
        super.registerListener(e);
        BasedataEdit market = (BasedataEdit)this.getView().getControl("market");
        market.addBeforeF7SelectListener((BeforeF7SelectListener)this);
    }

    @Override
    public void afterBindData(EventObject e) {
        super.afterBindData(e);
        boolean isDataChange = this.getModel().getDataChanged();
        Date bizDate = (Date)this.getModel().getValue("bizdate");
        ((DateEdit)this.getControl("intdate")).setMinDate(bizDate);
        Date intDate = (Date)this.getModel().getValue("intdate");
        ((DateEdit)this.getControl("settledate")).setMinDate(intDate);
        if (this.getView().getFormShowParameter().getStatus().equals((Object)OperationStatus.ADDNEW)) {
            this.callSettleDate();
        }
        this.getModel().setDataChanged(isDataChange);
    }

    public void propertyChanged(PropertyChangedArgs args) {
        String propName;
        super.propertyChanged(args);
        switch (propName = args.getProperty().getName()) {
            case "bizdate": {
                this.bizDateChgEvt();
                break;
            }
            case "intdate": {
                this.callSettleDate();
                StructDepositHelper.initFirstObsDate((IDataModel)this.getModel(), (IFormView)this.getView(), (boolean)true);
                StructDepositHelper.initLastObsDate((IDataModel)this.getModel(), (IFormView)this.getView(), (boolean)false);
                break;
            }
            case "term": {
                Date settleDate = (Date)this.getModel().getValue("settledate");
                Date intDate = (Date)this.getModel().getValue("intdate");
                Integer delayLimit = !EmptyUtil.isAnyoneEmpty((Object[])new Object[]{intDate, settleDate}) ? TcDateUtils.getDiffDays((Date)intDate, (Date)settleDate) / 2 : 0;
                Integer settleDelay = (Integer)this.getModel().getValue("settledelay");
                if (settleDelay > delayLimit || settleDelay < 0) {
                    this.getModel().setValue("settledelay", (Object)0);
                }
            }
            case "dateadjustmethod": 
            case "workcalendar": {
                this.callSettleDate();
                StructDepositHelper.initFirstObsDate((IDataModel)this.getModel(), (IFormView)this.getView(), (boolean)false);
                StructDepositHelper.initLastObsDate((IDataModel)this.getModel(), (IFormView)this.getView(), (boolean)false);
                break;
            }
            case "settledate": {
                this.callTerm();
                this.callAdjustSettleDate();
                StructDepositHelper.initFirstObsDate((IDataModel)this.getModel(), (IFormView)this.getView(), (boolean)false);
                StructDepositHelper.initLastObsDate((IDataModel)this.getModel(), (IFormView)this.getView(), (boolean)false);
                break;
            }
            case "currency": {
                TmcViewInputHelper.setValWithoutPropChgEvt((IFormView)this.getView(), (IDataModel)this.getModel(), (String)"market", null);
                TradeBusinessHelper.initMarketValue((IDataModel)this.getModel(), (IFormView)this.getView(), (String)"market", (String)"currency");
                break;
            }
            case "amount": {
                this.getModel().setValue("bizrestamt", this.getModel().getValue("amount"));
            }
        }
    }

    private void bizDateChgEvt() {
        Date intDate = (Date)this.getModel().getValue("intdate");
        Date bizDate = (Date)this.getModel().getValue("bizdate");
        ((DateEdit)this.getControl("intdate")).setMinDate(bizDate);
        if (!EmptyUtil.isAnyoneEmpty((Object[])new Object[]{intDate, bizDate}) && intDate.before(bizDate)) {
            this.getModel().setValue("intdate", (Object)bizDate);
        }
    }

    private void callSettleDate() {
        Date intDate = (Date)this.getModel().getValue("intdate");
        String term = (String)this.getModel().getValue("term");
        if (EmptyUtil.isNoEmpty((Object)intDate) && EmptyUtil.isNoEmpty((String)term)) {
            Date settleDate = TermUtils.getDateByBaseDate4ymd((String)term, (Date)intDate);
            ((DateEdit)this.getControl("settledate")).setMinDate(intDate);
            TmcViewInputHelper.setValWithoutPropChgEvt((IFormView)this.getView(), (IDataModel)this.getModel(), (String)"settledate", (Object)settleDate);
            this.callAdjustSettleDate();
            StructDepositHelper.initLastObsDate((IDataModel)this.getModel(), (IFormView)this.getView(), (boolean)true);
        }
    }

    private void callAdjustSettleDate() {
        Date settleDate = (Date)this.getModel().getValue("settledate");
        if (EmptyUtil.isNoEmpty((Object)settleDate)) {
            AdjustMethodEnum adjustmethod = AdjustMethodEnum.valueOf((String)((String)this.getModel().getValue("dateadjustmethod")));
            DynamicObjectCollection wc = (DynamicObjectCollection)this.getModel().getValue("workcalendar");
            Date ad_settleDate = TradeBusinessHelper.callAdjustSettleDate((DynamicObjectCollection)wc, (Date)TcDateUtils.truncateDate((Date)settleDate), (AdjustMethodEnum)adjustmethod);
            TmcViewInputHelper.setValWithoutPropChgEvt((IFormView)this.getView(), (IDataModel)this.getModel(), (String)"adjustsettledate", (Object)ad_settleDate);
        }
    }

    private void callTerm() {
        Date settleDate = (Date)this.getModel().getValue("settledate");
        Date intDate = (Date)this.getModel().getValue("intdate");
        if (EmptyUtil.isNoEmpty((Object)intDate) && EmptyUtil.isNoEmpty((Object)settleDate)) {
            this.getModel().setValue("term", (Object)TcDateUtils.getDiffYMD((Date)intDate, (Date)settleDate));
        }
    }

    public void beforeF7Select(BeforeF7SelectEvent evt) {
        DynamicObject currency;
        if ("market".equals(((BasedataEdit)evt.getSource()).getKey()) && EmptyUtil.isNoEmpty((DynamicObject)(currency = (DynamicObject)this.getModel().getValue("currency")))) {
            QFilter qFilter = new QFilter("currency.id", "=", (Object)currency.getLong("id"));
            ListShowParameter showParameter = (ListShowParameter)evt.getFormShowParameter();
            showParameter.getListFilterParameter().setFilter(qFilter);
        }
    }

    protected void verifyInput(String key, Object value, BeforeFieldPostBackEvent e) {
        super.verifyInput(key, value, e);
        if (EmptyUtil.isEmpty((Object)value)) {
            return;
        }
        switch (key) {
            case "settledelay": {
                Date settleDate = (Date)this.getModel().getValue("settledate");
                Date intDate = (Date)this.getModel().getValue("intdate");
                Integer delayLimit = TcDateUtils.getDiffDays((Date)intDate, (Date)settleDate) / 2;
                Integer settleDelay = Integer.valueOf(value.toString());
                if (settleDelay <= delayLimit && delayLimit >= 0) break;
                e.setCancel(true);
                this.getView().updateView("settledelay");
            }
        }
    }
}

