/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.tm.formplugin.swaps;

import java.math.BigDecimal;
import java.util.Date;
import java.util.EventObject;
import java.util.Set;
import kd.bos.bill.OperationStatus;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.ShowFormHelper;
import kd.bos.form.control.events.ClickListener;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.TextEdit;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.list.ListShowParameter;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.tmc.fbp.common.enums.TradeDirectionEnum;
import kd.tmc.fbp.common.helper.TmcDataServiceHelper;
import kd.tmc.fbp.common.helper.TmcViewInputHelper;
import kd.tmc.fbp.common.helper.service.MarketDataServiceHelper;
import kd.tmc.fbp.common.util.EmptyUtil;
import kd.tmc.fbp.common.util.TcDateUtils;
import kd.tmc.fbp.formplugin.edit.AbstractTmcBillEdit;
import kd.tmc.tm.common.enums.CombReqNoteEnum;
import kd.tmc.tm.common.helper.ForexHelper;

public class ForexSwapBsInfoEdit
extends AbstractTmcBillEdit
implements BeforeF7SelectListener,
ClickListener {
    public void registerListener(EventObject e) {
        super.registerListener(e);
        BasedataEdit market = (BasedataEdit)this.getView().getControl("market_bs");
        market.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        TextEdit pair = (TextEdit)this.getView().getControl("pair");
        pair.addButtonClickListener((ClickListener)this);
    }

    public void beforeF7Select(BeforeF7SelectEvent evt) {
        DynamicObject currency;
        String key = evt.getProperty().getName();
        if (StringUtils.equals((CharSequence)key, (CharSequence)"market_bs") && EmptyUtil.isNoEmpty((DynamicObject)(currency = (DynamicObject)this.getModel().getValue("currency_bs")))) {
            QFilter qFilter = new QFilter("currency.id", "=", currency.getPkValue());
            ListShowParameter showParameter = (ListShowParameter)evt.getFormShowParameter();
            showParameter.getListFilterParameter().setFilter(qFilter);
        }
    }

    public void click(EventObject e) {
        if (e.getSource() instanceof TextEdit && ((TextEdit)e.getSource()).getKey().equals("pair")) {
            ListShowParameter showParameter = ShowFormHelper.createShowListForm((String)"bd_currency_tc", (boolean)true);
            showParameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, "selectPair"));
            showParameter.setShowTitle(false);
            showParameter.setCustomParam("billFormId", (Object)"bd_currency_tc");
            QFilter qFilter = new QFilter("enable", "=", (Object)Boolean.TRUE);
            String noteno = (String)this.getModel().getValue("reqnoteno");
            if (EmptyUtil.isNoEmpty((Object)this.getModel().getValue("pair"))) {
                DynamicObject buyCurrency = (DynamicObject)this.getModel().getValue("currency");
                DynamicObject sellCurrency = (DynamicObject)this.getModel().getValue("sellcurrency");
                if (EmptyUtil.isNoEmpty((String)noteno)) {
                    qFilter.and("id", "in", (Object)new Long[]{buyCurrency.getLong("id"), sellCurrency.getLong("id")});
                }
                showParameter.setSelectedRows(new Object[]{buyCurrency.getLong("id"), sellCurrency.getLong("id")});
            } else if (EmptyUtil.isNoEmpty((String)noteno)) {
                DynamicObject sourceBill;
                Object sourceBillId = this.getModel().getValue("sourcebillid");
                String buyCurrencyProp = "swapsinfo.currin";
                String sellCurrencyProp = "swapsinfo.currout";
                String entryRowIdProp = "swapsinfo.id";
                String source = (String)this.getModel().getValue("source");
                String soureEntityNum = "tm_reqnote";
                if (source.startsWith("combreqnote")) {
                    buyCurrencyProp = CombReqNoteEnum.SWAPS.getEntryName() + "." + CombReqNoteEnum.SWAPS.getEntryBuyCurrName();
                    sellCurrencyProp = CombReqNoteEnum.SWAPS.getEntryName() + "." + CombReqNoteEnum.SWAPS.getEntrySellCurrName();
                    entryRowIdProp = CombReqNoteEnum.SWAPS.getEntryName() + ".id";
                    soureEntityNum = "tm_combreqnote";
                }
                if ((sourceBill = QueryServiceHelper.queryOne((String)soureEntityNum, (String)(buyCurrencyProp + "," + sellCurrencyProp), (QFilter[])new QFilter("billno", "=", (Object)noteno).and(entryRowIdProp, "=", sourceBillId).toArray())) != null && sourceBill.get(buyCurrencyProp) != null && sourceBill.get(sellCurrencyProp) != null) {
                    qFilter.and("id", "in", (Object)new Object[]{sourceBill.get(buyCurrencyProp), sourceBill.get(sellCurrencyProp)});
                }
            }
            showParameter.getListFilterParameter().getQFilters().add(qFilter);
            this.getView().showForm((FormShowParameter)showParameter);
        }
    }

    public void propertyChanged(PropertyChangedArgs args) {
        super.propertyChanged(args);
        String propName = args.getProperty().getName();
        int rowIndex = args.getChangeSet()[0].getRowIndex();
        Object newValue = args.getChangeSet()[0].getNewValue();
        switch (propName) {
            case "tradedirect": 
            case "pair": {
                this.buildEntryBS();
                this.setBiztype();
                break;
            }
            case "amount_bs": {
                this.amoutBsChange(rowIndex, (BigDecimal)newValue);
                break;
            }
            case "spotrate": {
                this.setSecondAmt(0, 1, (BigDecimal)newValue);
                break;
            }
            case "forwrate": {
                this.setSecondAmt(2, 3, (BigDecimal)newValue);
                break;
            }
            case "market_bs": {
                if (rowIndex == 0) {
                    this.getModel().setValue("buymarket", newValue);
                    this.getModel().setValue("buymarket_far", newValue);
                    TmcViewInputHelper.setValWithoutPropChgEvt((IFormView)this.getView(), (IDataModel)this.getModel(), (String)"market_bs", (Object)newValue, (int)2);
                    break;
                }
                this.getModel().setValue("sellmarket", newValue);
                this.getModel().setValue("sellmarket_far", newValue);
                TmcViewInputHelper.setValWithoutPropChgEvt((IFormView)this.getView(), (IDataModel)this.getModel(), (String)"market_bs", (Object)newValue, (int)3);
                break;
            }
            case "amount": {
                this.getModel().setValue("bizrestamt", newValue);
                this.getModel().setValue("farbizrestamt", newValue);
                break;
            }
            case "currency": {
                this.getModel().setValue("amount", null);
                if (!EmptyUtil.isNoEmpty((DynamicObjectCollection)this.getModel().getEntryEntity("entry_bs"))) break;
                this.getModel().setValue("amount_bs", null, 0);
                this.getModel().setValue("amount_bs", null, 2);
                break;
            }
            case "sellcurrency": {
                this.getModel().setValue("sellamount", null);
                if (!EmptyUtil.isNoEmpty((DynamicObjectCollection)this.getModel().getEntryEntity("entry_bs"))) break;
                this.getModel().setValue("amount_bs", null, 1);
                this.getModel().setValue("amount_bs", null, 3);
            }
        }
    }

    public void beforeBindData(EventObject e) {
        super.beforeBindData(e);
        this.buildEntryBS();
    }

    public void afterBindData(EventObject e) {
        super.afterBindData(e);
        if (this.getView().getFormShowParameter().getStatus() == OperationStatus.ADDNEW && this.getView().getFormShowParameter().getCustomParams().containsKey("iscopy") && ((Boolean)this.getView().getFormShowParameter().getCustomParam("iscopy")).booleanValue()) {
            BigDecimal amount = (BigDecimal)this.getModel().getValue("amount_bs", 0);
            TmcViewInputHelper.setValWithoutPropChgEvt((IFormView)this.getView(), (IDataModel)this.getModel(), (String)"amount_bs", (Object)BigDecimal.ZERO, (int)0);
            this.getModel().setValue("amount_bs", (Object)amount, 0);
        }
    }

    public void afterCopyData(EventObject e) {
        super.afterCopyData(e);
        this.setBiztype();
    }

    public void closedCallBack(ClosedCallBackEvent event) {
        ListSelectedRowCollection data;
        super.closedCallBack(event);
        if (event.getActionId().equals("selectPair") && EmptyUtil.isNoEmpty((Object)(data = (ListSelectedRowCollection)event.getReturnData()))) {
            Object buyCurrencyId = data.get(0).getPrimaryKeyValue();
            Object sellCurrencyId = data.get(1).getPrimaryKeyValue();
            Set exCurrency = ForexHelper.getExCurrency((Long)((DynamicObject)this.getModel().getValue("org")).getLong("id"));
            if (EmptyUtil.isNoEmpty((Object)exCurrency)) {
                if (exCurrency.contains(buyCurrencyId) && exCurrency.contains(sellCurrencyId)) {
                    this.getView().showErrorNotification(ResManager.loadKDString((String)"\u8d27\u5e01\u5bf9\u9009\u62e9\u9519\u8bef\uff08\u9009\u62e9\u7684\u4e24\u5e01\u79cd\u5747\u4e3a\u5916\u6c47\u4ea4\u6613\u672c\u4f4d\u5e01\uff09\uff0c\u8bf7\u91cd\u65b0\u9009\u62e9\u3002", (String)"ForexBsInfoEdit_0", (String)"tmc-tm-formplugin", (Object[])new Object[0]));
                    return;
                }
            } else {
                this.getView().showErrorNotification(ResManager.loadKDString((String)"\u5f53\u524d\u7ec4\u7ec7\u6ca1\u6709\u914d\u7f6e\u5916\u6c47\u4ea4\u6613\u672c\u4f4d\u5e01\uff0c\u65e0\u6cd5\u83b7\u53d6\u4e1a\u52a1\u7c7b\u578b\u3002", (String)"OrgWithoutExCurrencyConfig", (String)"tmc-tm-formplugin", (Object[])new Object[0]));
                return;
            }
            DynamicObject buyCurrency = TmcDataServiceHelper.loadSingleFromCache((Object)buyCurrencyId, (String)"bd_currency");
            DynamicObject sellCurrency = TmcDataServiceHelper.loadSingleFromCache((Object)sellCurrencyId, (String)"bd_currency");
            String pair = buyCurrency.getString("number") + "/" + sellCurrency.getString("number");
            DynamicObject priceRule = (DynamicObject)this.getModel().getValue("pricerule");
            if (EmptyUtil.isNoEmpty((DynamicObject)priceRule)) {
                if (EmptyUtil.isEmpty((DynamicObject)priceRule.getDynamicObject("forexquote"))) {
                    this.getView().showErrorNotification(ResManager.loadKDString((String)"\u8be5\u5b9a\u4ef7\u89c4\u5219\u6ca1\u6709\u8bbe\u7f6e\u5916\u6c47\u62a5\u4ef7\u3002", (String)"PriceRuleWithoutFX", (String)"tmc-tm-formplugin", (Object[])new Object[0]));
                    return;
                }
                Long fqId = priceRule.getDynamicObject("forexquote").getLong("id");
                MarketDataServiceHelper.getForexQuoteInfo((Long)fqId, (String)pair, null, (Date)TcDateUtils.getCurrentDate());
            } else {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u586b\u5199\u5b9a\u4ef7\u89c4\u5219\u83b7\u53d6\u5916\u6c47\u62a5\u4ef7\u65b9\u5f0f\u3002", (String)"PriceRuleIsNull", (String)"tmc-tm-formplugin", (Object[])new Object[0]));
            }
            this.getModel().setValue("currency", buyCurrencyId);
            this.getModel().setValue("sellcurrency", sellCurrencyId);
            this.getModel().setValue("buycurrency_far", buyCurrencyId);
            this.getModel().setValue("sellcurrency_far", sellCurrencyId);
            this.getModel().setValue("pair", (Object)pair);
        }
    }

    private void setBiztype() {
        QFilter filter_enable;
        String pair;
        String dir = (String)this.getModel().getValue("tradedirect");
        if (EmptyUtil.isAnyoneEmpty((Object[])new Object[]{dir, pair = (String)this.getModel().getValue("pair")})) {
            this.getModel().setValue("biztype", null);
            return;
        }
        DynamicObject sellCurrency = (DynamicObject)this.getModel().getValue("sellcurrency");
        DynamicObject currency = (DynamicObject)this.getModel().getValue("currency");
        Long orgId = ((DynamicObject)this.getModel().getValue("org")).getLong("id");
        QFilter filter_org = new QFilter("org", "=", (Object)orgId);
        DynamicObject exCurrencyConfig = TmcDataServiceHelper.loadSingle((String)"tbd_excurrency", (String)"excurrency", (QFilter[])new QFilter[]{filter_org, filter_enable = new QFilter("enable", "=", (Object)Character.valueOf('1'))});
        if (EmptyUtil.isEmpty((DynamicObject)exCurrencyConfig)) {
            this.getView().showErrorNotification(ResManager.loadKDString((String)"\u5f53\u524d\u7ec4\u7ec7\u6ca1\u6709\u914d\u7f6e\u5916\u6c47\u4ea4\u6613\u672c\u4f4d\u5e01\uff0c\u65e0\u6cd5\u83b7\u53d6\u4e1a\u52a1\u7c7b\u578b\u3002", (String)"OrgWithoutExCurrencyConfig", (String)"tmc-tm-formplugin", (Object[])new Object[0]));
            return;
        }
        DynamicObjectCollection exCurrencyCol = exCurrencyConfig.getDynamicObjectCollection("excurrency");
        boolean isContainSell = false;
        for (DynamicObject oneCurrency : exCurrencyCol) {
            if (sellCurrency.getLong("id") != oneCurrency.getDynamicObject("fbasedataid").getLong("id")) continue;
            isContainSell = true;
            break;
        }
        boolean isContainBuy = false;
        for (DynamicObject oneCurrency : exCurrencyCol) {
            if (currency.getLong("id") != oneCurrency.getDynamicObject("fbasedataid").getLong("id")) continue;
            isContainBuy = true;
            break;
        }
        if (isContainBuy && isContainSell) {
            this.getModel().setValue("biztype", (Object)"");
            this.getView().showErrorNotification(ResManager.loadKDString((String)"\u8d27\u5e01\u5bf9\u9009\u62e9\u9519\u8bef\uff08\u9009\u62e9\u7684\u4e24\u5e01\u79cd\u5747\u4e3a\u5916\u6c47\u4ea4\u6613\u672c\u4f4d\u5e01\uff09\uff0c\u8bf7\u91cd\u65b0\u9009\u62e9\u3002", (String)"ForexBsInfoEdit_0", (String)"tmc-tm-formplugin", (Object[])new Object[0]));
            return;
        }
        if (isContainSell && TradeDirectionEnum.buy.getValue().equals(dir) || isContainBuy && TradeDirectionEnum.sell.getValue().equals(dir)) {
            this.getModel().setValue("biztype", (Object)"buy");
        } else if (isContainSell && TradeDirectionEnum.sell.getValue().equals(dir) || isContainBuy && TradeDirectionEnum.buy.getValue().equals(dir)) {
            this.getModel().setValue("biztype", (Object)"sell");
        } else {
            this.getModel().setValue("biztype", (Object)"diff");
        }
    }

    private void buildEntryBS() {
        String tradeDir;
        String pair = (String)this.getModel().getValue("pair");
        if (!EmptyUtil.isAnyoneEmpty((Object[])new Object[]{pair, tradeDir = (String)this.getModel().getValue("tradedirect")})) {
            this.getModel().deleteEntryData("entry_bs");
            this.getModel().batchCreateNewEntryRow("entry_bs", 4);
            if (TradeDirectionEnum.buy.getValue().equals(tradeDir)) {
                this.getModel().setValue("direct_bs", (Object)"buy", 0);
                this.getModel().setValue("direct_bs", (Object)"sell", 1);
                this.getModel().setValue("direct_bs", (Object)"sell", 2);
                this.getModel().setValue("direct_bs", (Object)"buy", 3);
            } else {
                this.getModel().setValue("direct_bs", (Object)"sell", 0);
                this.getModel().setValue("direct_bs", (Object)"buy", 1);
                this.getModel().setValue("direct_bs", (Object)"buy", 2);
                this.getModel().setValue("direct_bs", (Object)"sell", 3);
            }
            this.getModel().setValue("dir_bs", (Object)"spot", 0);
            this.getModel().setValue("currency_bs", this.getModel().getValue("currency"), 0);
            TmcViewInputHelper.setValWithoutPropChgEvt((IFormView)this.getView(), (IDataModel)this.getModel(), (String)"amount_bs", (Object)this.getModel().getValue("amount"), (int)0);
            this.getModel().setValue("market_bs", this.getModel().getValue("buymarket"), 0);
            this.getModel().setValue("currency_bs", this.getModel().getValue("sellcurrency"), 1);
            TmcViewInputHelper.setValWithoutPropChgEvt((IFormView)this.getView(), (IDataModel)this.getModel(), (String)"amount_bs", (Object)this.getModel().getValue("sellamount"), (int)1);
            this.getModel().setValue("market_bs", this.getModel().getValue("sellmarket"), 1);
            this.getModel().setValue("dir_bs", (Object)"fwd", 2);
            this.getModel().setValue("currency_bs", this.getModel().getValue("currency"), 2);
            TmcViewInputHelper.setValWithoutPropChgEvt((IFormView)this.getView(), (IDataModel)this.getModel(), (String)"amount_bs", (Object)this.getModel().getValue("buyamount_far"), (int)2);
            this.getModel().setValue("market_bs", this.getModel().getValue("buymarket"), 2);
            this.getModel().setValue("currency_bs", this.getModel().getValue("sellcurrency"), 3);
            TmcViewInputHelper.setValWithoutPropChgEvt((IFormView)this.getView(), (IDataModel)this.getModel(), (String)"amount_bs", (Object)this.getModel().getValue("sellamount_far"), (int)3);
            this.getModel().setValue("market_bs", this.getModel().getValue("sellmarket"), 3);
            this.getView().setEnable(Boolean.valueOf(false), 2, new String[]{"amount_bs", "market_bs"});
            this.getView().setEnable(Boolean.valueOf(false), 3, new String[]{"amount_bs", "market_bs"});
        } else {
            this.getModel().deleteEntryData("entry_bs");
            if (this.getView().getFormShowParameter().getCustomParams().containsKey("iscopy") && ((Boolean)this.getView().getFormShowParameter().getCustomParam("iscopy")).booleanValue()) {
                this.getModel().batchCreateNewEntryRow("entry_bs", 4);
            }
            if (EmptyUtil.isEmpty((String)pair)) {
                this.getModel().setValue("currency", null);
                this.getModel().setValue("amount", null);
                this.getModel().setValue("buymarket", null);
                this.getModel().setValue("sellcurrency", null);
                this.getModel().setValue("sellamount", null);
                this.getModel().setValue("sellmarket", null);
                this.getModel().setValue("buyamount_far", null);
                this.getModel().setValue("sellamount_far", null);
            }
        }
        this.getView().updateView("entry_bs");
        this.getModel().setDataChanged(false);
    }

    private void amoutBsChange(int rowIndex, BigDecimal amountBs) {
        BigDecimal spotRate = (BigDecimal)this.getModel().getValue("spotrate");
        if (rowIndex == 0) {
            this.getModel().setValue("amount", (Object)amountBs);
            this.setSecondAmt(0, 1, spotRate);
            this.getModel().setValue("buyamount_far", (Object)amountBs);
            TmcViewInputHelper.setValWithoutPropChgEvt((IFormView)this.getView(), (IDataModel)this.getModel(), (String)"amount_bs", (Object)amountBs, (int)2);
            BigDecimal forwRate = (BigDecimal)this.getModel().getValue("forwrate");
            this.setSecondAmt(2, 3, forwRate);
        } else {
            this.getModel().setValue("sellamount", (Object)amountBs);
            this.setFirstAmt(spotRate);
        }
    }

    private boolean isSameFX() {
        String pair = (String)this.getModel().getValue("pair");
        String fxquote = (String)this.getModel().getValue("fxquote");
        return !EmptyUtil.isAnyoneEmpty((Object[])new Object[]{pair, fxquote}) && pair.equals(fxquote);
    }

    private void setFirstAmt(BigDecimal exRate) {
        if (EmptyUtil.isNoEmpty((DynamicObjectCollection)this.getModel().getEntryEntity("entry_bs"))) {
            BigDecimal amtSecondRow = (BigDecimal)this.getModel().getValue("amount_bs", 1);
            if (EmptyUtil.isAnyoneEmpty((Object[])new Object[]{exRate, amtSecondRow})) {
                return;
            }
            boolean isSame = this.isSameFX();
            BigDecimal amtFirstRow = isSame ? amtSecondRow.divide(exRate, 6, 4) : amtSecondRow.multiply(exRate);
            TmcViewInputHelper.setValWithoutPropChgEvt((IFormView)this.getView(), (IDataModel)this.getModel(), (String)"amount_bs", (Object)amtFirstRow, (int)0);
            TmcViewInputHelper.setValWithoutPropChgEvt((IFormView)this.getView(), (IDataModel)this.getModel(), (String)"amount_bs", (Object)amtFirstRow, (int)2);
            this.getModel().setValue("amount", (Object)amtFirstRow);
            this.getModel().setValue("buyamount_far", (Object)amtFirstRow);
            BigDecimal forwRate = (BigDecimal)this.getModel().getValue("forwrate");
            if (EmptyUtil.isNoEmpty((BigDecimal)forwRate)) {
                BigDecimal amtSecondRowFar = isSame ? amtFirstRow.multiply(forwRate) : amtFirstRow.divide(forwRate, 6, 4);
                TmcViewInputHelper.setValWithoutPropChgEvt((IFormView)this.getView(), (IDataModel)this.getModel(), (String)"amount_bs", (Object)amtSecondRowFar, (int)3);
                this.getModel().setValue("sellamount_far", (Object)amtFirstRow);
            }
        }
    }

    private void setSecondAmt(int firstRowIndex, int secondRowIndex, BigDecimal exRate) {
        if (EmptyUtil.isNoEmpty((DynamicObjectCollection)this.getModel().getEntryEntity("entry_bs"))) {
            BigDecimal amtFirstRow = (BigDecimal)this.getModel().getValue("amount_bs", firstRowIndex);
            if (EmptyUtil.isAnyoneEmpty((Object[])new Object[]{amtFirstRow, exRate})) {
                return;
            }
            BigDecimal amtSecondRow = this.isSameFX() ? amtFirstRow.multiply(exRate) : amtFirstRow.divide(exRate, 6, 4);
            TmcViewInputHelper.setValWithoutPropChgEvt((IFormView)this.getView(), (IDataModel)this.getModel(), (String)"amount_bs", (Object)amtSecondRow, (int)secondRowIndex);
            if (secondRowIndex == 1) {
                this.getModel().setValue("sellamount", (Object)amtSecondRow);
            } else {
                this.getModel().setValue("sellamount_far", (Object)amtSecondRow);
            }
            this.getView().updateView("entry_bs");
        }
    }
}

