/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.tm.formplugin.swaps;

import java.math.BigDecimal;
import java.util.Date;
import java.util.EventObject;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.form.IFormView;
import kd.tmc.fbp.common.constant.Constants;
import kd.tmc.fbp.common.enums.TcBillStatusEnum;
import kd.tmc.fbp.common.enums.TradeDirectionEnum;
import kd.tmc.fbp.common.helper.TmcViewInputHelper;
import kd.tmc.fbp.common.helper.service.MarketDataServiceHelper;
import kd.tmc.fbp.common.model.ForexQuoteInfo;
import kd.tmc.fbp.common.util.EmptyUtil;
import kd.tmc.tm.formplugin.trade.AbstractTradeBillEdit;

public class ForexSwapsEdit
extends AbstractTradeBillEdit {
    public void propertyChanged(PropertyChangedArgs args) {
        String propName;
        super.propertyChanged(args);
        switch (propName = args.getProperty().getName()) {
            case "pricerule": 
            case "tradedirect": 
            case "bizdate": 
            case "adjustsettledate": 
            case "adjustsettledate_far": {
                this.dealForexQuoteInfo();
                break;
            }
            case "pair": {
                if (EmptyUtil.isNoEmpty((Object)this.getModel().getValue("sourcebillid"))) {
                    if ("buy".equals(this.getModel().getValue("tradedirect"))) {
                        TmcViewInputHelper.setValWithoutPropChgEvt((IFormView)this.getView(), (IDataModel)this.getModel(), (String)"tradedirect", (Object)"sell");
                    } else if ("sell".equals(this.getModel().getValue("tradedirect"))) {
                        TmcViewInputHelper.setValWithoutPropChgEvt((IFormView)this.getView(), (IDataModel)this.getModel(), (String)"tradedirect", (Object)"buy");
                    }
                }
                this.dealForexQuoteInfo();
                break;
            }
            case "spotrate": 
            case "forwrate": {
                this.setPips();
                break;
            }
            case "pips": {
                this.setForwRate();
            }
        }
    }

    public void beforeBindData(EventObject e) {
        super.beforeBindData(e);
    }

    public void afterCopyData(EventObject e) {
        super.afterCopyData(e);
        this.dealForexQuoteInfo();
    }

    @Override
    public void afterBindData(EventObject e) {
        super.afterBindData(e);
        String billStatus = (String)this.getModel().getValue("billstatus");
        String sourse = (String)this.getModel().getValue("source");
        if (TcBillStatusEnum.SAVE.getValue().equals(billStatus) && EmptyUtil.isNotEmpty((CharSequence)sourse) && sourse.contains("combreqnote")) {
            this.dealForexQuoteInfo();
        }
    }

    protected void setPips() {
        BigDecimal spotRate = (BigDecimal)this.getModel().getValue("spotrate");
        BigDecimal forwRate = (BigDecimal)this.getModel().getValue("forwrate");
        TmcViewInputHelper.setValWithoutPropChgEvt((IFormView)this.getView(), (IDataModel)this.getModel(), (String)"pips", (Object)forwRate.subtract(spotRate).multiply(Constants.TEN_THOUSAND));
    }

    protected void setForwRate() {
        BigDecimal spotRate = (BigDecimal)this.getModel().getValue("spotrate");
        BigDecimal pips = (BigDecimal)this.getModel().getValue("pips");
        this.getModel().setValue("forwrate", (Object)spotRate.add(pips.divide(Constants.TEN_THOUSAND, 10, 4)));
    }

    private void dealForexQuoteInfo() {
        String forexQuote;
        ForexQuoteInfo info;
        Long fqId;
        DynamicObject priceRule = (DynamicObject)this.getModel().getValue("pricerule");
        String pair = (String)this.getModel().getValue("pair");
        Date dm = (Date)this.getModel().getValue("adjustsettledate");
        Date dm_far = (Date)this.getModel().getValue("adjustsettledate_far");
        BigDecimal spotRate = BigDecimal.ZERO;
        BigDecimal forwRate = BigDecimal.ZERO;
        Date bizdate = (Date)this.getModel().getValue("bizdate");
        String dir = (String)this.getModel().getValue("tradedirect");
        if (!EmptyUtil.isAnyoneEmpty((Object[])new Object[]{priceRule, pair, dm})) {
            if (EmptyUtil.isEmpty((DynamicObject)priceRule.getDynamicObject("forexquote"))) {
                this.getView().showErrorNotification(ResManager.loadKDString((String)"\u8be5\u5b9a\u4ef7\u89c4\u5219\u6ca1\u6709\u8bbe\u7f6e\u5916\u6c47\u62a5\u4ef7\u3002", (String)"PriceRuleWithoutFX", (String)"tmc-tm-formplugin", (Object[])new Object[0]));
                return;
            }
            fqId = priceRule.getDynamicObject("forexquote").getLong("id");
            info = MarketDataServiceHelper.getForexQuoteInfo((Long)fqId, (String)pair, (Date)bizdate, (Date)dm);
            forexQuote = info.getFxquote();
            spotRate = TradeDirectionEnum.buy.getValue().equals(dir) && pair.equals(forexQuote) || TradeDirectionEnum.sell.getValue().equals(dir) && !pair.equals(forexQuote) ? info.getSellPrice() : info.getBuyPrice();
            this.getModel().setValue("fxquote", (Object)forexQuote);
            this.getModel().setValue("spotrate", (Object)spotRate);
        } else {
            this.getModel().setValue("spotrate", null);
        }
        if (!EmptyUtil.isAnyoneEmpty((Object[])new Object[]{priceRule, pair, dm_far})) {
            fqId = priceRule.getDynamicObject("forexquote").getLong("id");
            info = MarketDataServiceHelper.getForexQuoteInfo((Long)fqId, (String)pair, (Date)bizdate, (Date)dm_far);
            forexQuote = info.getFxquote();
            forwRate = TradeDirectionEnum.buy.getValue().equals(dir) && pair.equals(forexQuote) || TradeDirectionEnum.sell.getValue().equals(dir) && !pair.equals(forexQuote) ? info.getBuyPrice() : info.getSellPrice();
            this.getModel().setValue("fxquote", (Object)forexQuote);
            this.getModel().setValue("forwrate", (Object)forwRate);
        } else {
            this.getModel().setValue("forwrate", null);
        }
        BigDecimal pips = forwRate.subtract(spotRate).multiply(Constants.TEN_THOUSAND);
        TmcViewInputHelper.setValWithoutPropChgEvt((IFormView)this.getView(), (IDataModel)this.getModel(), (String)"pips", (Object)pips);
    }
}

