/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.tm.formplugin.trade;

import java.util.EventObject;
import java.util.HashMap;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.entity.tree.TreeNode;
import kd.bos.form.control.TreeView;
import kd.bos.form.control.events.RefreshNodeEvent;
import kd.bos.list.events.BuildTreeListFilterEvent;
import kd.bos.list.plugin.StandardTreeListPlugin;
import kd.bos.orm.query.QFilter;
import kd.tmc.fbp.common.helper.TmcDataServiceHelper;
import kd.tmc.fbp.common.util.EmptyUtil;

public abstract class AbstractTreeListPlugin
extends StandardTreeListPlugin {
    public void buildTreeListFilter(BuildTreeListFilterEvent e) {
        super.buildTreeListFilter(e);
        if (e.getNodeId() instanceof Long) {
            e.getFilters().add(new QFilter(this.getTreeNodeFilterField(), "in", e.getNodeId()));
            this.getPageCache().put("nodeId", (String)e.getNodeId());
        }
    }

    public void afterCreateNewData(EventObject e) {
        TreeView tv = (TreeView)this.getView().getControl(this.getTreeViewControl());
        this.constructorData(tv);
    }

    public void refreshNode(RefreshNodeEvent e) {
        TreeView tv = (TreeView)this.getView().getControl(this.getTreeViewControl());
        this.constructorData(tv);
    }

    private void constructorData(TreeView tv) {
        TreeNode root = this.getTreeModel().getRoot();
        root.setIsOpened(true);
        if (!EmptyUtil.isEmpty((String)this.getRootNodeName())) {
            root.setText(this.getRootNodeName());
        }
        Map colls = TmcDataServiceHelper.loadFromCache((String)this.getTreeNodeEntity(), (String)"id,number,name,parent,isleaf,longnumber", (QFilter[])this.getFilter().toArray(), (String)"longnumber,isleaf asc");
        HashMap<String, TreeNode> nodes = new HashMap<String, TreeNode>(colls.size());
        for (Map.Entry entry : colls.entrySet()) {
            DynamicObject note = (DynamicObject)entry.getValue();
            TreeNode parentNode = null;
            if (nodes.size() > 0) {
                parentNode = (TreeNode)nodes.get(note.getString("parent.id"));
            }
            if (parentNode == null) {
                parentNode = root;
            }
            String parentId = null;
            if (parentNode != null) {
                parentId = parentNode.getId();
            }
            TreeNode tn = new TreeNode(parentId, String.valueOf(entry.getKey()), note.getString("name"), !note.getBoolean("isleaf"));
            tn.setIsOpened(true);
            nodes.put(note.getString("id"), tn);
            if (parentNode != null) {
                parentNode.addChild(tn);
                continue;
            }
            tv.addNode(tn);
        }
    }

    protected abstract QFilter getFilter();

    protected abstract String getRootNodeName();

    protected abstract String getTreeViewControl();

    protected abstract String getTreeNodeEntity();

    protected abstract String getTreeNodeFilterField();
}

