/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.tm.formplugin.trade;

import java.math.BigDecimal;
import java.util.Date;
import java.util.EventObject;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.form.IFormView;
import kd.bos.form.container.Tab;
import kd.bos.form.control.events.TabSelectEvent;
import kd.bos.form.control.events.TabSelectListener;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.form.operate.FormOperate;
import kd.bos.list.ListShowParameter;
import kd.bos.orm.query.QFilter;
import kd.tmc.fbp.common.enums.TcBillStatusEnum;
import kd.tmc.fbp.common.enums.TradeDirectionEnum;
import kd.tmc.fbp.common.helper.TmcDataServiceHelper;
import kd.tmc.fbp.common.helper.TmcViewInputHelper;
import kd.tmc.fbp.common.util.EmptyUtil;
import kd.tmc.fbp.formplugin.edit.AbstractTmcBillEdit;
import kd.tmc.tm.common.enums.CashFlowTypeEnum;
import kd.tmc.tm.common.helper.TcAccountHelper;
import org.apache.commons.lang3.StringUtils;

public class BuySettleTabEdit
extends AbstractTmcBillEdit
implements BeforeF7SelectListener,
TabSelectListener {
    public void registerListener(EventObject e) {
        Tab tabap;
        super.registerListener(e);
        BasedataEdit payBankAcct = (BasedataEdit)this.getView().getControl("paybankacct");
        if (EmptyUtil.isNoEmpty((Object)payBankAcct)) {
            payBankAcct.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        }
        if ((tabap = (Tab)this.getView().getControl("tabap")) != null) {
            tabap.addTabSelectListener((TabSelectListener)this);
        }
    }

    public void tabSelected(TabSelectEvent e) {
        if (e.getTabKey().equals("tabsettle")) {
            boolean isDataChange = this.getModel().getDataChanged();
            if (EmptyUtil.isEmpty((Object)this.getModel().getValue("buysettledate"))) {
                String entity;
                switch (entity = this.getModel().getDataEntityType().getName()) {
                    case "tm_bond_fix": 
                    case "tm_bond_float": {
                        TmcViewInputHelper.setValWithoutPropChgEvt((IFormView)this.getView(), (IDataModel)this.getModel(), (String)"buysettledate", (Object)this.getModel().getValue("settledate"));
                        TmcViewInputHelper.setValWithoutPropChgEvt((IFormView)this.getView(), (IDataModel)this.getModel(), (String)"buysettleamt", (Object)this.getModel().getValue("totalproceeds"));
                        break;
                    }
                    case "tm_structdeposit": {
                        TmcViewInputHelper.setValWithoutPropChgEvt((IFormView)this.getView(), (IDataModel)this.getModel(), (String)"buysettledate", (Object)this.getModel().getValue("intdate"));
                        TmcViewInputHelper.setValWithoutPropChgEvt((IFormView)this.getView(), (IDataModel)this.getModel(), (String)"buysettleamt", (Object)this.getModel().getValue("amount"));
                    }
                }
            }
            this.createSettleCashflow();
            this.getModel().setDataChanged(isDataChange);
        }
    }

    public void beforeF7Select(BeforeF7SelectEvent event) {
        if ("paybankacct".equals(event.getProperty().getName())) {
            DynamicObject org = (DynamicObject)this.getModel().getValue("org");
            long orgId = org == null ? 0L : Long.parseLong(org.getPkValue().toString());
            QFilter qFilter = TcAccountHelper.getAccountBankFilterByOrg((Long)orgId);
            qFilter.and(new QFilter("acctstatus", "=", (Object)"normal"));
            qFilter.and(new QFilter("finorgtype", "!=", (Object)"1"));
            String entity = this.getModel().getDataEntityType().getName();
            if ("tm_forex_options".equals(entity)) {
                DynamicObject premiumCurrency = (DynamicObject)this.getModel().getValue("premiumcurrency");
                if (EmptyUtil.isNoEmpty((DynamicObject)premiumCurrency)) {
                    qFilter = qFilter.and(new QFilter("currency.fbasedataid", "=", premiumCurrency.getPkValue()));
                }
            } else {
                DynamicObject currency = (DynamicObject)this.getModel().getValue("currency");
                if (EmptyUtil.isNoEmpty((DynamicObject)currency)) {
                    qFilter = qFilter.and(new QFilter("currency.fbasedataid", "=", currency.getPkValue()));
                }
            }
            DynamicObject settletype = this.getModel().getDataEntity().getDynamicObject("paysettletype");
            if (settletype != null) {
                QFilter qFilter1 = new QFilter("settlementtype.fbasedataid.id", "=", settletype.getPkValue());
                QFilter qFilter2 = new QFilter("settlementtype.fbasedataid.id", "is null", null);
                qFilter = qFilter.and(qFilter1.or(qFilter2));
            }
            ListShowParameter showParameter = (ListShowParameter)event.getFormShowParameter();
            showParameter.getListFilterParameter().setFilter(qFilter);
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    public void propertyChanged(PropertyChangedArgs args) {
        String entity;
        super.propertyChanged(args);
        String propName = args.getProperty().getName();
        switch (entity = this.getModel().getDataEntityType().getName()) {
            case "tm_bond_fix": 
            case "tm_bond_float": {
                switch (propName) {
                    case "settledate": {
                        TmcViewInputHelper.setValWithoutPropChgEvt((IFormView)this.getView(), (IDataModel)this.getModel(), (String)"buysettledate", (Object)this.getModel().getValue("settledate"));
                        break;
                    }
                    case "totalproceeds": {
                        this.getModel().setValue("buysettleamt", this.getModel().getValue("totalproceeds"));
                        break;
                    }
                }
                break;
            }
            case "tm_structdeposit": {
                switch (propName) {
                    case "intdate": {
                        TmcViewInputHelper.setValWithoutPropChgEvt((IFormView)this.getView(), (IDataModel)this.getModel(), (String)"buysettledate", (Object)this.getModel().getValue("intdate"));
                        break;
                    }
                    case "amount": {
                        this.getModel().setValue("buysettleamt", this.getModel().getValue("amount"));
                        break;
                    }
                }
                break;
            }
            case "tm_forex_options": {
                switch (propName) {
                    case "premiumdate": {
                        TmcViewInputHelper.setValWithoutPropChgEvt((IFormView)this.getView(), (IDataModel)this.getModel(), (String)"buysettledate", (Object)this.getModel().getValue(propName));
                        break;
                    }
                    case "tradedirect": 
                    case "premium": {
                        String tradeDir = (String)this.getModel().getValue("tradedirect");
                        BigDecimal premium = (BigDecimal)this.getModel().getValue("premium");
                        if (TradeDirectionEnum.buy.getValue().equals(tradeDir)) {
                            this.getModel().setValue("buysettleamt", (Object)premium.abs().negate());
                        }
                        if (!TradeDirectionEnum.sell.getValue().equals(tradeDir)) break;
                        this.getModel().setValue("buysettleamt", (Object)premium.abs());
                    }
                }
                break;
            }
        }
        switch (propName) {
            case "paybankacct": {
                DynamicObject payBankAcct = (DynamicObject)this.getModel().getValue("paybankacct");
                if (!EmptyUtil.isNoEmpty((DynamicObject)payBankAcct)) return;
                this.getModel().setValue("paybank", (Object)payBankAcct.getDynamicObject("bank").getLong("id"));
                return;
            }
            case "buysettledate": {
                this.createSettleCashflow();
                return;
            }
            case "counterparty": {
                this.getModel().setValue("paysettletype", null);
                this.getModel().setValue("paybankacct", null);
                this.getModel().setValue("paybank", null);
                this.getModel().setValue("opppaybankacct", null);
                this.getModel().setValue("opppaybank", null);
                return;
            }
            case "paysettletype": {
                this.getModel().setValue("paybankacct", null);
                this.getModel().setValue("paybank", null);
                return;
            }
        }
    }

    private void createSettleCashflow() {
        Date buysettledate = (Date)this.getModel().getValue("buysettledate");
        if (EmptyUtil.isEmpty((Object)buysettledate)) {
            return;
        }
        String entity = this.getModel().getDataEntityType().getName();
        if ("tm_forex_options".equals(entity)) {
            this.getModel().deleteEntryData("settlecashflow");
            int rowIndex = this.getModel().createNewEntryRow("settlecashflow");
            this.getModel().setValue("cftype_settle", (Object)"premium", rowIndex);
            this.getModel().setValue("cfpaydate_settle", (Object)buysettledate, rowIndex);
            this.getModel().setValue("cfcurrency_settle", this.getModel().getValue("premiumcurrency"), rowIndex);
            this.getModel().setValue("cfpayamount_settle", this.getModel().getValue("buysettleamt"), rowIndex);
            this.getModel().setDataChanged(false);
            return;
        }
        if ("tm_structdeposit".equals(entity)) {
            this.getModel().deleteEntryData("settlecashflow");
            int rowIndex = this.getModel().createNewEntryRow("settlecashflow");
            this.getModel().setValue("cftype_settle", (Object)CashFlowTypeEnum.capital.getValue(), rowIndex);
            this.getModel().setValue("cfpaydate_settle", (Object)buysettledate, rowIndex);
            this.getModel().setValue("cfcurrency_settle", this.getModel().getValue("currency"), rowIndex);
            this.getModel().setValue("cfpayamount_settle", (Object)((BigDecimal)this.getModel().getValue("amount")).negate(), rowIndex);
            this.getModel().setDataChanged(false);
            return;
        }
        if (entity.equals("tm_bond_fix") || entity.equals("tm_bond_float")) {
            DynamicObjectCollection cashflowCol = this.getModel().getEntryEntity("cashflow");
            if (EmptyUtil.isEmpty((DynamicObjectCollection)cashflowCol)) {
                QFilter filter = new QFilter("billid", "=", this.getModel().getDataEntity().getPkValue());
                Object[] cashFlow = TmcDataServiceHelper.load((String)"tm_cashflow", (String)"cftype,cfcurrency,cfpayamount", (QFilter[])new QFilter[]{filter});
                if (EmptyUtil.isNoEmpty((Object[])cashFlow)) {
                    this.getModel().deleteEntryData("settlecashflow");
                    int rowIndex = this.getModel().createNewEntryRow("settlecashflow");
                    this.getModel().setValue("cftype_settle", cashFlow[0].get("cftype"), rowIndex);
                    this.getModel().setValue("cfpaydate_settle", (Object)buysettledate, rowIndex);
                    this.getModel().setValue("cfcurrency_settle", cashFlow[0].get("cfcurrency"), rowIndex);
                    this.getModel().setValue("cfpayamount_settle", cashFlow[0].get("cfpayamount"), rowIndex);
                    rowIndex = this.getModel().createNewEntryRow("settlecashflow");
                    this.getModel().setValue("cftype_settle", cashFlow[1].get("cftype"), rowIndex);
                    this.getModel().setValue("cfpaydate_settle", (Object)buysettledate, rowIndex);
                    this.getModel().setValue("cfcurrency_settle", cashFlow[1].get("cfcurrency"), rowIndex);
                    this.getModel().setValue("cfpayamount_settle", cashFlow[1].get("cfpayamount"), rowIndex);
                }
            } else {
                this.getModel().deleteEntryData("settlecashflow");
                int rowIndex = this.getModel().createNewEntryRow("settlecashflow");
                this.getModel().setValue("cftype_settle", ((DynamicObject)cashflowCol.get(0)).get("cftype"), rowIndex);
                this.getModel().setValue("cfpaydate_settle", (Object)buysettledate, rowIndex);
                this.getModel().setValue("cfcurrency_settle", ((DynamicObject)cashflowCol.get(0)).get("cfcurrency"), rowIndex);
                this.getModel().setValue("cfpayamount_settle", ((DynamicObject)cashflowCol.get(0)).get("cfpayamount"), rowIndex);
                rowIndex = this.getModel().createNewEntryRow("settlecashflow");
                this.getModel().setValue("cftype_settle", ((DynamicObject)cashflowCol.get(1)).get("cftype"), rowIndex);
                this.getModel().setValue("cfpaydate_settle", (Object)buysettledate, rowIndex);
                this.getModel().setValue("cfcurrency_settle", ((DynamicObject)cashflowCol.get(1)).get("cfcurrency"), rowIndex);
                this.getModel().setValue("cfpayamount_settle", ((DynamicObject)cashflowCol.get(1)).get("cfpayamount"), rowIndex);
            }
        }
    }

    public void afterBindData(EventObject e) {
        super.afterBindData(e);
        String entity = this.getModel().getDataEntityType().getName();
        boolean isbuysettle = (Boolean)this.getModel().getValue("isbuysettle");
        this.getView().setEnable(Boolean.valueOf(!isbuysettle), new String[]{"paysettletype", "paybankacct", "opppaybankacct", "opppaybank", "buysettledate"});
        if ("tm_forex_options".equals(entity)) {
            this.getView().setEnable(Boolean.valueOf(!TcBillStatusEnum.SURVIVAL.getValue().equals(this.getModel().getValue("billstatus")) && !TcBillStatusEnum.FINISH.getValue().equals(this.getModel().getValue("billstatus")) && (Boolean)this.getModel().getValue("isbuysettle") == false), new String[]{"premium", "premiumcurrency", "premiumdate"});
            if (TcBillStatusEnum.SURVIVAL.getValue().equals(this.getModel().getValue("billstatus")) || TcBillStatusEnum.FINISH.getValue().equals(this.getModel().getValue("billstatus"))) {
                this.getView().setEnable(Boolean.valueOf(false), new String[]{"paysettletype", "paybankacct", "opppaybankacct", "opppaybank", "buysettledate"});
            }
        }
        this.createSettleCashflow();
        this.getModel().setDataChanged(false);
    }

    public void afterDoOperation(AfterDoOperationEventArgs args) {
        String entity;
        super.afterDoOperation(args);
        FormOperate formOperate = (FormOperate)args.getSource();
        if (StringUtils.equals((CharSequence)"settle", (CharSequence)formOperate.getOperateKey()) && args.getOperationResult() != null && args.getOperationResult().isSuccess()) {
            this.getView().setEnable(Boolean.valueOf(false), new String[]{"paysettletype", "paybankacct", "opppaybankacct", "opppaybank", "buysettledate"});
            entity = this.getModel().getDataEntityType().getName();
            if ("tm_forex_options".equals(entity)) {
                this.getView().setEnable(Boolean.valueOf(false), new String[]{"premium", "premiumcurrency", "premiumdate"});
            }
        }
        if (StringUtils.equals((CharSequence)"unsettle", (CharSequence)formOperate.getOperateKey()) && args.getOperationResult() != null && args.getOperationResult().isSuccess()) {
            this.getView().setEnable(Boolean.valueOf(true), new String[]{"paysettletype", "paybankacct", "opppaybankacct", "opppaybank", "buysettledate"});
            entity = this.getModel().getDataEntityType().getName();
            if ("tm_forex_options".equals(entity)) {
                this.getView().setEnable(Boolean.valueOf(true), new String[]{"premium", "premiumcurrency", "premiumdate"});
            }
        }
    }
}

