/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.tm.formplugin.trade;

import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.Date;
import java.util.EventObject;
import java.util.Map;
import kd.bos.bill.OperationStatus;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.form.IFormView;
import kd.bos.form.container.Tab;
import kd.bos.form.control.events.TabSelectEvent;
import kd.bos.form.control.events.TabSelectListener;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.form.operate.FormOperate;
import kd.bos.list.ListShowParameter;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.basedata.BaseDataServiceHelper;
import kd.tmc.fbp.common.enums.BillStatusEnum;
import kd.tmc.fbp.common.helper.TmcViewInputHelper;
import kd.tmc.fbp.common.helper.service.MarketDataServiceHelper;
import kd.tmc.fbp.common.model.ForexQuoteInfo;
import kd.tmc.fbp.common.util.EmptyUtil;
import kd.tmc.fbp.formplugin.edit.AbstractTmcBillEdit;
import kd.tmc.tm.common.enums.CashFlowTypeEnum;
import kd.tmc.tm.common.enums.SwapExchangeType;
import kd.tmc.tm.common.enums.SwapTypeEnum;
import kd.tmc.tm.common.helper.TcAccountHelper;
import org.apache.commons.lang3.StringUtils;

public class RateSwapsBuySettleTabEdit
extends AbstractTmcBillEdit
implements BeforeF7SelectListener,
TabSelectListener {
    public void registerListener(EventObject e) {
        Tab tabap;
        BasedataEdit settleCurrency;
        BasedataEdit recBankAcct;
        super.registerListener(e);
        BasedataEdit payBankAcct = (BasedataEdit)this.getView().getControl("paybankacct");
        if (EmptyUtil.isNoEmpty((Object)payBankAcct)) {
            payBankAcct.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        }
        if (EmptyUtil.isNoEmpty((Object)(recBankAcct = (BasedataEdit)this.getView().getControl("recbankacct")))) {
            recBankAcct.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        }
        if (EmptyUtil.isNoEmpty((Object)(settleCurrency = (BasedataEdit)this.getView().getControl("plcurrency")))) {
            settleCurrency.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        }
        if ((tabap = (Tab)this.getView().getControl("tabap")) != null) {
            tabap.addTabSelectListener((TabSelectListener)this);
        }
    }

    public void tabSelected(TabSelectEvent e) {
        if (e.getTabKey().equals("tabsettle")) {
            boolean isChanged = this.getModel().getDataChanged();
            if (EmptyUtil.isEmpty((Object)this.getModel().getValue("buysettledate"))) {
                TmcViewInputHelper.setValWithoutPropChgEvt((IFormView)this.getView(), (IDataModel)this.getModel(), (String)"buysettledate", (Object)this.getModel().getValue("startdate"));
            }
            this.createSettleCashflow();
            if (this.isShowVoucherPlPanel()) {
                this.getView().setVisible(Boolean.TRUE, new String[]{"fieldsetpanelap3"});
            } else {
                this.getView().setVisible(Boolean.FALSE, new String[]{"fieldsetpanelap3"});
            }
            if (!isChanged) {
                this.getModel().setDataChanged(false);
            }
            TmcViewInputHelper.registerMustInput((IFormView)this.getView(), (boolean)true, (String[])new String[]{"paysettletype", "recsettletype", "buysettledate"});
        }
    }

    private void calVoucherPlOnPropChgEvt() {
        DynamicObject baseCurrency = (DynamicObject)this.getModel().getValue("basecurrency");
        if (this.isShowVoucherPlPanel()) {
            this.setVoucherPlOnUnSettle(baseCurrency, true);
            this.getView().setVisible(Boolean.TRUE, new String[]{"fieldsetpanelap3"});
        } else {
            TmcViewInputHelper.setValWithoutPropChgEvt((IFormView)this.getView(), (IDataModel)this.getModel(), (String)"reclocalfq", (Object)"");
            TmcViewInputHelper.setValWithoutPropChgEvt((IFormView)this.getView(), (IDataModel)this.getModel(), (String)"reclocalexrate", (Object)BigDecimal.ZERO);
            TmcViewInputHelper.setValWithoutPropChgEvt((IFormView)this.getView(), (IDataModel)this.getModel(), (String)"paylocalfq", (Object)"");
            TmcViewInputHelper.setValWithoutPropChgEvt((IFormView)this.getView(), (IDataModel)this.getModel(), (String)"paylocalexrate", (Object)BigDecimal.ZERO);
            TmcViewInputHelper.setValWithoutPropChgEvt((IFormView)this.getView(), (IDataModel)this.getModel(), (String)"voucherpl", (Object)BigDecimal.ZERO);
            this.getView().setVisible(Boolean.FALSE, new String[]{"fieldsetpanelap3"});
        }
    }

    private void calVoucherPlOnChangePriceRule() {
        DynamicObject baseCurrency = (DynamicObject)this.getModel().getValue("basecurrency");
        if (this.isShowVoucherPlPanel()) {
            this.setVoucherPlOnUnSettle(baseCurrency, false);
            this.getView().setVisible(Boolean.TRUE, new String[]{"fieldsetpanelap3"});
        } else {
            TmcViewInputHelper.setValWithoutPropChgEvt((IFormView)this.getView(), (IDataModel)this.getModel(), (String)"reclocalfq", (Object)"");
            TmcViewInputHelper.setValWithoutPropChgEvt((IFormView)this.getView(), (IDataModel)this.getModel(), (String)"reclocalexrate", (Object)BigDecimal.ZERO);
            TmcViewInputHelper.setValWithoutPropChgEvt((IFormView)this.getView(), (IDataModel)this.getModel(), (String)"paylocalfq", (Object)"");
            TmcViewInputHelper.setValWithoutPropChgEvt((IFormView)this.getView(), (IDataModel)this.getModel(), (String)"paylocalexrate", (Object)BigDecimal.ZERO);
            TmcViewInputHelper.setValWithoutPropChgEvt((IFormView)this.getView(), (IDataModel)this.getModel(), (String)"voucherpl", (Object)BigDecimal.ZERO);
            this.getView().setVisible(Boolean.FALSE, new String[]{"fieldsetpanelap3"});
        }
    }

    private void setVoucherPlOnUnSettle(DynamicObject baseCurrency, boolean isPropertyChanged) {
        boolean isbuysettle = (Boolean)this.getModel().getValue("isbuysettle");
        if (isbuysettle) {
            return;
        }
        this.setVoucherPl(baseCurrency, isPropertyChanged);
    }

    private void setVoucherPl(DynamicObject baseCurrency, boolean isPropertyChanged) {
        BigDecimal payExAmt;
        BigDecimal payExRate;
        BigDecimal recExAmt;
        BigDecimal recExRate;
        BigDecimal recAmt = (BigDecimal)this.getModel().getValue("initexamount");
        BigDecimal payAmt = (BigDecimal)this.getModel().getValue("recinitexamount");
        payAmt = payAmt.abs();
        DynamicObject recCurrency = (DynamicObject)this.getModel().getValue("currency");
        DynamicObject payCurrency = (DynamicObject)this.getModel().getValue("reccurrency");
        String recCurrencyNumber = recCurrency.getString("number");
        String payCurrencyNumber = payCurrency.getString("number");
        Date bizDate = (Date)this.getModel().getValue("bizdate");
        DynamicObject priceRule = (DynamicObject)this.getModel().getValue("pricerule");
        ForexQuoteInfo recCurFqInfo = MarketDataServiceHelper.getForexQuoteInfo((Long)priceRule.getLong("forexquote.id"), (String)(recCurrencyNumber + "/" + baseCurrency.getString("number")), (Date)bizDate, null);
        String recCurFxQuote = recCurFqInfo.getFxquote();
        if (recCurrencyNumber.equals(recCurFxQuote.split("/")[0])) {
            recExRate = isPropertyChanged ? (BigDecimal)this.getModel().getValue("reclocalexrate") : recCurFqInfo.getBuyPrice();
            recExAmt = recAmt.multiply(recExRate);
        } else {
            recExRate = isPropertyChanged ? (BigDecimal)this.getModel().getValue("reclocalexrate") : recCurFqInfo.getSellPrice();
            recExAmt = EmptyUtil.isEmpty((BigDecimal)recExRate) ? BigDecimal.ZERO : recAmt.divide(recExRate, 10, 4);
        }
        ForexQuoteInfo payCurFqInfo = MarketDataServiceHelper.getForexQuoteInfo((Long)priceRule.getLong("forexquote.id"), (String)(payCurrencyNumber + "/" + baseCurrency.getString("number")), (Date)bizDate, null);
        String payCurFxQuote = payCurFqInfo.getFxquote();
        if (payCurrencyNumber.equals(payCurFxQuote.split("/")[0])) {
            payExRate = isPropertyChanged ? (BigDecimal)this.getModel().getValue("paylocalexrate") : payCurFqInfo.getBuyPrice();
            payExAmt = payAmt.multiply(payExRate);
        } else {
            payExRate = isPropertyChanged ? (BigDecimal)this.getModel().getValue("paylocalexrate") : payCurFqInfo.getSellPrice();
            payExAmt = EmptyUtil.isEmpty((BigDecimal)payExRate) ? BigDecimal.ZERO : payAmt.divide(payExRate, 10, 4);
        }
        TmcViewInputHelper.setValWithoutPropChgEvt((IFormView)this.getView(), (IDataModel)this.getModel(), (String)"reclocalexrate", (Object)recExRate);
        TmcViewInputHelper.setValWithoutPropChgEvt((IFormView)this.getView(), (IDataModel)this.getModel(), (String)"paylocalexrate", (Object)payExRate);
        TmcViewInputHelper.setValWithoutPropChgEvt((IFormView)this.getView(), (IDataModel)this.getModel(), (String)"reclocalfq", (Object)recCurFxQuote);
        TmcViewInputHelper.setValWithoutPropChgEvt((IFormView)this.getView(), (IDataModel)this.getModel(), (String)"paylocalfq", (Object)payCurFxQuote);
        TmcViewInputHelper.setValWithoutPropChgEvt((IFormView)this.getView(), (IDataModel)this.getModel(), (String)"voucherpl", (Object)recExAmt.subtract(payExAmt));
    }

    private boolean isShowVoucherPlPanel() {
        DynamicObject recCurrency;
        DynamicObject payCurrency;
        DynamicObject baseCurrency;
        DynamicObject priceRule = (DynamicObject)this.getModel().getValue("pricerule");
        if (EmptyUtil.isAnyoneEmpty((Object[])new Object[]{priceRule, baseCurrency = (DynamicObject)this.getModel().getValue("basecurrency"), payCurrency = (DynamicObject)this.getModel().getValue("currency"), recCurrency = (DynamicObject)this.getModel().getValue("reccurrency")})) {
            return false;
        }
        String swapType = (String)this.getModel().getValue("rateswaptype");
        String initpriexType = (String)this.getModel().getValue("initpriextype");
        long payCurrencyId = payCurrency.getLong("id");
        long recCurrencyId = recCurrency.getLong("id");
        long baseCurrencyId = baseCurrency.getLong("id");
        return SwapTypeEnum.currency.getValue().equals(swapType) && SwapExchangeType.Actual.getValue().equals(initpriexType) && payCurrencyId != baseCurrencyId && recCurrencyId != baseCurrencyId;
    }

    private void setPlAmt() {
        BigDecimal amtPay = (BigDecimal)this.getModel().getValue("initexamount");
        BigDecimal amtRec = (BigDecimal)this.getModel().getValue("recinitexamount");
        DynamicObject plCurrency = (DynamicObject)this.getModel().getValue("plcurrency");
        DynamicObject payCurrency = (DynamicObject)this.getModel().getValue("currency");
        String fxquote = (String)this.getModel().getValue("fxquote");
        BigDecimal spotrate = (BigDecimal)this.getModel().getValue("spotrate");
        if (!EmptyUtil.isAnyoneEmpty((Object[])new Object[]{plCurrency, payCurrency, amtPay, amtRec})) {
            if (plCurrency.getLong("id") == payCurrency.getLong("id")) {
                amtRec = plCurrency.getString("number").equals(fxquote.split("/")[0]) ? (EmptyUtil.isEmpty((BigDecimal)spotrate) ? BigDecimal.ZERO : amtRec.divide(spotrate, 10, RoundingMode.HALF_UP)) : amtRec.multiply(spotrate);
            } else {
                amtPay = plCurrency.getString("number").equals(fxquote.split("/")[0]) ? (EmptyUtil.isEmpty((BigDecimal)spotrate) ? BigDecimal.ZERO : amtPay.divide(spotrate, 10, RoundingMode.HALF_UP)) : amtPay.multiply(spotrate);
            }
            this.getModel().setValue("plamt", (Object)amtRec.add(amtPay));
        }
    }

    private void setVisiblePlInfo() {
        DynamicObject baseCurrency;
        DynamicObject plCurrency = (DynamicObject)this.getModel().getValue("plcurrency");
        if (!EmptyUtil.isAnyoneEmpty((Object[])new Object[]{plCurrency, baseCurrency = (DynamicObject)this.getModel().getValue("basecurrency")})) {
            boolean isShow = plCurrency.getLong("id") != baseCurrency.getLong("id");
            this.getView().setVisible(Boolean.valueOf(isShow), new String[]{"basefq", "baseexrate", "baseplamt"});
        } else {
            this.getView().setVisible(Boolean.valueOf(false), new String[]{"basefq", "baseexrate", "baseplamt"});
        }
    }

    private void initBasePlInfo() {
        DynamicObject plCurrency = (DynamicObject)this.getModel().getValue("plcurrency");
        DynamicObject baseCurrency = (DynamicObject)this.getModel().getValue("basecurrency");
        if (!EmptyUtil.isAnyoneEmpty((Object[])new Object[]{plCurrency, baseCurrency})) {
            if (plCurrency.getLong("id") != baseCurrency.getLong("id")) {
                BigDecimal baseAmt;
                BigDecimal baseExrate;
                DynamicObject priceRule = (DynamicObject)this.getModel().getValue("pricerule");
                if (EmptyUtil.isEmpty((DynamicObject)priceRule)) {
                    this.getModel().setValue("basefq", null);
                    this.getModel().setValue("baseexrate", null);
                    this.getModel().setValue("baseplamt", null);
                    return;
                }
                if (EmptyUtil.isEmpty((DynamicObject)priceRule.getDynamicObject("forexquote"))) {
                    this.getView().showErrorNotification(ResManager.loadKDString((String)"\u8be5\u5b9a\u4ef7\u89c4\u5219\u6ca1\u6709\u8bbe\u7f6e\u5916\u6c47\u62a5\u4ef7\u3002", (String)"PriceRuleWithoutFX", (String)"tmc-tm-formplugin", (Object[])new Object[0]));
                    return;
                }
                String pair = baseCurrency.getString("number") + "/" + plCurrency.getString("number");
                Long fqId = priceRule.getDynamicObject("forexquote").getLong("id");
                Date bizdate = (Date)this.getModel().getValue("settledate");
                ForexQuoteInfo fqInfo = MarketDataServiceHelper.getForexQuoteInfo((Long)fqId, (String)pair, (Date)bizdate, null);
                this.getModel().setValue("basefq", (Object)fqInfo.getFxquote());
                BigDecimal amt_pl = (BigDecimal)this.getModel().getValue("plamt");
                if (plCurrency.getString("number").equals(fqInfo.getFxquote().split("/")[0])) {
                    baseExrate = fqInfo.getBuyPrice();
                    baseAmt = amt_pl.multiply(baseExrate);
                } else {
                    baseExrate = fqInfo.getSellPrice();
                    baseAmt = amt_pl.divide(baseExrate, 10, 4);
                }
                TmcViewInputHelper.setValWithoutPropChgEvt((IFormView)this.getView(), (IDataModel)this.getModel(), (String)"baseexrate", (Object)baseExrate);
                TmcViewInputHelper.setValWithoutPropChgEvt((IFormView)this.getView(), (IDataModel)this.getModel(), (String)"baseplamt", (Object)baseAmt);
            } else {
                this.getModel().setValue("basefq", null);
                this.getModel().setValue("baseexrate", null);
                this.getModel().setValue("baseplamt", null);
            }
        } else {
            this.getModel().setValue("basefq", null);
            this.getModel().setValue("baseexrate", null);
            this.getModel().setValue("baseplamt", null);
        }
    }

    private void setSpotRate() {
        DynamicObject priceRule;
        DynamicObject recCurrency;
        DynamicObject currency = (DynamicObject)this.getModel().getValue("currency");
        if (!EmptyUtil.isAnyoneEmpty((Object[])new Object[]{currency, recCurrency = (DynamicObject)this.getModel().getValue("reccurrency"), priceRule = (DynamicObject)this.getModel().getValue("pricerule")})) {
            if (EmptyUtil.isEmpty((DynamicObject)priceRule.getDynamicObject("forexquote"))) {
                this.getView().showErrorNotification(ResManager.loadKDString((String)"\u8be5\u5b9a\u4ef7\u89c4\u5219\u6ca1\u6709\u8bbe\u7f6e\u5916\u6c47\u62a5\u4ef7\u3002", (String)"PriceRuleWithoutFX", (String)"tmc-tm-formplugin", (Object[])new Object[0]));
                return;
            }
            Long fqId = priceRule.getDynamicObject("forexquote").getLong("id");
            String pair = currency.getString("number") + "/" + recCurrency.getString("number");
            ForexQuoteInfo fqInfo = MarketDataServiceHelper.getForexQuoteInfo((Long)fqId, (String)pair, null, null);
            this.getModel().setValue("fxquote", (Object)fqInfo.getFxquote());
            DynamicObject plCurrency = (DynamicObject)this.getModel().getValue("plcurrency");
            BigDecimal spotrate = plCurrency != null && plCurrency.getString("number").equals(fqInfo.getFxquote().split("/")[0]) ? fqInfo.getSellPrice() : fqInfo.getBuyPrice();
            this.getModel().setValue("spotrate", (Object)spotrate);
        }
    }

    private void setBasePlAmt() {
        String basefq;
        BigDecimal baseExrate;
        DynamicObject plCurrency = (DynamicObject)this.getModel().getValue("plcurrency");
        if (EmptyUtil.isAnyoneEmpty((Object[])new Object[]{plCurrency, baseExrate = (BigDecimal)this.getModel().getValue("baseexrate"), basefq = (String)this.getModel().getValue("basefq")})) {
            this.getModel().setValue("baseplamt", null);
            return;
        }
        BigDecimal amt_pl = (BigDecimal)this.getModel().getValue("plamt");
        BigDecimal baseAmt = plCurrency.getString("number").equals(basefq.split("/")[0]) ? amt_pl.multiply(baseExrate) : amt_pl.divide(baseExrate, 10, 4);
        this.getModel().setValue("baseplamt", (Object)baseAmt);
    }

    public void beforeF7Select(BeforeF7SelectEvent event) {
        ListShowParameter showParameter;
        if ("paybankacct".equals(event.getProperty().getName())) {
            showParameter = (ListShowParameter)event.getFormShowParameter();
            showParameter.getListFilterParameter().getQFilters().add(this.getBankAcctFilter("reccurrency", "paysettletype"));
        }
        if ("recbankacct".equals(event.getProperty().getName())) {
            showParameter = (ListShowParameter)event.getFormShowParameter();
            showParameter.getListFilterParameter().getQFilters().add(this.getBankAcctFilter("currency", "recsettletype"));
        }
        if ("plcurrency".equals(event.getProperty().getName())) {
            DynamicObject currency = (DynamicObject)this.getModel().getValue("currency");
            DynamicObject recCurrency = (DynamicObject)this.getModel().getValue("reccurrency");
            if (EmptyUtil.isNoEmpty((DynamicObject)currency) && EmptyUtil.isNoEmpty((DynamicObject)recCurrency)) {
                ListShowParameter showParameter2 = (ListShowParameter)event.getFormShowParameter();
                QFilter qFilter = new QFilter("id", "=", currency.getPkValue());
                qFilter.or("id", "=", recCurrency.getPkValue());
                showParameter2.getListFilterParameter().getQFilters().add(qFilter);
            }
        }
    }

    private QFilter getBankAcctFilter(String curyName, String settleType) {
        QFilter qFilter = TcAccountHelper.getAccountBankFilterByOrg((Long)((DynamicObject)this.getModel().getValue("org")).getLong("id"));
        qFilter.and(new QFilter("acctstatus", "=", (Object)"normal"));
        DynamicObject currency = (DynamicObject)this.getModel().getValue(curyName);
        if (currency != null) {
            qFilter = qFilter.and(new QFilter("currency.fbasedataid", "=", currency.getPkValue()));
        }
        qFilter = qFilter.and(new QFilter("finorgtype", "!=", (Object)"1"));
        DynamicObject settletype = this.getModel().getDataEntity().getDynamicObject(settleType);
        if (settletype != null) {
            QFilter qFilter1 = new QFilter("settlementtype.fbasedataid.id", "=", settletype.getPkValue());
            QFilter qFilter2 = new QFilter("settlementtype.fbasedataid.id", "is null", null);
            qFilter = qFilter.and(qFilter1.or(qFilter2));
        }
        return qFilter;
    }

    public void propertyChanged(PropertyChangedArgs args) {
        super.propertyChanged(args);
        String propName = args.getProperty().getName();
        String swapType = (String)this.getModel().getValue("rateswaptype");
        String initPriExType = (String)this.getModel().getValue("initpriextype");
        if (!SwapTypeEnum.currency.getValue().equals(swapType) || !SwapExchangeType.Actual.getValue().equals(initPriExType)) {
            return;
        }
        switch (propName) {
            case "paybankacct": {
                DynamicObject payBankAcct = (DynamicObject)this.getModel().getValue("paybankacct");
                if (!EmptyUtil.isNoEmpty((DynamicObject)payBankAcct)) break;
                this.getModel().setValue("paybank", (Object)payBankAcct.getDynamicObject("bank").getLong("id"));
                break;
            }
            case "recbankacct": {
                DynamicObject buyBankAcct = (DynamicObject)this.getModel().getValue("recbankacct");
                if (!EmptyUtil.isNoEmpty((DynamicObject)buyBankAcct)) break;
                this.getModel().setValue("recbank", (Object)buyBankAcct.getDynamicObject("bank").getLong("id"));
                break;
            }
            case "buysettledate": {
                this.createSettleCashflowOnUnChanged();
                break;
            }
            case "startdate": {
                TmcViewInputHelper.setValWithoutPropChgEvt((IFormView)this.getView(), (IDataModel)this.getModel(), (String)"buysettledate", (Object)this.getModel().getValue("startdate"));
                break;
            }
            case "pricerule": {
                this.setSpotRate();
                this.initBasePlInfo();
                this.calVoucherPlOnChangePriceRule();
                break;
            }
            case "plcurrency": {
                this.setSpotRate();
                this.initBasePlInfo();
                this.setVisiblePlInfo();
                break;
            }
            case "spotrate": 
            case "initexamount": 
            case "recinitexamount": {
                this.setPlAmt();
                break;
            }
            case "plamt": 
            case "baseexrate": {
                this.setBasePlAmt();
                break;
            }
            case "currency": {
                this.setSpotRate();
                break;
            }
            case "reccurrency": {
                this.getModel().setValue("plcurrency", this.getModel().getValue("reccurrency"));
                break;
            }
            case "counterparty": {
                this.getModel().setValue("paysettletype", null);
                this.getModel().setValue("paybankacct", null);
                this.getModel().setValue("paybank", null);
                this.getModel().setValue("opppaybankacct", null);
                this.getModel().setValue("opppaybank", null);
                this.getModel().setValue("recsettletype", null);
                this.getModel().setValue("recbankacct", null);
                this.getModel().setValue("recbank", null);
                this.getModel().setValue("opprecbankacct", null);
                this.getModel().setValue("opprecbank", null);
                break;
            }
            case "paysettletype": {
                this.getModel().setValue("paybankacct", null);
                this.getModel().setValue("paybank", null);
                break;
            }
            case "recsettletype": {
                this.getModel().setValue("recbankacct", null);
                this.getModel().setValue("recbank", null);
                break;
            }
            case "reclocalexrate": 
            case "paylocalexrate": {
                this.calVoucherPlOnPropChgEvt();
            }
        }
    }

    private void createSettleCashflow() {
        Date buysettledate = (Date)this.getModel().getValue("buysettledate");
        if (EmptyUtil.isEmpty((Object)buysettledate)) {
            return;
        }
        this.getModel().deleteEntryData("settlecashflow");
        this.getModel().batchCreateNewEntryRow("settlecashflow", 2);
        this.getModel().setValue("cftype_settle", (Object)CashFlowTypeEnum.capital.getValue(), 0);
        this.getModel().setValue("cfdirect", (Object)"rec", 0);
        this.getModel().setValue("cfcurrency_settle", this.getModel().getValue("currency"), 0);
        this.getModel().setValue("cfpayamount_settle", this.getModel().getValue("initexamount"), 0);
        this.getModel().setValue("cftype_settle", (Object)CashFlowTypeEnum.capital.getValue(), 1);
        this.getModel().setValue("cfdirect", (Object)"pay", 1);
        this.getModel().setValue("cfcurrency_settle", this.getModel().getValue("reccurrency"), 1);
        BigDecimal recinitexamount = (BigDecimal)this.getModel().getValue("recinitexamount");
        this.getModel().setValue("cfpayamount_settle", (Object)recinitexamount.abs(), 1);
    }

    public void afterBindData(EventObject e) {
        super.afterBindData(e);
        this.setSettleVisible();
        this.setVisiblePlInfo();
        this.getView().setEnable(Boolean.valueOf((Boolean)this.getModel().getValue("isbuysettle") == false), new String[]{"paysettletype", "paybankacct", "opppaybankacct", "opppaybank", "buysettledate", "recsettletype", "recbankacct", "opprecbankacct", "opprecbank", "flexpay", "flexrec", "flexsettledetail", "fp_plinfo", "reclocalexrate", "paylocalexrate", "voucherpl"});
        this.createSettleCashflowOnUnChanged();
        String billStatus = (String)this.getModel().getValue("billstatus");
        if (StringUtils.equals((CharSequence)BillStatusEnum.SAVE.getValue(), (CharSequence)billStatus)) {
            TmcViewInputHelper.registerMustInput((IFormView)this.getView(), (boolean)false, (String[])new String[]{"paysettletype", "recsettletype", "buysettledate"});
        }
    }

    private void createSettleCashflowOnUnChanged() {
        boolean isChanged = this.getModel().getDataChanged();
        this.createSettleCashflow();
        if (!isChanged) {
            this.getModel().setDataChanged(false);
        }
    }

    private void setSettleVisible() {
        String swapType = (String)this.getModel().getValue("rateswaptype");
        String initPriExType = (String)this.getModel().getValue("initpriextype");
        if (SwapTypeEnum.currency.getValue().equals(swapType) && SwapExchangeType.Actual.getValue().equals(initPriExType)) {
            this.getView().setVisible(Boolean.valueOf(true), new String[]{"tabsettle", "barsettle"});
            if (this.isShowVoucherPlPanel()) {
                this.getView().setVisible(Boolean.TRUE, new String[]{"fieldsetpanelap3"});
            } else {
                this.getView().setVisible(Boolean.FALSE, new String[]{"fieldsetpanelap3"});
            }
        } else {
            this.getView().setVisible(Boolean.valueOf(false), new String[]{"tabsettle", "barsettle"});
        }
    }

    public void beforeBindData(EventObject e) {
        super.beforeBindData(e);
        if (this.getView().getFormShowParameter().getStatus().equals((Object)OperationStatus.ADDNEW)) {
            Map result = BaseDataServiceHelper.getBaseAccountingInfo((Long)((DynamicObject)this.getModel().getValue("org")).getLong("id"));
            Long localCurrencyId = (Long)result.get("baseCurrencyID");
            this.getModel().setValue("basecurrency", (Object)localCurrencyId);
        }
    }

    public void afterDoOperation(AfterDoOperationEventArgs args) {
        super.afterDoOperation(args);
        FormOperate formOperate = (FormOperate)args.getSource();
        if (StringUtils.equals((CharSequence)"audit", (CharSequence)formOperate.getOperateKey()) && args.getOperationResult() != null && args.getOperationResult().isSuccess()) {
            this.setSettleVisible();
            this.getView().invokeOperation("refresh");
        }
        if (StringUtils.equals((CharSequence)"unaudit", (CharSequence)formOperate.getOperateKey()) && args.getOperationResult() != null && args.getOperationResult().isSuccess()) {
            this.getView().invokeOperation("refresh");
            Tab tabap = (Tab)this.getControl("tabap");
            tabap.activeTab("tabpageap");
        }
        if (StringUtils.equals((CharSequence)"settle", (CharSequence)formOperate.getOperateKey()) && args.getOperationResult() != null && args.getOperationResult().isSuccess()) {
            this.getView().setEnable(Boolean.valueOf(false), new String[]{"flexpay", "flexrec", "flexsettledetail", "fp_plinfo", "reclocalexrate", "paylocalexrate", "voucherpl"});
            this.getView().invokeOperation("refresh");
        }
        if (StringUtils.equals((CharSequence)"unsettle", (CharSequence)formOperate.getOperateKey()) && args.getOperationResult() != null && args.getOperationResult().isSuccess()) {
            this.getView().setEnable(Boolean.valueOf(true), new String[]{"flexpay", "flexrec", "flexsettledetail", "fp_plinfo", "reclocalexrate", "paylocalexrate", "voucherpl"});
        }
    }
}

