/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.tm.formplugin.trade;

import kd.bos.bill.OperationStatus;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.form.control.events.TreeNodeEvent;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.operate.AbstractOperate;
import kd.bos.list.BillList;
import kd.bos.list.events.BeforeShowBillFormEvent;
import kd.bos.list.events.BuildTreeListFilterEvent;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.tmc.fbp.common.enums.TcBillStatusEnum;
import kd.tmc.fbp.common.helper.TmcDataServiceHelper;
import kd.tmc.fbp.common.util.EmptyUtil;
import kd.tmc.tm.formplugin.trade.AbstractTreeListPlugin;

public class TradeTreeList
extends AbstractTreeListPlugin {
    private static String root = "8609760E-EF83-4775-A9FF-CCDEC7C0B689";

    public void treeNodeClick(TreeNodeEvent e) {
        if (root.equals(e.getNodeId())) {
            this.getPageCache().put("protecttype_longnumber", "");
            this.getPageCache().put("isbiznode", "false");
        }
        if (EmptyUtil.isNoEmpty((Object)e.getParentNodeId())) {
            String nodeId = (String)e.getNodeId();
            this.getPageCache().put("isbiznode", "false");
            DynamicObject tradetype = TmcDataServiceHelper.loadSingleFromCache((Object)Long.valueOf(nodeId), (String)"tbd_tradetype", (String)"id,number,name,isbiznode,longnumber");
            this.getPageCache().put("protecttype_longnumber", tradetype.getString("longnumber"));
            if (EmptyUtil.isNoEmpty((DynamicObject)tradetype) && tradetype.getBoolean("isbiznode")) {
                this.getPageCache().put("protecttype", tradetype.getString("id"));
                this.getPageCache().put("protecttype_longnumber", tradetype.getString("longnumber"));
                this.getPageCache().put("isbiznode", "true");
            }
        }
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        super.beforeDoOperation(args);
        Object source = args.getSource();
        AbstractOperate op = (AbstractOperate)source;
        if ("refresh".equalsIgnoreCase(op.getOperateKey()) && root.equals(this.getTreeModel().getCurrentNodeId())) {
            args.setCancel(true);
        }
    }

    public void beforeShowBill(BeforeShowBillFormEvent e) {
        String formId = e.getParameter().getFormId();
        if (EmptyUtil.isEmpty((String)formId) || formId.equals("tm_trade")) {
            e.setCancel(true);
            if ("true".equals(this.getPageCache().get("isbiznode"))) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u4ea4\u6613\u7c7b\u578b\u672a\u8bbe\u7f6e\u3002", (String)"TradeTreeList_0", (String)"tmc-tm-formplugin", (Object[])new Object[0]));
            }
        }
        e.getParameter().setCustomParam("protecttype", (Object)this.getPageCache().get("protecttype"));
        Object billId = e.getParameter().getPkId();
        if (billId != null) {
            BillList billList = (BillList)this.getControl("billlistap");
            String entity = billList.getEntityId();
            DynamicObject info = QueryServiceHelper.queryOne((String)entity, (String)"id, billstatus", (QFilter[])new QFilter[]{new QFilter("id", "=", billId)});
            String billStaus = info.getString("billstatus");
            if (!OperationStatus.ADDNEW.equals((Object)e.getParameter().getStatus()) && (billStaus.equals(TcBillStatusEnum.SURVIVAL.getValue()) || billStaus.equals(TcBillStatusEnum.FINISH.getValue()))) {
                e.getParameter().setStatus(OperationStatus.VIEW);
            }
        }
        super.beforeShowBill(e);
    }

    @Override
    protected String getTreeViewControl() {
        return "treeview";
    }

    @Override
    protected String getTreeNodeEntity() {
        return "tbd_tradetype";
    }

    @Override
    protected String getTreeNodeFilterField() {
        return "protecttype";
    }

    @Override
    protected String getRootNodeName() {
        return ResManager.loadKDString((String)"\u4ea7\u54c1\u7c7b\u578b", (String)"TradeTreeList_1", (String)"tmc-tm-formplugin", (Object[])new Object[0]);
    }

    @Override
    protected QFilter getFilter() {
        return new QFilter("enable", "=", (Object)true).and(new QFilter("longnumber", "!=", (Object)"TRADE")).and(new QFilter("longnumber", "!=", (Object)"BONDISSUE")).and(new QFilter("longnumber", "not like", (Object)"%BIZOPEN%"));
    }

    @Override
    public void buildTreeListFilter(BuildTreeListFilterEvent e) {
        String protecttypeLongnumber = this.getPageCache().get("protecttype_longnumber");
        if (EmptyUtil.isNoEmpty((String)protecttypeLongnumber) && !protecttypeLongnumber.startsWith("BIZOPEN")) {
            String isbiznode = this.getPageCache().get("isbiznode");
            if (EmptyUtil.isNoEmpty((String)isbiznode) && Boolean.parseBoolean(isbiznode)) {
                String protectTypeCache = this.getPageCache().get("protecttype");
                if (!EmptyUtil.isEmpty((String)protectTypeCache)) {
                    QFilter fi = new QFilter("protecttype.id", "=", (Object)Long.valueOf(protectTypeCache));
                    e.getFilters().add(fi);
                }
            } else {
                QFilter fi = new QFilter("protecttype.longnumber", "like", (Object)(protecttypeLongnumber + "%"));
                e.getFilters().add(fi);
            }
        }
    }
}

