/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.tm.formplugin.warn.datasource;

import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.earlywarn.EarlyWarnContext;
import kd.bos.entity.filter.FilterBuilder;
import kd.bos.entity.filter.FilterCondition;
import kd.bos.exception.KDBizException;
import kd.bos.orm.query.QFilter;
import kd.bos.service.earlywarn.impl.DefaultEarlyWarnBillDataSource;
import kd.tmc.fbp.common.enums.TcBillStatusEnum;
import kd.tmc.fbp.common.helper.TmcDataServiceHelper;
import kd.tmc.fbp.common.util.EmptyUtil;
import kd.tmc.fbp.common.util.TcDateUtils;
import kd.tmc.tm.common.enums.BizOperateEnum;

public class TmCustomEarlyWarnDataSource
extends DefaultEarlyWarnBillDataSource {
    public List<QFilter> buildFilter(String dataSource, FilterCondition filterCondition, EarlyWarnContext context) {
        Map customConditionMap = context.getCustomConditionDataMap();
        Integer warndays = (Integer)customConditionMap.get("warndays");
        String commonFilterStr = (String)customConditionMap.get("common_filter");
        FilterCondition commonFilter = (FilterCondition)SerializationUtils.fromJsonString((String)commonFilterStr, FilterCondition.class);
        String fieldname = (String)customConditionMap.get("fieldname");
        String producttype = (String)customConditionMap.get("producttype");
        Long busibillproduct = (Long)customConditionMap.get("busibillproduct");
        String operate = (String)customConditionMap.get("operate");
        String billtype = (String)customConditionMap.get("billtype");
        String lifecycle = (String)customConditionMap.get("lifecycle");
        this.checkDataSource(producttype, dataSource);
        MainEntityType mainEntityType = EntityMetadataCache.getDataEntityType((String)dataSource);
        FilterBuilder filterBuilder = new FilterBuilder(mainEntityType, commonFilter);
        filterBuilder.buildFilter();
        List commonFilters = filterBuilder.getQFilters();
        ArrayList<QFilter> filters = new ArrayList<QFilter>(commonFilters);
        QFilter protecttypeFilter = new QFilter("protecttype.id", "=", (Object)busibillproduct);
        filters.add(protecttypeFilter);
        Date nowDate = TcDateUtils.truncateDate((Date)new Date());
        switch (billtype) {
            case "bizbill": {
                Date date = TcDateUtils.addSecond((Date)TcDateUtils.getNextDay((Date)nowDate, (int)(warndays + 1)), (int)-1);
                QFilter expireDateFilter = new QFilter(fieldname, "<", (Object)date);
                expireDateFilter.and(fieldname, ">", (Object)TcDateUtils.addSecond((Date)nowDate, (int)-1));
                filters.add(expireDateFilter);
                return filters;
            }
            case "lifecycle": {
                Date date = TcDateUtils.addSecond((Date)TcDateUtils.getNextDay((Date)nowDate, (int)(warndays + 1)), (int)-1);
                QFilter expireDateFilter = new QFilter(lifecycle, "<", (Object)date);
                expireDateFilter.and(lifecycle, ">", (Object)TcDateUtils.addSecond((Date)nowDate, (int)-1));
                filters.add(expireDateFilter);
                QFilter operateFilter = new QFilter("operate", "=", (Object)operate);
                filters.add(operateFilter);
                return filters;
            }
            case "break": {
                QFilter qFilter = new QFilter("firstbreakdate", "!=", null);
                filters.add(qFilter);
                return filters;
            }
        }
        return filters;
    }

    private void checkDataSource(String productType, String dataSource) {
        if (dataSource.equals("tm_businessbill")) {
            return;
        }
        String dataSourceTemp = null;
        switch (productType) {
            case "forwardinfo": {
                dataSourceTemp = "tm_forex_forward";
                break;
            }
            case "spotinfo": {
                dataSourceTemp = "tm_forex";
                break;
            }
            case "optionsinfo": {
                dataSourceTemp = "tm_forex_options";
                break;
            }
            case "swapsinfo": {
                dataSourceTemp = "tm_forex_swaps";
                break;
            }
            case "structdeposit": {
                dataSourceTemp = "tm_structdeposit";
                break;
            }
            case "rateswap": {
                dataSourceTemp = "tm_rateswap";
                break;
            }
            default: {
                throw new KDBizException(String.format(ResManager.loadKDString((String)"\u7ed1\u5b9a\u6570\u636e\u6e90%s\u4e0d\u652f\u6301\u81ea\u5b9a\u4e49\u9884\u8b66\u65b9\u6848\u3002", (String)"TmCustomEarlyWarnDataSource_0", (String)"tmc-tm-formplugin", (Object[])new Object[0]), productType));
            }
        }
        if (!StringUtils.equals((CharSequence)dataSource, (CharSequence)dataSourceTemp)) {
            throw new KDBizException(String.format(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u4e0e\u9884\u8b66\u5bf9\u8c61\u5bf9\u5e94\u7684\u4ea7\u54c1\u7c7b\u578b\u3002\u5982\u9884\u8b66\u5bf9\u8c61\u4e3a\u5916\u6c47\u8fdc\u671f\uff0c\u4ea7\u54c1\u7c7b\u578b\u9009\u62e9\u5916\u6c47\u8fdc\u671f\u3002", (String)"TmCustomEarlyWarnDataSource_1", (String)"tmc-tm-formplugin", (Object[])new Object[0]), new Object[0]));
        }
    }

    public DynamicObjectCollection getData(String dataSource, List<QFilter> filterList, EarlyWarnContext context) {
        context.getWarnSchedule().getWarnCondition().setFilterCondition(null);
        DynamicObjectCollection data = super.getData(dataSource, filterList, context);
        Map customConditionMap = context.getCustomConditionDataMap();
        String billtype = (String)customConditionMap.get("billtype");
        if ("break".equals(billtype) && EmptyUtil.isNoEmpty((DynamicObjectCollection)data)) {
            HashMap dataMap = new HashMap(data.size() * 2);
            data.forEach(obj -> dataMap.put(obj.getLong("id"), obj));
            QFilter qFilter = new QFilter("operate", "=", (Object)BizOperateEnum.ratecfg.getValue()).and("billstatus", "=", (Object)TcBillStatusEnum.AUDIT.getValue()).and("tradebill", "in", dataMap.keySet());
            Object[] bills = TmcDataServiceHelper.load((String)"tm_businessbill", (String)"tradebill", (QFilter[])new QFilter[]{qFilter});
            if (EmptyUtil.isEmpty((Object[])bills)) {
                return data;
            }
            DynamicObjectCollection tarDatas = new DynamicObjectCollection();
            for (Object bill : bills) {
                dataMap.remove(bill.getDynamicObject("tradebill").getLong("id"));
                tarDatas.addAll(dataMap.values());
            }
            return tarDatas;
        }
        return data;
    }
}

