/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.tm.formplugin.warn.plugin;

import java.util.ArrayList;
import java.util.EventObject;
import java.util.HashMap;
import java.util.Map;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.entity.earlywarn.warn.EarlyWarnConditionCheckResult;
import kd.bos.entity.earlywarn.warn.plugin.IEarlyWarnConditionForm;
import kd.bos.entity.filter.FilterCondition;
import kd.bos.exception.KDBizException;
import kd.bos.form.FormShowParameter;
import kd.bos.form.control.FilterGrid;
import kd.bos.form.field.ComboEdit;
import kd.bos.form.field.ComboItem;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.tmc.fbp.common.enums.ProductTypeEnum;
import kd.tmc.fbp.common.util.EmptyUtil;
import kd.tmc.tm.common.enums.BizOperateEnum;

public class TmCustomEarlyWarnPlugin
extends AbstractFormPlugin
implements IEarlyWarnConditionForm {
    public Map<String, Object> getCustomParams() {
        IDataModel model = this.getModel();
        Integer warnDays = (Integer)model.getValue("warndays");
        FilterGrid filterGrid = (FilterGrid)this.getView().getControl("common_filter");
        FilterGrid.FilterGridState filterGridState = filterGrid.getFilterGridState();
        FilterCondition condition = filterGridState.getFilterCondition();
        HashMap<String, Object> dataMap = new HashMap<String, Object>();
        dataMap.put("warndays", warnDays);
        String producttype = (String)model.getValue("producttype");
        String billtype = (String)model.getValue("billtype");
        String lifecycle = (String)model.getValue("lifecycle");
        String entityName = this.getProductTypeMap(producttype);
        for (ProductTypeEnum value : ProductTypeEnum.values()) {
            if (!value.getEntity().equals(entityName)) continue;
            dataMap.put("busibillproduct", Long.parseLong(value.getId()));
        }
        String fieldname = (String)model.getValue(producttype);
        dataMap.put("fieldname", fieldname);
        dataMap.put("producttype", producttype);
        dataMap.put("billtype", billtype);
        dataMap.put("lifecycle", lifecycle);
        if ("lifecycle".equals(billtype)) {
            String operate = (String)model.getValue("operate");
            dataMap.put("operate", operate);
        }
        dataMap.put("common_filter", SerializationUtils.toJsonString((Object)condition));
        return dataMap;
    }

    public EarlyWarnConditionCheckResult checkCustomParams() {
        String product;
        IDataModel model = this.getModel();
        String billtype = (String)model.getValue("billtype");
        if ("lifecycle".equals(billtype)) {
            String operate = (String)model.getValue("operate");
            if (EmptyUtil.isEmpty((String)operate)) {
                return EarlyWarnConditionCheckResult.failure((String)ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u751f\u547d\u5468\u671f\u64cd\u4f5c\u3002", (String)"TmCustomEarlyWarnPlugin_1", (String)"tmc-tm-formplugin", (Object[])new Object[0]));
            }
            if (EmptyUtil.isEmpty((Object)model.getValue("lifecycle"))) {
                return EarlyWarnConditionCheckResult.failure((String)ResManager.loadKDString((String)"\u9884\u8b66\u5b57\u6bb5\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"TmCustomEarlyWarnPlugin_3", (String)"tmc-tm-formplugin", (Object[])new Object[0]));
            }
        }
        if ("bizbill".equals(billtype) && EmptyUtil.isEmpty((Object)model.getValue(product = (String)model.getValue("producttype")))) {
            return EarlyWarnConditionCheckResult.failure((String)ResManager.loadKDString((String)"\u9884\u8b66\u5b57\u6bb5\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"TmCustomEarlyWarnPlugin_3", (String)"tmc-tm-formplugin", (Object[])new Object[0]));
        }
        Integer warnsday = (Integer)model.getValue("warndays");
        if (!"break".equals(billtype) && EmptyUtil.isEmpty((Integer)warnsday)) {
            return EarlyWarnConditionCheckResult.failure((String)ResManager.loadKDString((String)"\u63d0\u524d\u9884\u8b66\u5929\u6570\u5b57\u6bb5\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"TmCustomEarlyWarnPlugin_0", (String)"tmc-tm-formplugin", (Object[])new Object[0]));
        }
        return EarlyWarnConditionCheckResult.success((String)"");
    }

    public void beforeBindData(EventObject e) {
        FilterGrid filterGrid = (FilterGrid)this.getView().getControl("common_filter");
        FormShowParameter parameter = this.getView().getFormShowParameter();
        String producttype = (String)this.getModel().getValue("producttype");
        String fieldname = (String)parameter.getCustomParam("fieldname");
        Integer warndays = (Integer)parameter.getCustomParam("warndays");
        String operate = (String)parameter.getCustomParam("operate");
        String billtype = (String)this.getModel().getValue("billtype");
        String lifecycle = (String)parameter.getCustomParam("lifecycle");
        if (EmptyUtil.isEmpty((String)producttype)) {
            filterGrid.setEntityNumber("tm_forex_forward");
            return;
        }
        if ("lifecycle".equals(billtype)) {
            filterGrid.setEntityNumber("tm_businessbill");
        } else if ("bizbill".equals(billtype)) {
            filterGrid.setEntityNumber(this.getProductTypeMap(producttype));
        }
        if ("lifecycle".equals(billtype)) {
            this.getModel().setValue("operate", (Object)operate);
            this.setLifeCycleComs();
        }
        if ("bizbill".equals(billtype)) {
            String product = (String)this.getModel().getValue("producttype");
            ComboEdit control = (ComboEdit)this.getView().getControl(product);
            control.setMustInput(true);
        }
        this.getModel().setValue("producttype", (Object)producttype);
        this.getModel().setValue(producttype, (Object)fieldname);
        this.getModel().setValue("warndays", (Object)warndays);
        this.getModel().setValue("billtype", (Object)billtype);
        this.getModel().setValue("lifecycle", (Object)lifecycle);
    }

    public void afterBindData(EventObject e) {
        FilterGrid filterGrid = (FilterGrid)this.getView().getControl("common_filter");
        FormShowParameter parameter = this.getView().getFormShowParameter();
        String commonFilterStr = (String)parameter.getCustomParam("common_filter");
        if (EmptyUtil.isEmpty((String)commonFilterStr)) {
            return;
        }
        FilterCondition commonFilter = (FilterCondition)SerializationUtils.fromJsonString((String)commonFilterStr, FilterCondition.class);
        filterGrid.SetValue(commonFilter);
    }

    private String getProductTypeMap(String productType) {
        switch (productType) {
            case "forwardinfo": {
                return "tm_forex_forward";
            }
            case "spotinfo": {
                return "tm_forex";
            }
            case "optionsinfo": {
                return "tm_forex_options";
            }
            case "swapsinfo": {
                return "tm_forex_swaps";
            }
            case "structdeposit": {
                return "tm_structdeposit";
            }
            case "rateswap": {
                return "tm_rateswap";
            }
            case "lifecycle": {
                return "tm_businessbill";
            }
        }
        throw new KDBizException(String.format(ResManager.loadKDString((String)"\u7ed1\u5b9a\u6570\u636e\u6e90%s\u4e0d\u652f\u6301\u81ea\u5b9a\u4e49\u9884\u8b66\u65b9\u6848\u3002", (String)"TmCustomEarlyWarnPlugin_2", (String)"tmc-tm-formplugin", (Object[])new Object[0]), productType));
    }

    public void propertyChanged(PropertyChangedArgs e) {
        String key;
        switch (key = e.getProperty().getName()) {
            case "operate": {
                this.setLifeCycleComs();
                break;
            }
        }
    }

    private void setLifeCycleComs() {
        String productType = (String)this.getModel().getValue("producttype");
        ComboEdit lifeComs = (ComboEdit)this.getControl("lifecycle");
        lifeComs.setMustInput(true);
        String operate = (String)this.getModel().getValue("operate");
        ArrayList<ComboItem> data = new ArrayList<ComboItem>();
        switch (productType) {
            case "spotinfo": {
                if (BizOperateEnum.expiredey.getValue().equals(operate)) {
                    data.add(new ComboItem(new LocaleString(ResManager.loadKDString((String)"\u4ea4\u5272\u65e5", (String)"TmCustomEarlyWarnPlugin_5", (String)"tmc-tm-formplugin", (Object[])new Object[0])), "deliverydate"));
                    lifeComs.setComboItems(data);
                }
                if (!BizOperateEnum.flat.getValue().equals(operate)) break;
                data.add(new ComboItem(new LocaleString(ResManager.loadKDString((String)"\u7ed3\u7b97\u65e5", (String)"TmCustomEarlyWarnPlugin_6", (String)"tmc-tm-formplugin", (Object[])new Object[0])), "plsettledate"));
                lifeComs.setComboItems(data);
                break;
            }
            case "swapsinfo": {
                if (BizOperateEnum.expiredey_n.getValue().equals(operate) || BizOperateEnum.expiredey_f.getValue().equals(operate)) {
                    data.add(new ComboItem(new LocaleString(ResManager.loadKDString((String)"\u4ea4\u5272\u65e5", (String)"TmCustomEarlyWarnPlugin_5", (String)"tmc-tm-formplugin", (Object[])new Object[0])), "deliverydate"));
                    lifeComs.setComboItems(data);
                }
                if (BizOperateEnum.bdelivery_n.getValue().equals(operate) || BizOperateEnum.bdelivery_f.getValue().equals(operate)) {
                    data.add(new ComboItem(new LocaleString(ResManager.loadKDString((String)"\u4ea4\u5272\u65e5", (String)"TmCustomEarlyWarnPlugin_5", (String)"tmc-tm-formplugin", (Object[])new Object[0])), "deliverydate"));
                    data.add(new ComboItem(new LocaleString(ResManager.loadKDString((String)"\u7ed3\u7b97\u65e5", (String)"TmCustomEarlyWarnPlugin_6", (String)"tmc-tm-formplugin", (Object[])new Object[0])), "plsettledate"));
                    lifeComs.setComboItems(data);
                }
                if (!BizOperateEnum.flat_n.getValue().equals(operate) && !BizOperateEnum.flat_f.getValue().equals(operate) && !BizOperateEnum.defer_n.getValue().equals(operate) && !BizOperateEnum.defer_f.getValue().equals(operate) && !BizOperateEnum.maudate_n.getValue().equals(operate) && !BizOperateEnum.maudate_f.getValue().equals(operate)) break;
                data.add(new ComboItem(new LocaleString(ResManager.loadKDString((String)"\u7ed3\u7b97\u65e5", (String)"TmCustomEarlyWarnPlugin_6", (String)"tmc-tm-formplugin", (Object[])new Object[0])), "plsettledate"));
                lifeComs.setComboItems(data);
                break;
            }
            case "forwardinfo": {
                if (BizOperateEnum.expiredey.getValue().equals(operate)) {
                    data.add(new ComboItem(new LocaleString(ResManager.loadKDString((String)"\u4ea4\u5272\u65e5", (String)"TmCustomEarlyWarnPlugin_5", (String)"tmc-tm-formplugin", (Object[])new Object[0])), "deliverydate"));
                    lifeComs.setComboItems(data);
                }
                if (BizOperateEnum.bdelivery.getValue().equals(operate)) {
                    data.add(new ComboItem(new LocaleString(ResManager.loadKDString((String)"\u4ea4\u5272\u65e5", (String)"TmCustomEarlyWarnPlugin_5", (String)"tmc-tm-formplugin", (Object[])new Object[0])), "deliverydate"));
                    data.add(new ComboItem(new LocaleString(ResManager.loadKDString((String)"\u7ed3\u7b97\u65e5", (String)"TmCustomEarlyWarnPlugin_6", (String)"tmc-tm-formplugin", (Object[])new Object[0])), "plsettledate"));
                    lifeComs.setComboItems(data);
                }
                if (!BizOperateEnum.flat.getValue().equals(operate) && !BizOperateEnum.defer.getValue().equals(operate) && !BizOperateEnum.maudate.getValue().equals(operate)) break;
                data.add(new ComboItem(new LocaleString(ResManager.loadKDString((String)"\u7ed3\u7b97\u65e5", (String)"TmCustomEarlyWarnPlugin_6", (String)"tmc-tm-formplugin", (Object[])new Object[0])), "plsettledate"));
                lifeComs.setComboItems(data);
                break;
            }
            case "optionsinfo": {
                if (BizOperateEnum.exercise.getValue().equals(operate)) {
                    data.add(new ComboItem(new LocaleString(ResManager.loadKDString((String)"\u4ea4\u5272\u65e5", (String)"TmCustomEarlyWarnPlugin_5", (String)"tmc-tm-formplugin", (Object[])new Object[0])), "deliverydate"));
                }
                if (BizOperateEnum.flat.getValue().equals(operate)) {
                    data.add(new ComboItem(new LocaleString(ResManager.loadKDString((String)"\u7ed3\u7b97\u65e5", (String)"TmCustomEarlyWarnPlugin_6", (String)"tmc-tm-formplugin", (Object[])new Object[0])), "plsettledate"));
                }
                lifeComs.setComboItems(data);
                break;
            }
            case "structdeposit": 
            case "rateswap": {
                data.add(new ComboItem(new LocaleString(ResManager.loadKDString((String)"\u7ed3\u7b97\u65e5", (String)"TmCustomEarlyWarnPlugin_6", (String)"tmc-tm-formplugin", (Object[])new Object[0])), "plsettledate"));
                lifeComs.setComboItems(data);
            }
        }
    }
}

