/*
 * Decompiled with CFR 0.152.
 */
package kd.wtc.wtes.business.attperiod;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.hr.hbp.common.util.HRDynamicObjectUtils;
import kd.wtc.wtbs.common.util.third.collect.Lists;
import kd.wtc.wtbs.common.util.third.collect.Maps;
import kd.wtc.wtes.business.attperiod.AbstractAttPeriodSummary;
import kd.wtc.wtes.business.attperiod.AttPeriodSummaryRequest;
import kd.wtc.wtes.business.attperiod.AttPeriodSummaryService;
import kd.wtc.wtes.business.attperiod.chain.TieAttPeriodContext;
import kd.wtc.wtes.business.model.AttItemSpec;
import kd.wtc.wtes.business.model.AttItemSpecData;
import kd.wtc.wtes.business.model.AttPeriodSpliteModel;
import kd.wtc.wtes.business.model.attrecordadjust.AttRecordAdjust;
import kd.wtc.wtes.business.model.attrecordadjust.AttRecordTrimData;
import kd.wtc.wtes.business.model.attrecordadjust.AttRecordTrimResult;
import kd.wtc.wtes.business.util.AttRecordTrimUtil;
import kd.wtc.wtes.business.util.PeriodContextUtil;

public class AttPeriodRecordMove
extends AbstractAttPeriodSummary
implements AttPeriodSummaryService {
    @Override
    public AttPeriodSpliteModel sumBatch(TieAttPeriodContext tieAttPeriodContext, List<AttPeriodSummaryRequest> attPeriodSummaryRequestList, List<AttPeriodSpliteModel> attPeriodSpliteModelList) {
        return this.saveAttTotal(tieAttPeriodContext, attPeriodSpliteModelList);
    }

    private AttPeriodSpliteModel saveAttTotal(TieAttPeriodContext tieAttPeriodContext, List<AttPeriodSpliteModel> attPeriodSpliteModelList) {
        attPeriodSpliteModelList = PeriodContextUtil.copyAttPeriodSpliteModelList(attPeriodSpliteModelList);
        AttItemSpecData attItemSpecData = tieAttPeriodContext.getAttItemSpecData();
        AttRecordTrimData attRecordTrimData = tieAttPeriodContext.getAttRecordTrimData();
        if (attRecordTrimData == null || attItemSpecData == null) {
            return new AttPeriodSpliteModel(new DynamicObjectCollection(), new DynamicObjectCollection());
        }
        ArrayList deailDynamicObjects = Lists.newArrayListWithExpectedSize((int)16);
        PeriodContextUtil.dealDetailDynamicObjectList(attPeriodSpliteModelList, deailDynamicObjects);
        List<DynamicObject> mainDynamicObjects = PeriodContextUtil.getMainDysByDetail(deailDynamicObjects, attPeriodSpliteModelList);
        AttRecordTrimUtil.geneAdjustNode(tieAttPeriodContext, deailDynamicObjects, attRecordTrimData, mainDynamicObjects, "move");
        DynamicObjectCollection mainDynamicObjectList = new DynamicObjectCollection();
        DynamicObjectCollection detailDynamicObjectList = new DynamicObjectCollection();
        List<AttRecordTrimResult> attRecordTrimResultList = this.setData(deailDynamicObjects, mainDynamicObjects, detailDynamicObjectList, mainDynamicObjectList, tieAttPeriodContext);
        return AttRecordTrimUtil.getAttPeriodSpliteModel(mainDynamicObjectList, detailDynamicObjectList, attRecordTrimResultList);
    }

    private List<AttRecordTrimResult> setData(List<DynamicObject> deailDynamicObjects, List<DynamicObject> mainDynamicObjects, DynamicObjectCollection detailDynamicObjectList, DynamicObjectCollection mainDynamicObjectList, TieAttPeriodContext tieAttPeriodContext) {
        AttRecordTrimData attRecordTrimData = tieAttPeriodContext.getAttRecordTrimData();
        ArrayList attRecordTrimResultList = Lists.newArrayListWithExpectedSize((int)16);
        HashMap attitemMap = Maps.newHashMapWithExpectedSize((int)16);
        HashMap attmainMap = Maps.newHashMapWithExpectedSize((int)mainDynamicObjects.size());
        HashMap itemValueMap = Maps.newHashMapWithExpectedSize((int)deailDynamicObjects.size());
        Map<String, DynamicObject> detailMap = this.geneDetailMap(deailDynamicObjects, mainDynamicObjects);
        for (DynamicObject detailDynamicObject : deailDynamicObjects) {
            Long attitemId = detailDynamicObject.getLong("attitemid");
            Long attmainId = detailDynamicObject.getLong("attmain");
            DynamicObject deatilAttTotalDy = BusinessDataServiceHelper.newDynamicObject((String)"wtctd_atttotaldetail");
            HRDynamicObjectUtils.copy((DynamicObject)detailDynamicObject, (DynamicObject)deatilAttTotalDy);
            Long personId = AttRecordTrimUtil.getPersionId(mainDynamicObjects, attmainId);
            if (personId == null) continue;
            List<AttRecordAdjust> attRecordAdjustList = attRecordTrimData.getPeriodAdjustRecords(personId, "move");
            Long perAttPeriodid = detailDynamicObject.getLong("perattperiodid");
            String key = attitemId.toString() + "&&" + personId + "&&" + perAttPeriodid;
            String moveKey = null;
            for (AttRecordAdjust attRecordAdjust : attRecordAdjustList) {
                if (!AttRecordTrimUtil.isAdjust(attRecordAdjust, attitemId, personId, tieAttPeriodContext.getAttPeriodTable(), perAttPeriodid)) continue;
                BigDecimal orginValue = AttRecordTrimUtil.getOrginValue(detailDynamicObject, (BigDecimal)itemValueMap.get(key));
                BigDecimal valueUpdate = attRecordAdjust.getValueUpdate();
                BigDecimal valueAfter = orginValue.subtract(valueUpdate);
                deatilAttTotalDy.set("valuelong", (Object)valueAfter);
                itemValueMap.put(key, valueAfter);
                Long trimMoveItemId = attRecordAdjust.getBemoveItemId();
                moveKey = trimMoveItemId.toString() + "&&" + personId + "&&" + perAttPeriodid;
                DynamicObject detail = detailMap.get(moveKey);
                BigDecimal valueToBefore = AttRecordTrimUtil.getOrginValue(detail, (BigDecimal)itemValueMap.get(moveKey));
                if (valueToBefore == null) {
                    valueToBefore = BigDecimal.ZERO;
                }
                BigDecimal valueToAfter = valueToBefore.add(valueUpdate);
                if (detail != null) {
                    detail.set("valuelong", (Object)valueToAfter);
                }
                itemValueMap.put(moveKey, valueToAfter);
                AttRecordTrimResult attRecordTrimResult = AttRecordTrimResult.with().attRecordAdjust(attRecordAdjust).valueAfter(valueAfter).valueBefore(orginValue).valueToAfter(valueToAfter).valueToBefore(valueToBefore).attperiodId(perAttPeriodid).build();
                attRecordTrimResultList.add(attRecordTrimResult);
            }
            if (!itemValueMap.containsKey(key)) continue;
            AttRecordTrimUtil.builtTotalTrim(attmainId, mainDynamicObjectList, detailDynamicObjectList, mainDynamicObjects, attmainMap, deatilAttTotalDy);
            if (moveKey == null) continue;
            attitemMap.put(moveKey, attmainMap.get(attmainId));
        }
        this.dealDetail(itemValueMap, attitemMap, detailMap, detailDynamicObjectList, mainDynamicObjectList, tieAttPeriodContext);
        return attRecordTrimResultList;
    }

    private void dealDetail(Map<String, BigDecimal> itemValueMap, Map<String, Long> attitemMap, Map<String, DynamicObject> detailMap, DynamicObjectCollection detailDynamicObjectList, DynamicObjectCollection mainDynamicObjectList, TieAttPeriodContext tieAttPeriodContext) {
        itemValueMap.forEach((key, value) -> {
            DynamicObject detail = (DynamicObject)detailMap.get(key);
            if (detail == null) {
                Long mainId = (Long)attitemMap.get(key);
                if (mainId != null) {
                    this.builtDeatilMoveToAttTotalDy(tieAttPeriodContext, mainId, (String)key, (BigDecimal)value, detailDynamicObjectList, mainDynamicObjectList);
                }
            } else {
                detail.set("valuelong", value);
            }
        });
    }

    private void builtDeatilMoveToAttTotalDy(TieAttPeriodContext tieAttPeriodContext, Long attmainNewId, String key, BigDecimal valueToAfter, DynamicObjectCollection detailDynamicObjectList, DynamicObjectCollection mainDynamicObjectList) {
        DynamicObject mainDynamicObject = mainDynamicObjectList.stream().filter(ob -> ob.getLong("id") == attmainNewId.longValue()).findFirst().orElse(null);
        if (mainDynamicObject == null) {
            return;
        }
        String[] keyArray = key.split("&&");
        if (keyArray == null || keyArray.length == 0) {
            return;
        }
        Long trimMoveItemId = Long.parseLong(keyArray[0]);
        AttItemSpecData attItemSpecData = tieAttPeriodContext.getAttItemSpecData();
        DynamicObject deatilMoveToAttTotalDy = BusinessDataServiceHelper.newDynamicObject((String)"wtctd_atttotaldetail");
        deatilMoveToAttTotalDy.set("attmain", (Object)attmainNewId);
        deatilMoveToAttTotalDy.set("perattperiodid", mainDynamicObject.get("perattperiodid"));
        AttItemSpec attItemSpec = (AttItemSpec)attItemSpecData.getByBid(trimMoveItemId).getBoVersion();
        deatilMoveToAttTotalDy.set("attitemtype", (Object)(attItemSpec == null ? null : attItemSpec.getItemType()));
        deatilMoveToAttTotalDy.set("attitemid", (Object)trimMoveItemId);
        deatilMoveToAttTotalDy.set("attitemvid", (Object)trimMoveItemId);
        deatilMoveToAttTotalDy.set("valuelong", (Object)valueToAfter);
        detailDynamicObjectList.add((Object)deatilMoveToAttTotalDy);
    }

    private Map<String, DynamicObject> geneDetailMap(List<DynamicObject> deailDynamicObjects, List<DynamicObject> mainDynamicObjects) {
        HashMap detailMap = Maps.newHashMapWithExpectedSize((int)deailDynamicObjects.size());
        for (DynamicObject detailDynamicObject : deailDynamicObjects) {
            Long attitemId = detailDynamicObject.getLong("attitemid");
            Long attmainId = detailDynamicObject.getLong("attmain");
            Long personId = AttRecordTrimUtil.getPersionId(mainDynamicObjects, attmainId);
            if (personId == null) continue;
            Long perAttPeriodid = detailDynamicObject.getLong("perattperiodid");
            String key = attitemId.toString() + "&&" + personId + "&&" + perAttPeriodid;
            detailMap.put(key, detailDynamicObject);
        }
        return detailMap;
    }
}

