/*
 * Decompiled with CFR 0.152.
 */
package kd.wtc.wtes.business.attperiod;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.hr.hbp.common.util.HRDynamicObjectUtils;
import kd.wtc.wtbs.common.util.third.collect.Lists;
import kd.wtc.wtbs.common.util.third.collect.Maps;
import kd.wtc.wtes.business.attperiod.AbstractAttPeriodSummary;
import kd.wtc.wtes.business.attperiod.AttPeriodSummaryRequest;
import kd.wtc.wtes.business.attperiod.AttPeriodSummaryService;
import kd.wtc.wtes.business.attperiod.chain.TieAttPeriodContext;
import kd.wtc.wtes.business.model.AttPeriodSpliteModel;
import kd.wtc.wtes.business.model.attrecordadjust.AttRecordAdjust;
import kd.wtc.wtes.business.model.attrecordadjust.AttRecordTrimData;
import kd.wtc.wtes.business.model.attrecordadjust.AttRecordTrimResult;
import kd.wtc.wtes.business.util.AttRecordTrimUtil;
import kd.wtc.wtes.business.util.PeriodContextUtil;

public class AttPeriodRecordTrim
extends AbstractAttPeriodSummary
implements AttPeriodSummaryService {
    @Override
    public AttPeriodSpliteModel sumBatch(TieAttPeriodContext tieAttPeriodContext, List<AttPeriodSummaryRequest> attPeriodSummaryRequestList, List<AttPeriodSpliteModel> attPeriodSpliteModelList) {
        return this.saveAttTotal(tieAttPeriodContext, attPeriodSpliteModelList);
    }

    private AttPeriodSpliteModel saveAttTotal(TieAttPeriodContext tieAttPeriodContext, List<AttPeriodSpliteModel> attPeriodSpliteModelList) {
        AttRecordTrimData attRecordTrimData = tieAttPeriodContext.getAttRecordTrimData();
        if (attRecordTrimData == null) {
            return new AttPeriodSpliteModel(new DynamicObjectCollection(), new DynamicObjectCollection());
        }
        ArrayList deailDynamicObjects = Lists.newArrayListWithExpectedSize((int)16);
        attPeriodSpliteModelList = PeriodContextUtil.copyAttPeriodSpliteModelList(attPeriodSpliteModelList);
        PeriodContextUtil.dealDetailDynamicObjectList(attPeriodSpliteModelList, deailDynamicObjects);
        List<DynamicObject> mainDynamicObjects = PeriodContextUtil.getMainDysByDetail(deailDynamicObjects, attPeriodSpliteModelList);
        AttRecordTrimUtil.geneAdjustNode(tieAttPeriodContext, deailDynamicObjects, attRecordTrimData, mainDynamicObjects, "trim");
        DynamicObjectCollection mainDynamicObjectList = new DynamicObjectCollection();
        DynamicObjectCollection detailDynamicObjectList = new DynamicObjectCollection();
        ArrayList attRecordTrimResultList = Lists.newArrayListWithExpectedSize((int)16);
        HashMap attmainMap = Maps.newHashMapWithExpectedSize((int)mainDynamicObjects.size());
        HashMap itemValueMap = Maps.newHashMapWithExpectedSize((int)deailDynamicObjects.size());
        for (DynamicObject detailDynamicObject : deailDynamicObjects) {
            Long attitemId = detailDynamicObject.getLong("attitemid");
            DynamicObject deatilAttTotalDy = BusinessDataServiceHelper.newDynamicObject((String)"wtctd_atttotaldetail");
            HRDynamicObjectUtils.copy((DynamicObject)detailDynamicObject, (DynamicObject)deatilAttTotalDy);
            Long attmainId = detailDynamicObject.getLong("attmain");
            Long personId = AttRecordTrimUtil.getPersionId(mainDynamicObjects, attmainId);
            if (personId == null) continue;
            List<AttRecordAdjust> attRecordAdjustList = attRecordTrimData.getPeriodAdjustRecords(personId, "trim");
            Long perAttPeriodid = detailDynamicObject.getLong("perattperiodid");
            String key = attitemId.toString() + "&&" + personId + "&&" + perAttPeriodid;
            for (AttRecordAdjust attRecordAdjust : attRecordAdjustList) {
                if (!AttRecordTrimUtil.isAdjust(attRecordAdjust, attitemId, personId, tieAttPeriodContext.getAttPeriodTable(), perAttPeriodid)) continue;
                BigDecimal orginValue = AttRecordTrimUtil.getOrginValue(detailDynamicObject, (BigDecimal)itemValueMap.get(key));
                BigDecimal valueUpdate = attRecordAdjust.getValueUpdate();
                BigDecimal valueAfter = orginValue.add(valueUpdate);
                itemValueMap.put(key, valueAfter);
                deatilAttTotalDy.set("valuelong", (Object)valueAfter);
                AttRecordTrimResult attRecordTrimResult = AttRecordTrimResult.with().attRecordAdjust(attRecordAdjust).valueAfter(valueAfter).valueBefore(orginValue).attperiodId(perAttPeriodid).build();
                attRecordTrimResultList.add(attRecordTrimResult);
            }
            if (!itemValueMap.containsKey(key)) continue;
            AttRecordTrimUtil.builtTotalTrim(attmainId, mainDynamicObjectList, detailDynamicObjectList, mainDynamicObjects, attmainMap, deatilAttTotalDy);
        }
        return AttRecordTrimUtil.getAttPeriodSpliteModel(mainDynamicObjectList, detailDynamicObjectList, attRecordTrimResultList);
    }
}

