/*
 * Decompiled with CFR 0.152.
 */
package kd.wtc.wtes.business.attperiod;

import java.time.LocalDate;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DataEntityBase;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.db.DB;
import kd.bos.entity.MainEntityType;
import kd.bos.exception.KDException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.MetadataServiceHelper;
import kd.hr.hbp.business.servicehelper.HRBaseServiceHelper;
import kd.hr.hbp.common.util.HRDynamicObjectUtils;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.sdk.wtc.wtes.business.tie.exexutor.period.TieAttPeriodEvaluatorExt;
import kd.sdk.wtc.wtes.business.tie.persistent.period.AfterSaveAllPerPeriodDataResultEvent;
import kd.sdk.wtc.wtes.business.tie.persistent.period.BeforeSavePerPeriodDataResultEvent;
import kd.sdk.wtc.wtes.business.tie.persistent.period.TieSaveAllAttPeriodDataExtPlugin;
import kd.sdk.wtc.wtes.business.tie.persistent.period.TieSavePerPeriodDataExtPlugin;
import kd.sdk.wtc.wtes.business.tie.persistent.utils.TieDataResultExt;
import kd.sdk.wtc.wtes.business.tie.persistent.utils.TieDataResultRelExt;
import kd.sdk.wtc.wtes.business.tie.persistent.utils.TieDataResultUtils;
import kd.wtc.wtbs.business.accountplan.AccountPlanBuryPointUtil;
import kd.wtc.wtbs.business.caltask.common.WTCCalTaskDetailEntity;
import kd.wtc.wtbs.business.extplugin.WTCPluginProxyFactory;
import kd.wtc.wtbs.business.subject.AttSubject;
import kd.wtc.wtbs.business.task.common.WTCTaskDetailStatus;
import kd.wtc.wtbs.common.helper.WTCAppContextHelper;
import kd.wtc.wtbs.common.model.period.PerAttPeriod;
import kd.wtc.wtbs.common.util.SystemParamQueryUtil;
import kd.wtc.wtbs.common.util.Tuple;
import kd.wtc.wtbs.common.util.WTCCollections;
import kd.wtc.wtbs.common.util.WTCDateUtils;
import kd.wtc.wtbs.common.util.WTCStringUtils;
import kd.wtc.wtbs.common.util.third.collect.Lists;
import kd.wtc.wtbs.common.util.third.collect.Maps;
import kd.wtc.wtes.business.attperiod.AttPeriodSummaryRequest;
import kd.wtc.wtes.business.attperiod.AttPeriodSummaryService;
import kd.wtc.wtes.business.attperiod.SchemeWrapper;
import kd.wtc.wtes.business.attperiod.TieAttPeriodEvaluatorExtProxy;
import kd.wtc.wtes.business.attperiod.chain.TieAttPeriodContext;
import kd.wtc.wtes.business.core.TieEngineErrorCodes;
import kd.wtc.wtes.business.core.TieMsgLevel;
import kd.wtc.wtes.business.core.TieStatus;
import kd.wtc.wtes.business.core.chain.TiePointer;
import kd.wtc.wtes.business.core.engine.TieEngineCallbackEvent;
import kd.wtc.wtes.business.core.exporter.ITieExporter;
import kd.wtc.wtes.business.core.scheme.DecisionConfig;
import kd.wtc.wtes.business.core.scheme.TiePhaseConfig;
import kd.wtc.wtes.business.core.scheme.TiePhaseIdentity;
import kd.wtc.wtes.business.core.scheme.TieScheme;
import kd.wtc.wtes.business.core.scheme.TieSchemeIdentity;
import kd.wtc.wtes.business.core.scheme.TieStepConfig;
import kd.wtc.wtes.business.core.scheme.TieStepIdentity;
import kd.wtc.wtes.business.ext.utils.TiePeriodContextExtUtil;
import kd.wtc.wtes.business.model.AccountPlanData;
import kd.wtc.wtes.business.model.AttPeriodEntity;
import kd.wtc.wtes.business.model.AttPeriodSpliteModel;
import kd.wtc.wtes.business.model.AttPeriodTable;
import kd.wtc.wtes.business.model.attrecordadjust.AttRecordAdjust;
import kd.wtc.wtes.business.model.attrecordadjust.AttRecordTrimResult;
import kd.wtc.wtes.business.service.ICalFinishAfterProcessService;
import kd.wtc.wtes.business.std.TieMessageStd;
import kd.wtc.wtes.business.util.AttRecordTrimUtil;
import kd.wtc.wtes.business.util.PeriodContextUtil;
import kd.wtc.wtes.business.util.WtesHRBaseTimeWatchUtil;
import kd.wtc.wtes.common.util.CollectionUtils;

public class AttPeriodSummaryCallback
implements ICalFinishAfterProcessService {
    private static final Log LOGGER = LogFactory.getLog(AttPeriodSummaryCallback.class);
    private static HRBaseServiceHelper attPeriodSummaryService = WtesHRBaseTimeWatchUtil.create(AttPeriodSummaryCallback.class.getName() + "." + "wtctd_atttotalbase", "wtctd_atttotalbase");
    private static HRBaseServiceHelper attPeriodDetailSummaryService = WtesHRBaseTimeWatchUtil.create(AttPeriodSummaryCallback.class.getName() + "." + "wtdtd_attrecorddetail", "wtctd_atttotaldetail");
    private static HRBaseServiceHelper attPeriodSummaryHisService = WtesHRBaseTimeWatchUtil.create(AttPeriodSummaryCallback.class.getName() + "." + "wtdtd_attrecordbasehis", "wtctd_atttotalbasehis");
    private static HRBaseServiceHelper attPeriodDetailHisSummaryService = WtesHRBaseTimeWatchUtil.create(AttPeriodSummaryCallback.class.getName() + "." + "wtctd_atttotaldetailhis", "wtctd_atttotaldetailhis");
    private static HRBaseServiceHelper periodMoveDetailService = WtesHRBaseTimeWatchUtil.create(AttPeriodSummaryCallback.class.getName() + "." + "wtte_periodmovedetail", "wtte_periodmovedetail");
    public static MainEntityType adjustRecord = MetadataServiceHelper.getDataEntityType((String)"wtte_periodmovedetail");

    @Override
    public void completedCallback(TieEngineCallbackEvent callbackEvent) {
        String version = callbackEvent.getRequest().getVersion();
        LOGGER.debug("AttPeriodSummaryCallback_begin_version_{}", (Object)version);
        TieAttPeriodContext tieAttPeriodContext = new TieAttPeriodContext(callbackEvent);
        this.invokeSummary(tieAttPeriodContext);
        this.clearSummaryItem(tieAttPeriodContext.getDeathNameList(), callbackEvent);
    }

    protected Map<Long, Date> initDeathNameList(TieEngineCallbackEvent callbackEvent) {
        ITieExporter exporter = callbackEvent.getEngine().getExporter();
        List errorBoList = exporter.getResult().stream().filter(entity -> entity.getTaskDetailState() == WTCTaskDetailStatus.FAIL).collect(Collectors.toList());
        HashMap<Long, Date> deathNameList = new HashMap<Long, Date>(errorBoList.size());
        for (WTCCalTaskDetailEntity errorBo : errorBoList) {
            deathNameList.put(errorBo.getAttPersonId(), null);
        }
        LOGGER.debug("AttPeriodSummaryCallback find DeathNameList size={}, detail={}", (Object)deathNameList.size(), deathNameList);
        return deathNameList;
    }

    /*
     * WARNING - void declaration
     */
    protected void clearSummaryItem(Map<Long, Date> deathNameList, TieEngineCallbackEvent callbackEvent) {
        DynamicObject[] dynArr;
        Object[] objectArray;
        void var7_14;
        void var6_9;
        List<AttSubject> attSubjects = callbackEvent.getEngine().getAttSubjects();
        LOGGER.debug("before clear SummaryItem: attSubjects.size={}, deathNameList.size()={}", (Object)attSubjects.size(), (Object)deathNameList.size());
        HashMap<Long, Date> person2BeginDateMap = new HashMap<Long, Date>(16);
        for (AttSubject attSubject : attSubjects) {
            long l = attSubject.getAttPersonId();
            LocalDate localDate = attSubject.getStartDate();
            Date subjectStartDate = WTCDateUtils.toDate((LocalDate)localDate);
            if (subjectStartDate == null) {
                LOGGER.debug("before clear SummaryItem: find subject[{}] not exist startDate", (Object)attSubject);
            }
            person2BeginDateMap.put(l, subjectStartDate);
        }
        HashMap<Date, List> reserveMap = new HashMap<Date, List>(deathNameList.size());
        for (Map.Entry<Long, Date> entry : deathNameList.entrySet()) {
            void var9_20;
            Long attPersonId = entry.getKey();
            Date date = entry.getValue();
            if (date == null) {
                Date date2 = (Date)person2BeginDateMap.get(attPersonId);
                LOGGER.debug("before clear SummaryItem: find subject[{}] not exist lastOperateDate, now use subjectStartDate[{}] replace it.", (Object)attPersonId, (Object)date2);
            }
            if (var9_20 == null) continue;
            List sameDatePersonIdList = reserveMap.computeIfAbsent((Date)var9_20, key -> new ArrayList(16));
            sameDatePersonIdList.add(attPersonId);
        }
        if (reserveMap.isEmpty()) {
            LOGGER.debug("before clear SummaryItem: not exist any person need clear SummaryItem");
            return;
        }
        Object var6_8 = null;
        Object var7_13 = null;
        for (Map.Entry entry : reserveMap.entrySet()) {
            Date lastOperateDate = (Date)entry.getKey();
            List personIdList = (List)entry.getValue();
            QFilter qFilter = this.setDeleteCondition(personIdList, (QFilter)var6_9, lastOperateDate, "personid", "perperiodbegindate", null);
            List<Long> attFileBoIds = this.getAttFileBoidByPersonId(attSubjects, personIdList);
            QFilter qFilter2 = this.setDeleteCondition(attFileBoIds, (QFilter)var7_14, lastOperateDate, "attfilebase", "attperiodid.begindate", "revisionhisid.datastatus");
        }
        if (var6_9 != null && (objectArray = Arrays.stream(dynArr = attPeriodSummaryService.query("id", var6_9.toArray())).map(DataEntityBase::getPkValue).toArray()).length != 0) {
            attPeriodSummaryService.delete(objectArray);
            attPeriodDetailSummaryService.deleteByFilter(new QFilter[]{new QFilter("attmain", "in", (Object)objectArray)});
            LOGGER.debug("clear SummaryItem success, delete range:{}", Arrays.asList(objectArray));
        }
        if (var7_14 != null) {
            periodMoveDetailService.deleteByFilter(new QFilter[]{var7_14});
        }
    }

    private List<Long> getAttFileBoidByPersonId(List<AttSubject> attSubjects, List<Long> personIdList) {
        ArrayList attFileBoIds = Lists.newArrayListWithExpectedSize((int)16);
        for (AttSubject attSubject : attSubjects) {
            if (!personIdList.contains(attSubject.getAttPersonId())) continue;
            List addBoIdList = attSubject.getAttFileBos().stream().map(AttSubject.AttFileBo::getAttFileBoid).collect(Collectors.toList());
            attFileBoIds.addAll(addBoIdList);
        }
        return attFileBoIds;
    }

    protected QFilter setDeleteCondition(List<Long> personIdList, QFilter deleteCondition, Date lastOperateDate, String personKey, String perperiodBegindate, String dataStatusKey) {
        QFilter tmp = new QFilter(perperiodBegindate, ">=", (Object)lastOperateDate);
        if (personIdList.size() == 1) {
            tmp.and(personKey, "=", (Object)personIdList.get(0));
        } else {
            tmp.and(personKey, "in", personIdList);
        }
        if (!HRStringUtils.isEmpty((String)dataStatusKey)) {
            tmp.and(dataStatusKey, "=", (Object)"1");
        }
        if (deleteCondition != null) {
            deleteCondition.or(tmp);
            return deleteCondition;
        }
        return tmp;
    }

    protected List<AttPeriodSummaryRequest> genSummaryRequests(TieEngineCallbackEvent callbackEvent, List<AttSubject> realAttSubject) {
        AttPeriodTable attPeriodTable = (AttPeriodTable)callbackEvent.getEngine().getInitParams().get("ATT_PERIOD");
        List<AttSubject> attSubjects = callbackEvent.getEngine().getAttSubjects();
        Map attSubjectMap = attSubjects.stream().collect(Collectors.toMap(AttSubject::getAttPersonId, Function.identity(), (key1, key2) -> key2));
        List involvedAttPersonIds = attSubjects.stream().map(AttSubject::getAttPersonId).distinct().collect(Collectors.toList());
        AccountPlanData accountPlanData = (AccountPlanData)callbackEvent.getEngine().getInitParams().get("ACCOUNT_PLAN");
        ArrayList list = Lists.newArrayListWithExpectedSize((int)involvedAttPersonIds.size());
        for (Long attPersonId : involvedAttPersonIds) {
            AttPeriodSummaryRequest summaryRequest = new AttPeriodSummaryRequest();
            AttSubject attSubject = (AttSubject)attSubjectMap.get(attPersonId);
            List<PerAttPeriod> perAttPeriodList = attPeriodTable.getPerAttPeriodList(attPersonId);
            if (WTCCollections.isEmpty(perAttPeriodList)) {
                LOGGER.debug("AttPeriodSummaryCallback_PerAttPeriod_isnull_attPersonId_{}", (Object)attPersonId);
                continue;
            }
            Date startDate = WTCDateUtils.toDate((LocalDate)attSubject.getStartDate());
            Date endDate = WTCDateUtils.toDate((LocalDate)attSubject.getEndDate());
            List<PerAttPeriod> filerList = perAttPeriodList.stream().filter(period -> period.getPerAttBeginDate().getTime() <= endDate.getTime() && period.getPerAttEndDate().getTime() >= startDate.getTime()).collect(Collectors.toList());
            if (WTCCollections.isEmpty(filerList)) {
                LOGGER.debug("AttPeriodSummaryCallback_PerAttPeriod_filerList_isnull_attPersonId_{}_startDate{}_endDate_{}", new Object[]{attPersonId, startDate, endDate});
                continue;
            }
            List<String> attPeriodIds = filerList.stream().map(PerAttPeriod::getId).collect(Collectors.toList());
            LOGGER.debug("AttPeriodSummaryCallback_PerAttPeriod_startDate_{}_endDate_{}_attPeriodIds_{}", new Object[]{startDate, endDate, attPeriodIds});
            Set<Long> fileBoIdSet = filerList.stream().map(PerAttPeriod::getFileBoId).collect(Collectors.toSet());
            Map<String, PerAttPeriod> perAttPeriodMap = perAttPeriodList.stream().collect(Collectors.toMap(PerAttPeriod::getId, Function.identity(), (key1, key2) -> key2));
            summaryRequest.setAttFileBoId(fileBoIdSet);
            summaryRequest.setAttPersonId(attPersonId);
            summaryRequest.setAttPeriodIds(attPeriodIds);
            summaryRequest.setPerAttPeriodMap(perAttPeriodMap);
            summaryRequest.setAttPeriodIdToSchemeMap(this.generalAttPeriodIdToSchemeMap(filerList, accountPlanData));
            list.add(summaryRequest);
            realAttSubject.add(attSubject);
        }
        return list;
    }

    protected Map<String, SchemeWrapper> generalAttPeriodIdToSchemeMap(List<PerAttPeriod> perAttPeriodList, AccountPlanData planData) {
        HashMap<String, SchemeWrapper> result = new HashMap<String, SchemeWrapper>(perAttPeriodList.size());
        for (PerAttPeriod perAttPeriod : perAttPeriodList) {
            LocalDate localDate = WTCDateUtils.toLocalDate((Date)perAttPeriod.getPerAttEndDate());
            TieScheme versionByDate = planData.getTieSchemeByTotalAndDate(localDate);
            if (versionByDate == null) continue;
            result.put(perAttPeriod.getId(), new SchemeWrapper(versionByDate, localDate));
        }
        return result;
    }

    protected void invokeSummary(TieAttPeriodContext tieAttPeriodContext) {
        String version = tieAttPeriodContext.getVersion();
        Map<SchemeWrapper, List<AttPeriodSummaryRequest>> periodSchemeMap = tieAttPeriodContext.getPeriodSchemeMap();
        ArrayList result = Lists.newArrayListWithExpectedSize((int)16);
        for (Map.Entry<SchemeWrapper, List<AttPeriodSummaryRequest>> tieSchemeListEntry : periodSchemeMap.entrySet()) {
            SchemeWrapper schemeWrapper = tieSchemeListEntry.getKey();
            List<AttPeriodSummaryRequest> attPeriodSummaryRequestList = tieSchemeListEntry.getValue();
            result.add(this.summaryByScheme(schemeWrapper, attPeriodSummaryRequestList, tieAttPeriodContext));
        }
        this.dealResult(version, result, tieAttPeriodContext);
    }

    protected AttPeriodEntity summaryByScheme(SchemeWrapper schemeWrapper, List<AttPeriodSummaryRequest> attPeriodSummaryRequestList, TieAttPeriodContext tieAttPeriodContext) {
        TieScheme scheme = schemeWrapper.getTieScheme();
        LocalDate localDate = schemeWrapper.getLocalDate();
        List<TiePhaseConfig> phaseProperties = scheme.getPhaseProperties();
        Integer index = phaseProperties.stream().filter(ob -> ob.getNumber().equals("PHASE_PRRIOD_SUM")).map(TiePhaseConfig::getIndex).findFirst().orElse(null);
        if (index == null) {
            return null;
        }
        List<DecisionConfig> decisionConfigList = scheme.getPhaseDecisions();
        List phase_period_sum = phaseProperties.stream().filter(ob -> ob.getIndex() >= index).collect(Collectors.toList());
        ArrayList result = Lists.newArrayListWithExpectedSize((int)16);
        Tuple<Boolean, TieStatus> tuple = null;
        int phaseIndex = 0;
        TiePointer phaseTiePointer = null;
        TieSchemeIdentity schemeIdentity = new TieSchemeIdentity(scheme.getId(), scheme.getBid(), scheme.getNumber(), 0L, null);
        for (TiePhaseConfig phaseProperty : phase_period_sum) {
            List<TieStepConfig> stepConfigs = phaseProperty.getStepConfigsByDate(localDate);
            if (CollectionUtils.isEmpty(stepConfigs)) {
                ++phaseIndex;
                continue;
            }
            if (!PeriodContextUtil.isContinue(tuple, phaseTiePointer = PeriodContextUtil.getPhaseTiePointer(tuple, phaseTiePointer, phaseIndex, decisionConfigList))) break;
            TiePhaseIdentity phaseIdentity = new TiePhaseIdentity(phaseProperty.getNumber(), schemeIdentity, phaseProperty.getIndex(), phaseProperty.getSaveFlag(), phaseProperty.getResult(), phaseProperty.getId());
            int stepIndex = 0;
            for (TieStepConfig stepConfig : stepConfigs) {
                AttPeriodSummaryService evaluator;
                if (stepConfig == null) continue;
                if (WTCStringUtils.equals((String)stepConfig.getNumber(), (String)AccountPlanBuryPointUtil.getPointStepNum((boolean)false))) {
                    TieAttPeriodEvaluatorExt attPeriodEvaluatorExt = (TieAttPeriodEvaluatorExt)WTCAppContextHelper.getBean((String)stepConfig.getEvaluatorName(), TieAttPeriodEvaluatorExt.class);
                    evaluator = new TieAttPeriodEvaluatorExtProxy(attPeriodEvaluatorExt);
                } else {
                    evaluator = this.createEvaluator(stepConfig);
                }
                TieStepIdentity stepIdentity = new TieStepIdentity(stepConfig.getId(), stepConfig.getBid(), stepConfig.getNumber(), phaseIdentity, stepConfig.getStepEntryId(), stepConfig.getTieUnitType());
                evaluator.setTieStepIdentity(stepIdentity);
                AttPeriodSpliteModel attPeriodSpliteModel = this.doExecute(evaluator, attPeriodSummaryRequestList, tieAttPeriodContext, result);
                if (attPeriodSpliteModel == null) continue;
                TieStatus tieStatus = attPeriodSpliteModel.getResultStatus();
                TiePointer stepTiePointer = PeriodContextUtil.getDecision(stepIndex, phaseProperty.getExecutorDecision(), tieStatus);
                tuple = PeriodContextUtil.dealDecision(stepTiePointer, result, attPeriodSpliteModel, tieAttPeriodContext, phaseProperty);
                if (!((Boolean)tuple.getKey()).booleanValue()) break;
                ++stepIndex;
            }
            ++phaseIndex;
            if (TiePointer.ERROR != phaseTiePointer) continue;
            throw new KDException(TieEngineErrorCodes.getLineBreak(), new Object[]{PeriodContextUtil.getErrorMsg(tieAttPeriodContext.getTieMessages())});
        }
        ArrayList detailDynamicObjectList = Lists.newArrayListWithExpectedSize((int)16);
        PeriodContextUtil.dealDetailDynamicObjectList(result, detailDynamicObjectList);
        List<DynamicObject> mainDynamicObjectList = PeriodContextUtil.getMainDysByDetail(detailDynamicObjectList, result);
        mainDynamicObjectList = this.getMainDynamicObjectList(mainDynamicObjectList, detailDynamicObjectList);
        AttPeriodEntity attPeriodEntity = this.builtAttPeriodEntity(mainDynamicObjectList, detailDynamicObjectList);
        this.setAttRecordTrimResultList(attPeriodEntity, result);
        return attPeriodEntity;
    }

    private List<DynamicObject> getMainDynamicObjectList(List<DynamicObject> mainDynamicObjectList, List<DynamicObject> detailDynamicObjectList) {
        Map<String, List<DynamicObject>> mainMap = mainDynamicObjectList.stream().collect(Collectors.groupingBy(ob -> ob.getString("attperattperiodid")));
        ArrayList mainDynamicObjects = Lists.newArrayListWithExpectedSize((int)16);
        for (Map.Entry<String, List<DynamicObject>> entry : mainMap.entrySet()) {
            String perPeriodId = entry.getKey();
            if (perPeriodId == null) continue;
            List<DynamicObject> dynamicObjectList = entry.getValue();
            List idList = dynamicObjectList.stream().map(ob -> ob.getLong("id")).collect(Collectors.toList());
            List filterDynamicObject = detailDynamicObjectList.stream().filter(ob -> idList.contains(ob.getLong("attmain"))).collect(Collectors.toList());
            DynamicObject dynamicObject = dynamicObjectList.get(0);
            mainDynamicObjects.add(dynamicObject);
            for (DynamicObject detail : filterDynamicObject) {
                detail.set("attmain", (Object)dynamicObject.getLong("id"));
            }
        }
        return mainDynamicObjects;
    }

    protected AttPeriodSpliteModel doExecute(AttPeriodSummaryService evaluator, List<AttPeriodSummaryRequest> attPeriodSummaryRequestList, TieAttPeriodContext tieAttPeriodContext, List<AttPeriodSpliteModel> result) {
        AttPeriodSpliteModel attPeriodSpliteModel;
        try {
            attPeriodSpliteModel = evaluator.sumBatch(tieAttPeriodContext, attPeriodSummaryRequestList, result);
        }
        catch (Exception e) {
            attPeriodSpliteModel = new AttPeriodSpliteModel(new DynamicObjectCollection(), new DynamicObjectCollection());
            attPeriodSpliteModel.setResultStatus(TieStatus.EXCLUSION);
            attPeriodSpliteModel.getTieMessages().add(new TieMessageStd(TieMsgLevel.ERROR, e.getMessage()));
            LOGGER.warn("attPeriodSummaryCallback error", (Throwable)e);
        }
        return attPeriodSpliteModel;
    }

    protected void setAttRecordTrimResultList(AttPeriodEntity attPeriodEntity, List<AttPeriodSpliteModel> result) {
        ArrayList attRecordTrimResultList = Lists.newArrayListWithExpectedSize((int)16);
        result.forEach(key -> {
            List<AttRecordTrimResult> keyAttRecordTrimResultList = key.getAttRecordTrimResultList();
            if (!CollectionUtils.isEmpty(keyAttRecordTrimResultList)) {
                attRecordTrimResultList.addAll(key.getAttRecordTrimResultList());
            }
        });
        attPeriodEntity.setAttRecordTrimResultList(attRecordTrimResultList);
    }

    protected AttPeriodEntity builtAttPeriodEntity(List<DynamicObject> mainDynamicObjectList, List<DynamicObject> detailDynamicObjectList) {
        ArrayList mainHisDynamicObjectList = Lists.newArrayListWithExpectedSize((int)mainDynamicObjectList.size());
        HashMap map = Maps.newHashMapWithExpectedSize((int)mainDynamicObjectList.size());
        long[] longIds = DB.genLongIds((String)"wtctd_atttotalbasehis", (int)mainDynamicObjectList.size());
        int num = 0;
        for (DynamicObject mainDynamicObject : mainDynamicObjectList) {
            DynamicObject baseAttTotalHisDy = BusinessDataServiceHelper.newDynamicObject((String)"wtctd_atttotalbasehis");
            HRDynamicObjectUtils.copy((DynamicObject)mainDynamicObject, (DynamicObject)baseAttTotalHisDy);
            long id = longIds[num];
            baseAttTotalHisDy.set("id", (Object)id);
            map.put(mainDynamicObject.getLong("id"), id);
            mainHisDynamicObjectList.add(baseAttTotalHisDy);
            ++num;
        }
        ArrayList detailHisDynamicObjectList = Lists.newArrayListWithExpectedSize((int)detailDynamicObjectList.size());
        for (DynamicObject detailDynamicObject : detailDynamicObjectList) {
            Long attmainId = detailDynamicObject.getLong("attmain");
            Long attmainHisId = (Long)map.get(attmainId);
            DynamicObject deatilAttTotalHisDy = BusinessDataServiceHelper.newDynamicObject((String)"wtctd_atttotaldetailhis");
            HRDynamicObjectUtils.copy((DynamicObject)detailDynamicObject, (DynamicObject)deatilAttTotalHisDy);
            deatilAttTotalHisDy.set("attmain", (Object)attmainHisId);
            detailHisDynamicObjectList.add(deatilAttTotalHisDy);
        }
        return new AttPeriodEntity(mainDynamicObjectList, mainHisDynamicObjectList, detailDynamicObjectList, detailHisDynamicObjectList);
    }

    private void addAll(DynamicObjectCollection dynamicObjects, List<DynamicObject> addDynamicObjects) {
        if (CollectionUtils.isNotEmpty(addDynamicObjects)) {
            dynamicObjects.addAll(addDynamicObjects);
        }
    }

    protected void dealResult(String version, List<AttPeriodEntity> result, TieAttPeriodContext tieAttPeriodContext) {
        if (CollectionUtils.isEmpty(result)) {
            return;
        }
        Map<Long, Date> deathNameList = tieAttPeriodContext.getDeathNameList();
        DynamicObjectCollection mainDynamicObjects = new DynamicObjectCollection();
        DynamicObjectCollection mainHisDynamicObjects = new DynamicObjectCollection();
        DynamicObjectCollection detailDynamicObjects = new DynamicObjectCollection();
        DynamicObjectCollection detailHisDynamicObjects = new DynamicObjectCollection();
        ArrayList attRecordTrimResultList = Lists.newArrayListWithExpectedSize((int)16);
        for (AttPeriodEntity attPeriodEntity : result) {
            this.addAll(mainDynamicObjects, attPeriodEntity.getMainDynamicObjects());
            this.addAll(detailDynamicObjects, attPeriodEntity.getDetailDynamicObjects());
            this.addAll(mainHisDynamicObjects, attPeriodEntity.getMainHisDynamicObjects());
            this.addAll(detailHisDynamicObjects, attPeriodEntity.getDetailHisDynamicObjects());
            List<AttRecordTrimResult> periodAttRecordTrimResultList = attPeriodEntity.getAttRecordTrimResultList();
            if (CollectionUtils.isEmpty(periodAttRecordTrimResultList)) continue;
            attRecordTrimResultList.addAll(periodAttRecordTrimResultList);
        }
        if (!mainDynamicObjects.isEmpty()) {
            for (DynamicObject periodSummaryBaseRecord : mainDynamicObjects) {
                Date lastOpDate;
                long personId = periodSummaryBaseRecord.getLong("personid");
                Date periodEndDate = periodSummaryBaseRecord.getDate("perperiodenddate");
                if (!AttPeriodSummaryCallback.needHandle(deathNameList, personId) || (lastOpDate = deathNameList.get(personId)) != null && periodEndDate.compareTo(lastOpDate) <= 0) continue;
                deathNameList.put(personId, periodEndDate);
            }
        }
        this.saveAttRecordTrimResult(attRecordTrimResultList);
        this.savePeriodTotal((List<DynamicObject>)mainDynamicObjects, (List<DynamicObject>)detailDynamicObjects, tieAttPeriodContext);
        this.saveHisPeriodTotal((List<DynamicObject>)mainHisDynamicObjects, (List<DynamicObject>)detailHisDynamicObjects);
        LOGGER.debug("AttPeriodSummaryServiceImpl_end_version_{}", (Object)version);
    }

    private static boolean needHandle(Map<Long, Date> deathNameList, long personId) {
        if (deathNameList == null) {
            return false;
        }
        return deathNameList.containsKey(personId);
    }

    protected void saveAttRecordTrimResult(List<AttRecordTrimResult> attRecordTrimResultList) {
        if (CollectionUtils.isNotEmpty(attRecordTrimResultList)) {
            periodMoveDetailService.save(this.setData(attRecordTrimResultList));
        }
    }

    private DynamicObjectCollection setData(List<AttRecordTrimResult> attRecordTrimResultList) {
        DynamicObjectCollection dynamicObjectLists = new DynamicObjectCollection();
        if (CollectionUtils.isEmpty(attRecordTrimResultList)) {
            return dynamicObjectLists;
        }
        attRecordTrimResultList.forEach(attRecordTrimResult -> {
            if (attRecordTrimResult != null) {
                DynamicObject adjustDyn = new DynamicObject((DynamicObjectType)adjustRecord);
                AttRecordAdjust attRecordAdjust = attRecordTrimResult.getAttRecordAdjust();
                if (attRecordAdjust != null) {
                    adjustDyn.set("attPeriodId", (Object)attRecordTrimResult.getAttperiodId());
                    AttRecordTrimUtil.builtTrimDy(adjustDyn, attRecordTrimResult);
                    dynamicObjectLists.add((Object)adjustDyn);
                }
            }
        });
        return dynamicObjectLists;
    }

    protected void savePeriodTotal(List<DynamicObject> mainDynamicObjects, List<DynamicObject> detailDynamicObjects, TieAttPeriodContext tieAttPeriodContext) {
        this.beforeSavePeriodDataResult(mainDynamicObjects, detailDynamicObjects, tieAttPeriodContext);
        if (CollectionUtils.isNotEmpty(mainDynamicObjects)) {
            attPeriodSummaryService.save(mainDynamicObjects.toArray(new DynamicObject[0]));
        }
        if (CollectionUtils.isNotEmpty(detailDynamicObjects)) {
            attPeriodDetailSummaryService.save(detailDynamicObjects.toArray(new DynamicObject[0]));
        }
        this.afterSaveAllPerPeriodDataResult(mainDynamicObjects, detailDynamicObjects, tieAttPeriodContext);
    }

    private void beforeSavePeriodDataResult(List<DynamicObject> mainDynamicObjects, List<DynamicObject> detailDynamicObjects, TieAttPeriodContext tieAttPeriodContext) {
        WTCPluginProxyFactory.create(TieSavePerPeriodDataExtPlugin.class, (String)"kd.sdk.wtc.wtes.business.tie.persistent.period.TieSavePerPeriodDataExtPlugin").invokeReplace(instance -> {
            ArrayList tieDataResultRelExtList = new ArrayList(mainDynamicObjects.size());
            Map<Object, List<DynamicObject>> detailObjectListMap = detailDynamicObjects.stream().collect(Collectors.groupingBy(ob -> ob.getLong("attmain")));
            mainDynamicObjects.forEach(mainObject -> {
                TieDataResultExt tieDataResultExt = new TieDataResultExt(TieDataResultUtils.periodMainBlackList, mainObject);
                List dynamicObjects = detailObjectListMap.getOrDefault(mainObject.getLong("id"), Collections.emptyList());
                List tieDataResultExtList = dynamicObjects.stream().map(item -> new TieDataResultExt(TieDataResultUtils.periodDetailBlackList, item)).collect(Collectors.toList());
                TieDataResultRelExt tieDataResultRelExt = new TieDataResultRelExt(tieDataResultExt, tieDataResultExtList);
                tieDataResultRelExtList.add(tieDataResultRelExt);
            });
            BeforeSavePerPeriodDataResultEvent beforeSavePerPeriodDataResultEvent = new BeforeSavePerPeriodDataResultEvent(tieDataResultRelExtList, TiePeriodContextExtUtil.getTieAttPeriodContextExt(tieAttPeriodContext));
            instance.beforeSavePerPeriodDataResult(beforeSavePerPeriodDataResultEvent);
        });
    }

    private void afterSaveAllPerPeriodDataResult(List<DynamicObject> mainDynamicObjects, List<DynamicObject> detailDynamicObjects, TieAttPeriodContext tieAttPeriodContext) {
        WTCPluginProxyFactory.create(TieSaveAllAttPeriodDataExtPlugin.class, (String)"kd.sdk.wtc.wtes.business.tie.persistent.period.TieSaveAllAttPeriodDataExtPlugin").invokeReplace(instance -> {
            ArrayList tieDataResultRelExtList = new ArrayList(mainDynamicObjects.size());
            Map<Object, List<DynamicObject>> detailObjectListMap = detailDynamicObjects.stream().collect(Collectors.groupingBy(ob -> ob.getLong("attmain")));
            mainDynamicObjects.forEach(mainObject -> {
                TieDataResultExt tieDataResultExt = new TieDataResultExt(TieDataResultUtils.periodMainBlackList, mainObject);
                List dynamicObjects = detailObjectListMap.getOrDefault(mainObject.getLong("id"), Collections.emptyList());
                List tieDataResultExtList = dynamicObjects.stream().map(item -> new TieDataResultExt(TieDataResultUtils.periodDetailBlackList, item)).collect(Collectors.toList());
                TieDataResultRelExt tieDataResultRelExt = new TieDataResultRelExt(tieDataResultExt, tieDataResultExtList);
                tieDataResultRelExtList.add(tieDataResultRelExt);
            });
            AfterSaveAllPerPeriodDataResultEvent afterSaveAllPerPeriodDataResultEvent = new AfterSaveAllPerPeriodDataResultEvent(tieDataResultRelExtList, TiePeriodContextExtUtil.getTieAttPeriodContextExt(tieAttPeriodContext));
            instance.afterSaveAllPerPeriodDataResult(afterSaveAllPerPeriodDataResultEvent);
        });
    }

    public AttPeriodSummaryService createEvaluator(TieStepConfig tieStepConfig) {
        String evaluatorName = tieStepConfig.getEvaluatorName();
        AttPeriodSummaryService object = (AttPeriodSummaryService)WTCAppContextHelper.getBean((String)evaluatorName, AttPeriodSummaryService.class);
        return object;
    }

    protected void saveHisPeriodTotal(List<DynamicObject> mainHisDynamicObjects, List<DynamicObject> detailHisDynamicObjects) {
        if (this.isSaveSumHis().booleanValue()) {
            if (CollectionUtils.isNotEmpty(mainHisDynamicObjects)) {
                attPeriodSummaryHisService.save(mainHisDynamicObjects.toArray(new DynamicObject[0]));
            }
            if (CollectionUtils.isNotEmpty(detailHisDynamicObjects)) {
                attPeriodDetailHisSummaryService.save(detailHisDynamicObjects.toArray(new DynamicObject[0]));
            }
        }
    }

    private Boolean isSaveSumHis() {
        return (Boolean)SystemParamQueryUtil.getValueByAppNumAndKey((String)"wtte", (String)"checkboxfield1");
    }
}

