/*
 * Decompiled with CFR 0.152.
 */
package kd.wtc.wtes.business.attperiod;

import java.math.BigDecimal;
import java.math.RoundingMode;
import java.time.LocalDate;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.exception.ErrorCode;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.hr.hbp.business.servicehelper.HRBaseServiceHelper;
import kd.hr.hbp.common.util.HRCollUtil;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.wtc.wtbs.common.enums.AttitemUnitEnum;
import kd.wtc.wtbs.common.model.period.PerAttPeriod;
import kd.wtc.wtbs.common.util.WTCDateUtils;
import kd.wtc.wtbs.common.util.WTCStringUtils;
import kd.wtc.wtbs.common.util.third.collect.Lists;
import kd.wtc.wtbs.common.util.third.collect.Maps;
import kd.wtc.wtbs.common.util.third.collect.Sets;
import kd.wtc.wtes.business.attperiod.AbstractAttPeriodSummary;
import kd.wtc.wtes.business.attperiod.AttPeriodSummaryRequest;
import kd.wtc.wtes.business.attperiod.AttPeriodSummaryService;
import kd.wtc.wtes.business.attperiod.SummaryDataProvider;
import kd.wtc.wtes.business.attperiod.chain.TieAttPeriodContext;
import kd.wtc.wtes.business.executor.rlotcal.PolicyResultHelp;
import kd.wtc.wtes.business.model.AttFileCabinet;
import kd.wtc.wtes.business.model.AttFileModel;
import kd.wtc.wtes.business.model.AttItemSpec;
import kd.wtc.wtes.business.model.AttItemSpecData;
import kd.wtc.wtes.business.model.AttPeriodSpliteModel;
import kd.wtc.wtes.business.model.AttPeriodTable;
import kd.wtc.wtes.business.model.ShiftSpec;
import kd.wtc.wtes.business.model.rlid.IncrDecrConf;
import kd.wtc.wtes.business.model.rlid.IncrDecrConfEntry;
import kd.wtc.wtes.business.model.rlid.IncrDecrPlan;
import kd.wtc.wtes.business.model.rlid.IncrDecrRule;
import kd.wtc.wtes.business.model.util.ParserUtil;
import kd.wtc.wtes.common.constants.TimeConstants;
import kd.wtc.wtes.common.lang.WtesException;
import kd.wtc.wtes.common.util.CollectionUtils;

public class AttPeriodSummaryIncrDecrServiceImpl
extends AbstractAttPeriodSummary
implements AttPeriodSummaryService {
    private static final Log LOG = LogFactory.getLog(AttPeriodSummaryIncrDecrServiceImpl.class);
    private static final String VALUELONG = "valuelong";
    private static final String APPEND = "&&";
    private static final String[] SELECTS = new String[]{"attmain.personid", "attmain.attperattperiodid", "attmain.perattperiodid", "attmain.orgid", "attitemtype", "attitemid", "valuelong", "attmain.perperiodbegindate", "attmain.perperiodenddate", "attitemvid", "attitemid", "owndate", "attmain.jobvid", "attmain.companyvid", "attmain.departmentvid", "attmain.positionvid", "attmain.managescopevid", "attmain.affiliateadminorgvid", "attmain.reckoner", "attmain.attfileid", "attmain.attfilevid"};

    @Override
    public AttPeriodSpliteModel sumBatch(TieAttPeriodContext tieAttPeriodContext, List<AttPeriodSummaryRequest> summaryRequestList, List<AttPeriodSpliteModel> splitModelList) {
        this.saveAttTotal(tieAttPeriodContext, summaryRequestList, splitModelList);
        return null;
    }

    private void saveAttTotal(TieAttPeriodContext tieAttPeriodContext, List<AttPeriodSummaryRequest> summaryRequestList, List<AttPeriodSpliteModel> spliteModelList) {
        LOG.debug("AttPeriodSummaryIncrDecrServiceImpl_beigin_version_{}", (Object)tieAttPeriodContext.getVersion());
        Map<Long, List<PerAttPeriod>> periodMap = tieAttPeriodContext.getPerAttPeriodMap();
        if (CollectionUtils.isEmpty(periodMap)) {
            LOG.warn("AttPeriodSummaryIncrDecrServiceImpl_not_find_PerattPeroid_version_{}", (Object)tieAttPeriodContext.getVersion());
        }
        List<Object> personIds = Lists.newArrayListWithExpectedSize((int)periodMap.size());
        HashSet periodSets = Sets.newHashSetWithExpectedSize((int)periodMap.size());
        for (AttPeriodSummaryRequest request : summaryRequestList) {
            personIds.add(request.getAttPersonId());
            periodSets.addAll(request.getAttPeriodIds());
        }
        personIds = personIds.stream().distinct().collect(Collectors.toList());
        if (LOG.isDebugEnabled()) {
            LOG.debug("AttPeriodSummaryIncrDecrServiceImpl_personIds_{},periodSets_{}", (Object)WTCStringUtils.subStr((String)personIds.toString(), (int)200), (Object)WTCStringUtils.subStr((String)((Object)periodSets).toString(), (int)200));
        }
        SummaryDataProvider summaryDataProvider = tieAttPeriodContext.getSummaryDataProvider();
        List<DynamicObject> recordDys = summaryDataProvider.getSumAttRecords();
        Map<String, Double> sumMap = recordDys.stream().collect(Collectors.groupingBy(dy -> dy.getString("attmain.attperattperiodid") + APPEND + dy.getLong("attitemid"), Collectors.summingDouble(dy -> dy.getBigDecimal(VALUELONG).doubleValue())));
        Map<String, PerAttPeriod> perPeriodMap = this.perAttPeriodMap(summaryRequestList);
        AttFileCabinet attFileCabinet = tieAttPeriodContext.getAttFileCabinet();
        for (Map.Entry<String, PerAttPeriod> entry : perPeriodMap.entrySet()) {
            String period = entry.getKey();
            PerAttPeriod perAttPeriod = entry.getValue();
            Long attPersonId = perAttPeriod.getPersonId();
            LOG.debug("AttPeriodSummaryIncrDecrServiceImpl_attPersonId_{},period_{}", (Object)attPersonId, (Object)period);
            LocalDate chainDate = tieAttPeriodContext.getPeriodData(perAttPeriod);
            AttFileModel attFileModel = attFileCabinet.getByAttPersonIdAndDate((long)attPersonId, chainDate);
            IncrDecrPlan incrDecrPlan = attFileModel.getIncrDecrPlan(chainDate);
            if (incrDecrPlan == null) {
                LOG.warn("AttPeriodSummaryIncrDecrServiceImpl incrDecrPlan is null");
                continue;
            }
            IncrDecrRule rule = this.getIncrDecrRule(tieAttPeriodContext, incrDecrPlan, perAttPeriod);
            if (null == rule) {
                LOG.warn("AttPeriodSummaryIncrDecrServiceImpl rule is null");
                continue;
            }
            List<IncrDecrConf> configList = this.getMatchConfigByIncrDecrRule(rule, chainDate);
            HashMap<Long, BigDecimal> attItemMap = new HashMap<Long, BigDecimal>(configList.size());
            for (IncrDecrConf conf : configList) {
                if (HRStringUtils.equals((String)"1", (String)conf.getSuitType())) continue;
                this.processCondition(conf.getEntry(), attItemMap, sumMap, tieAttPeriodContext, period, perAttPeriod, spliteModelList);
            }
        }
    }

    private void processCondition(List<IncrDecrConfEntry> entry, Map<Long, BigDecimal> attItemMap, Map<String, Double> sumMap, TieAttPeriodContext tieAttPeriodContext, String period, PerAttPeriod perAttPeriod, List<AttPeriodSpliteModel> spliteModelList) {
        LocalDate chainDate = WTCDateUtils.toLocalDate((Date)perAttPeriod.getPerAttBeginDate());
        AttItemSpecData attItemSpecData = tieAttPeriodContext.getAttItemSpecData();
        for (IncrDecrConfEntry confEntry : entry) {
            boolean matchExpress = this.parseExpress(confEntry, attItemMap, period, sumMap);
            if (!matchExpress) continue;
            this.newAttItemValue(spliteModelList, confEntry, perAttPeriod, chainDate, attItemSpecData, attItemMap);
        }
    }

    private boolean parseExpress(IncrDecrConfEntry confEntry, Map<Long, BigDecimal> attItemMap, String period, Map<String, Double> sumMap) {
        boolean matchExpress;
        String relateExpress = confEntry.getRelateExpress();
        for (IncrDecrConfEntry.LimitEntry limitEntry : confEntry.getLimitEntry()) {
            BigDecimal attValue = BigDecimal.ZERO;
            for (Long attItemId : limitEntry.getAttItems()) {
                attValue = attValue.add(this.getAmount(attItemMap, period, attItemId, sumMap));
            }
            String parse = limitEntry.getParser().replaceAll("attValue", attValue.setScale(10, RoundingMode.HALF_UP).toString());
            relateExpress = relateExpress.replaceAll(limitEntry.getLimitNo(), parse);
        }
        try {
            LOG.debug(" IncrDecrEvaluator calculate,relateExpress:{}", (Object)relateExpress);
            matchExpress = new ParserUtil().calculate(relateExpress, null);
        }
        catch (Exception e) {
            throw new WtesException(new ErrorCode("rlid_01", ResManager.loadKDString((String)"\u589e\u51cf\u8ba1\u7b97\u9650\u5236\u6761\u4ef6\u89e3\u6790\u5f02\u5e38\u3002", (String)"IncrDecrEvaluator_2", (String)"wtc-wtes-business", (Object[])new Object[0])), new Object[]{e});
        }
        return matchExpress;
    }

    private void newAttItemValue(List<AttPeriodSpliteModel> spliteModelList, IncrDecrConfEntry entry, PerAttPeriod perAttPeriod, LocalDate chainDate, AttItemSpecData attItemSpecData, Map<Long, BigDecimal> attItemMap) {
        Set attItemIds = entry.getResultEntry().stream().map(IncrDecrConfEntry.ResultEntry::getResultItemId).collect(Collectors.toSet());
        Date date = WTCDateUtils.toDate((LocalDate)chainDate);
        HRBaseServiceHelper serviceHelper = new HRBaseServiceHelper("wtbd_attitem");
        QFilter[] qFilters = new QFilter[]{new QFilter("boid", "in", attItemIds), new QFilter("iscurrentversion", "=", (Object)"0"), new QFilter("itemtype", "in", Arrays.asList("2", "3")), new QFilter("bsed", "<=", (Object)date).and("bsled", ">=", (Object)date)};
        DynamicObject[] attItemDys = serviceHelper.query("id,boid", qFilters);
        Map<Long, List<DynamicObject>> attItemDyMap = Arrays.stream(attItemDys).collect(Collectors.groupingBy(dy -> dy.getLong("boid")));
        for (IncrDecrConfEntry.ResultEntry resultEntry : entry.getResultEntry()) {
            List<DynamicObject> attItemDyList;
            Long attItemId = resultEntry.getResultItemId();
            String incdecRelation = resultEntry.getResultRel();
            BigDecimal amount = resultEntry.getResultValue();
            if (StringUtils.equals((CharSequence)incdecRelation, (CharSequence)"B")) {
                amount = BigDecimal.ZERO.subtract(amount);
            }
            Map<String, Object> map = this.getAttMainId(spliteModelList, perAttPeriod);
            long attMainId = (Long)map.get("attMainId");
            int index = (Integer)map.get("index");
            if (attMainId <= 0L) continue;
            BigDecimal cacheAmount = attItemMap.get(attItemId);
            if (null != cacheAmount) {
                amount = amount.add(cacheAmount);
            }
            if (!HRCollUtil.isNotEmpty(attItemDyList = attItemDyMap.get(attItemId))) continue;
            DynamicObject attItemDy = attItemDyList.get(0);
            DynamicObject resDyn = BusinessDataServiceHelper.newDynamicObject((String)"wtctd_atttotaldetail");
            resDyn.set("attmain", (Object)attMainId);
            resDyn.set(VALUELONG, (Object)amount);
            resDyn.set("perattperiodid", (Object)perAttPeriod.getAttPeriodId());
            AttItemSpec attItemSpec = attItemSpecData.getByBidAndDate(attItemId, chainDate);
            resDyn.set("attitemtype", (Object)(attItemSpec.isOriginalItem() ? "0" : "1"));
            resDyn.set("attitemid", attItemDy.get("boid"));
            resDyn.set("attitemvid", attItemDy.get("id"));
            AttPeriodSpliteModel model = spliteModelList.get(index);
            DynamicObjectCollection collection = model.getDetailDynamicObjects();
            Iterator iterator = collection.iterator();
            while (iterator.hasNext()) {
                boolean sameAttItemId;
                DynamicObject dy2 = (DynamicObject)iterator.next();
                boolean sameAttMainId = dy2.getLong("attmain") == attMainId;
                boolean samePerAttPeriodId = dy2.getLong("perattperiodid") == perAttPeriod.getAttPeriodId().longValue();
                boolean bl = sameAttItemId = dy2.getLong("attitemid") == attItemId.longValue();
                if (!sameAttMainId || !samePerAttPeriodId || !sameAttItemId) continue;
                iterator.remove();
            }
            model.getDetailDynamicObjects().add((Object)resDyn);
            attItemMap.put(attItemId, amount);
        }
    }

    private Map<String, Object> getAttMainId(List<AttPeriodSpliteModel> spliteModelList, PerAttPeriod perAttPeriod) {
        HashMap<String, Object> map = new HashMap<String, Object>(4);
        long attMainId = 0L;
        for (AttPeriodSpliteModel model : spliteModelList) {
            DynamicObjectCollection mainDynamicObjects = model.getMainDynamicObjects();
            for (DynamicObject mainDy : mainDynamicObjects) {
                boolean samePerAttPeriodId;
                boolean sameAttPersonId = mainDy.getLong("personid") == perAttPeriod.getPersonId().longValue();
                boolean sameAttPerAttPeriodId = HRStringUtils.equalsIgnoreCase((String)mainDy.getString("attperattperiodid"), (String)perAttPeriod.getId());
                boolean bl = samePerAttPeriodId = mainDy.getLong("perattperiodid") == perAttPeriod.getAttPeriodId().longValue();
                if (!sameAttPerAttPeriodId || !sameAttPersonId || !samePerAttPeriodId) continue;
                attMainId = mainDy.getLong("id");
                int index = spliteModelList.indexOf(model);
                map.put("index", index);
                map.put("attMainId", attMainId);
                break;
            }
            if (attMainId <= 0L) continue;
            break;
        }
        return map;
    }

    private BigDecimal getAmount(Map<Long, BigDecimal> attItemMap, String period, Long attItemId, Map<String, Double> sumMap) {
        String key;
        Double amountDouble;
        BigDecimal cacheAmount = attItemMap.get(attItemId);
        BigDecimal amount = null != cacheAmount ? cacheAmount : BigDecimal.valueOf((amountDouble = sumMap.get(key = period + APPEND + attItemId)) == null ? 0.0 : amountDouble);
        return amount;
    }

    private static BigDecimal scale(BigDecimal value, int dataAccuracy, BigDecimal scale) {
        return value.divide(scale, dataAccuracy, RoundingMode.HALF_UP);
    }

    private BigDecimal getSecond(String unit, BigDecimal amount, ShiftSpec shiftSpec) {
        if (AttitemUnitEnum.DAY.getUnit().equals(unit)) {
            return shiftSpec.daysToSecondDecimal(amount);
        }
        if (AttitemUnitEnum.HOUR.getUnit().equals(unit)) {
            return amount.multiply(TimeConstants.SECOND_OF_ONE_HOUR_DECIMAL);
        }
        if (AttitemUnitEnum.MINUTE.getUnit().equals(unit)) {
            return amount.multiply(TimeConstants.SECOND_OF_ONE_MINUTE_DECIMAL);
        }
        return amount;
    }

    public Map<String, PerAttPeriod> getPerAttPeriodMap(AttPeriodTable attPeriodTable) {
        Map<Long, List<PerAttPeriod>> periodMap = attPeriodTable.getPerAttPeriodMap();
        HashMap perPeriodMap = Maps.newHashMapWithExpectedSize((int)periodMap.size());
        for (Map.Entry<Long, List<PerAttPeriod>> entry : periodMap.entrySet()) {
            for (PerAttPeriod perAttPeriod : entry.getValue()) {
                perPeriodMap.put(perAttPeriod.getId(), perAttPeriod);
            }
        }
        return perPeriodMap;
    }

    private List<DynamicObject> queryAttRecordData(Date startDate, Date endDate, List<Long> attFIleBoIds) {
        HRBaseServiceHelper attRecordDetailService = new HRBaseServiceHelper("wtdtd_attrecorddetail");
        QFilter[] qFilters = new QFilter[]{new QFilter("attmain.owndate", ">=", (Object)startDate), new QFilter("attmain.owndate", "<=", (Object)endDate), new QFilter("attmain.attfileid", "in", attFIleBoIds), new QFilter("attitemid.itemtype", "in", Arrays.asList("2", "3"))};
        return Arrays.asList(attRecordDetailService.query(String.join((CharSequence)",", SELECTS), qFilters));
    }

    private List<IncrDecrConf> getMatchConfigByIncrDecrRule(IncrDecrRule rule, LocalDate chainDate) {
        LinkedList<IncrDecrConf> configList = new LinkedList<IncrDecrConf>();
        List<IncrDecrRule.Tuple> tuples = rule.getEntities();
        for (IncrDecrRule.Tuple tuple : tuples) {
            IncrDecrConf incrDecrConf = (IncrDecrConf)tuple.getIncrDecrConfBo().getVersionByDate(chainDate);
            if (null == incrDecrConf) continue;
            configList.add(incrDecrConf);
        }
        return configList;
    }

    private IncrDecrRule getIncrDecrRule(TieAttPeriodContext tieAttPeriodContext, IncrDecrPlan incrDecrPlan, PerAttPeriod perAttPeriod) {
        IncrDecrRule rule = HRStringUtils.equalsIgnoreCase((String)"2", (String)incrDecrPlan.getSetRuleWay()) ? PolicyResultHelp.getIncrRuleEngineRule(tieAttPeriodContext, incrDecrPlan, perAttPeriod) : (IncrDecrRule)incrDecrPlan.getIncrDecrRule().getVersionByDate(tieAttPeriodContext.getPeriodData(perAttPeriod));
        return rule;
    }
}

