/*
 * Decompiled with CFR 0.152.
 */
package kd.wtc.wtes.business.attperiod;

import java.time.LocalDate;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.db.DB;
import kd.bos.entity.MainEntityType;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.MetadataServiceHelper;
import kd.wtc.wtbs.common.model.period.PerAttPeriod;
import kd.wtc.wtbs.common.util.third.collect.Lists;
import kd.wtc.wtbs.common.util.third.collect.Maps;
import kd.wtc.wtbs.common.util.third.collect.Sets;
import kd.wtc.wtes.business.attperiod.AbstractAttPeriodSummary;
import kd.wtc.wtes.business.attperiod.AttPeriodSummaryRequest;
import kd.wtc.wtes.business.attperiod.AttPeriodSummaryService;
import kd.wtc.wtes.business.attperiod.PeriodBuryPointService;
import kd.wtc.wtes.business.attperiod.SummaryDataProvider;
import kd.wtc.wtes.business.attperiod.chain.TieAttPeriodContext;
import kd.wtc.wtes.business.model.AttFileModel;
import kd.wtc.wtes.business.model.AttPeriodSpliteModel;
import kd.wtc.wtes.business.model.AttPeriodTable;
import kd.wtc.wtes.business.model.attendperson.AttendPersonModel;
import kd.wtc.wtes.business.util.PeriodContextUtil;
import kd.wtc.wtes.common.util.CollectionUtils;

public class AttPeriodSummaryServiceImpl
extends AbstractAttPeriodSummary
implements AttPeriodSummaryService {
    private static final Log LOGGER = LogFactory.getLog(AttPeriodSummaryServiceImpl.class);
    private static final String VALUELONG = "valuelong";
    private static final String STR_VERSION = "versionid";
    private static final String APPEND = "&&";

    @Override
    public AttPeriodSpliteModel sumBatch(TieAttPeriodContext tieAttPeriodContext, List<AttPeriodSummaryRequest> attPeriodSummaryRequestList, List<AttPeriodSpliteModel> attPeriodSpliteModelList) {
        return this.saveAttTotal(tieAttPeriodContext, attPeriodSummaryRequestList);
    }

    private AttPeriodSpliteModel saveAttTotal(TieAttPeriodContext tieAttPeriodContext, List<AttPeriodSummaryRequest> attPeriodSummaryRequestList) {
        LOGGER.debug("AttPeriodSummaryServiceImpl_beigin_version_{}", (Object)tieAttPeriodContext.getVersion());
        Map<Long, List<PerAttPeriod>> periodMap = tieAttPeriodContext.getPerAttPeriodMap();
        if (CollectionUtils.isEmpty(periodMap)) {
            LOGGER.debug("AttPeriodSummaryServiceImpl_not_find_PerattPeroid_version_{}", (Object)tieAttPeriodContext.getVersion());
        }
        List<Object> personIds = Lists.newArrayListWithExpectedSize((int)periodMap.size());
        HashSet periodSets = Sets.newHashSetWithExpectedSize((int)periodMap.size());
        HashSet attfileBoids = Sets.newHashSetWithExpectedSize((int)periodMap.size());
        for (AttPeriodSummaryRequest request : attPeriodSummaryRequestList) {
            personIds.add(request.getAttPersonId());
            periodSets.addAll(request.getAttPeriodIds());
            attfileBoids.addAll(request.getAttFileBoId());
        }
        personIds = personIds.stream().distinct().collect(Collectors.toList());
        SummaryDataProvider summaryDataProvider = tieAttPeriodContext.getSummaryDataProvider();
        List<DynamicObject> recordList = summaryDataProvider.getSumAttRecords();
        AttPeriodSpliteModel attPeriodSpliteModel = this.groupAndTransToDy(tieAttPeriodContext, recordList, personIds);
        if (attPeriodSpliteModel == null) {
            LOGGER.warn("AttPeriodSummaryServiceImpl_not_find_date_periodSet_{};personIds_{}", (Object)periodSets, (Object)personIds);
        } else {
            PeriodBuryPointService.getInstance().dealPeriodBuryPoint(tieAttPeriodContext, attPeriodSpliteModel);
        }
        return attPeriodSpliteModel;
    }

    private AttPeriodSpliteModel groupAndTransToDy(TieAttPeriodContext tieAttPeriodContext, List<DynamicObject> recordList, List<Long> personIds) {
        Map<String, Double> sumMap = recordList.stream().collect(Collectors.groupingBy(dy -> dy.getString("attmain.attperattperiodid") + APPEND + dy.getString("attitemid"), Collectors.summingDouble(dy -> dy.getBigDecimal(VALUELONG).doubleValue())));
        Map<String, Optional<DynamicObject>> attItemMap = recordList.stream().collect(Collectors.groupingBy(dy -> dy.getString("attmain.attperattperiodid") + APPEND + dy.getString("attitemid"), Collectors.maxBy(Comparator.comparingLong(dy -> dy.getLong("attitemvid")))));
        AttPeriodTable attPeriodTable = tieAttPeriodContext.getAttPeriodTable();
        Map<String, PerAttPeriod> perPeriodMap = this.getPerAttPeriodMap(attPeriodTable);
        HashMap mainPerattperiodIdMap = Maps.newHashMapWithExpectedSize((int)16);
        DynamicObjectCollection mainDynamicObjects = new DynamicObjectCollection();
        DynamicObjectCollection detailDynamicObjects = new DynamicObjectCollection();
        long[] genLongIds = DB.genLongIds((String)"wtctd_atttotalbase", (int)sumMap.size());
        int num = 0;
        MainEntityType mainEntityType = MetadataServiceHelper.getDataEntityType((String)"wtctd_atttotalbase");
        for (Map.Entry<String, Double> entry : sumMap.entrySet()) {
            String perPeriodId = entry.getKey().split(APPEND)[0];
            PerAttPeriod perAttPeriod = perPeriodMap.get(perPeriodId);
            if (perAttPeriod == null) {
                LOGGER.warn("AttPeriodSummaryServiceImpl_not_find_perAttPeriod_{}", (Object)perPeriodId);
                continue;
            }
            AttFileModel attFileModel = tieAttPeriodContext.getAttFileModelById(perAttPeriod.getPersonId(), perAttPeriod.getFileId());
            if (attFileModel == null) {
                LOGGER.warn("AttPeriodSummaryServiceImpl_not_find_attFileId={},attFileMap={}", (Object)perAttPeriod.getFileId(), (Object)perAttPeriod.getPersonId());
                continue;
            }
            LocalDate endDate = tieAttPeriodContext.getPeriodData(perAttPeriod, attFileModel);
            AttendPersonModel personModel = tieAttPeriodContext.getAttendPersonModel(attFileModel, endDate);
            if (personModel == null) {
                LOGGER.warn("AttPeriodSummaryServiceImpl_not_find_personModel_personId={},endDate={}", (Object)perAttPeriod.getPersonId(), (Object)endDate);
                continue;
            }
            if (null == mainPerattperiodIdMap.get(perPeriodId)) {
                DynamicObject baseAttTotalDy = PeriodContextUtil.getBaseAttTotalData(tieAttPeriodContext, perAttPeriod, personModel, attFileModel, mainEntityType);
                long id = genLongIds[num];
                baseAttTotalDy.set("id", (Object)id);
                mainDynamicObjects.add((Object)baseAttTotalDy);
                mainPerattperiodIdMap.put(perPeriodId, id);
                ++num;
            }
            DynamicObject deatilAttTotalDy = this.getDeatilAttTotalData(mainPerattperiodIdMap.get(perPeriodId), entry, perAttPeriod, attItemMap);
            detailDynamicObjects.add((Object)deatilAttTotalDy);
        }
        if (mainDynamicObjects.isEmpty()) {
            LOGGER.warn("AttPeriodSummaryServiceImpl_not_find_data_version={},personIds={},recordList.size={}", new Object[]{tieAttPeriodContext.getVersion(), personIds, recordList.size()});
            return null;
        }
        return new AttPeriodSpliteModel(mainDynamicObjects, detailDynamicObjects);
    }

    public Map<String, PerAttPeriod> getPerAttPeriodMap(AttPeriodTable attPeriodTable) {
        Map<Long, List<PerAttPeriod>> periodMap = attPeriodTable.getPerAttPeriodMap();
        HashMap perPeriodMap = Maps.newHashMapWithExpectedSize((int)periodMap.size());
        for (Map.Entry<Long, List<PerAttPeriod>> entry : periodMap.entrySet()) {
            for (PerAttPeriod perAttPeriod : entry.getValue()) {
                perPeriodMap.put(perAttPeriod.getId(), perAttPeriod);
            }
        }
        return perPeriodMap;
    }

    private DynamicObject getDeatilAttTotalData(Object attMainId, Map.Entry<String, Double> entry, PerAttPeriod perAttPeriod, Map<String, Optional<DynamicObject>> attItemMap) {
        DynamicObject attItem;
        DynamicObject resDyn = BusinessDataServiceHelper.newDynamicObject((String)"wtctd_atttotaldetail");
        resDyn.set("attmain", attMainId);
        resDyn.set(VALUELONG, (Object)entry.getValue());
        resDyn.set("perattperiodid", (Object)perAttPeriod.getAttPeriodId());
        Optional<DynamicObject> optional = attItemMap.get(entry.getKey());
        DynamicObject dynamicObject = attItem = optional.isPresent() ? optional.get() : null;
        if (attItem != null) {
            resDyn.set("attitemtype", attItem.get("attitemtype"));
            resDyn.set("attitemid", (Object)attItem.getLong("attitemid"));
            resDyn.set("attitemvid", (Object)attItem.getLong("attitemvid"));
        }
        return resDyn;
    }
}

