/*
 * Decompiled with CFR 0.152.
 */
package kd.wtc.wtes.business.attperiod;

import java.math.BigDecimal;
import java.time.LocalDate;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.db.DB;
import kd.bos.entity.MainEntityType;
import kd.bos.exception.KDBizException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.MetadataServiceHelper;
import kd.sdk.wtc.wtes.business.tie.exexutor.period.TieAttPeriodEvaluatorExt;
import kd.sdk.wtc.wtes.business.tie.exexutor.period.TieExecPerPeriodSummaryExtPlugin;
import kd.sdk.wtc.wtes.business.tie.model.attitem.AttItemSpecExt;
import kd.sdk.wtc.wtes.business.tie.model.attitem.PeriodAttItemInstanceExt;
import kd.wtc.wtbs.business.extplugin.WTCPluginProxy;
import kd.wtc.wtbs.business.extplugin.WTCPluginProxyFactory;
import kd.wtc.wtbs.business.timeseq.AbstractTimeSeqVersion;
import kd.wtc.wtbs.common.model.period.PerAttPeriod;
import kd.wtc.wtbs.common.util.WTCCollections;
import kd.wtc.wtbs.common.util.WTCDateUtils;
import kd.wtc.wtbs.common.util.third.collect.Maps;
import kd.wtc.wtes.business.attperiod.chain.TieAttPeriodContext;
import kd.wtc.wtes.business.ext.model.attitem.AttItemSpecExtImpl;
import kd.wtc.wtes.business.ext.utils.TiePeriodContextExtUtil;
import kd.wtc.wtes.business.model.AttFileModel;
import kd.wtc.wtes.business.model.AttItemSpec;
import kd.wtc.wtes.business.model.AttItemSpecData;
import kd.wtc.wtes.business.model.AttPeriodSpliteModel;
import kd.wtc.wtes.business.model.attendperson.AttendPersonModel;
import kd.wtc.wtes.business.util.PeriodContextUtil;

class PeriodBuryPointService {
    private final Log LOGGER = LogFactory.getLog(PeriodBuryPointService.class);
    private static PeriodBuryPointService periodBuryPointService = new PeriodBuryPointService();

    private PeriodBuryPointService() {
    }

    public static PeriodBuryPointService getInstance() {
        return periodBuryPointService;
    }

    public void dealPeriodBuryPoint(TieAttPeriodContext tieAttPeriodContext, AttPeriodSpliteModel attPeriodSpliteModel) {
        if (attPeriodSpliteModel == null) {
            return;
        }
        WTCPluginProxy wtcPluginProxy = WTCPluginProxyFactory.create(TieExecPerPeriodSummaryExtPlugin.class, (String)TieExecPerPeriodSummaryExtPlugin.class.getName());
        if (wtcPluginProxy.hasPlugin()) {
            wtcPluginProxy.invokeReplace(wtcPlugin -> {
                AttItemSpecData attItemSpecData = tieAttPeriodContext.getAttItemSpecData();
                Map<Long, Map<Long, DynamicObject>> detailAttitemMap = this.groupDetailByattPeriodAttitem(attPeriodSpliteModel);
                Map<Long, List<DynamicObject>> mainMap = attPeriodSpliteModel.getMainDynamicObjects().stream().collect(Collectors.groupingBy(ob -> ob.getLong("attperattperiodpk")));
                Map<Long, AttItemSpec> attitemMap = attItemSpecData.getPeriodAttitemList().stream().collect(Collectors.toMap(AbstractTimeSeqVersion::getId, attItemSpec -> attItemSpec));
                Map<Long, List<PeriodAttItemInstanceExt>> tieAttPeriodItemInstanceExtMap = this.builtAttitemInfoInputMap(mainMap, detailAttitemMap, attitemMap);
                this.LOGGER.debug("hrPlugin.class.name\uff1a{} doEvaluate inputParam\uff1a{}", (Object)wtcPlugin.getClass().getName(), tieAttPeriodItemInstanceExtMap);
                Map attitemInfoMap = wtcPlugin.afterExecPerPeriodSummary(TiePeriodContextExtUtil.getTieAttPeriodContextExt(tieAttPeriodContext), tieAttPeriodItemInstanceExtMap);
                if (WTCCollections.isEmpty((Map)attitemInfoMap)) {
                    return;
                }
                this.LOGGER.debug("doEvaluate outParam\uff1a{}", (Object)attitemInfoMap);
                List<PerAttPeriod> perAttPeriodList = tieAttPeriodContext.getPerAttPeriodList();
                Map<Long, PerAttPeriod> perAttPeriodMap = perAttPeriodList.stream().collect(Collectors.toMap(PerAttPeriod::getPrimaryId, perAttPeriod -> perAttPeriod));
                Map<Long, List<AttItemSpec>> groupAttitemMap = this.groupAttitemByPerAttPeriodId(perAttPeriodMap, attitemMap);
                this.valiteParam(attitemInfoMap, groupAttitemMap, perAttPeriodMap);
                AttPeriodSpliteModel buryAttPeriodSpliteModel = this.builtPeriodModel(tieAttPeriodContext, attitemMap, attitemInfoMap, mainMap, detailAttitemMap);
                attPeriodSpliteModel.getMainDynamicObjects().addAll((Collection)buryAttPeriodSpliteModel.getMainDynamicObjects());
                attPeriodSpliteModel.getDetailDynamicObjects().addAll((Collection)buryAttPeriodSpliteModel.getDetailDynamicObjects());
            });
        }
    }

    public AttPeriodSpliteModel dealExtendPeriodBuryPoint(TieAttPeriodEvaluatorExt tieAttPeriodEvaluatorExt, TieAttPeriodContext tieAttPeriodContext, AttPeriodSpliteModel attPeriodSpliteModel) {
        DynamicObjectCollection detailAttitemCollect = new DynamicObjectCollection();
        DynamicObjectCollection mainAttitemCollect = new DynamicObjectCollection();
        AttItemSpecData attItemSpecData = tieAttPeriodContext.getAttItemSpecData();
        Map<Long, Map<Long, DynamicObject>> detailAttitemMap = this.groupDetailByattPeriodAttitem(attPeriodSpliteModel);
        Map<Long, List<DynamicObject>> mainMap = attPeriodSpliteModel.getMainDynamicObjects().stream().collect(Collectors.groupingBy(ob -> ob.getLong("attperattperiodpk")));
        Map<Long, AttItemSpec> attitemMap = attItemSpecData.getPeriodAttitemList().stream().collect(Collectors.toMap(AbstractTimeSeqVersion::getId, attItemSpec -> attItemSpec));
        Map<Long, List<PeriodAttItemInstanceExt>> periodItemInstanceExtMap = this.builtAttitemInfoInputMap(mainMap, detailAttitemMap, attitemMap);
        if (tieAttPeriodEvaluatorExt == null) {
            return new AttPeriodSpliteModel(mainAttitemCollect, detailAttitemCollect);
        }
        this.LOGGER.debug("tieAttPeriodEvaluatorExt doEvaluate inputParam\uff1a{}", periodItemInstanceExtMap);
        Map attitemInfoMap = tieAttPeriodEvaluatorExt.doEvaluate(TiePeriodContextExtUtil.getTieAttPeriodContextExt(tieAttPeriodContext), periodItemInstanceExtMap);
        if (WTCCollections.isEmpty((Map)attitemInfoMap)) {
            return new AttPeriodSpliteModel(mainAttitemCollect, detailAttitemCollect);
        }
        this.LOGGER.debug("tieAttPeriodEvaluatorExt doEvaluate doputParam\uff1a{}", (Object)attitemInfoMap);
        List<PerAttPeriod> perAttPeriodList = tieAttPeriodContext.getPerAttPeriodList();
        Map<Long, PerAttPeriod> perAttPeriodMap = perAttPeriodList.stream().collect(Collectors.toMap(PerAttPeriod::getPrimaryId, perAttPeriod -> perAttPeriod));
        Map<Long, List<AttItemSpec>> groupAttitemMap = this.groupAttitemByPerAttPeriodId(perAttPeriodMap, attitemMap);
        this.valiteParam(attitemInfoMap, groupAttitemMap, perAttPeriodMap);
        return this.builtPeriodLastPhaseModel(tieAttPeriodContext, attitemMap, attitemInfoMap, mainMap, detailAttitemMap);
    }

    private AttPeriodSpliteModel builtPeriodModel(TieAttPeriodContext tieAttPeriodContext, Map<Long, AttItemSpec> attitemMap, Map<Long, List<PeriodAttItemInstanceExt>> attitemInfoMap, Map<Long, List<DynamicObject>> groupMainObject, Map<Long, Map<Long, DynamicObject>> detailAttitemMap) {
        List<PerAttPeriod> perAttPeriodList = tieAttPeriodContext.getPerAttPeriodList();
        Map<Long, PerAttPeriod> perAttPeriodMap = perAttPeriodList.stream().collect(Collectors.toMap(PerAttPeriod::getPrimaryId, perAttPeriod -> perAttPeriod));
        DynamicObjectCollection detailAttitemCollect = new DynamicObjectCollection();
        DynamicObjectCollection mainAttitemCollect = new DynamicObjectCollection();
        long[] genLongIds = DB.genLongIds((String)"wtctd_atttotalbase", (int)attitemInfoMap.size());
        int num = 0;
        MainEntityType mainEntityType = MetadataServiceHelper.getDataEntityType((String)"wtctd_atttotalbase");
        for (Map.Entry<Long, List<PeriodAttItemInstanceExt>> attitemEntry : attitemInfoMap.entrySet()) {
            DynamicObject main;
            Long attPerAttPeriodId = attitemEntry.getKey();
            List<DynamicObject> mainList = groupMainObject.get(attPerAttPeriodId);
            if (WTCCollections.isEmpty(mainList)) {
                PerAttPeriod perAttPeriod2 = perAttPeriodMap.get(attPerAttPeriodId);
                main = this.builtNewMainDyn(perAttPeriod2, tieAttPeriodContext, mainEntityType);
                if (main == null) continue;
                main.set("id", (Object)genLongIds[num]);
                mainAttitemCollect.add((Object)main);
            } else {
                main = mainList.get(0);
            }
            Map<Long, DynamicObject> detailMap = detailAttitemMap.get(attPerAttPeriodId);
            if (WTCCollections.isEmpty(detailMap)) continue;
            List<PeriodAttItemInstanceExt> attitemInfoList = attitemEntry.getValue();
            HashMap valueMap = Maps.newHashMapWithExpectedSize((int)16);
            for (PeriodAttItemInstanceExt attitemInfo : attitemInfoList) {
                Long attitemVid2 = attitemInfo.getAttItemSpecExt().getId();
                valueMap.put(attitemVid2, attitemInfo.getItemValue().add(valueMap.getOrDefault(attitemVid2, BigDecimal.ZERO)));
            }
            Long attPeriodId = main.getLong("perattperiodid");
            valueMap.forEach((attitemVid, value) -> {
                DynamicObject detail = (DynamicObject)detailMap.get(attitemVid);
                if (detail == null) {
                    DynamicObject newDetail = this.attitemInfoTranToDeatilDyn((Long)attitemVid, (BigDecimal)value, main, attPeriodId, attitemMap);
                    detailAttitemCollect.add((Object)newDetail);
                } else {
                    detail.set("valuelong", (Object)value.add(detail.getBigDecimal("valuelong")));
                }
            });
        }
        return new AttPeriodSpliteModel(mainAttitemCollect, detailAttitemCollect);
    }

    private AttPeriodSpliteModel builtPeriodLastPhaseModel(TieAttPeriodContext tieAttPeriodContext, Map<Long, AttItemSpec> attitemMap, Map<Long, List<PeriodAttItemInstanceExt>> attitemInfoMap, Map<Long, List<DynamicObject>> groupMainObject, Map<Long, Map<Long, DynamicObject>> detailAttitemMap) {
        DynamicObjectCollection mainDynamicObjects = new DynamicObjectCollection();
        DynamicObjectCollection detailDynamicObjects = new DynamicObjectCollection();
        long[] genLongIds = DB.genLongIds((String)"wtctd_atttotalbase", (int)attitemInfoMap.size());
        int num = 0;
        MainEntityType mainEntityType = MetadataServiceHelper.getDataEntityType((String)"wtctd_atttotalbase");
        for (Map.Entry<Long, List<PeriodAttItemInstanceExt>> attitemEntry : attitemInfoMap.entrySet()) {
            DynamicObject main;
            Long attPerAttPeriodId = attitemEntry.getKey();
            List<DynamicObject> mainList = groupMainObject.get(attPerAttPeriodId);
            if (WTCCollections.isEmpty(mainList)) {
                PerAttPeriod perAttPeriod = tieAttPeriodContext.getPerAttPeriodByPrimaryId(attPerAttPeriodId);
                main = this.builtNewMainDyn(perAttPeriod, tieAttPeriodContext, mainEntityType);
                if (main == null) continue;
                main.set("id", (Object)genLongIds[num]);
                ++num;
            } else {
                main = mainList.get(0);
            }
            Map<Long, DynamicObject> detailMap = detailAttitemMap.get(attPerAttPeriodId);
            if (WTCCollections.isEmpty(detailMap)) continue;
            List<PeriodAttItemInstanceExt> attitemInfoList = attitemEntry.getValue();
            HashMap valueMap = Maps.newHashMapWithExpectedSize((int)16);
            for (PeriodAttItemInstanceExt attitemInfo : attitemInfoList) {
                Long attitemVid2 = attitemInfo.getAttItemSpecExt().getId();
                valueMap.put(attitemVid2, attitemInfo.getItemValue().add(valueMap.getOrDefault(attitemVid2, BigDecimal.ZERO)));
            }
            Long attPeriodId = main.getLong("perattperiodid");
            valueMap.forEach((attitemVid, value) -> {
                DynamicObject newDetail = this.attitemInfoTranToDeatilDyn((Long)attitemVid, (BigDecimal)value, main, attPeriodId, attitemMap);
                detailDynamicObjects.add((Object)newDetail);
                mainDynamicObjects.add((Object)main);
            });
        }
        return new AttPeriodSpliteModel(mainDynamicObjects, detailDynamicObjects);
    }

    private Map<Long, List<AttItemSpec>> groupAttitemByPerAttPeriodId(Map<Long, PerAttPeriod> perAttPeriodMap, Map<Long, AttItemSpec> attitemMap) {
        HashMap groupAttitemMap = Maps.newHashMapWithExpectedSize((int)16);
        for (Map.Entry<Long, PerAttPeriod> entry : perAttPeriodMap.entrySet()) {
            PerAttPeriod perAttPeriod = entry.getValue();
            if (perAttPeriod == null) continue;
            List attItemSpecList = groupAttitemMap.computeIfAbsent(perAttPeriod.getPrimaryId(), key -> new ArrayList());
            LocalDate perAttBeginDate = WTCDateUtils.toLocalDate((Date)perAttPeriod.getPerAttBeginDate());
            LocalDate perAttEndDate = WTCDateUtils.toLocalDate((Date)perAttPeriod.getPerAttEndDate());
            attitemMap.forEach((vid, attItemSpec) -> {
                if (attItemSpec.getTimeSeqInfo().getBsed().compareTo(perAttEndDate) <= 0 && attItemSpec.getTimeSeqInfo().getBlsed().compareTo(perAttBeginDate) >= 0) {
                    attItemSpecList.add(attItemSpec);
                }
            });
        }
        return groupAttitemMap;
    }

    private void valiteParam(Map<Long, List<PeriodAttItemInstanceExt>> attitemInfoMap, Map<Long, List<AttItemSpec>> groutAttitemMap, Map<Long, PerAttPeriod> perAttPeriodMap) {
        for (Map.Entry<Long, List<PeriodAttItemInstanceExt>> attitemEntry : attitemInfoMap.entrySet()) {
            Long attPerAttPeriodId = attitemEntry.getKey();
            PerAttPeriod perAttPeriod = perAttPeriodMap.get(attPerAttPeriodId);
            if (perAttPeriod == null) {
                throw new KDBizException(ResManager.loadKDString((String)"\u4eba\u5458\u8003\u52e4\u671f\u95f4{0}\u4e0d\u5b58\u5728!", (String)"PeriodBuryPointContextUtil_01", (String)"wtc-wtes-formplugin", (Object[])new Object[]{attPerAttPeriodId}));
            }
            List<PeriodAttItemInstanceExt> attitemInfoList = attitemEntry.getValue();
            List<AttItemSpec> attItemSpecList = groutAttitemMap.get(attPerAttPeriodId);
            if (WTCCollections.isEmpty(attItemSpecList)) {
                throw new KDBizException(ResManager.loadKDString((String)"\u4eba\u5458\u8003\u52e4\u671f\u95f4{attPerAttPeriodId}\u5185\u9879\u76ee\u4e0d\u5b58\u5728!", (String)"PeriodBuryPointContextUtil_02", (String)"wtc-wtes-formplugin", (Object[])new Object[]{attPerAttPeriodId}));
            }
            Map<Long, AttItemSpec> attitemMap = attItemSpecList.stream().collect(Collectors.toMap(AbstractTimeSeqVersion::getId, ob -> ob));
            for (PeriodAttItemInstanceExt attitemInfo : attitemInfoList) {
                Long attitemVid = attitemInfo.getAttItemSpecExt().getId();
                AttItemSpec attItemSpec = attitemMap.get(attitemVid);
                if (attItemSpec != null) continue;
                throw new KDBizException(ResManager.loadKDString((String)"\u8003\u52e4\u9879\u76ee{0}\u4e0d\u5b58\u5728!", (String)"PeriodBuryPointContextUtil_03", (String)"wtc-wtes-formplugin", (Object[])new Object[]{attitemVid}));
            }
        }
    }

    private Map<Long, List<PeriodAttItemInstanceExt>> builtAttitemInfoInputMap(Map<Long, List<DynamicObject>> mainMap, Map<Long, Map<Long, DynamicObject>> detailAttitemMap, Map<Long, AttItemSpec> attitemMap) {
        HashMap periodAttItemInstanceExtMap = Maps.newHashMapWithExpectedSize((int)16);
        for (Map.Entry<Long, List<DynamicObject>> entry : mainMap.entrySet()) {
            Long attPerAttPeriodId = entry.getKey();
            Map<Long, DynamicObject> detailMap = detailAttitemMap.get(attPerAttPeriodId);
            if (WTCCollections.isEmpty(detailMap)) continue;
            List tieAttPeriodItemInstanceExtList = periodAttItemInstanceExtMap.computeIfAbsent(attPerAttPeriodId, key -> new ArrayList());
            detailMap.forEach((attitemVid, detail) -> tieAttPeriodItemInstanceExtList.add(new PeriodAttItemInstanceExt((AttItemSpecExt)new AttItemSpecExtImpl((AttItemSpec)((Object)((Object)attitemMap.get(attitemVid)))), detail.getBigDecimal("valuelong"))));
        }
        return periodAttItemInstanceExtMap;
    }

    private Map<Long, Map<Long, DynamicObject>> groupDetailByattPeriodAttitem(AttPeriodSpliteModel attPeriodSpliteModel) {
        DynamicObjectCollection mainDynamicObjects = attPeriodSpliteModel.getMainDynamicObjects();
        DynamicObjectCollection detailDynamicObjects = attPeriodSpliteModel.getDetailDynamicObjects();
        Map<Long, List<DynamicObject>> detailMainMap = detailDynamicObjects.stream().collect(Collectors.groupingBy(ob -> ob.getLong("attmain")));
        Map<Long, List<DynamicObject>> mainMap = mainDynamicObjects.stream().collect(Collectors.groupingBy(ob -> ob.getLong("attperattperiodpk")));
        HashMap detailAttitemMap = Maps.newHashMapWithExpectedSize((int)16);
        mainMap.forEach((attperattPeriodId, entry) -> {
            Map detailAttitemValueMap = detailAttitemMap.computeIfAbsent(attperattPeriodId, key -> new HashMap());
            for (DynamicObject dynamicObject : entry) {
                Long id = dynamicObject.getLong("id");
                List details = (List)detailMainMap.get(id);
                if (WTCCollections.isEmpty((Collection)details)) continue;
                for (DynamicObject detail : details) {
                    detailAttitemValueMap.put(detail.getLong("attitemvid"), detail);
                }
            }
        });
        return detailAttitemMap;
    }

    private DynamicObject attitemInfoTranToDeatilDyn(Long attitemVid, BigDecimal attitemValue, DynamicObject main, Long attPeriodId, Map<Long, AttItemSpec> attitemMap) {
        AttItemSpec attItem = attitemMap.get(attitemVid);
        DynamicObject detail = BusinessDataServiceHelper.newDynamicObject((String)"wtctd_atttotaldetail");
        detail.set("attmain", (Object)main.getLong("id"));
        detail.set("valuelong", (Object)attitemValue);
        detail.set("perattperiodid", (Object)attPeriodId);
        detail.set("attitemtype", (Object)attItem.getItemType());
        detail.set("attitemid", (Object)attItem.getBid());
        detail.set("attitemvid", (Object)attItem.getId());
        return detail;
    }

    private DynamicObject builtNewMainDyn(PerAttPeriod perAttPeriod, TieAttPeriodContext tieAttPeriodContext, MainEntityType mainEntityType) {
        AttFileModel attFile = tieAttPeriodContext.getAttFileByPerAttPeriodId(perAttPeriod.getPrimaryId());
        if (attFile == null) {
            this.LOGGER.debug("attFileMap_not_find_attFileId={}", (Object)perAttPeriod.getFileId());
            return null;
        }
        AttendPersonModel personModel = tieAttPeriodContext.getAttendPersonByPerAttPeriodId(perAttPeriod.getPrimaryId());
        if (personModel == null) {
            this.LOGGER.debug("AttPeriodSummaryServiceImpl_not_find_personModel_personId={}", (Object)perAttPeriod.getPersonId());
            return null;
        }
        return PeriodContextUtil.getBaseAttTotalData(tieAttPeriodContext, perAttPeriod, personModel, attFile, mainEntityType);
    }
}

