/*
 * Decompiled with CFR 0.152.
 */
package kd.wtc.wtes.business.bill;

import java.util.ArrayList;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.hr.hbp.business.servicehelper.HRBaseServiceHelper;
import kd.wtc.wtbs.common.util.Tuple;
import kd.wtc.wtbs.common.util.WTCDateUtils;
import kd.wtc.wtbs.common.util.third.collect.Maps;
import kd.wtc.wtbs.common.util.third.util.DateUtils;
import kd.wtc.wtes.common.util.CollectionUtils;

public final class BillAccountingRangeHelper {
    private static final Log LOG = LogFactory.getLog(BillAccountingRangeHelper.class);

    private BillAccountingRangeHelper() {
    }

    public static Map<Long, List<Tuple<Date, Date>>> BillMaxEffectiveRangeQuery(Date startDate, Date endDate, List<Long> personIdList) {
        HRBaseServiceHelper serviceHelper = new HRBaseServiceHelper("wtabm_vaapply");
        QFilter startDateFilter = new QFilter("entryentity.entrystartdate", "<=", (Object)WTCDateUtils.addDays((Date)endDate, (int)1));
        QFilter endDateFilter = new QFilter("entryentity.entryenddate", ">=", (Object)WTCDateUtils.addDays((Date)startDate, (int)-1));
        QFilter personidDateFilter = new QFilter("personid", "in", personIdList);
        QFilter billStatusDateFilter = new QFilter("billstatus", "=", (Object)"C");
        Object[] qFilters = new QFilter[]{startDateFilter, endDateFilter, personidDateFilter, billStatusDateFilter};
        if (LOG.isInfoEnabled()) {
            LOG.info("\u3010\u5b9a\u989d\u6838\u7b97\u3011\u67e5\u8be2\u5355\u636e\u786e\u8ba4\u6838\u7b97\u8303\u56f4\uff1aqfilters\uff1a{}", qFilters);
        }
        DataSet dataSet = serviceHelper.queryDataSet("BillAccountingRangeHelper.BillMaxEffectiveRangeQuery", "personid,startdate,enddate,entryentity.entrystartdate,entryentity.entryenddate", (QFilter[])qFilters);
        Map<Long, List<Tuple<Date, Date>>> map = BillAccountingRangeHelper.getBillEffectiveRangeMap(dataSet);
        return map;
    }

    private static Map<Long, List<Tuple<Date, Date>>> getBillEffectiveRangeMap(DataSet dataSet) {
        Iterator iterator = dataSet.iterator();
        HashMap map = Maps.newHashMapWithExpectedSize((int)16);
        while (iterator.hasNext()) {
            Row next = (Row)iterator.next();
            Long personId = next.getLong("personid");
            Date startdate = next.getDate("entryentity.entrystartdate");
            Date enddate = next.getDate("entryentity.entryenddate");
            startdate = WTCDateUtils.addDays((Date)startdate, (int)-1);
            enddate = WTCDateUtils.addDays((Date)enddate, (int)1);
            List tuples = map.computeIfAbsent(personId, v -> new ArrayList(100));
            tuples.add(new Tuple((Object)startdate, (Object)enddate));
        }
        dataSet.close();
        map.forEach((k, v) -> BillAccountingRangeHelper.mergeTuples(v));
        return map;
    }

    private static void mergeTuples(List<Tuple<Date, Date>> tuples) {
        if (CollectionUtils.isEmpty(tuples) || tuples.size() < 2) {
            return;
        }
        tuples.sort(Comparator.comparing(Tuple::getKey));
        Tuple<Date, Date> prevTuple = tuples.get(0);
        int index = 1;
        while (index < tuples.size()) {
            Tuple<Date, Date> tuple = tuples.get(index);
            Date preEnd = (Date)prevTuple.getValue();
            if (preEnd.after((Date)tuple.getValue()) || DateUtils.isSameDay((Date)preEnd, (Date)((Date)tuple.getValue()))) {
                tuples.remove(index);
                continue;
            }
            if (preEnd.after((Date)tuple.getKey()) || DateUtils.isSameDay((Date)preEnd, (Date)((Date)tuple.getValue())) || DateUtils.isSameDay((Date)DateUtils.addDays((Date)preEnd, (int)1), (Date)((Date)tuple.getKey()))) {
                prevTuple = new Tuple<Date, Date>(prevTuple.getKey(), tuple.getValue());
                tuples.set(index - 1, prevTuple);
                tuples.remove(index);
                continue;
            }
            prevTuple = tuple;
            ++index;
        }
    }
}

