/*
 * Decompiled with CFR 0.152.
 */
package kd.wtc.wtes.business.bill;

import java.util.List;
import java.util.Map;
import kd.wtc.wtbs.common.deduction.BillApply;
import kd.wtc.wtbs.common.helper.WTCAppContextHelper;
import kd.wtc.wtes.business.bill.BillAccountingDaily;
import kd.wtc.wtes.business.bill.BillAccountingRequest;
import kd.wtc.wtes.business.billcal.va.VaBillCalFilterService;
import kd.wtc.wtes.business.billcal.va.VaBillCalService;
import kd.wtc.wtes.business.core.TieRequest;
import kd.wtc.wtes.business.drouter.AbstractDataPackageRouterStd;
import kd.wtc.wtes.business.drouter.AttRecordRouter;
import kd.wtc.wtes.business.model.AttRecordModel;
import kd.wtc.wtes.business.std.datanode.DataPackageStd;
import kd.wtc.wtes.business.std.datanode.TieDataNodeStd;

public class BillAccountingRouter
extends AbstractDataPackageRouterStd {
    private Map<Long, BillApply> billApplyResMap;
    private BillAccountingRequest request;
    private AttRecordRouter attRecordRouter = new AttRecordRouter();
    private VaBillCalFilterService vaBillCalFilterService = (VaBillCalFilterService)WTCAppContextHelper.getBean(VaBillCalFilterService.class);

    public BillAccountingRouter(Map<Long, BillApply> billApplyResMap) {
        this.billApplyResMap = billApplyResMap;
    }

    @Override
    public void setTieRequest(TieRequest tieRequest) {
        this.request = (BillAccountingRequest)tieRequest;
    }

    @Override
    public void commitStd(DataPackageStd dataPackage) {
        this.attRecordRouter.setInitParams(this.getInitParams());
        this.attRecordRouter.setTieRequest(this.getTieRequestStd());
        this.attRecordRouter.setAttSubject(this.getAttSubject());
        boolean hasVaBill = this.vaBillCalFilterService.filterDataPackage(dataPackage);
        if (hasVaBill) {
            List<TieDataNodeStd> dataNodes = dataPackage.getAllDataNodes();
            List<AttRecordModel> recordModelList = this.attRecordRouter.geneRecordModelListByDateNodes(dataNodes, dataPackage.getAttPersonId(), dataPackage.getChainDate());
            VaBillCalService resParser = new VaBillCalService();
            this.billApplyResMap = resParser.parseResults(this.request, this.request.getBillIds(), new BillAccountingDaily(dataPackage, recordModelList), resParser.getAccountStage(), this.getInitParams(), this.billApplyResMap);
        }
    }
}

