/*
 * Decompiled with CFR 0.152.
 */
package kd.wtc.wtes.business.bill;

import java.time.LocalDateTime;
import java.time.ZoneId;
import java.time.temporal.ChronoUnit;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dlock.DLock;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.hr.hbp.business.servicehelper.HRBaseServiceHelper;
import kd.wtc.wtbs.common.deduction.BillApply;
import kd.wtc.wtbs.common.deduction.QTApplyReq;
import kd.wtc.wtbs.common.deduction.QTAtomApplyResponse;
import kd.wtc.wtbs.common.enums.BillIncrCalcResultEnum;
import kd.wtc.wtbs.common.enums.BusinessTypeEnum;
import kd.wtc.wtbs.common.helper.WTCAppContextHelper;
import kd.wtc.wtbs.common.model.bill.BillIncrCalcRes;
import kd.wtc.wtbs.common.util.third.util.ArrayUtils;
import kd.wtc.wtbs.common.util.third.util.CollectionUtils;
import kd.wtc.wtbs.common.util.third.util.StringUtils;
import kd.wtc.wtes.business.billcal.va.VaBillCalService;
import kd.wtc.wtp.business.vaqt.VAQuotaHelper;

public class BillIncrCalcService {
    private static final Log LOG = LogFactory.getLog(BillIncrCalcService.class);
    private final HRBaseServiceHelper logHelper = new HRBaseServiceHelper("wtte_billincrcalclog");
    private final HRBaseServiceHelper vaApplyBillHelper = new HRBaseServiceHelper("wtabm_vaapply");

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public BillIncrCalcRes incrCalc(BillApply billApply) {
        LocalDateTime startTime = LocalDateTime.now();
        long billId = billApply.getId();
        String billNo = billApply.getBillNo();
        long attFileBoId = billApply.getAttFileBoId();
        long attFileVId = billApply.getAttFileVId();
        long orgId = billApply.getOrgId();
        String lockKey = "wtc/wtes/incr/" + billApply.getAttFileBoId();
        String lockDesc = String.format("incrCalc.lock.billNo=%s,billId=%s", billNo, billId);
        try (DLock lock = DLock.create((String)lockKey, (String)lockDesc);){
            int timeout = WTCAppContextHelper.getSysParams().getIntValue("kd.wtc.wtes.bill.incrCalcTimeout", 300000);
            if (!lock.tryLock((long)timeout)) {
                LOG.warn("incrCalc.billNo={},billId={},scene=tryLock.timeout,lockInfo={}", new Object[]{billNo, billId, DLock.getLockInfo((String)lockKey)});
                DynamicObject log = this.saveInvalidLog(billId, billNo, startTime, BillIncrCalcResultEnum.TIMEOUT.CODE, BillIncrCalcResultEnum.TIMEOUT.getDesc(), attFileBoId, attFileVId, orgId);
                BillIncrCalcRes billIncrCalcRes = BillIncrCalcRes.failure((String)BillIncrCalcResultEnum.TIMEOUT.CODE).setRetry(log.getInt("retrynum") < 10);
                return billIncrCalcRes;
            }
            DynamicObject billDy = this.vaApplyBillHelper.loadSingle((Object)billId);
            if (!"C".equals(billDy.getString("billstatus"))) {
                LOG.warn("incrCalc.billNo={},billId={},scene=unaudited", (Object)billNo, (Object)billId);
                DynamicObject log = this.saveInvalidLog(billId, billNo, startTime, BillIncrCalcResultEnum.UNAUDITED.CODE, BillIncrCalcResultEnum.UNAUDITED.getDesc(), attFileBoId, attFileVId, orgId);
                BillIncrCalcRes billIncrCalcRes = BillIncrCalcRes.failure((String)BillIncrCalcResultEnum.UNAUDITED.CODE).setRetry(log.getInt("retrynum") < 10);
                return billIncrCalcRes;
            }
            QFilter[] filters = new QFilter[]{new QFilter("billid", "=", (Object)billId).and("calcstatus", "in", (Object)new String[]{"A", "C"})};
            Object[] logs = this.logHelper.query(filters);
            if (ArrayUtils.isNotEmpty((Object[])logs)) {
                LOG.warn("incrCalc.billNo={},billId={},scene=inCalc", (Object)billNo, (Object)billId);
                this.saveInvalidLog(billId, billNo, startTime, BillIncrCalcResultEnum.IN_CALC.CODE, BillIncrCalcResultEnum.IN_CALC.getDesc(), attFileBoId, attFileVId, orgId);
                BillIncrCalcRes billIncrCalcRes = BillIncrCalcRes.failure((String)BillIncrCalcResultEnum.IN_CALC.CODE);
                return billIncrCalcRes;
            }
            this.saveValidLog(billId, billNo, startTime, null, null, "A", attFileBoId, attFileVId, orgId);
            LOG.debug("incrCalc.billNo={},billId={},scene=calc", (Object)billNo, (Object)billId);
            VaBillCalService calcService = new VaBillCalService();
            List<Object> calcResult = calcService.calBillAugmentation(billApply);
            LOG.debug("incrCalc.billNo={},billId={},scene=calc}", (Object)billNo, (Object)billId);
            if (CollectionUtils.isEmpty(calcResult) || calcResult.stream().noneMatch(bill -> bill.getId() == billId)) {
                calcResult = this.createEmptyBillApply(billApply);
                LOG.debug("incrCalc.billNo={},billId={},scene=calc", (Object)billNo, (Object)billId);
            }
            QTApplyReq applyReq = new QTApplyReq();
            applyReq.setBillType(BusinessTypeEnum.VACATION.getCode());
            applyReq.setOperateType("USE");
            applyReq.setBillApplyList(calcResult);
            LOG.debug("incrCalc.billNo={},billId={},scene=qt,applyReq={}", new Object[]{billNo, billId, applyReq});
            QTAtomApplyResponse applyRes = VAQuotaHelper.handleApplyReqAtom((QTApplyReq)applyReq);
            LOG.debug("incrCalc.billNo={},billId={},scene=qt,applyRes={}", new Object[]{billNo, billId, applyRes});
            DynamicObject log = this.logHelper.loadDynamicObject(new QFilter[]{new QFilter("billid", "=", (Object)billId).and(new QFilter("calcstatus", "=", (Object)"A"))});
            if (applyRes.isSuccess()) {
                log.set("calcstatus", (Object)"C");
            } else {
                log.set("errcode", (Object)applyRes.getErrCode());
                log.set("errdesc", (Object)applyRes.getErrMsg());
                log.set("calcstatus", (Object)"B");
            }
            this.setEndTime(log, startTime);
            this.logHelper.saveOne(log);
            BillIncrCalcRes billIncrCalcRes = BillIncrCalcRes.success();
            return billIncrCalcRes;
        }
        catch (Exception exception) {
            LOG.warn("incrCalc.billNo={},billId={},scene=exception", new Object[]{billNo, billId, exception});
            this.saveValidLog(billId, billNo, startTime, BillIncrCalcResultEnum.EXCEPTION.CODE, BillIncrCalcResultEnum.EXCEPTION.getDesc() + exception.getMessage(), null, attFileBoId, attFileVId, orgId);
            return BillIncrCalcRes.failure((String)BillIncrCalcResultEnum.EXCEPTION.CODE);
        }
    }

    public void saveValidLog(long billId, String billNo, LocalDateTime startTime, String errCode, String errDesc, String calcStatus, long attFileBoId, long attFileVId, long orgId) {
        String errDescTrim;
        int retry = 0;
        DynamicObject inCalcLog = null;
        DynamicObject lastLog = this.queryLastLog(billId);
        if (lastLog != null) {
            if (!"A".equals(lastLog.getString("calcstatus"))) {
                lastLog.set("isvalid", (Object)"0");
                retry = lastLog.getInt("retrynum") + 1;
                this.logHelper.saveOne(lastLog);
                inCalcLog = this.logHelper.loadDynamicObject(new QFilter("billid", "=", (Object)billId).and(new QFilter("calcstatus", "=", (Object)"A")));
            } else {
                inCalcLog = lastLog;
            }
        }
        String string = errDescTrim = StringUtils.length((CharSequence)errDesc) >= 2000 ? errDesc.substring(0, 2000) : errDesc;
        if (inCalcLog == null) {
            DynamicObject log = this.createLog(billId, billNo, startTime, attFileBoId, attFileVId, orgId);
            log.set("retrynum", (Object)retry);
            log.set("errcode", (Object)errCode);
            log.set("errdesc", (Object)errDescTrim);
            if (StringUtils.isNotBlank((CharSequence)calcStatus)) {
                log.set("calcstatus", (Object)calcStatus);
            }
            this.logHelper.saveOne(log);
        } else {
            inCalcLog.set("calcstatus", (Object)"B");
            inCalcLog.set("errcode", (Object)errCode);
            inCalcLog.set("errdesc", (Object)errDescTrim);
            this.setEndTime(inCalcLog, startTime);
            this.logHelper.saveOne(inCalcLog);
        }
    }

    private DynamicObject saveInvalidLog(long billId, String billNo, LocalDateTime startTime, String errCode, String errDesc, long attFileBoId, long attFileVId, long orgId) {
        int retry = 0;
        DynamicObject lastLog = this.queryLastLog(billId);
        if (lastLog != null) {
            retry = lastLog.getInt("retrynum") + 1;
        }
        DynamicObject log = this.createLog(billId, billNo, startTime, attFileBoId, attFileVId, orgId);
        log.set("retrynum", (Object)retry);
        log.set("errcode", (Object)errCode);
        log.set("errdesc", (Object)errDesc);
        log.set("isvalid", (Object)"0");
        this.logHelper.saveOne(log);
        return log;
    }

    private DynamicObject queryLastLog(long billId) {
        String properties = String.join((CharSequence)",", "billid", "billno", "calcstatus", "retrynum", "billtype", "starttime", "isvalid", "endtime", "costtime", "retrynum", "errcode", "errdesc");
        QFilter[] filters = new QFilter[]{new QFilter("billid", "=", (Object)billId)};
        Object[] lastLogs = this.logHelper.query(properties, filters, "createtime desc", 1);
        return ArrayUtils.isNotEmpty((Object[])lastLogs) ? lastLogs[0] : null;
    }

    private DynamicObject createLog(long billId, String billNo, LocalDateTime startTime, long attFileBoId, long attFileVId, long orgId) {
        DynamicObject log = new DynamicObject((DynamicObjectType)EntityMetadataCache.getDataEntityType((String)"wtte_billincrcalclog"));
        log.set("billid", (Object)billId);
        log.set("billno", (Object)billNo);
        log.set("calcstatus", (Object)"B");
        log.set("retrynum", (Object)0);
        log.set("billtype", (Object)"A");
        log.set("attfilebo", (Object)attFileBoId);
        log.set("attfileid", (Object)attFileVId);
        log.set("org", (Object)orgId);
        log.set("starttime", (Object)Date.from(startTime.atZone(ZoneId.systemDefault()).toInstant()));
        log.set("isvalid", (Object)"1");
        this.setEndTime(log, startTime);
        return log;
    }

    public void setEndTime(DynamicObject log, LocalDateTime startTime) {
        LocalDateTime endTime = LocalDateTime.now();
        log.set("endtime", (Object)Date.from(endTime.atZone(ZoneId.systemDefault()).toInstant()));
        log.set("costtime", (Object)((double)ChronoUnit.MILLIS.between(startTime, endTime) / 1000.0));
    }

    public List<BillApply> createEmptyBillApply(BillApply billApply) {
        BillApply emptyBill = new BillApply();
        emptyBill.setId(billApply.getId());
        emptyBill.setBillNo(billApply.getBillNo());
        emptyBill.setPersonId(billApply.getPersonId());
        emptyBill.setAttFileBoId(billApply.getAttFileBoId());
        emptyBill.setAttFileVId(billApply.getAttFileVId());
        emptyBill.setParentId(billApply.getParentId());
        emptyBill.setBillType(billApply.getBillType());
        emptyBill.setLoggingProcess(billApply.isLoggingProcess());
        return Collections.singletonList(emptyBill);
    }
}

