/*
 * Decompiled with CFR 0.152.
 */
package kd.wtc.wtes.business.billcal.va;

import java.time.LocalDate;
import java.util.List;
import java.util.Map;
import kd.wtc.wtbs.common.helper.WTCAppContextHelper;
import kd.wtc.wtbs.common.predata.wtp.PreDataAccountSteps;
import kd.wtc.wtbs.common.util.third.util.CollectionUtils;
import kd.wtc.wtes.business.billcal.va.VaBillCalService;
import kd.wtc.wtes.business.model.AttFileModel;
import kd.wtc.wtes.business.model.AttRecordModel;
import kd.wtc.wtes.business.model.rlra.AttendanceBillTag;
import kd.wtc.wtes.business.std.datanode.DataPackageStd;
import kd.wtc.wtes.business.std.datanode.TieDataNodeStd;
import kd.wtc.wtes.business.std.datanode.TimeBucketStd;
import kd.wtc.wtes.common.enums.AccountStepEnum;

public class VaBillCalFilterService {
    private VaBillCalService vaBillCalService = (VaBillCalService)WTCAppContextHelper.getBean(VaBillCalService.class);

    public boolean filterDataPackage(DataPackageStd dataPackage) {
        AccountStepEnum vaStep = AccountStepEnum.from((Long)PreDataAccountSteps.PD_LE_1010_S);
        List paramDataNodes = dataPackage.getDataNodesByStepNumber(this.vaBillCalService.getAccountStage(), vaStep.getCode());
        if (CollectionUtils.isNotEmpty(paramDataNodes)) {
            boolean isOnVacation = false;
            for (TieDataNodeStd dataNodeStd : paramDataNodes) {
                TimeBucketStd timeBucket = dataNodeStd.castTo(TimeBucketStd.class);
                AttendanceBillTag attendanceBillTag = timeBucket.getAttendanceBillTag();
                if (!attendanceBillTag.isOnVacation()) continue;
                isOnVacation = true;
                break;
            }
            return isOnVacation;
        }
        return false;
    }

    @Deprecated
    public boolean filterRecordModel(AttRecordModel recordModel, AttFileModel attFileModel, LocalDate chainDate, Map<String, Object> initParams) {
        return true;
    }
}

