/*
 * Decompiled with CFR 0.152.
 */
package kd.wtc.wtes.business.billcal.va;

import java.math.BigDecimal;
import java.math.RoundingMode;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DataEntityBase;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.AppMetadataCache;
import kd.bos.entity.param.AppParam;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.servicehelper.parameter.SystemParamServiceHelper;
import kd.wtc.wtbs.business.bill.AttfileLimitScopeServiceImpl;
import kd.wtc.wtbs.business.bill.IAttfileLimitScopeService;
import kd.wtc.wtbs.business.subject.AttPlainSubject;
import kd.wtc.wtbs.business.timeseq.TimeSeqBo;
import kd.wtc.wtbs.common.bean.annotations.SingletonBean;
import kd.wtc.wtbs.common.bill.AttfileLimitScope;
import kd.wtc.wtbs.common.deduction.BillApply;
import kd.wtc.wtbs.common.deduction.BillApplyEntry;
import kd.wtc.wtbs.common.deduction.BillCalResult;
import kd.wtc.wtbs.common.deduction.BillEntryDateSplit;
import kd.wtc.wtbs.common.helper.WTCAppContextHelper;
import kd.wtc.wtbs.common.predata.wtp.PreDataAccountStageType;
import kd.wtc.wtbs.common.predata.wtp.PreDataAccountSteps;
import kd.wtc.wtbs.common.util.SystemParamQueryUtil;
import kd.wtc.wtbs.common.util.Tuple;
import kd.wtc.wtbs.common.util.WTCCollections;
import kd.wtc.wtbs.common.util.WTCDateUtils;
import kd.wtc.wtbs.common.util.third.collect.Lists;
import kd.wtc.wtbs.common.util.third.util.CollectionUtils;
import kd.wtc.wtbs.common.util.third.util.StringUtils;
import kd.wtc.wtes.business.bill.BillAccountingDaily;
import kd.wtc.wtes.business.bill.BillAccountingRequest;
import kd.wtc.wtes.business.bill.BillAccountingResult;
import kd.wtc.wtes.business.bill.BillAccountingService;
import kd.wtc.wtes.business.billcal.BillAccountingResParser;
import kd.wtc.wtes.business.billcal.IBillCalService;
import kd.wtc.wtes.business.model.AttBillTimeBucket;
import kd.wtc.wtes.business.model.AttBillTimeBucketData;
import kd.wtc.wtes.business.model.AttFileCabinet;
import kd.wtc.wtes.business.model.AttFileModel;
import kd.wtc.wtes.business.model.AttItemInstance;
import kd.wtc.wtes.business.model.AttRecordModel;
import kd.wtc.wtes.business.model.VaAttPackage;
import kd.wtc.wtes.business.model.quotacal.va.QuotaCalBatchReq;
import kd.wtc.wtes.business.model.rlra.AttendanceBillTag;
import kd.wtc.wtes.business.model.rlva.DeductionRulePackage;
import kd.wtc.wtes.business.model.rlva.VaCalculateRule;
import kd.wtc.wtes.business.model.rlva.VaRulePackage;
import kd.wtc.wtes.business.std.datanode.DataPackageStd;
import kd.wtc.wtes.business.std.datanode.TieDataNodeStd;
import kd.wtc.wtes.business.std.datanode.TimeBucketStd;
import kd.wtc.wtes.common.constants.TimeConstants;
import kd.wtc.wtes.common.enums.AccountStageTypeEnum;
import kd.wtc.wtes.common.enums.AccountStepEnum;
import kd.wtc.wtes.common.lang.WtesBizException;
import kd.wtc.wtes.common.lang.WtesException;

@SingletonBean
public class VaBillCalService
implements IBillCalService<BillApply>,
BillAccountingResParser {
    private static final Log LOG = LogFactory.getLog(VaBillCalService.class);
    private final BillAccountingService billAccountingService = (BillAccountingService)WTCAppContextHelper.getBean(BillAccountingService.class);
    private final IAttfileLimitScopeService attfileLimitScopeService = (IAttfileLimitScopeService)WTCAppContextHelper.getBean(AttfileLimitScopeServiceImpl.class);
    private static final String DEFAULT_PHASE = AccountStageTypeEnum.VA_1030_S.getPhaseCode();
    private static final String BILL_CHECK_RULE = "billcheckrule";
    private static final int SACLE = 6;

    @Override
    public List<BillApply> calBillAugmentation(BillApply billApply) throws WtesBizException {
        LOG.debug("\u5355\u636e\u589e\u91cf\u8ba1\u7b97\u8c03\u7528\u5f00\u59cb\uff1a,billNo={}, billApply:{}", (Object)billApply.getBillNo(), (Object)billApply);
        List entryEntities = billApply.getEntryEntities();
        if (CollectionUtils.isEmpty((Collection)entryEntities)) {
            LOG.info("\u4f20\u5165\u5355\u636e\u65e0\u5206\u5f55\uff0c\u4e0d\u9700\u8c03\u7528\u6838\u7b97\u5904\u7406.");
            return Lists.newArrayList((Object[])new BillApply[]{billApply});
        }
        List<BillApplyEntry> sortedEntities = entryEntities.stream().sorted(Comparator.comparing(BillApplyEntry::getStartDate)).collect(Collectors.toList());
        String traceId = RequestContext.get().getTraceId();
        HashMap<Long, BillApply> billApplies = new HashMap<Long, BillApply>(10);
        List<Tuple<LocalDate, LocalDate>> datePairs = this.generateTimePair(sortedEntities);
        long defaultTiePlanId = SystemParamQueryUtil.getDefaultTiePlanId();
        for (Tuple<LocalDate, LocalDate> tuple : datePairs) {
            BillAccountingRequest req = this.generateRequest(billApply.getAttFileBoId(), billApply.getPersonId(), (LocalDate)tuple.getKey(), (LocalDate)tuple.getValue(), defaultTiePlanId, Lists.newArrayList((Object[])new Long[]{billApply.getId()}));
            req.setVersion(billApply.getBillNo() + new Date().getTime());
            req.setTest(false);
            BillAccountingResult submitRes = this.billAccountingService.submit(req);
            LOG.info("\u8c03\u7528\u5355\u636e\u6838\u7b97\u670d\u52a1\u5b8c\u6210\u3002traceId:{}", (Object)traceId);
            if (!submitRes.getErrorMsgMap().isEmpty()) {
                LOG.warn("\u8c03\u7528\u5355\u636e\u6838\u7b97\u94fe\u5f02\u5e38\uff0c\u5f02\u5e38\u4fe1\u606f\uff1a{}", submitRes.getErrorMsgMap());
                throw new WtesBizException(submitRes.getErrorMsgMap().get(billApply.getAttFileBoId()));
            }
            this.analyseResultPlan(billApply, submitRes, tuple);
            try {
                Map<Long, BillApply> billApplyMap = submitRes.getBillApplyResMap();
                this.mergeBillApplyList(billApplies, billApplyMap);
            }
            catch (Exception exception) {
                String errorMsg = ResManager.loadKDString((String)"\u6838\u7b97\u7ed3\u679c\u89e3\u6790\u5f02\u5e38\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\u3002", (String)"VaBillCalService_01", (String)"wtc-wtes-business", (Object[])new Object[0]);
                LOG.warn("\u6838\u7b97\u7ed3\u679c\u89e3\u6790\u5f02\u5e38\uff0c\u5f02\u5e38\u4fe1\u606f\uff1a", (Throwable)exception);
                throw new WtesBizException(errorMsg);
            }
        }
        LOG.info("\u5355\u636e\u589e\u91cf\u8ba1\u7b97\u8c03\u7528\u7ed3\u675f\u3002");
        return Lists.newArrayList(billApplies.values());
    }

    @Override
    public BillCalResult<BillApply> calBillDeductionBatch(QuotaCalBatchReq quotaCal) {
        String traceId = RequestContext.get().getTraceId();
        LOG.info("\u3010batch\u3011\u5b9a\u989d\u6838\u7b97\u8c03\u7528\u8ba1\u7b97\u5f00\u59cb\uff1a{}\uff0c traceId:{}", (Object)quotaCal, (Object)traceId);
        BillAccountingRequest req = this.generateRequest(quotaCal.getPersonInfos(), quotaCal.getStartDate(), quotaCal.getEndDate(), quotaCal.getTiePlanId(), quotaCal.getBillIds());
        BillAccountingResult submitRes = this.billAccountingService.submit(req, quotaCal);
        LOG.info("\u3010batch\u3011\u5b9a\u989d\u6838\u7b97\u8c03\u7528\u8ba1\u7b97\u5b8c\u6210\uff1atraceId={}", (Object)traceId);
        if (LOG.isInfoEnabled() && WTCCollections.isNotEmpty(submitRes.getErrorMsgMap())) {
            LOG.info("\u3010batch\u3011\u8c03\u7528\u5355\u636e\u6838\u7b97\u94fe\u5b58\u5728\u5f02\u5e38\u5355\u636e\uff0c\u5f02\u5e38\u6863\u6848BO\u4fe1\u606f\uff1a{}", submitRes.getErrorMsgMap());
        }
        Map<Long, BillApply> billApplyResMap = submitRes.getBillApplyResMap();
        BillCalResult billCalResult = new BillCalResult();
        billCalResult.setFailAttFileMap(submitRes.getErrorMsgMap());
        billCalResult.setCalcBillApplies((List)Lists.newArrayList(billApplyResMap.values()));
        return billCalResult;
    }

    public String getAccountStage() {
        AccountStageTypeEnum accountStageTypeEnum = AccountStageTypeEnum.from((Long)PreDataAccountStageType.PD_1030_S);
        String accountStage = DEFAULT_PHASE;
        if (accountStageTypeEnum != null) {
            accountStage = accountStageTypeEnum.getPhaseCode();
        }
        LOG.debug("\u4f11\u5047\u9636\u6bb5\u7f16\u7801\uff1a{}", (Object)accountStage);
        return accountStage;
    }

    private List<Tuple<LocalDate, LocalDate>> generateTimePair(List<BillApplyEntry> sortedEntities) {
        int defaultInterval = WTCAppContextHelper.getSysParams().getIntValue("kd.wtc.wtes.billcal.billIntervalDay", 0);
        LocalDate prevEnd = null;
        ArrayList<Tuple<LocalDate, LocalDate>> dates = new ArrayList<Tuple<LocalDate, LocalDate>>(10);
        for (BillApplyEntry billApplyEntry : sortedEntities) {
            LocalDate startLocalDate = WTCDateUtils.toLocalDate((Date)billApplyEntry.getStartDate()).plusDays(-1L);
            LocalDate endLocalDate = WTCDateUtils.toLocalDate((Date)billApplyEntry.getEndDate());
            if (prevEnd == null || prevEnd.plusDays(defaultInterval).isBefore(startLocalDate)) {
                Tuple tuple = Tuple.of((Object)startLocalDate, (Object)endLocalDate);
                dates.add((Tuple<LocalDate, LocalDate>)tuple);
                prevEnd = endLocalDate;
                continue;
            }
            Tuple dateDateTuple = (Tuple)dates.get(dates.size() - 1);
            dates.set(dates.size() - 1, (Tuple<LocalDate, LocalDate>)Tuple.of((Object)dateDateTuple.getKey(), (Object)WTCDateUtils.toLocalDate((Date)billApplyEntry.getEndDate()).plusDays(1L)));
        }
        return dates;
    }

    private BillAccountingRequest generateRequest(Long attFileBoId, Long attPersonId, LocalDate startDate, LocalDate endDate, long tiePlanId, List<Long> billIds) {
        BillAccountingRequest billAccountingRequest = new BillAccountingRequest();
        billAccountingRequest.setAttPersonIds(Lists.newArrayList((Object[])new Long[]{attPersonId}));
        if (0L == tiePlanId) {
            billAccountingRequest.setPlanId(this.generatePlanId());
        } else {
            billAccountingRequest.setPlanId(tiePlanId);
        }
        billAccountingRequest.setStartDate(startDate);
        billAccountingRequest.setEndDate(endDate);
        billAccountingRequest.setBillIds(billIds);
        AttPlainSubject subject = new AttPlainSubject();
        subject.setAttFileBoid(attFileBoId.longValue());
        subject.setAttPersonId(attPersonId.longValue());
        ArrayList subjects = Lists.newArrayList((Object[])new AttPlainSubject[]{subject});
        billAccountingRequest.setAttPlainSubject(subjects);
        billAccountingRequest.setSubTaskDispatchedTime(LocalDateTime.now());
        billAccountingRequest.setTest(true);
        boolean billCheckRule = this.getBillCheckRule();
        billAccountingRequest.setBillCheckRule(billCheckRule);
        return billAccountingRequest;
    }

    private BillAccountingRequest generateRequest(Map<Long, Long> attFileInfos, LocalDate startDate, LocalDate endDate, long tiePlanId, List<Long> billIds) {
        BillAccountingRequest billAccountingRequest = new BillAccountingRequest();
        billAccountingRequest.setAttPersonIds(Lists.newArrayList(attFileInfos.values()));
        if (0L == tiePlanId) {
            billAccountingRequest.setPlanId(this.generatePlanId());
        } else {
            billAccountingRequest.setPlanId(tiePlanId);
        }
        billAccountingRequest.setBillIds(billIds);
        billAccountingRequest.setStartDate(startDate);
        billAccountingRequest.setEndDate(endDate);
        ArrayList<AttPlainSubject> subjects = new ArrayList<AttPlainSubject>(10);
        attFileInfos.forEach((attFileBoId, attPersonId) -> {
            AttPlainSubject subject = new AttPlainSubject();
            subject.setAttFileBoid(attFileBoId.longValue());
            subject.setAttPersonId(attPersonId.longValue());
            subjects.add(subject);
        });
        billAccountingRequest.setAttPlainSubject(subjects);
        billAccountingRequest.setSubTaskDispatchedTime(LocalDateTime.now());
        billAccountingRequest.setTest(true);
        boolean billCheckRule = this.getBillCheckRule();
        billAccountingRequest.setBillCheckRule(billCheckRule);
        return billAccountingRequest;
    }

    protected Map<Long, VaCalculateRule> getVaRuleEntryMap(AttFileModel attFileModel, Map<Long, AttfileLimitScope> limitScopeMap, DataPackageStd dataPackage) {
        VaRulePackage vaRule = dataPackage.getVaRule();
        if (vaRule == null) {
            LOG.warn("attFileModel.personId:{}", (Object)attFileModel.getAttPersonId());
            throw new WtesException(ResManager.loadKDString((String)"\u627e\u4e0d\u5230\u4f11\u5047\u89c4\u5219\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\u3002", (String)"VaBillCalService_04", (String)"wtc-wtes-business", (Object[])new Object[0]));
        }
        List<VaCalculateRule> vaCalculateRules = vaRule.getVaCalculateRules();
        return vaCalculateRules.stream().filter(vaRuleEntry -> this.attfileLimitScopeService.matchLimit((AttfileLimitScope)limitScopeMap.get(attFileModel.getId()), vaRuleEntry.getLimitJson())).collect(Collectors.toMap(VaCalculateRule::getVaTypeId, vaRuleEntry -> vaRuleEntry, (rule1, rule2) -> rule1));
    }

    protected Map<Long, List<TimeBucketStd>> groupDataNodes(List<TieDataNodeStd> dataNodes, Map<Long, VaCalculateRule> ruleEntryMap) {
        HashMap<Long, List<TimeBucketStd>> dataNodeMap = new HashMap<Long, List<TimeBucketStd>>(16);
        for (TieDataNodeStd dataNodeStd : dataNodes) {
            TimeBucketStd timeBucket = dataNodeStd.castTo(TimeBucketStd.class);
            AttendanceBillTag attendanceBillTag = timeBucket.getAttendanceBillTag();
            if (!attendanceBillTag.isOnVacation()) {
                LOG.debug("\u6b65\u9aa4\u5f02\u5e38\uff0c\u8282\u70b9\u4e0d\u662f\u4f11\u5047\u4ea7\u751f{}", (Object)attendanceBillTag);
                continue;
            }
            long vaBillTypeId = attendanceBillTag.getVaBillTypeId();
            VaCalculateRule vaCalculateRule = ruleEntryMap.get(vaBillTypeId);
            if (vaCalculateRule == null) {
                LOG.info("\u6839\u636e\u4f11\u5047\u7c7b\u578b\u672a\u83b7\u53d6\u5230\u4f11\u5047\u89c4\u5219\uff0cvaBillTypeId\uff1a{}", (Object)vaBillTypeId);
                continue;
            }
            List tieDataNodeStds = dataNodeMap.computeIfAbsent(vaCalculateRule.getResultId(), value -> Lists.newArrayList());
            tieDataNodeStds.add(timeBucket);
        }
        return dataNodeMap;
    }

    private BillApply generateBillApply(long id, List<Long> billIds, DynamicObject vaApplyBill) {
        BillApply bill = new BillApply();
        bill.setId(id);
        if (billIds.contains(id)) {
            bill.setBillType(0);
        } else {
            bill.setBillType(1);
        }
        bill.setBillNo(vaApplyBill.getString("billno")).setParentId(vaApplyBill.getLong("parentid")).setAttFileVId(vaApplyBill.getLong("attfilebasef7.id")).setAttFileBoId(vaApplyBill.getLong("attfile.id")).setPersonId(vaApplyBill.getLong("personid.id"));
        return bill;
    }

    private BillApplyEntry getBillApplyEntry(long entryId, BillApply bill, DynamicObject vaApplyBill) {
        Map<Object, DynamicObject> entryDynMap;
        DynamicObject entry;
        List entryEntities = bill.getEntryEntities();
        Map<Long, BillApplyEntry> billEntryIds = entryEntities.stream().collect(Collectors.toMap(BillApplyEntry::getEntryId, bean -> bean));
        BillApplyEntry billApplyEntry = billEntryIds.get(entryId);
        if (billApplyEntry == null && (entry = (entryDynMap = vaApplyBill.getDynamicObjectCollection("entryentity").stream().collect(Collectors.toMap(DataEntityBase::getPkValue, dyn -> dyn))).get(entryId)) != null) {
            billApplyEntry = new BillApplyEntry().setEntryId(entry.getLong("id")).setVaTimeDay(BigDecimal.ZERO).setVaTimeHour(BigDecimal.ZERO).setEntryUnit(entry.getString("entryunit")).setStartDate(entry.getDate("entrystartdate")).setEndDate(entry.getDate("entryenddate"));
            billApplyEntry.setDisposable(entry.getBoolean("isdisposable"));
            entryEntities.add(billApplyEntry);
        }
        return billApplyEntry;
    }

    protected void buildTimeBucketResult(BillAccountingRequest request, List<Long> billIds, LocalDate chainDate, AttRecordModel attRecordModel, Map.Entry<Long, List<TimeBucketStd>> mapEntry, Map<Long, VaCalculateRule> ruleEntryMap, Map<Long, BillApply> billApplyMap, Map<Long, DynamicObject> billMap) {
        Long resultId = mapEntry.getKey();
        BigDecimal attRecordSecond = BigDecimal.ZERO;
        BigDecimal attRecordDay = BigDecimal.ZERO;
        if (attRecordModel != null) {
            attRecordSecond = attRecordModel.getValueSecondDecimal();
            attRecordDay = attRecordModel.getValue();
        }
        BigDecimal usedDay = BigDecimal.ZERO;
        BigDecimal usedSecond = BigDecimal.ZERO;
        List<TimeBucketStd> timeBucketStds = mapEntry.getValue();
        if (CollectionUtils.isEmpty(timeBucketStds)) {
            LOG.debug("\u5f53\u524d\u65f6\u95f4\u5bf9\u89e3\u6790\u5f02\u5e38\uff0ctuneBucket\u7684entryId:{}", (Object)resultId);
            return;
        }
        BigDecimal sumSeconds = BigDecimal.ZERO;
        BigDecimal sumDays = BigDecimal.ZERO;
        for (TimeBucketStd timebucketStd : timeBucketStds) {
            for (AttItemInstance instance : timebucketStd.getAttItemInstances()) {
                sumSeconds = sumSeconds.add(instance.getSecondDecimal());
                sumDays = sumDays.add(instance.getDay());
            }
        }
        boolean billCheckRule = request != null ? request.getBillCheckRule() : this.getBillCheckRule();
        for (int index = 0; index < timeBucketStds.size(); ++index) {
            List splitList;
            Map<Date, BillEntryDateSplit> splitMap;
            BillEntryDateSplit currentSplit;
            DeductionRulePackage deductionRulePackage;
            BigDecimal resultDay;
            BigDecimal resultHour;
            TimeBucketStd timebucketStd = timeBucketStds.get(index);
            AttendanceBillTag attendanceBillTag = timebucketStd.getAttendanceBillTag();
            long vaBillId = attendanceBillTag.getVaBillId();
            long vaEntityId = attendanceBillTag.getVaBillEntryId();
            VaCalculateRule vaCalculateRule = ruleEntryMap.get(attendanceBillTag.getVaBillTypeId());
            Optional<AttItemInstance> attItemInstanceOp = timebucketStd.getAttItemInstances().stream().filter(attItemInstance -> attItemInstance.getAttItemSpec().getBid() == vaCalculateRule.getOriginId()).findFirst();
            if (!attItemInstanceOp.isPresent()) {
                LOG.info("\u6839\u636e\u89c4\u5219\u4e2d\u914d\u7f6e\u7684\u8003\u52e4\u9879\u76eeID\u672a\u627e\u5230\u8ba1\u7b97\u51fa\u7684\u8003\u52e4\u9879\u76ee\uff0c  vaCalculateRule.getOriginId()\uff1a{}", (Object)vaCalculateRule.getOriginId());
                continue;
            }
            AttItemInstance instance = attItemInstanceOp.get();
            BigDecimal seconds = instance.getSecondDecimal();
            BigDecimal days = instance.getDay();
            if (timeBucketStds.size() - 1 == index) {
                resultHour = attRecordSecond.subtract(usedSecond).divide(TimeConstants.SECOND_OF_ONE_HOUR_DECIMAL, 6, RoundingMode.HALF_UP);
                resultDay = attRecordDay.subtract(usedDay).setScale(6, RoundingMode.HALF_UP);
            } else {
                BigDecimal resultSeconds = BigDecimal.ZERO;
                if (sumSeconds.compareTo(BigDecimal.ZERO) != 0) {
                    resultSeconds = attRecordSecond.multiply(seconds).divide(sumSeconds, 6, RoundingMode.HALF_UP);
                }
                resultHour = resultSeconds.divide(TimeConstants.SECOND_OF_ONE_HOUR_DECIMAL, 6, RoundingMode.HALF_UP);
                resultDay = BigDecimal.ZERO;
                if (BigDecimal.ZERO.compareTo(sumDays) != 0) {
                    resultDay = attRecordDay.multiply(days).divide(sumDays, 6, RoundingMode.HALF_UP);
                }
                usedDay = usedDay.add(resultDay);
                usedSecond = usedSecond.add(resultSeconds);
            }
            DynamicObject vaApplyBill = billMap.get(vaBillId);
            BillApply bill = billApplyMap.computeIfAbsent(vaBillId, billApply -> this.generateBillApply(vaBillId, billIds, vaApplyBill));
            BillApplyEntry billApplyEntry = this.getBillApplyEntry(vaEntityId, bill, vaApplyBill);
            if (billApplyEntry == null) continue;
            boolean quota = vaCalculateRule.getQuota();
            billApplyEntry.setNonQuota(!quota);
            BigDecimal vaTimeDay = resultDay.add(billApplyEntry.getVaTimeDay());
            BigDecimal vaTimeHour = resultHour.add(billApplyEntry.getVaTimeHour());
            billApplyEntry.setVaTimeDay(vaTimeDay).setVaTimeHour(vaTimeHour);
            long deductionRuleId = 0L;
            TimeSeqBo<DeductionRulePackage> vaDeductionRulePackageTimeSeqBo = vaCalculateRule.getVaDeductionRulePackageTimeSeqBo();
            if (vaDeductionRulePackageTimeSeqBo != null && (deductionRulePackage = (DeductionRulePackage)vaDeductionRulePackageTimeSeqBo.getVersionByDate(chainDate)) != null) {
                deductionRuleId = deductionRulePackage.getId();
            }
            if (billApplyEntry.getDeductionRuleId() == 0L || !billCheckRule) {
                billApplyEntry.setDeductionRuleId(deductionRuleId);
            }
            if ((currentSplit = (splitMap = (splitList = billApplyEntry.getSplitList()).stream().collect(Collectors.toMap(BillEntryDateSplit::getDate, split -> split))).get(WTCDateUtils.toDate((LocalDate)chainDate))) != null) {
                currentSplit.setVaTimeDay(currentSplit.getVaTimeDay().add(resultDay));
                currentSplit.setVaTimeHour(currentSplit.getVaTimeHour().add(resultHour));
                continue;
            }
            BillEntryDateSplit splitResult = new BillEntryDateSplit(vaEntityId, WTCDateUtils.toDate((LocalDate)chainDate), resultDay, resultHour);
            splitList.add(splitResult);
        }
    }

    private boolean getBillCheckRule() {
        long orgId = SystemParamQueryUtil.getWTCRootOrg();
        String appId = AppMetadataCache.getAppInfo((String)"wtp").getId();
        AppParam appParam = new AppParam(appId, Long.valueOf(orgId));
        String billcheckrule = (String)SystemParamServiceHelper.loadAppParameterFromCache((AppParam)appParam, (String)BILL_CHECK_RULE);
        return StringUtils.equals((CharSequence)"0", (CharSequence)billcheckrule);
    }

    private void mergeBillApplyList(Map<Long, BillApply> mergedMap, Map<Long, BillApply> targetMap) {
        for (Map.Entry<Long, BillApply> longBillApplyEntry : targetMap.entrySet()) {
            BillApply target = longBillApplyEntry.getValue();
            List nonZeroDeductRuleVidList = target.getNonZeroDeductRuleVidList();
            if (CollectionUtils.isEmpty((Collection)nonZeroDeductRuleVidList)) continue;
            BillApply resBillApply = mergedMap.get(longBillApplyEntry.getKey());
            if (resBillApply == null) {
                mergedMap.put(longBillApplyEntry.getKey(), target);
                continue;
            }
            this.merge(resBillApply, target);
        }
    }

    private void merge(BillApply resoult, BillApply target) {
        Map<Long, BillApplyEntry> resEntry = resoult.getEntryEntities().stream().collect(Collectors.toMap(BillApplyEntry::getEntryId, entry -> entry));
        Map<Long, BillApplyEntry> targetEntryMap = target.getEntryEntities().stream().collect(Collectors.toMap(BillApplyEntry::getEntryId, entry -> entry));
        for (Map.Entry<Long, BillApplyEntry> targetEntry : targetEntryMap.entrySet()) {
            BillApplyEntry resApplyEntry = resEntry.get(targetEntry.getKey());
            if (resApplyEntry == null) {
                resoult.getEntryEntities().add(targetEntry.getValue());
                continue;
            }
            List splitList = resApplyEntry.getSplitList();
            Map<Date, BillEntryDateSplit> splitMap = splitList.stream().collect(Collectors.toMap(BillEntryDateSplit::getDate, split -> split));
            List targetSplitList = targetEntry.getValue().getSplitList();
            targetSplitList.forEach(targetSplit -> {
                if (splitMap.get(targetSplit.getDate()) == null) {
                    splitList.add(targetSplit);
                }
            });
            resApplyEntry.adjustSplitTime();
        }
    }

    private void analyseResultPlan(BillApply billApply, BillAccountingResult submitRes, Tuple<LocalDate, LocalDate> tuple) {
        AttFileCabinet attFileCabinet = submitRes.getAttFileCabinet();
        LocalDate chainDate = ((LocalDate)tuple.getKey()).plusDays(1L);
        while (((LocalDate)tuple.getValue()).isAfter(chainDate)) {
            AttFileModel attFileModel = attFileCabinet.getByAttPersonIdAndDate(billApply.getPersonId(), chainDate);
            if (attFileModel == null) {
                String errorMsg = ResManager.loadKDString((String)"\u627e\u4e0d\u5230\u8003\u52e4\u6863\u6848\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\u3002", (String)"VaBillCalService_03", (String)"wtc-wtes-business", (Object[])new Object[0]);
                LOG.warn("\u6838\u7b97\u7ed3\u679c\u89e3\u6790\u5f02\u5e38\uff0c\u672a\u67e5\u5230\u8003\u52e4\u6863\u6848\uff0cchainDate:", (Object)chainDate);
                throw new WtesBizException(errorMsg);
            }
            VaAttPackage attVaPackage = attFileModel.getAttVaPackage(chainDate);
            if (attVaPackage == null) {
                String errorMsg = ResManager.loadKDString((String)"\u627e\u4e0d\u5230\u4f11\u5047\u65b9\u6848\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\u3002", (String)"VaBillCalService_02", (String)"wtc-wtes-business", (Object[])new Object[0]);
                LOG.warn("\u6838\u7b97\u7ed3\u679c\u89e3\u6790\u5f02\u5e38\uff0c\u672a\u67e5\u5230\u4f11\u5047\u65b9\u6848\uff0cchainDate:", (Object)chainDate);
                throw new WtesBizException(errorMsg);
            }
            chainDate = chainDate.plusDays(1L);
        }
    }

    @Override
    public Map<Long, BillApply> parseResults(BillAccountingRequest request, List<Long> billIds, BillAccountingDaily accountingDaily, String accountStage, Map<String, Object> initParams, Map<Long, BillApply> billApplyMap) {
        AccountStepEnum vaStep;
        if (billApplyMap == null) {
            billApplyMap = new HashMap<Long, BillApply>(16);
        }
        AttFileCabinet attFileCabinet = (AttFileCabinet)initParams.get("ATT_FILE");
        AttBillTimeBucketData attBillTimeBucketData = (AttBillTimeBucketData)initParams.get("BILL_TIME_BUCKET");
        Map limitScopeMap = (Map)initParams.get("LIMIT_SCOPE");
        DataPackageStd dataPackage = accountingDaily.getDataPackage();
        List<TieDataNodeStd> paramDataNodes = dataPackage.getDataNodesByStepNumber(accountStage, (vaStep = AccountStepEnum.from((Long)PreDataAccountSteps.PD_LE_1010_S)).getCode());
        if (CollectionUtils.isEmpty(paramDataNodes)) {
            LOG.info("\u672a\u8fc7\u6ee4\u5230\u6307\u5b9a\u6b65\u9aa4\u4e0b\u7684dataNodes:accountStage:{} ", (Object)accountStage);
            return billApplyMap;
        }
        long personId = dataPackage.getAttPersonId();
        List<AttBillTimeBucket> billTimeBuckets = attBillTimeBucketData.getBillTimeBuckets(personId);
        Map<Long, DynamicObject> billDynsMap = billTimeBuckets.stream().filter(bucket -> bucket.getVaBillDyn() != null).map(AttBillTimeBucket::getVaBillDyn).collect(Collectors.toMap(dyn -> dyn.getLong("id"), dyn -> dyn, (dyn1, dyn2) -> dyn1));
        LocalDate chainDate = dataPackage.getChainDate();
        List<AttRecordModel> recordModelList = accountingDaily.getRecordModelList();
        Map<Long, AttRecordModel> recordModelMap = recordModelList.stream().collect(Collectors.toMap(AttRecordModel::getAttItemId, model -> model));
        AttFileModel attFileModel = attFileCabinet.getByAttPersonIdAndDate(personId, chainDate);
        if (attFileModel == null) {
            LOG.info("\u8003\u52e4\u6863\u6848\u5728\u5bf9\u5e94\u65e5\u672a\u67e5\u8be2\u5230\u7ed3\u679c\uff1apersonId\uff1a{}\uff0c chainDate:{}", (Object)personId, (Object)chainDate);
            return billApplyMap;
        }
        Map<Long, VaCalculateRule> ruleEntryMap = this.getVaRuleEntryMap(attFileModel, limitScopeMap, dataPackage);
        Map<Long, List<TimeBucketStd>> timeBucketMap = this.groupDataNodes(paramDataNodes, ruleEntryMap);
        if (LOG.isDebugEnabled()) {
            Set occurBillId = timeBucketMap.values().stream().flatMap(Collection::stream).filter(Objects::nonNull).map(TimeBucketStd::getAttendanceBillTag).filter(Objects::nonNull).map(AttendanceBillTag::getVaBillId).collect(Collectors.toSet());
            LOG.debug("\u51fa\u73b0\u8fc7\u7684\u5355\u636e, personId={}, billId={}", (Object)personId, occurBillId);
        }
        for (Map.Entry<Long, List<TimeBucketStd>> mapEntry : timeBucketMap.entrySet()) {
            Long resultId = mapEntry.getKey();
            AttRecordModel attRecordModel = recordModelMap.get(resultId);
            this.buildTimeBucketResult(request, billIds, chainDate, attRecordModel, mapEntry, ruleEntryMap, billApplyMap, billDynsMap);
        }
        return billApplyMap;
    }
}

