/*
 * Decompiled with CFR 0.152.
 */
package kd.wtc.wtes.business.core;

import kd.bos.exception.ErrorCode;
import kd.wtc.wtes.business.core.TieMessage;
import kd.wtc.wtes.business.core.TieMsgLevel;
import kd.wtc.wtes.common.lang.Nullable;
import kd.wtc.wtes.common.util.Assert;
import kd.wtc.wtes.common.util.ErrorCodeUtils;

public interface TieAlarm {
    public void alarm(TieMsgLevel var1, String var2);

    default public void alarm(TieMessage message) {
        this.alarm(message.getMsgLevel(), message.getMsg());
    }

    default public void alarm(TieMsgLevel msgLevel, ErrorCode errorCode, Object ... args) {
        Assert.nonNull((Object)((Object)msgLevel), (String)"msgLevel");
        Assert.nonNull((Object)errorCode, (String)"errorCode");
        this.alarm(msgLevel, "[" + errorCode.getCode() + "]:" + ErrorCodeUtils.getMessage((ErrorCode)errorCode, (Object[])args));
    }

    default public void alarm(TieMsgLevel msgLevel, String errorNumber, @Nullable String errorMsg) {
        Assert.nonNull((Object)((Object)msgLevel), (String)"msgLevel");
        Assert.notBlank((String)errorNumber, (String)"errorNumber");
        this.alarm(msgLevel, "[" + errorNumber + "]:" + errorMsg);
    }
}

