/*
 * Decompiled with CFR 0.152.
 */
package kd.wtc.wtes.business.core;

public enum TieState {
    NEW(1),
    INIT(2),
    RUNNING(4),
    TERMINATING(8),
    TERMINATED(16),
    ERROR(16),
    SUCCESS(16);

    private final byte num;

    private TieState(byte num) {
        this.num = num;
    }

    public boolean isAfter(TieState state) {
        if (state.isTerminating() && this == SUCCESS) {
            return false;
        }
        return this.num > state.num;
    }

    public boolean isAlive() {
        return (this.num & 7) != 0;
    }

    public boolean isDone() {
        return this.num == 16;
    }

    public boolean isTerminating() {
        return this.num == 8;
    }
}

