/*
 * Decompiled with CFR 0.152.
 */
package kd.wtc.wtes.business.core.chain;

import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import kd.bos.logging.Log;
import kd.wtc.wtbs.business.calreport.CalReportParaHolder;
import kd.wtc.wtbs.common.helper.WTCAppContextHelper;
import kd.wtc.wtes.business.core.TieAlarm;
import kd.wtc.wtes.business.core.TieMessage;
import kd.wtc.wtes.business.core.TieMsgLevel;
import kd.wtc.wtes.business.core.TieStatus;
import kd.wtc.wtes.business.core.chain.TieExecutionException;
import kd.wtc.wtes.business.core.chain.TieExecutor;
import kd.wtc.wtes.business.core.datanode.ITieDataNode;
import kd.wtc.wtes.business.log.TieLogFactory;
import kd.wtc.wtes.business.std.TieMessageStd;
import kd.wtc.wtes.common.util.Assert;

public abstract class AbstractTieExecutor<T extends ITieDataNode<T>>
implements TieExecutor<T>,
TieAlarm {
    private TieStatus resultStatus = TieStatus.UNKNOWN;
    private final List<T> resultDataNodes = new LinkedList<T>();
    private static final int VARIABLE_SIZE = 8;
    private final Map<String, Object> executorVariable = new HashMap<String, Object>(8);
    protected static final String EXECUTOR_TAG_DELIMITER = WTCAppContextHelper.getProjectParams().getString("tie.executor.tag.delimiter", ":");
    protected final Log log = TieLogFactory.getLog(this.getClass());
    protected final List<TieMessage> tieMessages = new LinkedList<TieMessage>();
    private CalReportParaHolder reportPara;

    @Override
    public void execute() {
        try {
            this.beforeExecute();
            this.init();
            this.doExecute();
            this.afterExecute();
            this.confirmResult();
        }
        catch (TieExecutionException e) {
            this.setResultStatus(TieStatus.EXCLUSION);
            this.tieMessages.add(new TieMessageStd(TieMsgLevel.WARNING, e.getMessage()));
        }
        finally {
            this.tieMessages.forEach(this::alarm);
        }
    }

    protected void beforeExecute() throws TieExecutionException {
    }

    protected void init() throws TieExecutionException {
    }

    protected abstract void doExecute() throws TieExecutionException;

    protected void afterExecute() throws TieExecutionException {
    }

    private void confirmResult() {
        if (this.resultStatus == TieStatus.UNKNOWN) {
            this.resultStatus = this.resultDataNodes.isEmpty() ? TieStatus.EXCLUSION : TieStatus.SUCCESS;
        }
    }

    @Override
    public TieStatus getResultStatus() {
        return this.resultStatus;
    }

    @Override
    public List<T> getResultDataNodes() {
        return this.resultDataNodes;
    }

    @Override
    public Map<String, Object> getExecutorVariable() {
        return this.executorVariable;
    }

    protected void setResultStatus(TieStatus resultStatus) {
        Assert.nonNull((Object)((Object)resultStatus), (String)"resultStatus");
        this.resultStatus = resultStatus;
    }

    protected void addResultDataNodes(List<T> dataNodes) {
        this.resultDataNodes.addAll(dataNodes);
    }

    @Override
    public List<TieMessage> getTieMessages() {
        return this.tieMessages;
    }

    @Override
    public CalReportParaHolder getReportPara() {
        return this.reportPara;
    }

    public void setReportPara(CalReportParaHolder reportPara) {
        this.reportPara = reportPara;
    }
}

