/*
 * Decompiled with CFR 0.152.
 */
package kd.wtc.wtes.business.core.chain;

import java.time.LocalDate;
import java.time.format.DateTimeFormatter;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.wtc.wtbs.business.calreport.CalReportParaHolder;
import kd.wtc.wtbs.business.subject.AttSubject;
import kd.wtc.wtbs.common.helper.WTCAppContextHelper;
import kd.wtc.wtes.business.core.TieAlarm;
import kd.wtc.wtes.business.core.TieMsgLevel;
import kd.wtc.wtes.business.core.TieRequest;
import kd.wtc.wtes.business.core.chain.AbstractTieExecutorsExecutor;
import kd.wtc.wtes.business.core.chain.TieChainExecutor;
import kd.wtc.wtes.business.core.chain.TieExecutionException;
import kd.wtc.wtes.business.core.chain.TieExecutor;
import kd.wtc.wtes.business.core.chain.TieIdService;
import kd.wtc.wtes.business.core.chain.TiePhaseExecutor;
import kd.wtc.wtes.business.core.chain.TieStatusDecision;
import kd.wtc.wtes.business.core.chain.TieStepExecutorUnitFactory;
import kd.wtc.wtes.business.core.chain.WrappedDataPackage;
import kd.wtc.wtes.business.core.datanode.DataPackage;
import kd.wtc.wtes.business.core.datanode.ITieDataNode;
import kd.wtc.wtes.business.core.datanode.PhaseDataResult;
import kd.wtc.wtes.business.core.datanode.TieDataNodeWrapper;
import kd.wtc.wtes.business.core.exporter.ITieLineExporter;
import kd.wtc.wtes.business.core.scheme.TiePhaseConfig;
import kd.wtc.wtes.business.core.scheme.TiePhaseIdentity;
import kd.wtc.wtes.business.core.scheme.TieScheme;
import kd.wtc.wtes.business.core.scheme.TieSchemeIdentity;
import kd.wtc.wtes.business.std.chain.TiePhaseExecutorStd;
import kd.wtc.wtes.common.util.Assert;

public class TieChainExecutorDefault<T extends ITieDataNode<T>>
extends AbstractTieExecutorsExecutor<T>
implements TieChainExecutor<T> {
    private LocalDate chainDate;
    private TieScheme tieScheme;
    private TieRequest tieRequest;
    private Map<String, Object> engineVariable;
    private Map<String, Object> lineVariable;
    private ITieLineExporter lineExporter;
    private TieDataNodeWrapper<T> dataNodeWrapper;
    private TieIdService idService;
    private TieStepExecutorUnitFactory<T> stepExecutorUnitFactory;
    private Map<String, Object> initParams;
    private TieSchemeIdentity schemeIdentity;
    private AttSubject.AttSubjectEntry attSubjectEntry;

    @Override
    protected void init() throws TieExecutionException {
        super.init();
        Assert.nonNull((Object)((Object)this.tieScheme), (String)"tieScheme");
        Assert.nonNull(this.lineVariable, (String)"lineVariable");
        Assert.nonNull((Object)this.chainDate, (String)"chainDate");
        Assert.nonNull((Object)this.tieRequest, (String)"tieRequest");
        Assert.nonNull(this.engineVariable, (String)"engineVariable");
        Assert.nonNull((Object)this.lineExporter, (String)"lineExporter");
        Assert.nonNull(this.dataNodeWrapper, (String)"dataNodeWrapper");
        Assert.nonNull((Object)this.idService, (String)"idService");
        Assert.nonNull(this.stepExecutorUnitFactory, (String)"stepExecutorUnitFactory");
        Assert.nonNull(this.initParams, (String)"initParams");
        Assert.nonNull((Object)this.attSubjectEntry, (String)"attSubjectEntry");
        this.schemeIdentity = new TieSchemeIdentity(this.tieScheme.getId(), this.tieScheme.getBid(), this.tieScheme.getNumber(), this.tieRequest.getNationalityId(), this.tieRequest.getNationalityNumber());
    }

    @Override
    public DataPackage<T> makeDataPackage() {
        return new WrappedDataPackage(this);
    }

    @Override
    protected int getExecutorSize() {
        return this.tieScheme.getPhaseProperties().size();
    }

    @Override
    protected TieExecutor<T> makeExecutor(int executorIndex) {
        TiePhaseConfig phaseConfig = this.tieScheme.getPhaseProperties().get(executorIndex);
        TiePhaseExecutor phase = (TiePhaseExecutor)WTCAppContextHelper.getBean(TiePhaseExecutorStd.class);
        phase.setChainExecutor(this);
        phase.setPhaseConfig(phaseConfig);
        CalReportParaHolder reportPara = this.getReportPara();
        phase.setReportPara(reportPara);
        phase.setPhaseIdentity(new TiePhaseIdentity(phaseConfig.getNumber(), this.getSchemeIdentity(), phaseConfig.getIndex(), phaseConfig.getSaveFlag(), phaseConfig.getResult(), phaseConfig.getId()));
        return phase;
    }

    @Override
    protected TieStatusDecision makeDecision() {
        TieStatusDecision tieStatusDecision = (TieStatusDecision)WTCAppContextHelper.getBean(TieStatusDecision.class);
        tieStatusDecision.mackDecisionMap(this.tieScheme.getPhaseDecisions());
        return tieStatusDecision;
    }

    @Override
    public String getExecutorTag() {
        return this.attSubjectEntry.getAttPersonId() + EXECUTOR_TAG_DELIMITER + this.chainDate.format(DateTimeFormatter.ofPattern("yyyyMMdd"));
    }

    @Override
    public String getExecutorName() {
        return null;
    }

    @Override
    public TieAlarm getAlarm() {
        return this.lineExporter;
    }

    @Override
    public Map<String, Object> getEngineVariable() {
        return this.engineVariable;
    }

    @Override
    public Map<String, Object> getLineVariable() {
        return this.lineVariable;
    }

    @Override
    public TieRequest getTieRequest() {
        return this.tieRequest;
    }

    @Override
    public LocalDate getChainDate() {
        return this.chainDate;
    }

    @Override
    public TieScheme getTieScheme() {
        return this.tieScheme;
    }

    @Override
    public void setTieScheme(TieScheme tieScheme) {
        this.tieScheme = tieScheme;
    }

    @Override
    public void setDataNodeWrapper(TieDataNodeWrapper<T> dataNodeWrapper) {
        this.dataNodeWrapper = dataNodeWrapper;
    }

    @Override
    public TieDataNodeWrapper<T> getDataNodeWrapper() {
        return this.dataNodeWrapper;
    }

    @Override
    public void setLineVariable(Map<String, Object> lineVariable) {
        this.lineVariable = lineVariable;
    }

    @Override
    public void setChainDate(LocalDate chainDate) {
        this.chainDate = chainDate;
    }

    @Override
    public void setTieRequest(TieRequest tieRequest) {
        this.tieRequest = tieRequest;
    }

    @Override
    public AttSubject.AttSubjectEntry getAttSubjectEntry() {
        return this.attSubjectEntry;
    }

    @Override
    public void setAttSubjectEntry(AttSubject.AttSubjectEntry attSubjectEntry) {
        this.attSubjectEntry = attSubjectEntry;
    }

    @Override
    public void setEngineVariable(Map<String, Object> engineVariable) {
        this.engineVariable = engineVariable;
    }

    @Override
    public void setInitParams(Map<String, Object> initParams) {
        this.initParams = initParams;
    }

    @Override
    public Map<String, Object> getInitParams() {
        return this.initParams;
    }

    @Override
    public void setLineExporter(ITieLineExporter lineExporter) {
        this.lineExporter = lineExporter;
    }

    @Override
    public List<TiePhaseExecutor<T>> getExecutedExecutors() {
        return super.getExecutedExecutors();
    }

    @Override
    public void alarm(TieMsgLevel msgLevel, String msg) {
        this.lineExporter.alarm(msgLevel, msg);
    }

    @Override
    public void setStepExecutorUnitFactory(TieStepExecutorUnitFactory<T> stepExecutorUnitFactory) {
        this.stepExecutorUnitFactory = stepExecutorUnitFactory;
    }

    @Override
    public TieStepExecutorUnitFactory<T> getStepExecutorUnitFactory() {
        return this.stepExecutorUnitFactory;
    }

    @Override
    public void setIdService(TieIdService idService) {
        this.idService = idService;
    }

    @Override
    public TieIdService getIdService() {
        return this.idService;
    }

    @Override
    public TieSchemeIdentity getSchemeIdentity() {
        return this.schemeIdentity;
    }

    @Override
    public List<PhaseDataResult<T>> getPhaseDataResults() {
        return this.getExecutedExecutors().stream().map(TiePhaseExecutor::getPhaseDataResult).collect(Collectors.toList());
    }
}

