/*
 * Decompiled with CFR 0.152.
 */
package kd.wtc.wtes.business.core.chain;

import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import kd.wtc.wtbs.business.subject.AttSubject;
import kd.wtc.wtes.business.core.TieRequest;
import kd.wtc.wtes.business.core.VScope;
import kd.wtc.wtes.business.core.chain.TieVariable;
import kd.wtc.wtes.business.core.datanode.DataPackage;
import kd.wtc.wtes.business.core.datanode.ITieDataNode;
import kd.wtc.wtes.business.core.datanode.PhaseDataResult;
import kd.wtc.wtes.business.core.datanode.StepDataResult;
import kd.wtc.wtes.business.core.scheme.TieStepIdentity;
import kd.wtc.wtes.common.lang.NotNull;
import kd.wtc.wtes.common.lang.Nullable;
import kd.wtc.wtes.common.lang.WtesBizException;
import kd.wtc.wtes.common.util.Assert;
import kd.wtc.wtes.common.util.CollectionUtils;

public interface TieContext<T extends ITieDataNode<T>> {
    public AttSubject.AttSubjectEntry getAttSubjectEntry();

    public TieRequest getRequest();

    public DataPackage<T> getDataPackage();

    default public List<T> getAllDataNodes() {
        return this.getDataPackage().getAllDataNodes();
    }

    default public List<T> getDataNodesByPhaseNumber(String phaseNumber) {
        return this.getDataPackage().getDataNodesByPhaseNumber(phaseNumber);
    }

    default public List<T> getDataNodesByStepNumber(String phaseNumber, String stepNumber) {
        Assert.nonNull((Object)phaseNumber, (String)"phaseNumber");
        Assert.nonNull((Object)stepNumber, (String)"stepNumber");
        return this.getDataNodesByPhaseNumber(phaseNumber).stream().filter(dataNode -> dataNode.getStepIdentity().getNumber().equals(stepNumber)).collect(Collectors.toList());
    }

    @Nullable
    default public T getDataNodeById(long id) {
        return (T)((ITieDataNode)this.getAllDataNodes().stream().filter(dataNode -> dataNode.getId() == id).findFirst().orElse(null));
    }

    default public List<T> getDataNodesOfPrevStepExecutor() {
        Optional<StepDataResult<StepDataResult>> lastExecutedStepResult = this.getDataPackage().getLastExecutedStepResult();
        return lastExecutedStepResult.map(stepDataResult -> CollectionUtils.unmodifiableList(stepDataResult.getDataNodes())).orElseGet(() -> Collections.emptyList());
    }

    default public List<T> getDataNodesInCurPhase() {
        Optional<PhaseDataResult<PhaseDataResult>> lastExecutedPhaseResult = this.getDataPackage().getLastPhaseResult();
        return lastExecutedPhaseResult.map(phaseResult -> {
            List dataNodesInStepResults = DataPackage.getDataNodesInStepResults(phaseResult.getStepDataResults());
            return CollectionUtils.unmodifiableList(dataNodesInStepResults);
        }).orElseGet(() -> Collections.emptyList());
    }

    public TieVariable getTieVariable();

    @Nullable
    default public Object setVariable(String key, Object value, VScope vScope) {
        return this.getTieVariable().getVariableMap(vScope).put(key, value);
    }

    @Nullable
    default public <V> V getVariable(String key, VScope vScope) {
        return (V)this.getTieVariable().getVariableMap(vScope).get(key);
    }

    default public boolean containsVariable(String key, VScope vScope) {
        return this.getTieVariable().getVariableMap(vScope).containsKey(key);
    }

    public Map<String, Object> getInitParams();

    @Nullable
    default public <V> V getInitParam(String key) {
        return (V)this.getInitParams().get(key);
    }

    default public <V> V getInitParamMust(String key, Class<V> paramType) {
        Object value = this.getInitParams().get(key);
        if (value == null) {
            throw new WtesBizException("Could not find [" + key + "] in init params");
        }
        if (!paramType.isInstance(value)) {
            throw new WtesBizException("Param type mismatch, expected: " + paramType.getName() + ",actual:" + value.getClass().getName() + ",the param key is: " + key);
        }
        return paramType.cast(value);
    }

    default public <V> Optional<V> getInitParamOptional(String key, Class<V> paramType) {
        Object value = this.getInitParams().get(key);
        if (value == null) {
            return Optional.empty();
        }
        if (!paramType.isInstance(value)) {
            throw new WtesBizException("Param type mismatch, expected: " + paramType.getName() + ",actual:" + value.getClass().getName() + ",the param key is: " + key);
        }
        return Optional.of(paramType.cast(value));
    }

    @NotNull
    public TieStepIdentity getTieStepIdentity();
}

