/*
 * Decompiled with CFR 0.152.
 */
package kd.wtc.wtes.business.core.chain;

import java.util.Map;
import kd.wtc.wtbs.business.subject.AttSubject;
import kd.wtc.wtes.business.core.TieRequest;
import kd.wtc.wtes.business.core.chain.TieChainExecutor;
import kd.wtc.wtes.business.core.chain.TieContext;
import kd.wtc.wtes.business.core.chain.TiePhaseExecutor;
import kd.wtc.wtes.business.core.chain.TieStepExecutor;
import kd.wtc.wtes.business.core.chain.TieVariable;
import kd.wtc.wtes.business.core.chain.WrappedDataPackage;
import kd.wtc.wtes.business.core.datanode.DataPackage;
import kd.wtc.wtes.business.core.datanode.ITieDataNode;
import kd.wtc.wtes.business.core.scheme.TieStepIdentity;
import kd.wtc.wtes.common.util.Assert;

public class TieContextDefault<T extends ITieDataNode<T>>
implements TieContext<T> {
    private final TieStepIdentity tieStepIdentity;
    private final TieRequest tieRequest;
    private final DataPackage<T> dataPackage;
    private final TieVariable tieVariable;
    private final Map<String, Object> initParams;
    private final AttSubject.AttSubjectEntry attSubjectEntry;

    public TieContextDefault(TieStepExecutor<T> stepExecutor) {
        TiePhaseExecutor<T> phaseExecutor = stepExecutor.getPhaseExecutor();
        Assert.nonNull(phaseExecutor, (String)"phaseExecutor");
        TieChainExecutor<T> chainExecutor = phaseExecutor.getChainExecutor();
        Assert.nonNull(chainExecutor, (String)"chainExecutor");
        WrappedDataPackage<T> dataPackage = new WrappedDataPackage<T>(chainExecutor);
        TieVariable tieVariable = new TieVariable(chainExecutor.getEngineVariable(), chainExecutor.getLineVariable(), chainExecutor.getExecutorVariable(), phaseExecutor.getExecutorVariable(), stepExecutor.getExecutorVariable());
        this.tieStepIdentity = stepExecutor.getStepIdentity();
        this.attSubjectEntry = chainExecutor.getAttSubjectEntry();
        this.tieRequest = chainExecutor.getTieRequest();
        this.dataPackage = dataPackage;
        this.tieVariable = tieVariable;
        this.initParams = chainExecutor.getInitParams();
    }

    @Override
    public AttSubject.AttSubjectEntry getAttSubjectEntry() {
        return this.attSubjectEntry;
    }

    @Override
    public TieRequest getRequest() {
        return this.tieRequest;
    }

    @Override
    public DataPackage<T> getDataPackage() {
        return this.dataPackage;
    }

    @Override
    public TieVariable getTieVariable() {
        return this.tieVariable;
    }

    @Override
    public Map<String, Object> getInitParams() {
        return this.initParams;
    }

    @Override
    public TieStepIdentity getTieStepIdentity() {
        return this.tieStepIdentity;
    }

    public String toString() {
        return "TieContextDefault{tieStepIdentity=" + this.tieStepIdentity + ", attPersonTieRange=" + this.attSubjectEntry + ", tieRequest=" + this.tieRequest + ", dataPackage=" + this.dataPackage + ", tieVariable=" + this.tieVariable + ", initParams=" + this.initParams + '}';
    }
}

