/*
 * Decompiled with CFR 0.152.
 */
package kd.wtc.wtes.business.core.chain;

import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.wtc.wtes.business.core.TieStatus;
import kd.wtc.wtes.business.core.chain.TiePointer;
import kd.wtc.wtes.business.core.scheme.DecisionConfig;

public class TieStatusDecision {
    private Map<String, TiePointer> decisionMap;

    public void mackDecisionMap(List<DecisionConfig> decisionProperties) {
        if (decisionProperties == null) {
            this.decisionMap = Collections.emptyMap();
        } else {
            this.decisionMap = new HashMap<String, TiePointer>(decisionProperties.size());
            for (DecisionConfig statusDecision : decisionProperties) {
                this.decisionMap.put(this.key(statusDecision.getPrefix(), statusDecision.getStatus()), statusDecision.getTp());
            }
        }
    }

    public TiePointer decide(String prefix, TieStatus status) {
        TiePointer tp = this.decisionMap.get(this.key(prefix, status));
        if (tp == null) {
            return this.defaultDecision(status);
        }
        return tp;
    }

    protected TiePointer defaultDecision(TieStatus status) {
        switch (status) {
            case SUCCESS: {
                return TiePointer.NEXT;
            }
            case EXCLUSION: {
                return TiePointer.CONTINUE;
            }
        }
        return TiePointer.ERROR;
    }

    private String key(String prefix, TieStatus status) {
        return prefix + "_" + (Object)((Object)status);
    }
}

