/*
 * Decompiled with CFR 0.152.
 */
package kd.wtc.wtes.business.core.datanode;

import java.time.LocalDate;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.ListIterator;
import java.util.Optional;
import java.util.stream.Collectors;
import kd.wtc.wtes.business.core.TieStatus;
import kd.wtc.wtes.business.core.datanode.ITieDataNode;
import kd.wtc.wtes.business.core.datanode.PhaseDataResult;
import kd.wtc.wtes.business.core.datanode.StepDataResult;
import kd.wtc.wtes.business.core.scheme.TieSchemeIdentity;
import kd.wtc.wtes.common.util.Assert;

public interface DataPackage<T extends ITieDataNode<T>> {
    public boolean isEmptyDataPackage();

    public void setEmptyDataPackage(boolean var1);

    public List<T> getAllDataNodes();

    public List<PhaseDataResult<T>> getPhaseDataResults();

    public String getVersion();

    public long getAttPersonId();

    public LocalDate getChainDate();

    public TieStatus getResultStatus();

    public TieSchemeIdentity getTieSchemeIdentity();

    default public Optional<PhaseDataResult<T>> getFirstPhaseResult() {
        List<PhaseDataResult<T>> phaseDataResults = this.getPhaseDataResults();
        if (phaseDataResults.isEmpty()) {
            return Optional.empty();
        }
        return Optional.of(phaseDataResults.get(0));
    }

    default public Optional<StepDataResult<T>> getFirstStepResult() {
        return this.getFirstPhaseResult().map(phaseDataResult -> {
            List stepDataResults = phaseDataResult.getStepDataResults();
            if (stepDataResults.isEmpty()) {
                return null;
            }
            return stepDataResults.get(0);
        });
    }

    default public Optional<PhaseDataResult<T>> getLastPhaseResult() {
        List<PhaseDataResult<T>> phaseDataResults = this.getPhaseDataResults();
        if (phaseDataResults.isEmpty()) {
            return Optional.empty();
        }
        return Optional.of(phaseDataResults.get(phaseDataResults.size() - 1));
    }

    default public Optional<StepDataResult<T>> getLastStepResult() {
        return this.getLastPhaseResult().map(phaseDataResult -> {
            List stepDataResults = phaseDataResult.getStepDataResults();
            if (stepDataResults.isEmpty()) {
                return null;
            }
            return stepDataResults.get(stepDataResults.size() - 1);
        });
    }

    default public Optional<StepDataResult<T>> getLastExecutedStepResult() {
        return this.getLastPhaseResult().map(phaseDataResult -> {
            List stepDataResults = phaseDataResult.getStepDataResults();
            if (stepDataResults.isEmpty()) {
                return null;
            }
            for (int i = stepDataResults.size() - 1; i >= 0; --i) {
                StepDataResult stepDataResult = stepDataResults.get(i);
                if (stepDataResult.getResultStatus() == TieStatus.UNKNOWN) continue;
                return stepDataResult;
            }
            return null;
        });
    }

    default public List<PhaseDataResult<T>> getPhaseResultsBeforePhase(String phaseNumber) {
        Assert.nonNull((Object)phaseNumber, (String)"phaseNumber");
        LinkedList<PhaseDataResult<T>> results = new LinkedList<PhaseDataResult<T>>();
        for (PhaseDataResult<T> phaseDataResult : this.getPhaseDataResults()) {
            if (!phaseDataResult.getNumber().equals(phaseNumber)) {
                results.add(phaseDataResult);
                continue;
            }
            return results;
        }
        return Collections.emptyList();
    }

    default public List<T> getDataNodesBeforePhase(String phaseNumber) {
        List<PhaseDataResult<T>> results = this.getPhaseResultsBeforePhase(phaseNumber);
        return DataPackage.getDataNodesInPhaseResults(results);
    }

    default public Optional<PhaseDataResult<T>> getPhaseResultByPhaseNumber(String phaseNumber) {
        return this.getPhaseDataResults().stream().filter(phaseDataResult -> phaseDataResult.getNumber().equals(phaseNumber)).findFirst();
    }

    default public List<T> getDataNodesByPhaseNumber(String phaseNumber) {
        Assert.nonNull((Object)phaseNumber, (String)"phaseNumber");
        Optional<PhaseDataResult<PhaseDataResult>> phaseResult = this.getPhaseResultByPhaseNumber(phaseNumber);
        LinkedList dataNodes = new LinkedList();
        phaseResult.ifPresent(result -> dataNodes.addAll(DataPackage.getDataNodesInStepResults(result.getStepDataResults())));
        return dataNodes;
    }

    default public List<PhaseDataResult<T>> getPhaseResultsAfterPhase(String phaseNumber) {
        Assert.nonNull((Object)phaseNumber, (String)"phaseNumber");
        LinkedList<PhaseDataResult<T>> results = new LinkedList<PhaseDataResult<T>>();
        List<PhaseDataResult<T>> phaseDataResultList = this.getPhaseDataResults();
        if (!phaseDataResultList.isEmpty()) {
            ListIterator<PhaseDataResult<T>> iterator = phaseDataResultList.listIterator(phaseDataResultList.size() - 1);
            while (iterator.hasPrevious()) {
                PhaseDataResult<T> phaseDataResult = iterator.previous();
                if (!phaseDataResult.getNumber().equals(phaseNumber)) {
                    results.add(phaseDataResult);
                    continue;
                }
                return results;
            }
        }
        return Collections.emptyList();
    }

    default public List<T> getDataNodesAfterPhase(String phaseNumber) {
        List<PhaseDataResult<T>> results = this.getPhaseResultsAfterPhase(phaseNumber);
        return DataPackage.getDataNodesInPhaseResults(results);
    }

    public static <T extends ITieDataNode<T>> List<T> getDataNodesInPhaseResults(List<PhaseDataResult<T>> phaseDataResults) {
        if (phaseDataResults.isEmpty()) {
            return Collections.emptyList();
        }
        LinkedList<T> dataNodes = new LinkedList<T>();
        for (PhaseDataResult<T> result : phaseDataResults) {
            dataNodes.addAll(DataPackage.getDataNodesInStepResults(result.getStepDataResults()));
        }
        return dataNodes;
    }

    public static <T extends ITieDataNode<T>> List<T> getDataNodesInStepResults(List<StepDataResult<T>> stepDataResults) {
        if (stepDataResults.isEmpty()) {
            return Collections.emptyList();
        }
        LinkedList<T> dataNodes = new LinkedList<T>();
        for (StepDataResult<T> result : stepDataResults) {
            dataNodes.addAll(result.getDataNodes());
        }
        return dataNodes;
    }

    default public List<T> getDataNodesByStepNumber(String phaseNumber, String stepNumber) {
        Assert.nonNull((Object)phaseNumber, (String)"phaseNumber");
        Assert.nonNull((Object)stepNumber, (String)"stepNumber");
        return this.getDataNodesByPhaseNumber(phaseNumber).stream().filter(dataNode -> dataNode.getStepIdentity().getNumber().equals(stepNumber)).collect(Collectors.toList());
    }
}

