/*
 * Decompiled with CFR 0.152.
 */
package kd.wtc.wtes.business.core.datanode;

import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.stream.Collectors;
import kd.wtc.wtes.business.core.TieStatus;
import kd.wtc.wtes.business.core.datanode.ITieDataNode;
import kd.wtc.wtes.business.core.datanode.StepDataResult;

public interface PhaseDataResult<T extends ITieDataNode<T>> {
    public List<StepDataResult<T>> getStepDataResults();

    default public List<T> getPhaseLeafDataNodes() {
        List<StepDataResult<T>> stepDataResults = this.getStepDataResults();
        if (stepDataResults.isEmpty()) {
            return Collections.emptyList();
        }
        LinkedList<T> phaseResult = new LinkedList<T>();
        for (StepDataResult<T> stepDataResult : stepDataResults) {
            phaseResult.addAll(stepDataResult.getDataNodes());
        }
        return phaseResult.stream().filter(ITieDataNode::isLeafInPhase).collect(Collectors.toList());
    }

    public String getNumber();

    public TieStatus getResultStatus();

    public String getName();

    public Long getId();
}

