/*
 * Decompiled with CFR 0.152.
 */
package kd.wtc.wtes.business.core.engine;

import java.time.format.DateTimeFormatter;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Callable;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorCompletionService;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import java.util.stream.Collectors;
import kd.bos.context.RequestContext;
import kd.bos.threads.ThreadPools;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.wtc.wtbs.business.subject.AttSubject;
import kd.wtc.wtbs.business.task.trace.Span;
import kd.wtc.wtbs.business.task.trace.TaskDesc;
import kd.wtc.wtbs.business.task.trace.TaskTracer;
import kd.wtc.wtbs.common.helper.WTCAppContextHelper;
import kd.wtc.wtbs.common.util.Tuple;
import kd.wtc.wtbs.common.util.WTCCollections;
import kd.wtc.wtbs.wtes.common.calreport.CalcReportConstants;
import kd.wtc.wtes.business.core.TieEngineErrorCodes;
import kd.wtc.wtes.business.core.TieException;
import kd.wtc.wtes.business.core.TieRequest;
import kd.wtc.wtes.business.core.TieState;
import kd.wtc.wtes.business.core.datanode.ITieDataNode;
import kd.wtc.wtes.business.core.engine.AbstractTieEngine;
import kd.wtc.wtes.business.core.engine.TieLine;
import kd.wtc.wtes.business.core.engine.TieParamInitExecutor;
import kd.wtc.wtes.business.core.init.InitParamRequest;
import kd.wtc.wtes.business.core.init.InitParamResult;
import kd.wtc.wtes.business.core.init.TieParamInitializer;
import kd.wtc.wtes.common.lang.WtesException;
import kd.wtc.wtes.common.util.CollectionUtils;

public class TieEngineConcurrent<T extends ITieDataNode<T>>
extends AbstractTieEngine<T> {
    private volatile Map<Long, Future<?>> attPersonId2LineFutureMap;
    private List<Future<Tuple<String, InitParamResult>>> initFutures;
    static final int DEFAULT_LINE_POOL_SIZE = 2;
    static final int LINE_POOL_SIZE = WTCAppContextHelper.getProjectParams().getIntValue("tie.line.pool.size", 2);
    static final String DEFAULT_LINE_POOL_NAME = "TieLinePool";
    static final String LINE_POOL_NAME = WTCAppContextHelper.getProjectParams().getString("tie.line.pool.name", "TieLinePool");
    private static final ExecutorService LINE_EXECUTOR_SERVICE = ThreadPools.newExecutorService((String)LINE_POOL_NAME, (int)LINE_POOL_SIZE);

    @Override
    protected Map<String, Object> loadInitParams(List<TieParamInitializer> initialises, InitParamRequest initRequest) throws InterruptedException, TieException {
        RequestContext requestContext = RequestContext.get();
        List tieParamInitExecutors = initialises.stream().map(initializer -> TaskTracer.wrap((Callable)new TieParamInitExecutor((TieParamInitializer)initializer, initRequest))).collect(Collectors.toList());
        this.initFutures = INIT_EXECUTOR_SERVICE.invokeAll(tieParamInitExecutors);
        HashMap<String, Object> params = new HashMap<String, Object>();
        for (Future<Tuple<String, InitParamResult>> future : this.initFutures) {
            Tuple<String, InitParamResult> tuple;
            this.checkInterrupt();
            try {
                tuple = future.get();
            }
            catch (ExecutionException e) {
                this.log.warn("[TIE] init error ", (Throwable)e);
                this.terminateRunningInitializer();
                throw new TieException(e.getCause(), TieEngineErrorCodes.getParamInitErr(), e.getCause().getMessage());
            }
            if (((InitParamResult)tuple.getValue()).hasParams()) {
                params.put((String)tuple.getKey(), ((InitParamResult)tuple.getValue()).getInitData());
            }
            if (!((InitParamResult)tuple.getValue()).hasMessage()) continue;
            this.exporter.alarm(((InitParamResult)tuple.getValue()).getMessage());
        }
        return params;
    }

    @Override
    protected void terminateRunningInitializer() {
        if (WTCCollections.isNotEmpty(this.initFutures)) {
            for (Future<Tuple<String, InitParamResult>> initFuture : this.initFutures) {
                initFuture.cancel(true);
            }
        }
    }

    @Override
    protected void doRun() throws InterruptedException, TieException {
        List<AttSubject> attSubjects = this.getAttSubjects();
        ExecutorCompletionService completionService = new ExecutorCompletionService(LINE_EXECUTOR_SERVICE);
        this.attPersonId2LineFutureMap = new ConcurrentHashMap(attSubjects.size());
        for (AttSubject attSubject : attSubjects) {
            Future future = completionService.submit(TaskTracer.wrap(() -> {
                try (Span lineSpan = TaskTracer.newSpan((String)(CalcReportConstants.CALCULATE_PIPELINE + "[" + attSubject.getAttPersonId() + "]"));){
                    lineSpan.info(CalcReportConstants.CALCULATE_DATE_RANGER, (Object)(attSubject.getStartDate() + "," + attSubject.getEndDate()));
                    TieLine currentLine = this.makeLine(attSubject);
                    currentLine.run();
                    this.attPersonId2LineFutureMap.remove(attSubject.getAttPersonId());
                    this.addDataPackageReportNode(currentLine);
                    if (currentLine.isError()) {
                        lineSpan.error(CalcReportConstants.RESULT_FAILED_REMARK, (Object)currentLine.getExceptionStr());
                    }
                    lineSpan.info(CalcReportConstants.CALCULATE_RESULT, () -> currentLine.getState() == TieState.SUCCESS ? CalcReportConstants.RESULT_SUCCESS : CalcReportConstants.RESULT_FAILED);
                    TieLine tieLine = currentLine;
                    return tieLine;
                }
            }, (String)CalcReportConstants.CALCULATE_PIPELINE));
            this.attPersonId2LineFutureMap.put(attSubject.getAttPersonId(), future);
        }
        int size = attSubjects.size();
        int finishLine = 0;
        for (int i = 0; i < size; ++i) {
            TieLine currentLine;
            this.checkInterrupt();
            try {
                currentLine = (TieLine)completionService.take().get();
            }
            catch (ExecutionException e) {
                this.log.warn("TieEngineConcurrent_run", (Throwable)e);
                throw new WtesException(e.getCause().getCause(), TieEngineErrorCodes.getLineRunnerErr(), new Object[]{e.getCause().getMessage()});
            }
            if (currentLine.isError()) {
                this.exporter.errorOneLine(currentLine.getAttSubject());
            } else if (currentLine.isSuccess()) {
                this.exporter.finishOneLine(currentLine.getAttSubject());
            }
            this.reportProcess(size, ++finishLine);
        }
        this.storeLastDataPackage();
        this.waitStoreFinished();
    }

    @Override
    public TaskDesc getTaskDesc(TieRequest request) {
        return new TaskDesc("wtte_tie", request.getVersion(), request.getTaskId(), request.getSubTaskId(), 0L, request.getShardingIndex(), request.getCreateUserId());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        TieRequest request = this.getTieRequest();
        TaskDesc taskDesc = new TaskDesc("wtte_tie", request.getVersion(), request.getTaskId(), request.getSubTaskId(), 0L, request.getShardingIndex(), request.getCreateUserId());
        try (TaskTracer taskTracer = TaskTracer.makeTracer((TaskDesc)taskDesc);){
            Span rootSpan = TaskTracer.newRootSpan();
            try {
                super.run();
            }
            catch (Throwable throwable) {
                if (HRStringUtils.isNotEmpty((String)this.exceptionStr)) {
                    rootSpan.error(CalcReportConstants.RESULT_FAILED_REMARK, (Object)this.exceptionStr);
                }
                rootSpan.info(CalcReportConstants.SUBTASK_DISPATCHED_TIME, (Object)request.getSubTaskDispatchedTime().format(DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm:ss")));
                rootSpan.info(CalcReportConstants.CALCULATE_RESULT, (Object)(this.getState() == TieState.SUCCESS ? CalcReportConstants.RESULT_SUCCESS : CalcReportConstants.RESULT_FAILED));
                rootSpan.close();
                throw throwable;
            }
            if (HRStringUtils.isNotEmpty((String)this.exceptionStr)) {
                rootSpan.error(CalcReportConstants.RESULT_FAILED_REMARK, (Object)this.exceptionStr);
            }
            rootSpan.info(CalcReportConstants.SUBTASK_DISPATCHED_TIME, (Object)request.getSubTaskDispatchedTime().format(DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm:ss")));
            rootSpan.info(CalcReportConstants.CALCULATE_RESULT, (Object)(this.getState() == TieState.SUCCESS ? CalcReportConstants.RESULT_SUCCESS : CalcReportConstants.RESULT_FAILED));
            rootSpan.close();
        }
    }

    @Override
    protected void terminateRunningLines() {
        if (CollectionUtils.isNotEmpty(this.attPersonId2LineFutureMap)) {
            for (Future<?> future : this.attPersonId2LineFutureMap.values()) {
                future.cancel(true);
            }
            this.attPersonId2LineFutureMap.clear();
        }
    }
}

