/*
 * Decompiled with CFR 0.152.
 */
package kd.wtc.wtes.business.core.init;

import java.time.LocalDate;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.sdk.wtc.wtes.business.tie.model.init.TieRequestExt;
import kd.wtc.wtbs.business.subject.AttSubject;
import kd.wtc.wtbs.common.util.third.collect.Lists;
import kd.wtc.wtes.business.core.TieRequest;
import kd.wtc.wtes.business.core.init.InitParam;
import kd.wtc.wtes.common.lang.NotNull;

public class InitParamRequest
implements InitParam,
TieRequestExt {
    private final List<Long> attPersonIds;
    private final LocalDate startDate;
    private final LocalDate endDate;
    private final TieRequest request;
    private final Map<String, Object> initParams = new HashMap<String, Object>(16);
    private List<AttSubject> attSubjects;

    public InitParamRequest(List<Long> attPersonIds, LocalDate startDate, LocalDate endDate, TieRequest request) {
        if (attPersonIds == null || startDate == null || endDate == null || request == null) {
            throw new NullPointerException();
        }
        this.attPersonIds = attPersonIds;
        this.startDate = startDate;
        this.endDate = endDate;
        this.request = request;
    }

    @Override
    @NotNull
    public List<Long> getAttPersonIds() {
        return this.attPersonIds;
    }

    @Override
    @NotNull
    public LocalDate getStartDate() {
        return this.startDate;
    }

    @Override
    @NotNull
    public LocalDate getEndDate() {
        return this.endDate;
    }

    @Override
    @NotNull
    public TieRequest getRequest() {
        return this.request;
    }

    @Override
    public Map<String, Object> getInitParams() {
        return this.initParams;
    }

    @Override
    public List<Long> getAttFileBoIdList() {
        ArrayList allFileBoIdList = Lists.newArrayListWithExpectedSize((int)this.attSubjects.size());
        for (AttSubject attSubject : this.attSubjects) {
            List attFileBoIdList = attSubject.getAttFileBos().stream().map(AttSubject.AttFileBo::getAttFileBoid).distinct().collect(Collectors.toList());
            allFileBoIdList.addAll(attFileBoIdList);
        }
        return allFileBoIdList;
    }

    @Override
    public long getNationalityId() {
        return this.request.getNationalityId();
    }

    public void putInitParams(Map<String, Object> map) {
        this.initParams.putAll(map);
    }

    public List<AttSubject> getAttSubjects() {
        return this.attSubjects;
    }

    public String toString() {
        return "InitParamRequest{attPersonIds=" + this.attPersonIds + ", startDate=" + this.startDate + ", endDate=" + this.endDate + ", request=" + this.request + '}';
    }

    public InitParamRequest(List<Long> attPersonIds, LocalDate startDate, LocalDate endDate, TieRequest request, List<AttSubject> attSubjects) {
        if (attPersonIds == null || startDate == null || endDate == null || request == null) {
            throw new NullPointerException();
        }
        this.attPersonIds = attPersonIds;
        this.startDate = startDate;
        this.endDate = endDate;
        this.request = request;
        this.attSubjects = attSubjects;
    }
}

