/*
 * Decompiled with CFR 0.152.
 */
package kd.wtc.wtes.business.core.scheme;

import java.time.LocalDate;
import java.util.List;
import java.util.stream.Collectors;
import kd.wtc.wtbs.business.timeseq.TimeSeqBo;
import kd.wtc.wtes.business.builder.DetectableBuilder;
import kd.wtc.wtes.business.core.scheme.DecisionConfig;
import kd.wtc.wtes.business.core.scheme.TieScheme;
import kd.wtc.wtes.business.core.scheme.TieStepConfig;
import kd.wtc.wtes.common.enums.TiePhaseRusultEnum;
import kd.wtc.wtes.common.util.CollectionUtils;

public class TiePhaseConfig {
    private final List<DecisionConfig> executorDecision;
    private final List<TimeSeqBo<TieStepConfig>> executorProperties;
    private final TieScheme planProperties;
    private final int index;
    private final String number;
    private final String name;
    private final TiePhaseRusultEnum result;
    private final boolean saveFlag;
    private final long phaseTypeId;
    private final long id;
    private final boolean delete;
    private final String accountType;

    protected TiePhaseConfig(Builder<?, ?> builder) {
        this.executorDecision = ((Builder)builder).executorDecision;
        this.executorProperties = ((Builder)builder).executorProperties;
        this.planProperties = ((Builder)builder).planProperties;
        this.index = ((Builder)builder).index;
        this.number = ((Builder)builder).number;
        this.name = ((Builder)builder).name;
        this.result = ((Builder)builder).result;
        this.saveFlag = ((Builder)builder).saveFlag;
        this.delete = ((Builder)builder).delete;
        this.phaseTypeId = ((Builder)builder).phaseTypeId;
        this.id = ((Builder)builder).id;
        this.accountType = ((Builder)builder).accountType;
    }

    public String getNumber() {
        return this.number;
    }

    public String getName() {
        return this.name;
    }

    public static Builder<?, ?> with() {
        return new BuilderImpl();
    }

    public boolean getSaveFlag() {
        return this.saveFlag;
    }

    public TieScheme getPlanProperties() {
        return this.planProperties;
    }

    public String getAccountType() {
        return this.accountType;
    }

    public List<DecisionConfig> getExecutorDecision() {
        return CollectionUtils.unmodifiableList(this.executorDecision);
    }

    public List<TimeSeqBo<TieStepConfig>> getExecutorProperties() {
        return CollectionUtils.unmodifiableList(this.executorProperties);
    }

    public List<TieStepConfig> getStepConfigsByDate(LocalDate inDate) {
        return this.executorProperties.stream().map(executorPropertyBO -> (TieStepConfig)executorPropertyBO.getVersionByDate(inDate)).collect(Collectors.toList());
    }

    public TiePhaseRusultEnum getResult() {
        return this.result;
    }

    public boolean getDelete() {
        return this.delete;
    }

    public long getPhaseTypeId() {
        return this.phaseTypeId;
    }

    public long getId() {
        return this.id;
    }

    public int getIndex() {
        return this.index;
    }

    public String toString() {
        return "TiePhaseProperties{executorDecision=" + this.executorDecision + ", executorProperties=" + this.executorProperties + ", schemeNumber=" + this.planProperties.getNumber() + '}';
    }

    private static class BuilderImpl
    extends Builder<TiePhaseConfig, BuilderImpl> {
        private BuilderImpl() {
        }

        @Override
        protected TiePhaseConfig building() {
            return new TiePhaseConfig(this);
        }

        @Override
        protected void check(TiePhaseConfig phaseConfig) {
        }

        @Override
        protected BuilderImpl self() {
            return this;
        }
    }

    public static abstract class Builder<E extends TiePhaseConfig, B extends Builder<E, B>>
    extends DetectableBuilder<E, B> {
        private String number;
        private String name;
        private long id;
        private List<DecisionConfig> executorDecision;
        private List<TimeSeqBo<TieStepConfig>> executorProperties;
        private TieScheme planProperties;
        private int index;
        private TiePhaseRusultEnum result;
        private boolean saveFlag;
        private boolean delete;
        private long phaseTypeId;
        private String accountType;

        public B executorDecision(List<DecisionConfig> executorDecision) {
            this.executorDecision = executorDecision;
            return (B)((Builder)this.self());
        }

        public B executorProperties(List<? extends TimeSeqBo<TieStepConfig>> executorProperties) {
            this.executorProperties = executorProperties;
            return (B)((Builder)this.self());
        }

        public B planProperties(TieScheme planProperties) {
            this.planProperties = planProperties;
            return (B)((Builder)this.self());
        }

        public B number(String number) {
            this.number = number;
            return (B)((Builder)this.self());
        }

        public B name(String name) {
            this.name = name;
            return (B)((Builder)this.self());
        }

        public B index(int index) {
            this.index = index;
            return (B)((Builder)this.self());
        }

        public B delete(boolean delete) {
            this.delete = delete;
            return (B)((Builder)this.self());
        }

        public B phaseTypeId(long phaseTypeId) {
            this.phaseTypeId = phaseTypeId;
            return (B)((Builder)this.self());
        }

        public B result(TiePhaseRusultEnum result) {
            this.result = result;
            return (B)((Builder)this.self());
        }

        public B saveFlag(boolean saveFlag) {
            this.saveFlag = saveFlag;
            return (B)((Builder)this.self());
        }

        public B id(long id) {
            this.id = id;
            return (B)((Builder)this.self());
        }

        public B accountType(String accountType) {
            this.accountType = accountType;
            return (B)((Builder)this.self());
        }

        public List<DecisionConfig> getExecutorDecision() {
            return this.executorDecision;
        }

        public List<TimeSeqBo<TieStepConfig>> getExecutorProperties() {
            return this.executorProperties;
        }

        public TieScheme getPlanProperties() {
            return this.planProperties;
        }

        public String getNumber() {
            return this.number;
        }

        public int getIndex() {
            return this.index;
        }

        public String getName() {
            return this.name;
        }

        public boolean getSaveFlag() {
            return this.saveFlag;
        }
    }
}

