/*
 * Decompiled with CFR 0.152.
 */
package kd.wtc.wtes.business.core.scheme;

import java.time.LocalDate;
import java.util.List;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.wtc.wtbs.business.timeseq.AbstractTimeSeqVersion;
import kd.wtc.wtbs.business.timeseq.TimeSeqInfo;
import kd.wtc.wtes.business.core.scheme.TiePhaseConfig;
import kd.wtc.wtes.common.lang.Nullable;
import kd.wtc.wtes.common.util.Assert;

public class TieStepConfig
extends AbstractTimeSeqVersion {
    private String tieUnitType;
    @Nullable
    private String filterName;
    private String evaluatorName;
    private TiePhaseConfig phaseProperties;
    private String name;
    private String number;
    private String accountType;
    private Long stepEntryId;
    private Long evaluatorId;

    protected TieStepConfig(Builder<?, ?> builder) {
        super(builder);
        this.tieUnitType = ((Builder)builder).tieUnitType;
        this.filterName = ((Builder)builder).filterName;
        this.evaluatorName = ((Builder)builder).evaluatorName;
        this.evaluatorId = ((Builder)builder).evaluatorId;
        this.phaseProperties = ((Builder)builder).phaseProperties;
        this.name = ((Builder)builder).name;
        this.accountType = ((Builder)builder).accountType;
        this.number = ((Builder)builder).number;
        this.stepEntryId = ((Builder)builder).stepEntryId;
    }

    public static Builder<?, ?> withTimeSeq(TimeSeqInfo timeSeqInfo) {
        return new BuilderImpl(timeSeqInfo);
    }

    public static Builder<?, ?> withNonTimeSeq(long id, String number) {
        return new BuilderImpl(id, number);
    }

    public String getName() {
        return this.name;
    }

    public String getTieUnitType() {
        return this.tieUnitType;
    }

    public String getFilterName() {
        return this.filterName;
    }

    public String getEvaluatorName() {
        return this.evaluatorName;
    }

    public TiePhaseConfig getPhaseProperties() {
        return this.phaseProperties;
    }

    public Long getStepEntryId() {
        return this.stepEntryId;
    }

    public String getAccountType() {
        return this.accountType;
    }

    public Long getEvaluatorId() {
        return this.evaluatorId;
    }

    public String getNumber() {
        return this.number;
    }

    public byte getIndex(LocalDate inDate) {
        List<TieStepConfig> stepConfigs = this.getPhaseProperties().getStepConfigsByDate(inDate);
        for (int i = 0; i < stepConfigs.size(); ++i) {
            if (!((Object)((Object)this)).equals((Object)stepConfigs.get(i))) continue;
            return (byte)i;
        }
        return -1;
    }

    public String toString() {
        return "TieStepConfig{id='" + this.getId() + '\'' + ", number='" + this.getNumber() + '\'' + ", tieUnitType='" + this.tieUnitType + '\'' + ", filterName='" + this.filterName + '\'' + ", evaluatorName='" + this.evaluatorName + '\'' + '}';
    }

    private static class BuilderImpl
    extends Builder<TieStepConfig, BuilderImpl> {
        protected BuilderImpl(TimeSeqInfo timeSeqInfo) {
            super(timeSeqInfo);
        }

        protected BuilderImpl(long id, String number) {
            super(id, number);
        }

        protected BuilderImpl self() {
            return this;
        }

        @Override
        protected void check() {
            super.check();
        }

        public TieStepConfig building() {
            return new TieStepConfig(this);
        }
    }

    public static abstract class Builder<E extends TieStepConfig, B extends Builder<E, B>>
    extends AbstractTimeSeqVersion.Builder<E, B> {
        private String name;
        private String number;
        private String tieUnitType;
        private String filterName;
        private String evaluatorName;
        private Long evaluatorId;
        private String checkerName;
        private TiePhaseConfig phaseProperties;
        private Long stepEntryId;
        private String accountType;

        protected Builder(TimeSeqInfo timeSeqInfo) {
            super(timeSeqInfo);
        }

        protected Builder(long id, String number) {
            super(id, number);
        }

        public B name(String name) {
            this.name = name;
            return (B)((Object)((Builder)this.self()));
        }

        public B number(String number) {
            this.number = number;
            return (B)((Object)((Builder)this.self()));
        }

        public B tieUnitType(String tieUnitType) {
            this.tieUnitType = tieUnitType;
            return (B)((Object)((Builder)this.self()));
        }

        public B filterName(String filterName) {
            this.filterName = filterName;
            return (B)((Object)((Builder)this.self()));
        }

        public B evaluatorName(String evaluatorName) {
            this.evaluatorName = evaluatorName;
            return (B)((Object)((Builder)this.self()));
        }

        public B checkerName(String checkerName) {
            this.checkerName = checkerName;
            return (B)((Object)((Builder)this.self()));
        }

        public B phaseProperties(TiePhaseConfig phaseProperties) {
            this.phaseProperties = phaseProperties;
            return (B)((Object)((Builder)this.self()));
        }

        public B accountType(String accountType) {
            this.accountType = accountType;
            return (B)((Object)((Builder)this.self()));
        }

        public B stepEntryId(Long stepEntryId) {
            this.stepEntryId = stepEntryId;
            return (B)((Object)((Builder)this.self()));
        }

        public B evaluatorId(Long evaluatorId) {
            this.evaluatorId = evaluatorId;
            return (B)((Object)((Builder)this.self()));
        }

        public String getName() {
            return this.name;
        }

        public void setName(String name) {
            this.name = name;
        }

        public String getTieUnitType() {
            return this.tieUnitType;
        }

        public void setTieUnitType(String tieUnitType) {
            this.tieUnitType = tieUnitType;
        }

        public String getFilterName() {
            return this.filterName;
        }

        public void setFilterName(String filterName) {
            this.filterName = filterName;
        }

        public String getEvaluatorName() {
            return this.evaluatorName;
        }

        public void setEvaluatorName(String evaluatorName) {
            this.evaluatorName = evaluatorName;
        }

        public String getCheckerName() {
            return this.checkerName;
        }

        public void setCheckerName(String checkerName) {
            this.checkerName = checkerName;
        }

        public TiePhaseConfig getPhaseProperties() {
            return this.phaseProperties;
        }

        public void setPhaseProperties(TiePhaseConfig phaseProperties) {
            this.phaseProperties = phaseProperties;
        }

        protected void check() {
            if (!HRStringUtils.equals((String)this.tieUnitType, (String)"formula")) {
                Assert.notBlank((String)this.evaluatorName, (String)"evaluatorName");
            }
        }

        public String toString() {
            return "Builder{name='" + this.name + '\'' + ", tieUnitType='" + this.tieUnitType + '\'' + ", filterName='" + this.filterName + '\'' + ", evaluatorName='" + this.evaluatorName + '\'' + ", checkerName='" + this.checkerName + '\'' + ", phaseProperties=" + this.phaseProperties + ", stepEntryId=" + this.stepEntryId + '}';
        }
    }
}

