/*
 * Decompiled with CFR 0.152.
 */
package kd.wtc.wtes.business.core.validator;

import java.time.LocalDate;
import java.util.List;
import java.util.Optional;
import kd.wtc.wtbs.business.subject.AttSubject;
import kd.wtc.wtbs.common.model.period.PerAttPeriod;
import kd.wtc.wtes.business.core.validator.AbstractTieChainValidator;
import kd.wtc.wtes.business.core.validator.TieLineValidatorException;
import kd.wtc.wtes.business.model.AttPeriodTable;
import kd.wtc.wtes.business.util.ValiteKDStringUtil;

public class AttPeriodChainValidator
extends AbstractTieChainValidator {
    @Override
    public void validate() {
        AttPeriodTable attPeriodTable = (AttPeriodTable)this.initParams.get("ATT_PERIOD");
        AttSubject.AttSubjectEntry attSubjectEntry = this.getAttSubjectEntry();
        long attPersonId = attSubjectEntry.getAttPersonId();
        LocalDate calDate = attSubjectEntry.getCurrentDate();
        List<PerAttPeriod> perAttPeriodList = attPeriodTable.getPerAttPeriodList(attPersonId);
        if (null == perAttPeriodList || perAttPeriodList.isEmpty()) {
            throw new TieLineValidatorException(ValiteKDStringUtil.noPerAttPeriod(calDate));
        }
        Optional<PerAttPeriod> optionalPerAttPeriod = attPeriodTable.getPerAttPeriodByAttPersonIdAndDate(attPersonId, calDate);
        if (!optionalPerAttPeriod.isPresent()) {
            throw new TieLineValidatorException(ValiteKDStringUtil.noPerAttPeriod(calDate));
        }
    }
}

