/*
 * Decompiled with CFR 0.152.
 */
package kd.wtc.wtes.business.core.validator;

import java.time.LocalDate;
import java.util.Date;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import kd.wtc.wtbs.common.model.period.PerAttPeriod;
import kd.wtc.wtbs.common.predata.wtp.PreDataAccountStepExecutors;
import kd.wtc.wtbs.common.util.WTCCollections;
import kd.wtc.wtbs.common.util.WTCDateUtils;
import kd.wtc.wtes.business.core.scheme.TiePhaseConfig;
import kd.wtc.wtes.business.core.scheme.TieScheme;
import kd.wtc.wtes.business.core.scheme.TieStepConfig;
import kd.wtc.wtes.business.core.validator.AbstractTieLineValidator;
import kd.wtc.wtes.business.core.validator.TieLineValidatorException;
import kd.wtc.wtes.business.model.AccountPlanData;
import kd.wtc.wtes.business.model.AttPeriodTable;
import kd.wtc.wtes.business.util.ValiteKDStringUtil;

public class FormulaMatchValidator
extends AbstractTieLineValidator {
    @Override
    public void validate() {
        AccountPlanData planData = (AccountPlanData)this.initParams.get("ACCOUNT_PLAN");
        if (planData == null) {
            return;
        }
        AttPeriodTable attPeriodTable = (AttPeriodTable)this.initParams.get("ATT_PERIOD");
        if (attPeriodTable == null) {
            return;
        }
        if (this.attSubject == null) {
            return;
        }
        Long attPersonId = this.attSubject.getAttPersonId();
        List<PerAttPeriod> perAttPeriodList = attPeriodTable.getPerAttPeriodList(attPersonId);
        Date startDate = WTCDateUtils.toDate((LocalDate)this.attSubject.getStartDate());
        Date endDate = WTCDateUtils.toDate((LocalDate)this.attSubject.getEndDate());
        if (WTCCollections.isEmpty(perAttPeriodList)) {
            return;
        }
        List filerList = perAttPeriodList.stream().filter(period -> period.getPerAttBeginDate().getTime() <= endDate.getTime() && period.getPerAttEndDate().getTime() >= startDate.getTime()).collect(Collectors.toList());
        for (PerAttPeriod perAttPeriod : filerList) {
            LocalDate localDate = WTCDateUtils.toLocalDate((Date)perAttPeriod.getPerAttEndDate());
            TieScheme tieScheme = planData.getTieSchemeByTotalAndDate(localDate);
            if (tieScheme == null) continue;
            List<TiePhaseConfig> tiePhaseConfigList = tieScheme.getPhaseProperties();
            if (WTCCollections.isEmpty(tiePhaseConfigList)) {
                return;
            }
            for (TiePhaseConfig tiePhaseConfig : tiePhaseConfigList) {
                Optional<TieStepConfig> optional;
                List<TieStepConfig> tieStepConfigList = tiePhaseConfig.getStepConfigsByDate(localDate);
                if (WTCCollections.isEmpty(tieStepConfigList) || !(optional = tieStepConfigList.stream().filter(ob -> ob.getEvaluatorId() != null && ob.getEvaluatorId().equals(PreDataAccountStepExecutors.DEFAULT_DETAIL_FORMULA_CAL)).findFirst()).isPresent()) continue;
                throw new TieLineValidatorException(ValiteKDStringUtil.formulaMatchErr(optional.get().getName()));
            }
        }
    }
}

