/*
 * Decompiled with CFR 0.152.
 */
package kd.wtc.wtes.business.engine;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import kd.bos.dataentity.utils.StringUtils;
import kd.wtc.wtbs.business.report.TieReportDao;
import kd.wtc.wtbs.business.report.TieReportDaoImpl;
import kd.wtc.wtbs.common.helper.WTCAppContextHelper;
import kd.wtc.wtes.business.bill.BillAccountingEngineSerialized;
import kd.wtc.wtes.business.bill.BillAccountingExporterStdImpl;
import kd.wtc.wtes.business.bill.BillAccountingRangeChecker;
import kd.wtc.wtes.business.bill.BillCallbackExecutor;
import kd.wtc.wtes.business.core.chain.TieIdService;
import kd.wtc.wtes.business.core.chain.TieIdServiceMemory;
import kd.wtc.wtes.business.core.chain.TieStepExecutorUnitFactory;
import kd.wtc.wtes.business.core.chain.TieStepExecutorUnitFactoryDefault;
import kd.wtc.wtes.business.core.datanode.TieDataNodeWrapper;
import kd.wtc.wtes.business.core.drouter.DataPackageRouterFactory;
import kd.wtc.wtes.business.core.engine.BillValidatorExecutor;
import kd.wtc.wtes.business.core.engine.TieEngine;
import kd.wtc.wtes.business.core.engine.TieEngineCompletedCallback;
import kd.wtc.wtes.business.core.engine.TieEngineConcurrent;
import kd.wtc.wtes.business.core.engine.TieEngineSerialized;
import kd.wtc.wtes.business.core.engine.TieRangeChecker;
import kd.wtc.wtes.business.core.exporter.ITieExporter;
import kd.wtc.wtes.business.core.init.TieParamInitializer;
import kd.wtc.wtes.business.core.scheme.ITieSchemeService;
import kd.wtc.wtes.business.core.validator.TieValidatorExecutor;
import kd.wtc.wtes.business.core.validator.ValidatorExecutor;
import kd.wtc.wtes.business.drouter.BillAccountingDataPackageRouterFactory;
import kd.wtc.wtes.business.drouter.TieDataPackageRouterFactoryStd;
import kd.wtc.wtes.business.engine.TieEngineConfig;
import kd.wtc.wtes.business.exporter.TieExporterStdImpl;
import kd.wtc.wtes.business.service.TieAttSubjectBuilder;
import kd.wtc.wtes.business.service.impl.TiePlanServiceImpl;
import kd.wtc.wtes.business.std.datanode.TieDataNodeStd;
import kd.wtc.wtes.business.std.datanode.TieDataNodeWrapperStd;
import kd.wtc.wtes.business.std.engine.EngineCallbackExecutor;

public class TieEngineConfigs {
    public static final TieEngineConfig DEFAULT = new TieEngineConfigInner();
    public static final TieEngineConfig BILL_ACCOUNTING_CONFIG = new BillTieEngineConfigInner();

    private static class BillTieEngineConfigInner
    implements TieEngineConfig {
        private BillTieEngineConfigInner() {
        }

        @Override
        public ITieExporter getExporter() {
            return (ITieExporter)WTCAppContextHelper.getBean(BillAccountingExporterStdImpl.class);
        }

        @Override
        public ITieSchemeService getTieSchemeService() {
            return (ITieSchemeService)WTCAppContextHelper.getBean(TiePlanServiceImpl.class);
        }

        @Override
        public DataPackageRouterFactory<TieDataNodeStd> getDataPackageRouterFactory() {
            return (DataPackageRouterFactory)WTCAppContextHelper.getBean(BillAccountingDataPackageRouterFactory.class);
        }

        @Override
        public TieRangeChecker getRangeChecker() {
            return (TieRangeChecker)WTCAppContextHelper.getBean(BillAccountingRangeChecker.class);
        }

        @Override
        public List<TieEngineCompletedCallback> getCompletedCallbackList() {
            return Collections.EMPTY_LIST;
        }

        @Override
        public List<List<TieParamInitializer>> getInitialises() {
            Object initialises = WTCAppContextHelper.getProjectParams().get("quota.billaccounting.init.initialises");
            if (initialises == null) {
                return Collections.emptyList();
            }
            List initializerList = (List)initialises;
            String exclude = "TieInitializerCert";
            ArrayList<List<TieParamInitializer>> initialisesLists = new ArrayList<List<TieParamInitializer>>(16);
            initializerList.forEach(list -> initialisesLists.add(list.stream().filter(e -> !e.contains(exclude)).map(initializerBeanName -> (TieParamInitializer)WTCAppContextHelper.getBean((String)initializerBeanName, TieParamInitializer.class)).collect(Collectors.toList())));
            return initialisesLists;
        }

        @Override
        public TieDataNodeWrapper<TieDataNodeStd> getDataNodeWrapper() {
            return (TieDataNodeWrapper)WTCAppContextHelper.getBean(TieDataNodeWrapperStd.class);
        }

        @Override
        public TieIdService getIdService() {
            return (TieIdService)WTCAppContextHelper.getBean(TieIdServiceMemory.class);
        }

        @Override
        public TieStepExecutorUnitFactory<TieDataNodeStd> getStepExecutorUnitFactory() {
            return (TieStepExecutorUnitFactory)WTCAppContextHelper.getBean(TieStepExecutorUnitFactoryDefault.class);
        }

        @Override
        public TieReportDao getReportDao() {
            return (TieReportDao)WTCAppContextHelper.getBean(TieReportDaoImpl.class);
        }

        @Override
        public TieEngine<TieDataNodeStd> getEngine(String serialized) {
            return (TieEngine)WTCAppContextHelper.getBean(BillAccountingEngineSerialized.class);
        }

        @Override
        public ValidatorExecutor getValidatorExecutor() {
            return (ValidatorExecutor)WTCAppContextHelper.getBean(BillValidatorExecutor.class);
        }

        @Override
        public TieEngineCompletedCallback getCallbackExecutor() {
            return (TieEngineCompletedCallback)WTCAppContextHelper.getBean(BillCallbackExecutor.class);
        }
    }

    private static class TieEngineConfigInner
    implements TieEngineConfig {
        private TieEngineConfigInner() {
        }

        @Override
        public ITieExporter getExporter() {
            return (ITieExporter)WTCAppContextHelper.getBean(TieExporterStdImpl.class);
        }

        @Override
        public ITieSchemeService getTieSchemeService() {
            return (ITieSchemeService)WTCAppContextHelper.getBean(TiePlanServiceImpl.class);
        }

        @Override
        public DataPackageRouterFactory<TieDataNodeStd> getDataPackageRouterFactory() {
            return (DataPackageRouterFactory)WTCAppContextHelper.getBean(TieDataPackageRouterFactoryStd.class);
        }

        @Override
        public TieRangeChecker getRangeChecker() {
            return (TieRangeChecker)WTCAppContextHelper.getBean(TieAttSubjectBuilder.class);
        }

        @Override
        public List<TieEngineCompletedCallback> getCompletedCallbackList() {
            Object initialises = WTCAppContextHelper.getProjectParams().get("tie.init.callBackList");
            if (initialises == null) {
                return Collections.emptyList();
            }
            List initializerList = (List)initialises;
            return initializerList.stream().map(initializerBeanName -> (TieEngineCompletedCallback)WTCAppContextHelper.getBean((String)initializerBeanName, TieEngineCompletedCallback.class)).collect(Collectors.toList());
        }

        @Override
        public List<List<TieParamInitializer>> getInitialises() {
            Object initialises = WTCAppContextHelper.getProjectParams().get("tie.init.initialises");
            if (initialises == null) {
                return Collections.emptyList();
            }
            List initializerList = (List)initialises;
            ArrayList<List<TieParamInitializer>> initialisesLists = new ArrayList<List<TieParamInitializer>>(16);
            initializerList.forEach(list -> initialisesLists.add(list.stream().map(initializerBeanName -> (TieParamInitializer)WTCAppContextHelper.getBean((String)initializerBeanName, TieParamInitializer.class)).collect(Collectors.toList())));
            return initialisesLists;
        }

        @Override
        public TieDataNodeWrapper<TieDataNodeStd> getDataNodeWrapper() {
            return (TieDataNodeWrapper)WTCAppContextHelper.getBean(TieDataNodeWrapperStd.class);
        }

        @Override
        public TieIdService getIdService() {
            return (TieIdService)WTCAppContextHelper.getBean(TieIdServiceMemory.class);
        }

        @Override
        public TieStepExecutorUnitFactory<TieDataNodeStd> getStepExecutorUnitFactory() {
            return (TieStepExecutorUnitFactory)WTCAppContextHelper.getBean(TieStepExecutorUnitFactoryDefault.class);
        }

        @Override
        public TieReportDao getReportDao() {
            return (TieReportDao)WTCAppContextHelper.getBean(TieReportDaoImpl.class);
        }

        @Override
        public TieEngine<TieDataNodeStd> getEngine(String serialized) {
            if (StringUtils.equals((CharSequence)serialized, (CharSequence)"SERIALIZED")) {
                return (TieEngine)WTCAppContextHelper.getBean(TieEngineSerialized.class);
            }
            return (TieEngine)WTCAppContextHelper.getBean(TieEngineConcurrent.class);
        }

        @Override
        public ValidatorExecutor getValidatorExecutor() {
            return (ValidatorExecutor)WTCAppContextHelper.getBean(TieValidatorExecutor.class);
        }

        @Override
        public TieEngineCompletedCallback getCallbackExecutor() {
            return new EngineCallbackExecutor(this.getCompletedCallbackList());
        }
    }
}

