/*
 * Decompiled with CFR 0.152.
 */
package kd.wtc.wtes.business.executor.attrecordadjust;

import java.math.BigDecimal;
import java.time.LocalDate;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.dataentity.utils.StringUtils;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.wtc.wtbs.common.util.third.collect.Lists;
import kd.wtc.wtes.business.model.AttItemSpec;
import kd.wtc.wtes.business.model.AttItemSpecData;
import kd.wtc.wtes.business.model.ShiftSpec;
import kd.wtc.wtes.business.model.attrecordadjust.AttRecordAdjust;
import kd.wtc.wtes.business.model.attrecordadjust.AttRecordTrimData;
import kd.wtc.wtes.business.model.attrecordadjust.AttRecordTrimResult;
import kd.wtc.wtes.business.std.chain.TieContextStd;
import kd.wtc.wtes.business.std.chain.TieDataResultStd;
import kd.wtc.wtes.business.std.chain.TieEvaluatorStd;
import kd.wtc.wtes.business.std.datanode.AttItemValue;
import kd.wtc.wtes.business.std.datanode.TieDataNodeStd;
import kd.wtc.wtes.business.util.AttRecordTrimUtil;
import kd.wtc.wtes.business.util.ContextUtil;
import kd.wtc.wtes.common.util.CollectionUtils;

public class AttDayRecordMoveEvaluator
implements TieEvaluatorStd {
    private ShiftSpec shiftSpec = null;

    @Override
    public TieDataResultStd doEvaluate(TieContextStd context, List<TieDataNodeStd> dataNodes) {
        TieDataResultStd tieDataResultStd = AttRecordTrimUtil.vailte(context);
        if (tieDataResultStd != null) {
            return tieDataResultStd;
        }
        AttRecordTrimData attRecordTrimData = ContextUtil.getAttRecordTrimtData(context);
        LocalDate chainDate = context.getChainDate();
        this.shiftSpec = ContextUtil.getCurrentShiftTable(context).getShiftSpec(chainDate);
        long attPersonId = context.getAttPersonId();
        AttItemSpecData attItemSpecData = ContextUtil.getAttItemSpecData(context);
        List<AttRecordAdjust> trimRecordList = attRecordTrimData.getDayAdjustRecords(attPersonId, chainDate, "move");
        List<AttItemValue> attItemValueList = this.matchAttRecordAdjust(trimRecordList, chainDate, attItemSpecData, context, dataNodes);
        return TieDataResultStd.success(attItemValueList);
    }

    @Override
    public TieDataResultStd doEvaluate(TieContextStd context) {
        return this.doEvaluate(context, context.getAllDataNodes());
    }

    private List<AttItemValue> matchAttRecordAdjust(List<AttRecordAdjust> attRecordAdjustList, LocalDate chainDate, AttItemSpecData attItemSpecData, TieContextStd context, List<TieDataNodeStd> dataNodes) {
        ArrayList attItemValueList = Lists.newArrayListWithExpectedSize((int)16);
        Map<Long, AttItemValue> attItemValueMap = context.getAllHandleResultAttItemValueMap(dataNodes);
        List dataNodesInCurPhase = context.getDataNodesInCurPhase();
        attRecordAdjustList.forEach(attRecordAdjust -> {
            AttItemSpec attItemSpec = attItemSpecData.getByBidAndDate(attRecordAdjust.getItemId(), chainDate);
            AttItemSpec attItemMoveSpec = attItemSpecData.getByBidAndDate(attRecordAdjust.getBemoveItemId(), chainDate);
            if (attItemSpec != null && attItemMoveSpec != null && StringUtils.equals((CharSequence)attItemSpec.getUnit(), (CharSequence)attRecordAdjust.getItemUnit())) {
                AttItemValue pointAttItemValue = AttRecordTrimUtil.getCurAttItemInstance(dataNodesInCurPhase, attItemValueMap, attItemSpec, false);
                AttItemValue pointMoveAttItemValue = AttRecordTrimUtil.getCurAttItemInstance(dataNodesInCurPhase, attItemValueMap, attItemMoveSpec, true);
                if (pointAttItemValue != null) {
                    AttItemValue moveAttItemValue = AttRecordTrimUtil.getAttItemSpecAttItemValue(attItemMoveSpec, attItemValueList);
                    AttItemValue resultMoveAttItemValue = this.builtMoveAttItemValue(moveAttItemValue, pointMoveAttItemValue, (AttRecordAdjust)attRecordAdjust, attItemMoveSpec);
                    attItemValueList.add(resultMoveAttItemValue);
                    AttItemValue attItemValue = AttRecordTrimUtil.getAttItemSpecAttItemValue(attItemSpec, attItemValueList);
                    attItemValueList.add(this.builtAttItemInstance(attItemValue, pointAttItemValue, (AttRecordAdjust)attRecordAdjust, attItemSpec, resultMoveAttItemValue));
                }
            }
        });
        Map<Long, List<AttItemValue>> map = attItemValueList.stream().collect(Collectors.groupingBy(ob -> ob.getAttItemInstance().getAttItemSpec().getBid()));
        ArrayList returnAttItemValue = Lists.newArrayListWithExpectedSize((int)16);
        map.forEach((key, value) -> {
            AttItemValue lastAttItemValue = (AttItemValue)value.get(value.size() - 1);
            List attRecordTrimResultList = value.stream().filter(entry -> entry.getAttItemInstance().getAttRecordTrimResult().getValueToBefore() != null).map(ob -> ob.getAttItemInstance().getAttRecordTrimResult()).collect(Collectors.toList());
            if (CollectionUtils.isEmpty(attRecordTrimResultList)) {
                List attRecordMoveTrimResultList = value.stream().map(ob -> ob.getAttItemInstance().getAttRecordTrimResult()).collect(Collectors.toList());
                lastAttItemValue.getAttItemInstance().getAttRecordMoveTrimResultList().addAll(attRecordMoveTrimResultList);
            }
            lastAttItemValue.getAttItemInstance().getAttRecordTrimResultList().addAll(attRecordTrimResultList);
            returnAttItemValue.add(lastAttItemValue);
        });
        return returnAttItemValue;
    }

    private AttItemValue builtAttItemInstance(AttItemValue attItemValue, AttItemValue curAttItemValue, AttRecordAdjust attRecordAdjust, AttItemSpec attItemSpec, AttItemValue resultMoveAttItemValue) {
        AttRecordTrimResult attRecordTrimResult;
        String itemUnit = attRecordAdjust.getItemUnit();
        BigDecimal valueBefore = HRStringUtils.equals((String)"time", (String)itemUnit) ? curAttItemValue.getAttItemInstance().getItemValue() : curAttItemValue.getAttItemInstance().getSecondDecimal();
        boolean isUpNode = false;
        if (attItemValue != null && (attRecordTrimResult = attItemValue.getAttItemInstance().getAttRecordTrimResult()) != null) {
            valueBefore = attRecordTrimResult.getValueAfter();
            isUpNode = true;
        }
        AttRecordTrimResult resultAttRecordTrimResult = resultMoveAttItemValue.getAttItemInstance().getAttRecordTrimResult();
        AttItemValue newAttItemValue = AttRecordTrimUtil.builtAttitemValueWithParent(attItemSpec, attRecordAdjust, valueBefore, curAttItemValue, this.shiftSpec, false, isUpNode, resultAttRecordTrimResult);
        return newAttItemValue;
    }

    public AttItemValue builtMoveAttItemValue(AttItemValue attItemValue, AttItemValue curAttItemValue, AttRecordAdjust attRecordAdjust, AttItemSpec attItemSpec) {
        AttRecordTrimResult attRecordTrimResult;
        BigDecimal valueBefore = null;
        String itemUnit = attRecordAdjust.getItemUnit();
        if (curAttItemValue != null) {
            valueBefore = HRStringUtils.equals((String)"time", (String)itemUnit) ? curAttItemValue.getAttItemInstance().getItemValue() : curAttItemValue.getAttItemInstance().getSecondDecimal();
        }
        boolean isUpNode = false;
        if (attItemValue != null && (attRecordTrimResult = attItemValue.getAttItemInstance().getAttRecordTrimResult()) != null) {
            valueBefore = attRecordTrimResult.getValueAfter();
            isUpNode = true;
        }
        return AttRecordTrimUtil.builtAttitemValueWithParent(attItemSpec, attRecordAdjust, valueBefore, curAttItemValue, this.shiftSpec, true, isUpNode, null);
    }
}

