/*
 * Decompiled with CFR 0.152.
 */
package kd.wtc.wtes.business.executor.attrecordadjust;

import java.math.BigDecimal;
import java.time.LocalDate;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.dataentity.utils.StringUtils;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.wtc.wtbs.common.util.third.collect.Lists;
import kd.wtc.wtes.business.model.AttItemInstance;
import kd.wtc.wtes.business.model.AttItemSpec;
import kd.wtc.wtes.business.model.AttItemSpecData;
import kd.wtc.wtes.business.model.ShiftSpec;
import kd.wtc.wtes.business.model.attrecordadjust.AttRecordAdjust;
import kd.wtc.wtes.business.model.attrecordadjust.AttRecordTrimData;
import kd.wtc.wtes.business.model.attrecordadjust.AttRecordTrimResult;
import kd.wtc.wtes.business.std.chain.TieContextStd;
import kd.wtc.wtes.business.std.chain.TieDataResultStd;
import kd.wtc.wtes.business.std.chain.TieEvaluatorStd;
import kd.wtc.wtes.business.std.datanode.AttItemValue;
import kd.wtc.wtes.business.std.datanode.TieDataNode;
import kd.wtc.wtes.business.std.datanode.TieDataNodeStd;
import kd.wtc.wtes.business.util.AttRecordTrimUtil;
import kd.wtc.wtes.business.util.ContextUtil;

public class AttDayRecordResetEvaluator
implements TieEvaluatorStd {
    private ShiftSpec shiftSpec = null;

    @Override
    public TieDataResultStd doEvaluate(TieContextStd context, List<TieDataNodeStd> dataNodes) {
        TieDataResultStd tieDataResultStd = AttRecordTrimUtil.vailte(context);
        if (tieDataResultStd != null) {
            return tieDataResultStd;
        }
        AttRecordTrimData attRecordTrimData = ContextUtil.getAttRecordTrimtData(context);
        LocalDate chainDate = context.getChainDate();
        this.shiftSpec = ContextUtil.getCurrentShiftTable(context).getShiftSpec(chainDate);
        long attPersonId = context.getAttPersonId();
        List<AttRecordAdjust> trimRecordList = attRecordTrimData.getDayAdjustRecords(attPersonId, chainDate, "reset");
        AttItemSpecData attItemSpecData = ContextUtil.getAttItemSpecData(context);
        List<AttItemValue> attItemValueList = this.matchAttRecordAdjust(trimRecordList, chainDate, attItemSpecData, context, dataNodes);
        return TieDataResultStd.success(attItemValueList);
    }

    @Override
    public TieDataResultStd doEvaluate(TieContextStd context) {
        return this.doEvaluate(context, context.getAllDataNodes());
    }

    private List<AttItemValue> matchAttRecordAdjust(List<AttRecordAdjust> attRecordAdjustList, LocalDate chainDate, AttItemSpecData attItemSpecData, TieContextStd context, List<TieDataNodeStd> dataNodes) {
        ArrayList attItemValueList = Lists.newArrayListWithExpectedSize((int)16);
        Map<Long, AttItemValue> attItemValueMap = context.getAllHandleResultAttItemValueMap(dataNodes);
        List dataNodesInCurPhase = context.getDataNodesInCurPhase();
        attRecordAdjustList.forEach(attRecordAdjust -> {
            AttItemValue pointAttItemValue;
            AttItemSpec attItemSpec = attItemSpecData.getByBidAndDate(attRecordAdjust.getItemId(), chainDate);
            if (attItemSpec != null && StringUtils.equals((CharSequence)attItemSpec.getUnit(), (CharSequence)attRecordAdjust.getItemUnit()) && (pointAttItemValue = AttRecordTrimUtil.getCurAttItemInstance(dataNodesInCurPhase, attItemValueMap, attItemSpec, false)) != null && !this.contianAttItemSpec(attItemValueList, attItemSpec)) {
                attItemValueList.add(this.builtAttItemInstance(pointAttItemValue, (AttRecordAdjust)attRecordAdjust, attItemSpec));
            }
        });
        Map<Long, List<AttItemValue>> map = attItemValueList.stream().collect(Collectors.groupingBy(ob -> ob.getAttItemInstance().getAttItemSpec().getBid()));
        ArrayList returnAttItemValue = Lists.newArrayListWithExpectedSize((int)16);
        map.forEach((key, value) -> {
            AttItemValue lastAttItemValue = (AttItemValue)value.get(value.size() - 1);
            List attRecordTrimResultList = value.stream().map(ob -> ob.getAttItemInstance().getAttRecordTrimResult()).collect(Collectors.toList());
            lastAttItemValue.getAttItemInstance().getAttRecordTrimResultList().addAll(attRecordTrimResultList);
            returnAttItemValue.add(lastAttItemValue);
        });
        return returnAttItemValue;
    }

    private boolean contianAttItemSpec(List<AttItemValue> attItemValueList, AttItemSpec attItemSpec) {
        for (AttItemValue attItemValue : attItemValueList) {
            if (attItemValue.getAttItemInstance().getAttItemSpec().getBid() != attItemSpec.getBid()) continue;
            return true;
        }
        return false;
    }

    private AttItemValue builtAttItemInstance(AttItemValue curAttItemValue, AttRecordAdjust attRecordAdjust, AttItemSpec attItemSpec) {
        AttItemInstance attItemInstance;
        BigDecimal valueAfter = attRecordAdjust.getValueUpdate();
        String itemUnit = attRecordAdjust.getItemUnit();
        BigDecimal valueBefore = HRStringUtils.equals((String)"time", (String)itemUnit) ? curAttItemValue.getAttItemInstance().getItemValue() : curAttItemValue.getAttItemInstance().getSecondDecimal();
        int dataAccuracy = attItemSpec.getDataAccuracy();
        int precisionTail = AttRecordTrimUtil.getPrecisionTail(attItemSpec.getPrecisionTail());
        ArrayList attRecordTrimResultList = Lists.newArrayListWithExpectedSize((int)16);
        switch (itemUnit) {
            case "time": {
                attItemInstance = new AttItemInstance(attItemSpec, valueAfter, null, BigDecimal.ZERO, null, AttRecordTrimResult.with().attRecordAdjust(attRecordAdjust).valueAfter(valueAfter).valueBefore(valueBefore).build(), attRecordTrimResultList);
                break;
            }
            case "day": {
                valueBefore = this.shiftSpec.secondsToDays(valueBefore);
                attItemInstance = new AttItemInstance(attItemSpec, null, valueAfter, this.shiftSpec.daysToSecondDecimal(valueAfter), null, AttRecordTrimResult.with().attRecordAdjust(attRecordAdjust).valueAfter(valueAfter).valueBefore(valueBefore).build(), attRecordTrimResultList);
                break;
            }
            case "hour": {
                valueBefore = AttRecordTrimUtil.secondToHour(valueBefore, dataAccuracy, precisionTail);
                BigDecimal second = AttRecordTrimUtil.hourToSecond(valueAfter);
                attItemInstance = new AttItemInstance(attItemSpec, null, this.shiftSpec.secondsToDays(second), second, null, AttRecordTrimResult.with().attRecordAdjust(attRecordAdjust).valueAfter(valueAfter).valueBefore(valueBefore).build(), attRecordTrimResultList);
                break;
            }
            case "minute": {
                valueBefore = AttRecordTrimUtil.secondToMinute(valueBefore, dataAccuracy, precisionTail);
                BigDecimal second = AttRecordTrimUtil.minuteToSecond(valueAfter);
                attItemInstance = new AttItemInstance(attItemSpec, null, this.shiftSpec.secondsToDays(second), second, null, AttRecordTrimResult.with().attRecordAdjust(attRecordAdjust).valueAfter(valueAfter).valueBefore(valueBefore).build(), attRecordTrimResultList);
                break;
            }
            default: {
                BigDecimal second = valueAfter;
                attItemInstance = new AttItemInstance(attItemSpec, null, this.shiftSpec.secondsToDays(second), second, null, AttRecordTrimResult.with().attRecordAdjust(attRecordAdjust).valueAfter(valueAfter).valueBefore(valueBefore).build(), attRecordTrimResultList);
            }
        }
        AttItemValue newAttItemValue = (AttItemValue)((AttItemValue.Builder)((TieDataNode.Builder)AttItemValue.builder().attItemInstance(attItemInstance)).parentDataNodes(curAttItemValue.parentDataNodes())).build();
        return newAttItemValue;
    }
}

