/*
 * Decompiled with CFR 0.152.
 */
package kd.wtc.wtes.business.executor.formula;

import java.time.LocalDate;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.db.DB;
import kd.bos.entity.MainEntityType;
import kd.bos.exception.KDBizException;
import kd.bos.exception.KDException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.MetadataServiceHelper;
import kd.hr.hbp.common.util.DynamicObjectJsonSerializer;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.wtc.wtbs.business.timeseq.AbstractTimeSeqVersion;
import kd.wtc.wtbs.common.lang.WTCBizException;
import kd.wtc.wtbs.common.model.period.PerAttPeriod;
import kd.wtc.wtbs.common.util.WTCCollections;
import kd.wtc.wtbs.common.util.WTCDateUtils;
import kd.wtc.wtbs.common.util.third.collect.Lists;
import kd.wtc.wtbs.common.util.third.collect.Maps;
import kd.wtc.wtes.business.attperiod.AbstractAttPeriodSummary;
import kd.wtc.wtes.business.attperiod.AttPeriodSummaryRequest;
import kd.wtc.wtes.business.attperiod.AttPeriodSummaryService;
import kd.wtc.wtes.business.attperiod.chain.TieAttPeriodContext;
import kd.wtc.wtes.business.core.scheme.TieStepIdentity;
import kd.wtc.wtes.business.executor.rlotcal.PolicyResultHelp;
import kd.wtc.wtes.business.ext.utils.TiePeriodContextExtUtil;
import kd.wtc.wtes.business.model.AttFileCabinet;
import kd.wtc.wtes.business.model.AttFileModel;
import kd.wtc.wtes.business.model.AttItemSpec;
import kd.wtc.wtes.business.model.AttItemSpecData;
import kd.wtc.wtes.business.model.AttPeriodSpliteModel;
import kd.wtc.wtes.business.model.attendperson.AttendPersonModel;
import kd.wtc.wtes.business.model.rlfm.FormulaConfigPackage;
import kd.wtc.wtes.business.model.rlfm.FormulaPlanPackage;
import kd.wtc.wtes.business.model.rlfm.FormulaRulePackage;
import kd.wtc.wtes.business.util.PeriodContextUtil;
import kd.wtc.wtes.common.lang.WtesBizException;
import kd.wtc.wtes.common.lang.WtesException;
import kd.wtc.wtes.common.util.CollectionUtils;
import kd.wtc.wtp.business.formula.FormulaCalcUtils;
import kd.wtc.wtp.business.formula.adapt.FormulaService;
import kd.wtc.wtp.business.formula.adapt.provider.SceneEnum;
import kd.wtc.wtp.business.formula.adapt.result.WTCCalResultDetailVO;
import kd.wtc.wtp.business.formula.adapt.result.WTCCalResultVO;

public class AttPeriodSummaryFormulaEvaluator
extends AbstractAttPeriodSummary
implements AttPeriodSummaryService {
    private static final Log LOG = LogFactory.getLog(AttPeriodSummaryFormulaEvaluator.class);

    @Override
    public AttPeriodSpliteModel sumBatch(TieAttPeriodContext tieAttPeriodContext, List<AttPeriodSummaryRequest> attPeriodSummaryRequestList, List<AttPeriodSpliteModel> result) {
        ArrayList detailDynamicObjectList = Lists.newArrayListWithExpectedSize((int)16);
        result = PeriodContextUtil.copyAttPeriodSpliteModelList(result);
        PeriodContextUtil.dealDetailDynamicObjectList(result, detailDynamicObjectList);
        if (LOG.isDebugEnabled()) {
            LOG.debug("sumBatch detailDynamicObjectList:{}", detailDynamicObjectList.stream().map(DynamicObjectJsonSerializer::convertDynamicObjectToJson).collect(Collectors.toList()));
        }
        List<DynamicObject> mainDynamicObjectList = PeriodContextUtil.getMainDysByDetail(detailDynamicObjectList, result);
        mainDynamicObjectList = this.getMainDynamicObjectList(mainDynamicObjectList, detailDynamicObjectList);
        Map<String, Object> initParams = tieAttPeriodContext.getInitParams();
        Map attPeriodId2MainListMap = mainDynamicObjectList.stream().collect(Collectors.groupingBy(dy -> dy.getString("attperattperiodid"), Collectors.toList()));
        if (LOG.isDebugEnabled()) {
            LOG.debug("mainDynamicObjectList size={}", (Object)mainDynamicObjectList.size());
            for (DynamicObject dynamicObject : mainDynamicObjectList) {
                LOG.debug("attperattperiodid={},attmianid={}", (Object)dynamicObject.getString("attperattperiodid"), (Object)dynamicObject.getLong("id"));
            }
        }
        Map detail2ListMap = detailDynamicObjectList.stream().collect(Collectors.groupingBy(detailDy -> detailDy.getLong("attmain"), Collectors.toList()));
        FormulaService formulaService = tieAttPeriodContext.getFormulaService();
        HashMap contextMap = Maps.newHashMapWithExpectedSize((int)4);
        contextMap.put("initParams", initParams);
        contextMap.put("tieAttPeriodContext", tieAttPeriodContext);
        contextMap.put("tieAttPeriodContextExt", TiePeriodContextExtUtil.getTieAttPeriodContextExt(tieAttPeriodContext));
        Map<String, PerAttPeriod> perAttPeriodMap = tieAttPeriodContext.getPerAttPeriodIdMap();
        AttPeriodSpliteModel resultModel = new AttPeriodSpliteModel(new DynamicObjectCollection(), new DynamicObjectCollection());
        for (Map.Entry entry : attPeriodId2MainListMap.entrySet()) {
            Map calResultDetailVOMap;
            String perAttPeriodId = entry.getKey();
            LOG.debug("sumBatch perAttPeriodId={}", (Object)perAttPeriodId);
            List mainList = entry.getValue();
            if (CollectionUtils.isEmpty(mainList)) {
                LOG.warn("mainList is Empty");
                continue;
            }
            DynamicObject attmainDy = (DynamicObject)mainList.get(0);
            long attMainId = attmainDy.getLong("id");
            PerAttPeriod perAttPeriod = perAttPeriodMap.get(perAttPeriodId);
            if (perAttPeriod == null) {
                LOG.warn("sumBatch perAttPeriod is null");
                continue;
            }
            contextMap.put("mainList", mainList);
            contextMap.put("detailList", detail2ListMap.get(attMainId));
            contextMap.put("perAttPeriod", perAttPeriod);
            contextMap.put("perAttPeriodId", perAttPeriodId);
            contextMap.put("perAttPeriodPrimaryId", perAttPeriod.getPrimaryId());
            contextMap.put("sceneCode", SceneEnum.ATTTOTAL.getCode());
            List<Long> formulaIdList = this.getFormulaIdList(tieAttPeriodContext, perAttPeriod, formulaService);
            if (CollectionUtils.isEmpty(formulaIdList)) {
                LOG.debug("sumBatch AttPeriodSummaryFormulaEvaluator formulaIdList is empty,perAttPeriodId={}", (Object)perAttPeriodId);
                continue;
            }
            try {
                LOG.debug("sumBatch formulaService invokeFormula perAttPeriodId={}", (Object)perAttPeriodId);
                calResultDetailVOMap = formulaService.invokeFormula(formulaIdList, (Map)contextMap, perAttPeriod.getFileBoId().longValue(), WTCDateUtils.toLocalDate((Date)perAttPeriod.getPerAttEndDate()));
            }
            catch (Exception ex) {
                LOG.warn("AttPeriodSummaryFormulaEvaluator.sumBatch error ", (Throwable)ex);
                if (ex instanceof WtesException) {
                    throw (WtesException)((Object)ex);
                }
                if (ex instanceof KDException) {
                    throw new WtesBizException((Throwable)ex, ex.getMessage());
                }
                String message = ResManager.loadKDString((String)"\u8003\u52e4\u6838\u7b97\u671f\u95f4\u6c47\u603b\u516c\u5f0f\u8fd0\u7b97\u5f02\u5e38\u3002", (String)"AttPeriodSummaryFormulaEvaluator_0", (String)"wtc-wtes-business", (Object[])new Object[0]);
                throw new WtesBizException((Throwable)ex, message);
            }
            Map formulaId2UsedAttItemIdMap = formulaService.getUsedAttItemId(formulaIdList);
            Map resultAttItemId2FormulaIdMap = formulaService.getResultAttItemId2FormulaIdMap(formulaIdList);
            Date attPeriodEndDate = perAttPeriod.getAttPeriodEndDate();
            LocalDate chainDate = WTCDateUtils.toLocalDate((Date)attPeriodEndDate);
            AttPeriodSpliteModel attPeriodSpliteModel = this.dealResult(calResultDetailVOMap, tieAttPeriodContext, perAttPeriodId, chainDate, formulaId2UsedAttItemIdMap, resultAttItemId2FormulaIdMap);
            this.addResult(resultModel, attPeriodSpliteModel);
        }
        return resultModel;
    }

    private AttPeriodSpliteModel addResult(AttPeriodSpliteModel resultModel, AttPeriodSpliteModel attPeriodSpliteModel) {
        DynamicObjectCollection mainDynamicObjects = resultModel.getMainDynamicObjects();
        mainDynamicObjects.addAll((Collection)attPeriodSpliteModel.getMainDynamicObjects());
        DynamicObjectCollection detailDynamicObjects = resultModel.getDetailDynamicObjects();
        detailDynamicObjects.addAll((Collection)attPeriodSpliteModel.getDetailDynamicObjects());
        return resultModel;
    }

    private AttPeriodSpliteModel dealResult(Map<String, WTCCalResultDetailVO> calResultDetailVOMap, TieAttPeriodContext tieAttPeriodContext, String perAttPeriodId, LocalDate chainDate, Map<Long, Set<Long>> formulaId2UsedAttItemIdMap, Map<Long, Long> resultAttItemId2FormulaIdMap) {
        Optional<WTCCalResultDetailVO> calResultDetailOp = calResultDetailVOMap.values().stream().filter(aa -> !aa.isSuccess()).findFirst();
        if (calResultDetailOp.isPresent()) {
            WTCCalResultDetailVO wtcCalResultDetailVO = calResultDetailOp.get();
            LOG.warn("{} cal error,{}", (Object)wtcCalResultDetailVO.getSumResultMap(), (Object)wtcCalResultDetailVO.getErrorMsg());
            throw new WTCBizException(wtcCalResultDetailVO.getErrorMsg());
        }
        DynamicObjectCollection mainDynamicObjects = new DynamicObjectCollection();
        DynamicObjectCollection detailDynamicObjects = new DynamicObjectCollection();
        Map<String, PerAttPeriod> perPeriodMap = tieAttPeriodContext.getPerAttPeriodIdMap();
        HashMap mainPerattperiodIdMap = Maps.newHashMapWithExpectedSize((int)16);
        List resultVOS = calResultDetailVOMap.values().stream().map(WTCCalResultDetailVO::getSumResultMap).filter(WTCCollections::isNotEmpty).flatMap(sumResultMap -> sumResultMap.values().stream()).collect(Collectors.toList());
        if (WTCCollections.isEmpty(resultVOS)) {
            return new AttPeriodSpliteModel(mainDynamicObjects, detailDynamicObjects);
        }
        long[] genLongIds = DB.genLongIds((String)"wtctd_atttotalbase", (int)resultVOS.size());
        MainEntityType mainEntityType = MetadataServiceHelper.getDataEntityType((String)"wtctd_atttotalbase");
        int num = 0;
        for (WTCCalResultVO value : resultVOS) {
            DynamicObject detailAttTotalDy;
            String uniqueCode;
            if (value.getCalResultValue() == null || !FormulaCalcUtils.isAttItemCode((String)(uniqueCode = value.getUniqueCode()))) continue;
            PerAttPeriod perAttPeriod = perPeriodMap.get(perAttPeriodId);
            if (perAttPeriod == null) {
                LOG.warn("AttPeriodSummaryFormulaEvaluator_not_find_perAttPeriod_{}", (Object)perAttPeriodId);
                continue;
            }
            if (null == mainPerattperiodIdMap.get(perAttPeriodId)) {
                AttFileModel attFile = tieAttPeriodContext.getAttFileModelById(perAttPeriod.getPersonId(), perAttPeriod.getFileId());
                if (attFile == null) {
                    LOG.warn("AttPeriodSummaryServiceImpl_not_find_attFileId={}", (Object)perAttPeriod.getFileId());
                    continue;
                }
                LocalDate endDate = tieAttPeriodContext.getPeriodData(perAttPeriod, attFile);
                AttendPersonModel personModel = tieAttPeriodContext.getAttendPersonModel(attFile, endDate);
                if (personModel == null) {
                    LOG.warn("AttPeriodSummaryServiceImpl_not_find_personModel_personId={},endDate={}", (Object)perAttPeriod.getPersonId(), (Object)endDate);
                    continue;
                }
                DynamicObject baseAttTotalDy = PeriodContextUtil.getBaseAttTotalData(tieAttPeriodContext, perAttPeriod, personModel, attFile, mainEntityType);
                long id = genLongIds[num];
                baseAttTotalDy.set("id", (Object)id);
                mainDynamicObjects.add((Object)baseAttTotalDy);
                mainPerattperiodIdMap.put(perAttPeriodId, id);
                ++num;
            }
            if ((detailAttTotalDy = this.genDetailAttTotalData(mainPerattperiodIdMap.get(perAttPeriodId), value, perAttPeriod, tieAttPeriodContext, chainDate)) == null) continue;
            detailDynamicObjects.add((Object)detailAttTotalDy);
        }
        return new AttPeriodSpliteModel(mainDynamicObjects, detailDynamicObjects);
    }

    private DynamicObject genDetailAttTotalData(Object attMainId, WTCCalResultVO calResultVO, PerAttPeriod perAttPeriod, TieAttPeriodContext tieAttPeriodContext, LocalDate chainDate) {
        DynamicObject resDyn = BusinessDataServiceHelper.newDynamicObject((String)"wtctd_atttotaldetail");
        resDyn.set("attmain", attMainId);
        resDyn.set("valuelong", calResultVO.getCalResultValue());
        resDyn.set("perattperiodid", (Object)perAttPeriod.getAttPeriodId());
        String uniqueCode = calResultVO.getUniqueCode();
        Long attItemBoId = FormulaCalcUtils.getAttItemBoIdByCode((String)uniqueCode);
        AttItemSpecData attItemSpecData = tieAttPeriodContext.getAttItemSpecData();
        AttItemSpec attItem = attItemSpecData.getByBidAndDate(attItemBoId, chainDate);
        if (attItem != null) {
            String itemType = attItem.getItemType();
            if ("1".equals(itemType)) {
                return null;
            }
            resDyn.set("attitemtype", (Object)itemType);
            resDyn.set("attitemid", (Object)attItem.getBid());
            resDyn.set("attitemvid", (Object)attItem.getId());
        }
        return resDyn;
    }

    private List<DynamicObject> getMainDynamicObjectList(List<DynamicObject> mainDynamicObjectList, List<DynamicObject> detailDynamicObjectList) {
        Map<String, List<DynamicObject>> mainMap = mainDynamicObjectList.stream().collect(Collectors.groupingBy(ob -> ob.getString("attperattperiodid")));
        ArrayList mainDynamicObjects = Lists.newArrayListWithExpectedSize((int)16);
        for (Map.Entry<String, List<DynamicObject>> entry : mainMap.entrySet()) {
            String perPeriodId = entry.getKey();
            if (perPeriodId == null) continue;
            List<DynamicObject> dynamicObjectList = entry.getValue();
            List idList = dynamicObjectList.stream().map(ob -> ob.getLong("id")).collect(Collectors.toList());
            List filterDynamicObject = detailDynamicObjectList.stream().filter(ob -> idList.contains(ob.getLong("attmain"))).collect(Collectors.toList());
            DynamicObject dynamicObject = dynamicObjectList.get(0);
            mainDynamicObjects.add(dynamicObject);
            for (DynamicObject detail : filterDynamicObject) {
                detail.set("attmain", (Object)dynamicObject.getLong("id"));
            }
        }
        return mainDynamicObjects;
    }

    public List<Long> getFormulaIdList(TieAttPeriodContext tieAttPeriodContext, PerAttPeriod perAttPeriod, FormulaService formulaService) {
        Map<String, Object> initParams = tieAttPeriodContext.getInitParams();
        Long personId = perAttPeriod.getPersonId();
        LocalDate localDate = tieAttPeriodContext.getPeriodData(perAttPeriod);
        AttFileCabinet attFileCabinet = (AttFileCabinet)initParams.get("ATT_FILE");
        AttFileModel attFileModel = attFileCabinet.getByAttPersonIdAndDate((long)personId, localDate);
        FormulaPlanPackage formulaPlan = attFileModel.getAttFormulaPlanPackage(localDate);
        if (formulaPlan == null) {
            LOG.debug("not find matched formula plan,attFileid={},localDate={}", (Object)attFileModel.getId(), (Object)localDate);
            return Collections.emptyList();
        }
        FormulaRulePackage formulaRule = this.getFormulaRule(tieAttPeriodContext, formulaPlan, perAttPeriod, formulaService);
        if (formulaRule == null) {
            LOG.debug("not find matched formula rule,attFileid={},localDate={}", (Object)attFileModel.getId(), (Object)localDate);
            return Collections.emptyList();
        }
        TieStepIdentity tieStepIdentity = this.getTieStepIdentity();
        long stepId = tieStepIdentity.getBoId();
        long planId = tieStepIdentity.getPhaseIdentity().getSchemeIdentity().getBoId();
        List<FormulaConfigPackage> formulaConfigList = formulaRule.getConfigsByDateAndStepId(localDate, planId, stepId);
        if (CollectionUtils.isEmpty(formulaConfigList)) {
            LOG.debug("attsum not find matched formulaConfigList,localDate={},planId={},stepId={}", new Object[]{localDate, planId, stepId});
            return Collections.emptyList();
        }
        return formulaConfigList.stream().map(AbstractTimeSeqVersion::getId).collect(Collectors.toList());
    }

    private FormulaRulePackage getFormulaRule(TieAttPeriodContext tieAttPeriodContext, FormulaPlanPackage formulaPlan, PerAttPeriod perAttPeriod, FormulaService formulaService) {
        FormulaRulePackage formulaRule;
        if (HRStringUtils.equalsIgnoreCase((String)"2", (String)formulaPlan.getSetRuleWay())) {
            formulaRule = PolicyResultHelp.getFormulaRuleEngineRule(tieAttPeriodContext, formulaPlan, perAttPeriod);
            if (formulaRule != null) {
                Set collect = formulaRule.getConfigs().stream().flatMap(e -> e.getVersions().stream()).map(AbstractTimeSeqVersion::getId).collect(Collectors.toSet());
                try {
                    formulaService.addFormulaIds(collect);
                }
                catch (KDBizException e2) {
                    throw new WtesBizException((Throwable)e2, e2.getMessage());
                }
            }
        } else {
            formulaRule = (FormulaRulePackage)formulaPlan.getRule().getVersionByDate(tieAttPeriodContext.getPeriodData(perAttPeriod));
        }
        return formulaRule;
    }
}

