/*
 * Decompiled with CFR 0.152.
 */
package kd.wtc.wtes.business.executor.formula;

import java.math.BigDecimal;
import java.time.LocalDate;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.exception.KDBizException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.wtc.wtbs.business.timeseq.AbstractTimeSeqVersion;
import kd.wtc.wtbs.common.enums.AttitemUnitEnum;
import kd.wtc.wtbs.common.util.third.collect.Lists;
import kd.wtc.wtbs.common.util.third.collect.Maps;
import kd.wtc.wtes.business.core.TieMsgLevel;
import kd.wtc.wtes.business.core.scheme.TieStepIdentity;
import kd.wtc.wtes.business.executor.rlotcal.PolicyResultHelp;
import kd.wtc.wtes.business.ext.utils.ContextExtUtil;
import kd.wtc.wtes.business.model.AttFileModel;
import kd.wtc.wtes.business.model.AttItemInstance;
import kd.wtc.wtes.business.model.AttItemSpec;
import kd.wtc.wtes.business.model.AttItemSpecData;
import kd.wtc.wtes.business.model.EvaluationRuleModel;
import kd.wtc.wtes.business.model.ShiftSpec;
import kd.wtc.wtes.business.model.attitem.DataType;
import kd.wtc.wtes.business.model.rlfm.FormulaConfigPackage;
import kd.wtc.wtes.business.model.rlfm.FormulaPlanPackage;
import kd.wtc.wtes.business.model.rlfm.FormulaRulePackage;
import kd.wtc.wtes.business.std.TieMessageStd;
import kd.wtc.wtes.business.std.chain.TieContextStd;
import kd.wtc.wtes.business.std.chain.TieDataResultStd;
import kd.wtc.wtes.business.std.chain.TieEvaluatorStd;
import kd.wtc.wtes.business.std.datanode.AttItemValue;
import kd.wtc.wtes.business.std.datanode.TieDataNode;
import kd.wtc.wtes.business.std.datanode.TieDataNodeStd;
import kd.wtc.wtes.business.util.ContextUtil;
import kd.wtc.wtes.common.constants.TimeConstants;
import kd.wtc.wtes.common.lang.WtesBizException;
import kd.wtc.wtes.common.lang.WtesException;
import kd.wtc.wtes.common.util.CollectionUtils;
import kd.wtc.wtp.business.formula.FormulaCalcUtils;
import kd.wtc.wtp.business.formula.adapt.FormulaService;
import kd.wtc.wtp.business.formula.adapt.provider.SceneEnum;
import kd.wtc.wtp.business.formula.adapt.result.WTCCalResultDetailVO;
import kd.wtc.wtp.business.formula.adapt.result.WTCCalResultVO;

public class AttRecordFormulaEvaluator
implements TieEvaluatorStd {
    private static final Log LOG = LogFactory.getLog(AttRecordFormulaEvaluator.class);

    @Override
    public TieDataResultStd doEvaluate(TieContextStd context) {
        return this.doEvaluate(context, context.getAllDataNodes());
    }

    @Override
    public TieDataResultStd doEvaluate(TieContextStd context, List<TieDataNodeStd> dataNodes) {
        LocalDate chainDate;
        AttFileModel chainDateAttFileModel;
        FormulaPlanPackage formulaPlan;
        if (LOG.isDebugEnabled()) {
            LOG.debug("AttRecordFormulaEvaluator start");
        }
        if ((formulaPlan = (chainDateAttFileModel = ContextUtil.getAttFile(context, chainDate = context.getChainDate())).getAttFormulaPlanPackage(chainDate)) == null) {
            LOG.debug("not find matched formula plan");
            return TieDataResultStd.exclusion(new TieMessageStd(TieMsgLevel.INFO, "formula plan is null"));
        }
        FormulaService formulaService = context.getInitParamMust("ATT_FOUMULA_INSTANCE", FormulaService.class);
        FormulaRulePackage formulaRule = this.getFormulaRule(context, formulaPlan, formulaService);
        if (formulaRule == null) {
            LOG.debug("not find matched formula rule");
            return TieDataResultStd.exclusion(new TieMessageStd(TieMsgLevel.INFO, "formula rule is null"));
        }
        TieStepIdentity tieStepIdentity = context.getTieStepIdentity();
        long stepId = tieStepIdentity.getBoId();
        long planId = tieStepIdentity.getPhaseIdentity().getSchemeIdentity().getBoId();
        List<FormulaConfigPackage> formulaConfigList = formulaRule.getConfigsByDateAndStepId(chainDate, planId, stepId);
        if (CollectionUtils.isEmpty(formulaConfigList)) {
            LOG.debug("attrecord not find matched formulaConfigList,localDate={},planId={},stepId={}", new Object[]{chainDate, planId, stepId});
            return TieDataResultStd.exclusion(new TieMessageStd(TieMsgLevel.INFO, "formulaIdList is null"));
        }
        List formulaIdList = formulaConfigList.stream().map(AbstractTimeSeqVersion::getId).collect(Collectors.toList());
        if (CollectionUtils.isNotEmpty(formulaIdList)) {
            HashMap contextMap = Maps.newHashMapWithExpectedSize((int)2);
            contextMap.put("context", context);
            contextMap.put("contextExt", ContextExtUtil.getTieContextExt(context));
            contextMap.put("sceneCode", SceneEnum.ATTRECORD.getCode());
            try {
                Map CalResultDetailVOMap = formulaService.invokeFormula(formulaIdList, (Map)contextMap, context.getAttSubjectEntry().getAttFileBoid(), chainDate);
                Map formulaId2UsedAttItemIdMap = formulaService.getUsedAttItemId(formulaIdList);
                Map resultAttItemId2FormulaIdMap = formulaService.getResultAttItemId2FormulaIdMap(formulaIdList);
                return TieDataResultStd.success(this.dealResult(CalResultDetailVOMap, context, formulaRule, formulaId2UsedAttItemIdMap, resultAttItemId2FormulaIdMap));
            }
            catch (Exception ex) {
                LOG.warn("AttRecordFormulaEvaluator error", (Throwable)ex);
                if (ex instanceof WtesException) {
                    throw (WtesException)((Object)ex);
                }
                if (ex instanceof KDBizException) {
                    throw new WtesBizException((Throwable)ex, ex.getMessage());
                }
                String message = ResManager.loadKDString((String)"\u8003\u52e4\u6838\u7b97\u65e5\u660e\u7ec6\u516c\u5f0f\u8fd0\u7b97\u5f02\u5e38\u3002", (String)"AttRecordFormulaEvaluator_1", (String)"wtc-wtes-business", (Object[])new Object[0]);
                throw new WtesBizException((Throwable)ex, message);
            }
        }
        return TieDataResultStd.exclusion(new TieMessageStd(TieMsgLevel.INFO, "formulaIdList is null"));
    }

    private List<? extends TieDataNode> dealResult(Map<String, WTCCalResultDetailVO> calResultDetailVOMap, TieContextStd context, FormulaRulePackage formulaRule, Map<Long, Set<Long>> formulaId2UsedAttItemIdMap, Map<Long, Long> resultAttItemId2FormulaIdMap) {
        ArrayList resultList = Lists.newArrayListWithExpectedSize((int)10);
        for (Map.Entry<String, WTCCalResultDetailVO> calResultDetailVOEntry : calResultDetailVOMap.entrySet()) {
            WTCCalResultDetailVO resultDetailVO = calResultDetailVOEntry.getValue();
            if (resultDetailVO.isSuccess()) {
                Map sumResultMap = resultDetailVO.getSumResultMap();
                for (Map.Entry calResultVOEntry : sumResultMap.entrySet()) {
                    WTCCalResultVO value = (WTCCalResultVO)calResultVOEntry.getValue();
                    if (value.getCalResultValue() == null) continue;
                    String uniqueCode = value.getUniqueCode();
                    Long attItemBoId = FormulaCalcUtils.getAttItemBoIdByCode((String)uniqueCode);
                    Long formulaId = resultAttItemId2FormulaIdMap.get(attItemBoId);
                    if (!FormulaCalcUtils.isAttItemCode((String)uniqueCode)) continue;
                    List<TieDataNodeStd> parentDataNodeList = this.getParentDataNodes(context, formulaId2UsedAttItemIdMap.get(formulaId));
                    AttItemInstance attItemInstance = this.genAttItemInstance(value, context);
                    if (attItemInstance == null) continue;
                    AttItemValue attItemValue = (AttItemValue)((AttItemValue.Builder)((AttItemValue.Builder)((AttItemValue.Builder)((TieDataNode.Builder)AttItemValue.builder().attItemInstance(attItemInstance)).parentDataNodes(parentDataNodeList)).evaluationRule(EvaluationRuleModel.of(formulaRule.getId(), "wtp_formularule"))).matchedRule(null)).build();
                    resultList.add(attItemValue);
                }
                continue;
            }
            LOG.warn("{} dealResult error,errorMsg={},errorTraceInfo={}", new Object[]{calResultDetailVOEntry.getKey(), resultDetailVO.getErrorMsg(), resultDetailVO.getErrorTraceInfo()});
            TieStepIdentity tieStepIdentity = context.getTieStepIdentity();
            String errorMsg = ResManager.loadKDString((String)"\u5728\u6838\u7b97\u6b65\u9aa4\u201c{0}\u201d\u4e2d\u8ba1\u7b97\u516c\u5f0f\u65f6\u51fa\u73b0\u5f02\u5e38\uff0c\u5f02\u5e38\u539f\u56e0\u4e3a\u201c{1}\u201d\u3002", (String)"AttRecordFormulaEvaluator_0", (String)"wtc-wtes-business", (Object[])new Object[]{tieStepIdentity.getName(), resultDetailVO.getErrorMsg()});
            throw new WtesException(errorMsg);
        }
        return resultList;
    }

    private List<TieDataNodeStd> getParentDataNodes(TieContextStd context, Set<Long> usedAttItemBoIdSet) {
        List<TieDataNodeStd> allDataNodes = context.getAllDataNodes();
        ArrayList parentDataNodes = Lists.newArrayListWithExpectedSize((int)10);
        block0: for (TieDataNodeStd dataNode : allDataNodes) {
            List<AttItemInstance> attItemInstances = dataNode.getAttItemInstances();
            for (AttItemInstance attItemInstance : attItemInstances) {
                long attItemBoId = attItemInstance.getAttItemSpec().getBid();
                if (!usedAttItemBoIdSet.contains(attItemBoId)) continue;
                parentDataNodes.add(dataNode);
                continue block0;
            }
        }
        return parentDataNodes;
    }

    private AttItemInstance genAttItemInstance(WTCCalResultVO calResultVO, TieContextStd context) {
        AttItemSpecData attItemSpecData = ContextUtil.getAttItemSpecData(context);
        LocalDate chainDate = context.getChainDate();
        ShiftSpec shiftSpec = ContextUtil.getShiftSpec(context);
        String uniqueCode = calResultVO.getUniqueCode();
        Long attItemBoId = FormulaCalcUtils.getAttItemBoIdByCode((String)uniqueCode);
        if (calResultVO.getCalResultValue() instanceof BigDecimal) {
            AttItemInstance itemInstance;
            BigDecimal calResultValue = (BigDecimal)calResultVO.getCalResultValue();
            AttItemSpec attItemSpec = attItemSpecData.getByBidAndDate(attItemBoId, chainDate);
            String itemType = attItemSpec.getItemType();
            if ("3".equals(itemType)) {
                return null;
            }
            if (attItemSpec.getDataType() == DataType.DURATION) {
                BigDecimal seconds = this.getSecond(attItemSpec.getUnit(), calResultValue, shiftSpec);
                itemInstance = new AttItemInstance(attItemSpec, calResultValue, shiftSpec.secondsToDays(seconds), seconds, null);
            } else {
                itemInstance = new AttItemInstance(attItemSpec, calResultValue);
            }
            return itemInstance;
        }
        Object obj = calResultVO.getCalResultValue();
        String objType = obj == null ? "null" : obj.getClass().getTypeName();
        throw new KDBizException("data type of formula calculate result incompatible, " + objType + " can't convert to BigDecimal");
    }

    protected BigDecimal getSecond(String unit, BigDecimal amount, ShiftSpec shiftSpec) {
        if (AttitemUnitEnum.DAY.getUnit().equals(unit)) {
            return shiftSpec.daysToSecondDecimal(amount);
        }
        if (AttitemUnitEnum.HOUR.getUnit().equals(unit)) {
            return amount.multiply(TimeConstants.SECOND_OF_ONE_HOUR_DECIMAL);
        }
        if (AttitemUnitEnum.MINUTE.getUnit().equals(unit)) {
            return amount.multiply(TimeConstants.SECOND_OF_ONE_MINUTE_DECIMAL);
        }
        return amount;
    }

    private FormulaRulePackage getFormulaRule(TieContextStd context, FormulaPlanPackage formulaPlan, FormulaService formulaService) {
        FormulaRulePackage formulaRule;
        LocalDate chainDate = context.getChainDate();
        if (HRStringUtils.equalsIgnoreCase((String)"2", (String)formulaPlan.getSetRuleWay())) {
            formulaRule = PolicyResultHelp.getFormulaRuleEngineRule(context, formulaPlan, chainDate);
            if (formulaRule != null) {
                Set collect = formulaRule.getConfigs().stream().flatMap(e -> e.getVersions().stream()).map(AbstractTimeSeqVersion::getId).collect(Collectors.toSet());
                try {
                    formulaService.addFormulaIds(collect);
                }
                catch (KDBizException e2) {
                    throw new WtesBizException((Throwable)e2, e2.getMessage());
                }
            }
        } else {
            formulaRule = (FormulaRulePackage)formulaPlan.getRule().getVersionByDate(chainDate);
        }
        return formulaRule;
    }
}

