/*
 * Decompiled with CFR 0.152.
 */
package kd.wtc.wtes.business.executor.formula.provider.service;

import com.alibaba.fastjson.JSON;
import java.math.BigDecimal;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.wtc.wtbd.business.retrieval.RetrievalUtil;
import kd.wtc.wtbs.common.util.WTCCollections;
import kd.wtc.wtbs.common.util.WTCDateUtils;
import kd.wtc.wtbs.common.util.WTCStringUtils;
import kd.wtc.wtbs.common.util.third.collect.Maps;
import kd.wtc.wtbs.wtp.constants.timebucket.TieProviderConstant;
import kd.wtc.wtes.business.model.AttBillTimeBucket;
import kd.wtc.wtes.business.model.AttBillTimeBucketData;
import kd.wtc.wtes.business.model.ShiftSpec;
import kd.wtc.wtes.business.model.base.PunchCardPair;
import kd.wtc.wtes.business.model.base.ShiftPeriod;
import kd.wtc.wtes.business.model.rlra.AttendanceBillTag;
import kd.wtc.wtes.business.model.rlra.ShiftTimeBucketPropertyEnum;
import kd.wtc.wtes.business.model.rlra.TimeBucketPositionEnum;
import kd.wtc.wtes.business.std.chain.TieContextStd;
import kd.wtc.wtes.business.std.datanode.TieDataNodeStd;
import kd.wtc.wtes.business.std.datanode.TimeBucketStd;
import kd.wtc.wtes.business.util.ContextUtil;
import kd.wtc.wtes.common.enums.ShiftType;

public abstract class TieProviderTimeBucketService
implements TieProviderConstant {
    private static final Log LOG = LogFactory.getLog(TieProviderTimeBucketService.class);

    protected abstract List<TieDataNodeStd> getTimeBucketNode(Map<String, Object> var1, List<TieDataNodeStd> var2);

    public Object[] getTimeBucketObjectArray(Map<String, Object> paramMap, String lang) {
        TieContextStd context = (TieContextStd)paramMap.get("context");
        List<TieDataNodeStd> tieDataNodeStdList = context.getRawTimeBuckets();
        if (WTCCollections.isEmpty(tieDataNodeStdList)) {
            return new Object[0];
        }
        int num = 0;
        List<PunchCardPair> punchCardPairList = ContextUtil.getPunchCardPairs(context);
        Map<Long, List<PunchCardPair>> punchCardPairMap = WTCCollections.isNotEmpty(punchCardPairList) ? punchCardPairList.stream().collect(Collectors.groupingBy(PunchCardPair::getId)) : Collections.emptyMap();
        List shiftPeriodList = (List)context.getInitParam("SHIFT_PERIOD");
        Map<Long, List<ShiftPeriod>> shiftPeriodMap = WTCCollections.isNotEmpty((Collection)shiftPeriodList) ? shiftPeriodList.stream().collect(Collectors.groupingBy(ShiftPeriod::getId)) : Collections.emptyMap();
        List<TieDataNodeStd> tieDataList = this.getTimeBucketNode(paramMap, tieDataNodeStdList);
        if (WTCCollections.isEmpty(tieDataList)) {
            return new Object[0];
        }
        Object[] allTimeBuckets = new Object[tieDataList.size()];
        Map billTagMap = RetrievalUtil.getComboItemMapByField((String)"wtte_timebucketraw", (String)"attendancebilltag", (String)lang);
        Map exTagMap = RetrievalUtil.getComboItemMapByField((String)"wtte_timebucketraw", (String)"punchcardtag", (String)lang);
        Map timePointSourceMap = RetrievalUtil.getComboItemMapByField((String)"wtte_timebucketraw", (String)"starttimepointsource", (String)lang);
        Map shiftTypeMap = RetrievalUtil.getComboItemMapByField((String)"wtbd_shift", (String)"shifttype", (String)lang);
        Map attendanceStatusMap = RetrievalUtil.getComboItemMapByField((String)"wtte_timebucketraw", (String)"attendancestatus", (String)lang);
        for (TieDataNodeStd tieDataNodeStd : tieDataList) {
            Map<String, Object> timeBucket = this.getTimeBucket(context, (TimeBucketStd)tieDataNodeStd, shiftPeriodMap, lang, punchCardPairMap, billTagMap, exTagMap, timePointSourceMap, shiftTypeMap);
            this.setSupplementaryTimeBucket(timeBucket, (TimeBucketStd)tieDataNodeStd, attendanceStatusMap, lang);
            allTimeBuckets[num] = timeBucket;
            ++num;
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("allTimeBuckets{}", JSON.toJSON((Object)allTimeBuckets));
        }
        return allTimeBuckets;
    }

    private void setSupplementaryTimeBucket(Map<String, Object> timeBucket, TimeBucketStd timeBucketStd, Map<String, String> attendanceStatusMap, String lang) {
        List<String> attendanceStatusList = timeBucketStd.getAttendanceStatuses();
        timeBucket.put("dateAttribute", timeBucketStd.getDateAttribute().getName(lang));
        timeBucket.put("dateAttributeCode", timeBucketStd.getDateAttribute().getCode());
        timeBucket.put("dateType", timeBucketStd.getDateType().getOrmLocaleName().get((Object)lang));
        timeBucket.put("dateTypeCode", timeBucketStd.getDateType().getNumber());
        timeBucket.put("dateTypeId", timeBucketStd.getDateType().getId());
        timeBucket.put("attendanceStatus", this.getList2string(attendanceStatusList, attendanceStatusMap));
        timeBucket.put("attendanceStatusCode", this.getList2string(attendanceStatusList));
        timeBucket.put("isLeaveRequestWithinTheShift", WTCStringUtils.equals((String)timeBucketStd.getAbsenceBillState(), (String)"0") ? "N" : "Y");
        timeBucket.put("isTravelRequestWithinTheShift", WTCStringUtils.equals((String)timeBucketStd.getTravelBillState(), (String)"0") ? "N" : "Y");
    }

    private String getList2string(List<String> stringList) {
        StringBuilder str = new StringBuilder();
        if (null != stringList && !stringList.isEmpty()) {
            int num = 0;
            for (String status : stringList) {
                if (num == stringList.size() - 1) {
                    str.append(status);
                } else {
                    str.append(status).append(',');
                }
                ++num;
            }
        }
        return str.toString();
    }

    private String getList2string(List<String> stringList, Map<String, String> comboMap) {
        StringBuilder str = new StringBuilder();
        if (null != stringList && !stringList.isEmpty()) {
            int num = 0;
            for (String status : stringList) {
                String value = comboMap.get(status);
                if (!WTCStringUtils.isNotEmpty((String)value)) continue;
                if (num == stringList.size() - 1) {
                    str.append(value);
                    continue;
                }
                str.append(value).append(',');
            }
        }
        return str.toString();
    }

    private Map<String, Object> getTimeBucket(TieContextStd context, TimeBucketStd timeBucketStd, Map<Long, List<ShiftPeriod>> shiftPeriodMap, String lang, Map<Long, List<PunchCardPair>> punchCardPairMap, Map<String, String> billTagMap, Map<String, String> exTagMap, Map<String, String> timePointSourceMap, Map<String, String> shiftTypeMap) {
        List<PunchCardPair> punchCardPairs;
        List<ShiftPeriod> shiftShiftPeriodList;
        ShiftTimeBucketPropertyEnum shiftTimeBucketPropertyEnum;
        List<ShiftPeriod> shiftShiftPeriodList2;
        HashMap timeBucket = Maps.newHashMapWithExpectedSize((int)16);
        timeBucket.put("dateAttribute", timeBucketStd.getDateAttribute().getName());
        LocalDateTime localStartDateTime = timeBucketStd.getStartTime();
        if (localStartDateTime != null) {
            timeBucket.put("startTime", WTCDateUtils.toDate((LocalDateTime)localStartDateTime));
        }
        timeBucket.put("startTimeSource", timePointSourceMap.get(timeBucketStd.getStartTimePointSource().getNumber()));
        LocalDateTime localEndDateTime = timeBucketStd.getEndTime();
        if (localEndDateTime != null) {
            timeBucket.put("endTime", WTCDateUtils.toDate((LocalDateTime)localEndDateTime));
        }
        timeBucket.put("endTimeSource", timePointSourceMap.get(timeBucketStd.getEndTimePointSource().getNumber()));
        ShiftSpec shiftSpec = timeBucketStd.getShiftSpec();
        if (shiftSpec != null) {
            timeBucket.put("shiftName", shiftSpec.getOrmLocaleName().get((Object)lang));
            timeBucket.put("shiftCode", shiftSpec.getNumber());
            ShiftType shiftType = shiftSpec.getShiftType();
            if (shiftType != null) {
                timeBucket.put("OFFShift", shiftSpec.isOff() ? "Y" : "N");
                timeBucket.put("shiftType", shiftTypeMap.get(shiftType.code));
            }
        }
        timeBucket.put("shiftDate", WTCDateUtils.toDate((LocalDate)timeBucketStd.getShiftDate()));
        List<ShiftPeriod> shiftPeriods = shiftPeriodMap.get(timeBucketStd.getShiftTimeBucketSeqId());
        if (WTCCollections.isNotEmpty(shiftPeriods)) {
            timeBucket.put("timeBucketSerialNo", shiftPeriods.get(0).getName().get((Object)lang));
            timeBucket.put("timeBucketSerialNoCode", shiftPeriods.get(0).getNumber());
        }
        timeBucket.put("exceptionTag", exTagMap.get(timeBucketStd.getPunchCardTag()));
        timeBucket.put("exceptionTagCode", timeBucketStd.getPunchCardTag());
        TimeBucketPositionEnum timeBucketPositionEnum = timeBucketStd.getTimeBucketPosition();
        if (timeBucketPositionEnum != null && WTCCollections.isNotEmpty(shiftShiftPeriodList2 = shiftPeriodMap.get(timeBucketPositionEnum.id))) {
            timeBucket.put("timeBucketPosition", shiftShiftPeriodList2.get(0).getName().get((Object)lang));
            timeBucket.put("timeBucketPositionCode", shiftShiftPeriodList2.get(0).getNumber());
        }
        if ((shiftTimeBucketPropertyEnum = timeBucketStd.getShiftTimeBucketProperty()) != null && WTCCollections.isNotEmpty(shiftShiftPeriodList = shiftPeriodMap.get(shiftTimeBucketPropertyEnum.id))) {
            timeBucket.put("timeBucketAttribute", shiftShiftPeriodList.get(0).getName().get((Object)lang));
            timeBucket.put("timeBucketAttributeCode", shiftShiftPeriodList.get(0).getNumber());
        }
        if (!WTCCollections.isEmpty(punchCardPairMap) && WTCCollections.isNotEmpty(punchCardPairs = punchCardPairMap.get(timeBucketStd.getShouldPunchCardSeqId()))) {
            timeBucket.put("shouldPunchPair", punchCardPairs.get(0).getName().get((Object)lang));
        }
        timeBucket.put("lengthOfTime", BigDecimal.valueOf(timeBucketStd.getTimeIntervalInSeconds()));
        AttendanceBillTag attendanceBillTag = timeBucketStd.getAttendanceBillTag();
        this.setBillTimeBucket(attendanceBillTag, timeBucket, context, billTagMap);
        return timeBucket;
    }

    private void setBillTimeBucket(AttendanceBillTag attendanceBillTag, Map<String, Object> timeBucket, TieContextStd context, Map<String, String> billTagMap) {
        if (attendanceBillTag != null) {
            AttBillTimeBucket tlAttBillTimeBucket;
            AttBillTimeBucket otAttBillTimeBucket;
            timeBucket.put("billTag", billTagMap.get(String.valueOf(attendanceBillTag.getStatus())));
            timeBucket.put("billTagCode", String.valueOf(attendanceBillTag.getStatus()));
            AttBillTimeBucketData attBillTimeBucketData = (AttBillTimeBucketData)context.getInitParams().get("BILL_TIME_BUCKET");
            AttBillTimeBucket vaAttBillTimeBucket = attBillTimeBucketData.getBillTimeBucketById(attendanceBillTag.getVaBillEntryId());
            if (vaAttBillTimeBucket != null && attendanceBillTag.isOnVacation()) {
                timeBucket.put("leaveRequestCode", vaAttBillTimeBucket.getNumber());
                timeBucket.put("leaveRequestBillID", String.valueOf(attendanceBillTag.getVaBillEntryId()));
                timeBucket.put("leaveStartTimeType", vaAttBillTimeBucket.getEntryRowDy() != null ? vaAttBillTimeBucket.getEntryRowDy().getString("entrystartmethod") : "");
            }
            if ((otAttBillTimeBucket = attBillTimeBucketData.getBillTimeBucketById(attendanceBillTag.getOtBillEntryId())) != null && attendanceBillTag.isOverTime()) {
                timeBucket.put("overtimeRequestCode", otAttBillTimeBucket.getNumber());
                timeBucket.put("overtimeRequestBillID", String.valueOf(attendanceBillTag.getOtBillEntryId()));
            }
            if ((tlAttBillTimeBucket = attBillTimeBucketData.getBillTimeBucketById(attendanceBillTag.getTlBillEntryId())) != null && attendanceBillTag.isOnBusiness()) {
                timeBucket.put("travelRequestCode", tlAttBillTimeBucket.getNumber());
                timeBucket.put("travelRequestBillID", String.valueOf(attendanceBillTag.getTlBillEntryId()));
                timeBucket.put("travelStartTimeType", tlAttBillTimeBucket.getEntryRowDy() != null ? tlAttBillTimeBucket.getEntryRowDy().getString("startmethod") : "");
            }
        }
    }
}

